/*
 * Decompiled with CFR 0.152.
 */
package fipaos.agent;

import fipaos.agent.FIPAOSAgentComponentFactory;
import fipaos.agent.StandardFIPAOSAgentComponentFactory;
import fipaos.agent.conversation.Conversation;
import fipaos.agent.conversation.ConversationListener;
import fipaos.agent.conversation.ConversationManager;
import fipaos.agent.conversation.InvalidConversationIDException;
import fipaos.agent.conversation.UnknownProtocolException;
import fipaos.agent.profile.AgentProfile;
import fipaos.agent.profile.DatabaseProfile;
import fipaos.agent.profile.PlatformProfile;
import fipaos.agent.task.SynchronousTask;
import fipaos.agent.task.Task;
import fipaos.agent.task.TaskManager;
import fipaos.mts.MTS;
import fipaos.mts.Message;
import fipaos.mts.MessageSender;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.parser.datamapping.DataMapperFactory;
import fipaos.platform.ams.AMSDeregistrationTask;
import fipaos.platform.ams.AMSRegistrationException;
import fipaos.platform.ams.AMSRegistrationTask;
import fipaos.platform.df.DFDeregistrationTask;
import fipaos.platform.df.DFRegistrationException;
import fipaos.platform.df.DFRegistrationTask;
import fipaos.util.DocumentRetriever;
import fipaos.util.DynamicClass;
import fipaos.util.DynamicClassException;
import fipaos.util.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public abstract class FIPAOSAgent
implements ConversationListener {
    private static final String IDLE = "IDLE";
    private MessageSender _sender = null;
    private boolean _ready_to_accept;
    private Object _push_lock = new Object();
    protected TaskManager _tm;
    private ConversationManager _cm;
    private MTS _mts;
    private AgentID _aid;
    private AgentProfile _profile;
    private PlatformProfile _platform_profile;
    private boolean _shutdown;
    protected DatabaseProfile _database_profile;
    private String _owner;
    private TopLevelHandlerTask _top_level_handler;
    public String _state = "unknown";
    public List _registered_with;
    static /* synthetic */ Class class$fipaos$agent$task$Task;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Throwable;

    /*
     * Unable to fully structure code
     */
    private FIPAOSAgent(String var1_1, String var2_2) {
        super();
        this._registered_with = Collections.synchronizedList(new LinkedList<E>());
        try {
            var3_3 = DocumentRetriever.getDoc(var1_1);
            var4_7 = DataMapperFactory.createDataMapper(var1_1, var3_3, null);
            this._platform_profile = (PlatformProfile)var4_7.unmarshall(var3_3);
        }
        catch (Throwable var3_4) {
            throw new RuntimeException("An error occured whilst loading the platform profile: " + var3_4);
        }
        try {
            var3_3 = this._platform_profile.getProfileDirectory();
            if (!var3_3.endsWith("/") && !var3_3.endsWith("\\")) {
                var3_3 = var3_3 + "/";
            }
            var4_7 = var3_3 + var2_2 + ".profile";
            var5_9 = var3_3 + "default.profile";
            var6_10 = null;
            var7_11 = null;
            try {
                var8_12 = DocumentRetriever.getDoc(var5_9);
                var9_15 = DataMapperFactory.createDataMapper(var5_9, (String)var8_12, null);
                var6_10 = (AgentProfile)var9_15.unmarshall((String)var8_12);
            }
            catch (Throwable var8_13) {
                // empty catch block
            }
            var8_12 = DocumentRetriever.getDoc((String)var4_7);
            var9_15 = DataMapperFactory.createDataMapper((String)var4_7, (String)var8_12, null);
            var7_11 = (AgentProfile)var9_15.unmarshall((String)var8_12);
            ** finally { 
lbl34:
            // 1 sources

            if (var7_11 == null && var6_10 == null) {
                throw new RuntimeException("An error occured whilst loading the agents profile - neither default profile or Agent specific profile have been loaded!");
            }
            if (var6_10 != null) {
                this._profile = var6_10;
                if (var7_11 != null) {
                    var8_12 = var7_11.getDatabaseProfile();
                    var9_15 = this._profile.getDatabaseProfile();
                    if (var8_12 != null) {
                        if (var8_12.getDatabaseLocation() != null) {
                            var9_15.setDatabaseLocation(var8_12.getDatabaseLocation());
                        }
                        if (var8_12.getDatabaseType() != null) {
                            var9_15.setDatabaseType(var8_12.getDatabaseType());
                        }
                    }
                    if (var7_11.getInternalAddresss() != null && !var7_11.getInternalAddresss().isEmpty()) {
                        this._profile.getInternalAddresss().addAll(var7_11.getInternalAddresss());
                    }
                    if (var7_11.getProtocolProfile() != null) {
                        this._profile.getProtocolProfile().getProtocolMappings().addAll(var7_11.getProtocolProfile().getProtocolMappings());
                    }
                }
            } else {
                this._profile = var7_11;
            }
        }
        catch (RuntimeException var3_5) {
            throw var3_5;
        }
        catch (Throwable var4_8) {
            throw new RuntimeException("An error occured whilst loading the agents profile: " + var4_8);
        }
        try {
            this._aid = new AgentID();
            this._aid.setName(var2_2 + "@" + this._platform_profile.getHAPName());
        }
        catch (Throwable var3_6) {
            throw new RuntimeException("Error whilst generating AgentID: " + var3_6);
        }
    }

    public FIPAOSAgent(String string, String string2, String string3) {
        this(string, string2, string3, true);
    }

    public FIPAOSAgent(String string, String string2, String string3, boolean bl) {
        this(string, string2);
        this.init(bl, new StandardFIPAOSAgentComponentFactory());
    }

    public FIPAOSAgent(PlatformProfile platformProfile, AgentProfile agentProfile, String string, String string2, boolean bl) {
        this(platformProfile, agentProfile, string, string2, bl, new StandardFIPAOSAgentComponentFactory());
    }

    public FIPAOSAgent(PlatformProfile platformProfile, AgentProfile agentProfile, String string, String string2, boolean bl, FIPAOSAgentComponentFactory fIPAOSAgentComponentFactory) {
        this._registered_with = Collections.synchronizedList(new LinkedList());
        this._platform_profile = platformProfile;
        this._profile = agentProfile;
        this._owner = string2;
        try {
            this._aid = new AgentID();
            this._aid.setName(string + "@" + this._platform_profile.getHAPName());
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Error whilst generating AgentID: " + throwable);
        }
        this.init(bl, fIPAOSAgentComponentFactory);
    }

    private void init(boolean bl, FIPAOSAgentComponentFactory fIPAOSAgentComponentFactory) {
        this._ready_to_accept = false;
        try {
            this._database_profile = this._profile.getDatabaseProfile();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this._mts = fIPAOSAgentComponentFactory.getMTS(this._platform_profile, this._profile, this._aid);
            ConversationListener conversationListener = this;
            if (bl) {
                this._top_level_handler = new TopLevelHandlerTask();
                this._tm = fIPAOSAgentComponentFactory.getTM(this, null, this._top_level_handler, this._profile.getTaskManagerProfile());
                conversationListener = this._tm;
                new TaskManager.DefaultTaskManagerListener(this._tm);
            }
            this._cm = fIPAOSAgentComponentFactory.getCM(conversationListener, this._mts, this, this._database_profile, this._profile.getProtocolProfile());
            this._sender = this._cm;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void forward(ACL aCL) {
        Message message = new Message(aCL);
        message.getEnvelope().setSlotValue("X-fipaos-debug-as-send-time", new Long(System.currentTimeMillis()));
        this._sender.sendMessage(message);
    }

    public void forward(Message message) {
        message.getEnvelope().setSlotValue("X-fipaos-debug-as-send-time", new Long(System.currentTimeMillis()));
        this._sender.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForPushLock() {
        if (this._ready_to_accept) {
            return;
        }
        Object object = this._push_lock;
        synchronized (object) {
            while (!this._ready_to_accept) {
                try {
                    this._push_lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public synchronized void shutdown() {
        if (this._cm != null) {
            this._cm.shutdown();
            this._cm = null;
        }
        if (this._tm != null) {
            this._tm.shutdown();
            this._tm = null;
        }
        if (this._mts != null) {
            this._mts.shutdown();
        }
        this._state = "unknown";
        this._shutdown = true;
    }

    public boolean isShutdown() {
        return this._shutdown;
    }

    public String getOwnership() {
        return this._owner;
    }

    public AgentProfile getProfile() {
        return this._profile;
    }

    public PlatformProfile getPlatformProfile() {
        return this._platform_profile;
    }

    public AgentID getAID() {
        return (AgentID)this._aid.clone();
    }

    public String getHAP() {
        return this._platform_profile.getHAPName();
    }

    public void activate() {
    }

    public Conversation getCurrentConversation(String string) throws InvalidConversationIDException {
        return this._cm.getConversation(string);
    }

    public String getLocalAMS() {
        return this.getLocalAMSAID().toString();
    }

    public AgentID getLocalAMSAID() {
        AgentID agentID = new AgentID();
        agentID.setName("ams@" + this._platform_profile.getHAPName());
        agentID.setAddresses(new LinkedList<URL>(Collections.singleton(new URL(this._platform_profile.getAMSAddress()))));
        return agentID;
    }

    public String getLocalDF() {
        return this.getLocalDFAID().toString();
    }

    public AgentID getLocalDFAID() {
        AgentID agentID = new AgentID();
        agentID.setName("df@" + this._platform_profile.getHAPName());
        return agentID;
    }

    public String getState() {
        return this._state;
    }

    protected boolean setListenerTask(Task task) {
        if (this._tm != null) {
            this._tm.newTask(task, IDLE);
            this.startPushing();
            return true;
        }
        return false;
    }

    protected void startPushing() {
        Object object = this._push_lock;
        synchronized (object) {
            this._ready_to_accept = true;
            this._push_lock.notify();
        }
        this._state = "active";
    }

    protected boolean addNewProtocol(String string, String string2) {
        return this._cm.addProtocol(string, string2);
    }

    protected boolean knowsProtocol(String string) {
        return this._cm.hasProtocol(string);
    }

    public Conversation getNewConversation(String string) throws UnknownProtocolException {
        return this._cm.addConversation(string);
    }

    protected ConversationManager getCM() {
        return this._cm;
    }

    public void notify(Conversation conversation) {
    }

    public void notify(Enumeration enumeration) {
        this.waitForPushLock();
        while (enumeration.hasMoreElements()) {
            this.notify((Conversation)enumeration.nextElement());
        }
    }

    public void notifyMessageInEndedConversation(Message message) {
    }

    public void notifyMessageUndeliverable(Message message) {
    }

    public void setMessageSender(MessageSender messageSender) {
        this._sender = messageSender;
    }

    public boolean sendNotUnderstood(ACL aCL) {
        return this.sendNotUnderstood(aCL, "internal-failure unknown");
    }

    public boolean sendNotUnderstood(ACL aCL, String string) {
        boolean bl = false;
        try {
            if (!aCL.getPerformative().equalsIgnoreCase("not-understood")) {
                ACL aCL2 = (ACL)aCL.clone();
                aCL2.setPerformative("not-understood");
                aCL2.setReceiverAID(aCL2.getSenderAID());
                aCL2.setSenderAID(this.getAID());
                aCL2.setInReplyTo(aCL2.getReplyWith());
                aCL2.setReplyWith(null);
                aCL2.setContentObject("(" + aCL.toString() + "(" + string + "))");
                this.forward(aCL2);
                bl = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected boolean registeredWith(AgentID agentID) {
        return this._registered_with.contains(agentID);
    }

    protected boolean registeredWithAMS() {
        return this.registeredWith(this.getLocalAMSAID());
    }

    protected boolean registeredWithDF() {
        return this.registeredWith(this.getLocalDFAID());
    }

    protected void registerWithAMS() throws AMSRegistrationException {
        this.registerWithAMS(new AMSRegistrationTask());
    }

    protected void registerWithAMS(AgentID agentID) throws AMSRegistrationException {
        this.registerWithAMS(new AMSRegistrationTask((AgentID)agentID.clone()));
    }

    protected void registerWithAMS(AgentID agentID, String string) throws AMSRegistrationException {
        this.registerWithAMS(new AMSRegistrationTask((AgentID)agentID.clone(), string));
    }

    protected void registerWithAMS(AMSRegistrationTask aMSRegistrationTask) throws AMSRegistrationException {
        Object object = null;
        try {
            object = SynchronousTask.executeTask(this._tm, aMSRegistrationTask);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                AgentID agentID = (AgentID)objectArray[0];
                String string = (String)objectArray[1];
                if (string.equals("already-registered")) {
                    this._registered_with.add(agentID);
                }
                String string2 = "Registration with " + agentID + " failed :" + string;
                throw new AMSRegistrationException(string2, string);
            }
            if (!(object instanceof AgentID)) {
                throw new AMSRegistrationException("Registration with AMS failed");
            }
        } else {
            throw new AMSRegistrationException("Registration with AMS failed");
        }
        this._registered_with.add((AgentID)((AgentID)object).clone());
    }

    protected void registerWithDF(String string) throws DFRegistrationException {
        this.registerWithDF(new DFRegistrationTask(string));
    }

    protected void registerWithDF(DFAgentDescription dFAgentDescription) throws DFRegistrationException {
        this.registerWithDF(new DFRegistrationTask(dFAgentDescription));
    }

    protected void registerWithDF(AgentID agentID, DFAgentDescription dFAgentDescription) throws DFRegistrationException {
        this.registerWithDF(new DFRegistrationTask(agentID, dFAgentDescription));
    }

    protected void registerWithDF(AgentID agentID, String string) throws DFRegistrationException {
        this.registerWithDF(new DFRegistrationTask(agentID, string));
    }

    protected void registerWithDF(DFRegistrationTask dFRegistrationTask) throws DFRegistrationException {
        Object object = null;
        try {
            object = SynchronousTask.executeTask(this._tm, dFRegistrationTask);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                AgentID agentID = (AgentID)objectArray[0];
                String string = (String)objectArray[1];
                if (string.equals("already-registered")) {
                    this._registered_with.add(agentID);
                }
                String string2 = "Registration with " + agentID + " failed :" + string;
                throw new DFRegistrationException(string2, string);
            }
            if (!(object instanceof AgentID)) {
                throw new DFRegistrationException("Registration with DF failed");
            }
        } else {
            throw new DFRegistrationException("Registration with DF failed");
        }
        this._registered_with.add((AgentID)((AgentID)object).clone());
    }

    protected void deregisterWithDF() throws DFRegistrationException {
        Object object = null;
        try {
            object = SynchronousTask.executeTask(this._tm, new DFDeregistrationTask());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                AgentID agentID = (AgentID)objectArray[0];
                String string = (String)objectArray[1];
                String string2 = "Deregistration with " + agentID + " failed :" + string;
                throw new DFRegistrationException(string2, string);
            }
            if (!(object instanceof AgentID)) {
                throw new DFRegistrationException("Deregistration with DF failed");
            }
        } else {
            throw new DFRegistrationException("Deregistration with DF failed");
        }
        AgentID agentID = (AgentID)object;
        this._registered_with.remove(agentID);
    }

    protected void deregisterWithAMS() throws AMSRegistrationException {
        Object object = null;
        try {
            object = SynchronousTask.executeTask(this._tm, new AMSDeregistrationTask());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                AgentID agentID = (AgentID)objectArray[0];
                String string = (String)objectArray[1];
                String string2 = "Deregistration with " + agentID + " failed :" + string;
                throw new AMSRegistrationException(string2, string);
            }
            if (!(object instanceof AgentID)) {
                throw new AMSRegistrationException("Deregistration with AMS failed");
            }
        } else {
            throw new AMSRegistrationException("Deregistration with AMS failed");
        }
        AgentID agentID = (AgentID)object;
        this._registered_with.remove(agentID);
    }

    public void notifyDone(Task task, String string, Object object) {
        DynamicClass dynamicClass = new DynamicClass(this);
        try {
            if (object == null) {
                dynamicClass.invoke(string, new Class[]{class$fipaos$agent$task$Task == null ? (class$fipaos$agent$task$Task = FIPAOSAgent.class$("fipaos.agent.task.Task")) : class$fipaos$agent$task$Task}, new Object[]{task});
            } else {
                dynamicClass.invoke(string, new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = FIPAOSAgent.class$("java.lang.Object")) : class$java$lang$Object}, new Object[]{object});
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (DynamicClassException dynamicClassException) {
            // empty catch block
        }
    }

    public void notifyTimeout(Task task, String string) {
        DynamicClass dynamicClass = new DynamicClass(this);
        try {
            dynamicClass.invoke(string, new Class[]{class$fipaos$agent$task$Task == null ? (class$fipaos$agent$task$Task = FIPAOSAgent.class$("fipaos.agent.task.Task")) : class$fipaos$agent$task$Task}, new Object[]{task});
        }
        catch (Throwable throwable) {
            if (!(task instanceof SynchronousTask)) {
                // empty if block
            }
        }
    }

    public void notifyError(Task task, String string, Throwable throwable) {
        DynamicClass dynamicClass = new DynamicClass(this);
        try {
            dynamicClass.invoke(string, new Class[]{class$fipaos$agent$task$Task == null ? (class$fipaos$agent$task$Task = FIPAOSAgent.class$("fipaos.agent.task.Task")) : class$fipaos$agent$task$Task, class$java$lang$Throwable == null ? (class$java$lang$Throwable = FIPAOSAgent.class$("java.lang.Throwable")) : class$java$lang$Throwable}, new Object[]{task, throwable});
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class TopLevelHandlerTask
    extends Task {
    }
}

