/*
 * Decompiled with CFR 0.152.
 */
package fipaos.agent.conversation.lightweight;

import fipaos.agent.conversation.Conversation;
import fipaos.agent.conversation.InvalidConversationIDException;
import fipaos.mts.Message;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.Envelope;
import fipaos.parser.acl.ACLMessage;
import fipaos.util.UTCContainer;
import fipaos.util.UTCDuration;
import fipaos.util.UTCTime;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LightweightConversationImpl
implements Conversation {
    protected AgentID _agent_id;
    protected String _agent_name;
    private String _conv_id;
    private List _messages;
    private AgentID[] _participants;
    protected String _protocol;
    private transient Object _serialised = new Object();
    private boolean _updated;
    private long _wait_before_end_timeout;
    public static final int AGENT_ACTION_REQ = -3;
    public static final int CONVERSATION_END = -1;
    public static final int NO_AGENT_ACTION_REQ = -2;
    public static final int WAIT_BEFORE_END = -4;
    private int _current_state = 0;
    private static final int ACTIVE = 0;
    private static final int NOT_UNDERSTOOD = 1;

    public LightweightConversationImpl() {
        this._messages = Collections.synchronizedList(new LinkedList());
        this._participants = new AgentID[10];
    }

    public LightweightConversationImpl(String string, AgentID agentID) {
        this._agent_id = agentID;
        this._agent_name = agentID.getName();
        this._protocol = string;
        this._messages = Collections.synchronizedList(new LinkedList());
        this._participants = new AgentID[10];
    }

    public int getLatestMessageIndex() {
        return this._messages.size() - 1;
    }

    public ACL getACL(int n) {
        ACL aCL = null;
        try {
            Message message = ((MessageDetails)this._messages.get((int)n))._msg;
            aCL = message.getACL();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return aCL;
    }

    public Envelope getEnvelope(int n) {
        Envelope envelope = null;
        try {
            Message message = ((MessageDetails)this._messages.get((int)n))._msg;
            envelope = message.getEnvelope();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return envelope;
    }

    public String getSender(int n) {
        String string = null;
        try {
            int n2 = ((MessageDetails)this._messages.get((int)n))._sender_number;
            string = this._participants[n2].toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public String getConversationID() {
        return this._conv_id;
    }

    public ACL getFilledInACL() {
        ACL aCL = new ACL();
        try {
            aCL.setConversationID(new String(this._conv_id));
            aCL.setSenderAID(this._agent_id);
            aCL.setProtocol(new String(this._protocol));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return aCL;
    }

    public ACLMessage getFilledInMessage() {
        return new ACLMessage();
    }

    public List getNextMessages() {
        return null;
    }

    public List getNextPerformatives() {
        return null;
    }

    public String getObjectID() {
        return this._conv_id;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public AgentID getSenderAID(int n) {
        AgentID agentID = null;
        try {
            agentID = new AgentID(this.getSender(n));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return agentID;
    }

    public int getState() {
        if (this._current_state == 1) {
            return -1;
        }
        if (this.getSender(this._messages.size() - 1).equals(this._agent_name)) {
            if (this.getTimeOut() > System.currentTimeMillis()) {
                return -1;
            }
            return -2;
        }
        return -3;
    }

    public long getTimeOut() {
        long l = -1L;
        try {
            l = ((MessageDetails)this._messages.get((int)(this._messages.size() - 1)))._timeout;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return l;
    }

    public long getTimeStamp(int n) {
        long l = -1L;
        try {
            l = ((MessageDetails)this._messages.get((int)n))._timestamp;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return l;
    }

    void addMessage(Message message) throws InvalidConversationIDException {
        String string = message.getACL().getConversationID();
        if (string == null || !string.equals(this._conv_id)) {
            throw new InvalidConversationIDException("ConversationID is invalid or not specified");
        }
        ACL aCL = (message = (Message)message.clone()).getACL();
        String string2 = aCL.getPerformative();
        if (string2.equals("not-understood")) {
            if (this._current_state == 1) {
                return;
            }
            int n = this.findParticipant(aCL.getSenderAID());
            if (n == -1 && !this._agent_name.equals(aCL.getSenderAID().getName())) {
                return;
            }
            this.addMessageDetails(message);
            this._current_state = 1;
            this._updated = true;
        } else {
            AgentID agentID;
            if (this.findParticipant(aCL.getSenderAID()) == -1) {
                int n = 0;
                while (n < this._participants.length) {
                    if (this._participants[n] == null) {
                        this._participants[n] = aCL.getSenderAID();
                        break;
                    }
                    ++n;
                }
            }
            if (this.findParticipant(agentID = (AgentID)aCL.getReceiverAIDs().get(0)) == -1) {
                int n = 0;
                while (n < this._participants.length) {
                    if (this._participants[n] == null) {
                        this._participants[n] = agentID;
                        break;
                    }
                    ++n;
                }
            }
            this.addMessageDetails(message);
            this._updated = true;
        }
    }

    private int findParticipant(AgentID agentID) {
        int n = -1;
        int n2 = 0;
        while (n2 < this._participants.length) {
            if (this._participants[n2] != null && agentID.getName().equals(this._participants[n2].getName())) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    private void addMessageDetails(Message message) {
        MessageDetails messageDetails = new MessageDetails();
        int n = this.findParticipant(message.getACL().getSenderAID());
        messageDetails._msg = message;
        messageDetails._sender_number = n;
        messageDetails._timestamp = System.currentTimeMillis();
        messageDetails._timeout = -1L;
        if (message.getACL().getReplyByUTC() != null) {
            UTCContainer uTCContainer = message.getACL().getReplyByUTC();
            if (uTCContainer instanceof UTCTime) {
                long l = new UTCTime().getZTime().getTimeInMillis();
                long l2 = ((UTCTime)uTCContainer).getZTime().getTimeInMillis() - l;
                messageDetails._timeout = messageDetails._timestamp + l2;
            } else if (uTCContainer instanceof UTCDuration) {
                messageDetails._timeout = messageDetails._timestamp + ((UTCDuration)uTCContainer).getDurationInMillis();
            }
        }
        this._messages.add(messageDetails);
    }

    void setConversationID(String string) {
        this._conv_id = string;
    }

    synchronized boolean isUpdated() {
        return this._updated;
    }

    synchronized void removeReferences() {
        if (this._messages != null) {
            this._messages.clear();
            this._messages = null;
        }
        if (this._participants != null) {
            int n = 0;
            while (n < this._participants.length) {
                this._participants[n] = null;
                ++n;
            }
            this._participants = null;
        }
        this._agent_id = null;
        this._agent_name = null;
        this._conv_id = null;
        this._protocol = null;
    }

    synchronized void resetUpdate() {
        this._updated = false;
    }

    synchronized LightweightConversationImpl cloneAndResetUpdate() {
        LightweightConversationImpl lightweightConversationImpl = (LightweightConversationImpl)this.clone();
        this._updated = false;
        return lightweightConversationImpl;
    }

    public synchronized Object clone() {
        try {
            LightweightConversationImpl lightweightConversationImpl = (LightweightConversationImpl)super.clone();
            lightweightConversationImpl._agent_id = (AgentID)this._agent_id.clone();
            lightweightConversationImpl._participants = new AgentID[this._participants.length];
            int n = 0;
            while (n < this._participants.length) {
                if (this._participants[n] != null) {
                    lightweightConversationImpl._participants[n] = (AgentID)this._participants[n].clone();
                }
                ++n;
            }
            if (this._messages != null) {
                lightweightConversationImpl._messages = new LinkedList();
                Iterator iterator = this._messages.iterator();
                while (iterator.hasNext()) {
                    lightweightConversationImpl._messages.add(((MessageDetails)iterator.next()).clone());
                }
            }
            lightweightConversationImpl._serialised = this._serialised;
            return lightweightConversationImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    class MessageDetails
    implements Serializable,
    Cloneable {
        public Message _msg;
        public int _sender_number;
        public long _timestamp;
        public long _timeout = -1L;

        MessageDetails() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append(" ");
            stringBuffer.append(this._msg.toString());
            stringBuffer.append(",");
            stringBuffer.append(" ");
            stringBuffer.append(this._sender_number);
            stringBuffer.append(",");
            stringBuffer.append(" ");
            stringBuffer.append(this._timestamp);
            stringBuffer.append(",");
            stringBuffer.append(" ");
            stringBuffer.append(this._timeout);
            stringBuffer.append(" ");
            stringBuffer.append("}");
            return stringBuffer.toString();
        }

        public Object clone() {
            try {
                MessageDetails messageDetails = (MessageDetails)super.clone();
                messageDetails._msg = (Message)this._msg.clone();
                return messageDetails;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

