/*
 * Decompiled with CFR 0.152.
 */
package fipaos.agent.conversation.lightweight;

import fipaos.agent.FIPAOSAgent;
import fipaos.agent.conversation.Conversation;
import fipaos.agent.conversation.ConversationFinishedException;
import fipaos.agent.conversation.ConversationListener;
import fipaos.agent.conversation.ConversationManager;
import fipaos.agent.conversation.ConversationManagerException;
import fipaos.agent.conversation.InvalidConversationIDException;
import fipaos.agent.conversation.ProtocolErrorException;
import fipaos.agent.conversation.UnknownProtocolException;
import fipaos.agent.conversation.lightweight.LightweightConversationImpl;
import fipaos.agent.profile.DatabaseProfile;
import fipaos.agent.profile.ProtocolProfile;
import fipaos.mts.Message;
import fipaos.mts.MessageReceiver;
import fipaos.mts.MessageSender;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.skill.db.Database;
import fipaos.skill.db.DatabaseException;
import fipaos.skill.db.DatabaseFactory;
import fipaos.util.Comparators;
import fipaos.util.FIFOQueue;
import fipaos.util.Monitor;
import fipaos.util.MonitorListener;
import fipaos.util.Queue;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class LightweightConversationManagerImpl
implements ConversationManager,
Runnable {
    private Map _active_list;
    private AgentID _agent_id;
    private String _agent_name;
    private ConversationListener _conversation_listener;
    private int _count = 0;
    private Database _database;
    private Monitor _monitor;
    private FIPAOSAgent _owner;
    private Map _protocol_cache;
    private static ProtocolProfile _protocol_profile;
    private MessageSender _sender;
    private boolean _terminate = false;
    private Thread _thread;
    private Queue _updates;

    public LightweightConversationManagerImpl(ConversationListener conversationListener, MessageSender messageSender, FIPAOSAgent fIPAOSAgent, DatabaseProfile databaseProfile, ProtocolProfile protocolProfile) {
        this._owner = fIPAOSAgent;
        this._conversation_listener = conversationListener;
        this._agent_id = fIPAOSAgent.getAID();
        this._agent_name = fIPAOSAgent.getAID().getName();
        this._sender = messageSender;
        _protocol_profile = protocolProfile;
        this._active_list = new TreeMap(Comparators.STRING_COMPARE);
        this._protocol_cache = new TreeMap(Comparators.STRING_COMPARE);
        String string = fIPAOSAgent.getAID().getName() + "_convdb";
        this._database = DatabaseFactory.getDatabase(string, databaseProfile);
        if (this._database == null) {
            return;
        }
        try {
            this._database.openDatabase();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        this._thread = new Thread((Runnable)this, "CM-" + this._agent_name);
        this._thread.start();
        this._updates = new FIFOQueue();
        this._monitor = new Monitor(this._updates, new MonitorListener(){

            public void monitorUpdate(Object object) {
                Conversation conversation = (Conversation)object;
                LightweightConversationManagerImpl.this.checkState(conversation);
            }
        });
        this._sender.setMessageReceiver(this);
        this._conversation_listener.setMessageSender(this);
    }

    public Conversation addConversation(String string) throws UnknownProtocolException {
        if (this._terminate) {
            return null;
        }
        Map map = this._active_list;
        synchronized (map) {
            LightweightConversationImpl lightweightConversationImpl = this.createConversation(string, this._agent_id);
            this._active_list.put(lightweightConversationImpl.getConversationID(), lightweightConversationImpl);
            Conversation conversation = (Conversation)lightweightConversationImpl.clone();
            return conversation;
        }
    }

    public Conversation getConversation(String string) throws InvalidConversationIDException {
        if (this._terminate) {
            return null;
        }
        Conversation conversation = null;
        Map map = this._active_list;
        synchronized (map) {
            conversation = (Conversation)((LightweightConversationImpl)this._active_list.get(string)).clone();
        }
        if (conversation == null) {
            try {
                this._database.startTransaction(true);
                conversation = (Conversation)this._database.findObject(string);
                return conversation;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    this._database.endTransaction();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (conversation == null) {
            throw new InvalidConversationIDException("Conversation " + string + " isn't active");
        }
        return conversation;
    }

    public void removeConversation(String string) throws InvalidConversationIDException {
        if (this._terminate) {
            return;
        }
        LightweightConversationImpl lightweightConversationImpl = null;
        Map map = this._active_list;
        synchronized (map) {
            lightweightConversationImpl = (LightweightConversationImpl)this._active_list.remove(string);
        }
    }

    public boolean hasActiveConversations() {
        return !this._active_list.isEmpty();
    }

    public boolean addProtocol(String string, String string2) {
        return true;
    }

    public boolean hasProtocol(String string) {
        return true;
    }

    public void sendMessage(Message message) {
        if (this._terminate) {
            return;
        }
        message.getEnvelope().setSlotValue("X-fipaos-debug-cm-send-time", new Long(System.currentTimeMillis()));
        try {
            if (this._sender != null) {
                this.handleMessage(message);
                this._sender.sendMessage(message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setMessageSender(MessageSender messageSender) {
        this._sender = messageSender;
    }

    public void setMessageReceiver(MessageReceiver messageReceiver) {
    }

    public void shutdown() {
        if (this._terminate) {
            return;
        }
        this._terminate = true;
        this._monitor.halt();
        this._thread.interrupt();
        this._owner = null;
        this._conversation_listener = null;
        this._sender = null;
        this._agent_id = null;
        this._database = null;
        this._monitor = null;
        this._updates = null;
        this._thread = null;
        this._active_list.clear();
        this._active_list = null;
        this._protocol_cache.clear();
        this._protocol_cache = null;
    }

    public void receiveMessage(Message message) {
        if (this._terminate) {
            return;
        }
        message.getEnvelope().setSlotValue("X-fipaos-debug-cm-receive-time", new Long(System.currentTimeMillis()));
        try {
            this._owner.waitForPushLock();
            this.handleMessage(message);
        }
        catch (ProtocolErrorException protocolErrorException) {
            this._owner.sendNotUnderstood(message.getACL());
        }
        catch (ConversationFinishedException conversationFinishedException) {
            this._owner.sendNotUnderstood(message.getACL());
        }
        catch (ConversationManagerException conversationManagerException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void run() {
        while (!this._terminate) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkState();
        }
    }

    private void checkState(Conversation conversation) {
        if (this._terminate) {
            return;
        }
        Map map = this._active_list;
        synchronized (map) {
            Conversation conversation2 = conversation;
            synchronized (conversation2) {
                long l = conversation.getTimeOut();
                AgentID agentID = conversation.getSenderAID(conversation.getLatestMessageIndex());
                switch (conversation.getState()) {
                    case -1: {
                        try {
                            this.removeConversation(conversation.getConversationID());
                        }
                        catch (InvalidConversationIDException invalidConversationIDException) {
                            break;
                        }
                    }
                    default: {
                        if (agentID.equals(this._agent_id)) break;
                        this._conversation_listener.notify(conversation);
                    }
                }
            }
        }
    }

    private void checkState() {
        if (this._terminate) {
            return;
        }
        Map map = this._active_list;
        synchronized (map) {
            Iterator iterator = this._active_list.keySet().iterator();
            while (iterator.hasNext()) {
                LightweightConversationImpl lightweightConversationImpl;
                String string = (String)iterator.next();
                LightweightConversationImpl lightweightConversationImpl2 = lightweightConversationImpl = (LightweightConversationImpl)this._active_list.get(string);
                synchronized (lightweightConversationImpl2) {
                    long l = lightweightConversationImpl.getTimeOut();
                    if (!(lightweightConversationImpl.isUpdated() || l != -1L && l <= System.currentTimeMillis())) {
                        continue;
                    }
                    switch (lightweightConversationImpl.getState()) {
                        case -3: 
                        case -1: {
                            try {
                                this._updates.addItem(lightweightConversationImpl.cloneAndResetUpdate());
                            }
                            catch (NullPointerException nullPointerException) {}
                            break;
                        }
                        case -2: {
                            lightweightConversationImpl.resetUpdate();
                            break;
                        }
                    }
                }
            }
        }
    }

    private LightweightConversationImpl createConversation(String string, AgentID agentID) throws UnknownProtocolException {
        LightweightConversationImpl lightweightConversationImpl = new LightweightConversationImpl(string, agentID);
        lightweightConversationImpl.setConversationID(this.createConversationID());
        return lightweightConversationImpl;
    }

    private synchronized String createConversationID() {
        String string = null;
        String string2 = null;
        ++this._count;
        long l = System.currentTimeMillis();
        string2 = "" + l;
        string = this._agent_name + string2 + this._count;
        return string;
    }

    public void handleMessage(Message message) throws UnknownProtocolException, InvalidConversationIDException, ProtocolErrorException, ConversationFinishedException {
        if (this._terminate) {
            return;
        }
        ACL aCL = message.getACL();
        if (aCL.getConversationID() == null) {
            LightweightConversationImpl lightweightConversationImpl = this.createConversation(aCL.getProtocol(), this._agent_id);
            aCL.setConversationID(lightweightConversationImpl.getConversationID());
            Map map = this._active_list;
            synchronized (map) {
                this._active_list.put(lightweightConversationImpl.getConversationID(), lightweightConversationImpl);
                LightweightConversationImpl lightweightConversationImpl2 = lightweightConversationImpl;
                synchronized (lightweightConversationImpl2) {
                    lightweightConversationImpl.addMessage(message);
                    lightweightConversationImpl = lightweightConversationImpl.cloneAndResetUpdate();
                }
                this.dealWithConversation(lightweightConversationImpl);
            }
        }
        Map map = this._active_list;
        synchronized (map) {
            LightweightConversationImpl lightweightConversationImpl = (LightweightConversationImpl)this._active_list.get(aCL.getConversationID());
            if (lightweightConversationImpl == null) {
                lightweightConversationImpl = this.createConversation(aCL.getProtocol(), this._agent_name, aCL.getConversationID());
                this._active_list.put(lightweightConversationImpl.getConversationID(), lightweightConversationImpl);
            }
            LightweightConversationImpl lightweightConversationImpl3 = lightweightConversationImpl;
            synchronized (lightweightConversationImpl3) {
                lightweightConversationImpl.addMessage(message);
                lightweightConversationImpl = lightweightConversationImpl.cloneAndResetUpdate();
            }
            this.dealWithConversation(lightweightConversationImpl);
        }
    }

    private LightweightConversationImpl createConversation(String string, String string2, String string3) throws UnknownProtocolException {
        LightweightConversationImpl lightweightConversationImpl = this.createConversation(string, this._agent_id);
        lightweightConversationImpl.setConversationID(string3);
        return lightweightConversationImpl;
    }

    private void dealWithConversation(LightweightConversationImpl lightweightConversationImpl) {
        if (this._terminate) {
            return;
        }
        if (lightweightConversationImpl.getState() != -2 && lightweightConversationImpl.getState() != -4) {
            this._updates.addItem(lightweightConversationImpl);
        }
    }

    public static void main(String[] stringArray) {
    }
}

