/*
 * Decompiled with CFR 0.152.
 */
package fipaos.agent.conversation.standard;

import fipaos.agent.conversation.Conversation;
import fipaos.agent.conversation.ConversationFinishedException;
import fipaos.agent.conversation.InvalidConversationIDException;
import fipaos.agent.conversation.ProtocolErrorException;
import fipaos.agent.conversation.UnknownProtocolException;
import fipaos.agent.conversation.standard.ConversationManagerImpl;
import fipaos.mts.Message;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.Envelope;
import fipaos.parser.ParserException;
import fipaos.parser.acl.ACLMessage;
import fipaos.skill.db.DatabaseObject;
import fipaos.util.Comparators;
import fipaos.util.UTCContainer;
import fipaos.util.UTCDuration;
import fipaos.util.UTCTime;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class ConversationImpl
implements Cloneable,
Serializable,
DatabaseObject,
Conversation {
    public static final int CONVERSATION_END = -1;
    public static final int NO_AGENT_ACTION_REQ = -2;
    public static final int AGENT_ACTION_REQ = -3;
    public static final int WAIT_BEFORE_END = -4;
    private static ConversationProtocol __not_understood = new ConversationProtocol();
    protected ConversationProtocol _protocol_tree;
    private ConversationProtocol _current_node;
    transient Object _serialised = new Object();
    private List _messages = new LinkedList();
    private boolean _updated;
    protected AgentID _agent_id;
    private AgentID _other_agent_aid;
    private boolean _initiator = true;
    private boolean _initiator_known = false;
    private String _conv_id;
    protected String _protocol;
    private long _wait_before_end_timeout;
    static /* synthetic */ Class class$fipaos$agent$conversation$standard$ConversationImpl;

    protected ConversationImpl() {
    }

    public static ConversationImpl getConversation(String string, String string2) throws UnknownProtocolException, ParserException {
        return ConversationImpl.getConversation(string, new AgentID(string2));
    }

    public static ConversationImpl getConversation(String string, AgentID agentID) throws UnknownProtocolException {
        String string2 = ConversationManagerImpl.getProtocolClassName(string);
        try {
            Class<?> clazz = Class.forName(string2);
            Field field = clazz.getField("__protocol");
            if (!(class$fipaos$agent$conversation$standard$ConversationImpl == null ? (class$fipaos$agent$conversation$standard$ConversationImpl = ConversationImpl.class$("fipaos.agent.conversation.standard.ConversationImpl")) : class$fipaos$agent$conversation$standard$ConversationImpl).isAssignableFrom(clazz)) {
                throw new UnknownProtocolException("Error loading class " + string2 + " - it doesn't " + "extend ConversationImpl class");
            }
            ConversationImpl conversationImpl = (ConversationImpl)clazz.newInstance();
            conversationImpl._agent_id = agentID;
            conversationImpl._protocol = string;
            conversationImpl._protocol_tree = ConversationImpl.setupProtocol((Object[])field.get(null));
            conversationImpl._conv_id = System.currentTimeMillis() + "";
            return conversationImpl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnknownProtocolException("Error creating Conversation class to deal with \"" + string + "\", " + string2 + " was not found");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Error creating Conversation class to deal with \"" + string + "\", " + string2 + " could not be " + "instantiaited");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Error creating Conversation class to deal with \"" + string + "\", SecurityManager prevented " + string2 + " from being instantiated");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("Error creating Conversation object from " + string2 + ", it doesn't contain a __protocol definition");
        }
    }

    public int getLatestMessageIndex() {
        return this._messages.size() - 1;
    }

    public ACL getACL(int n) {
        ACL aCL = null;
        try {
            Message message = ((MessageDetails)this._messages.get((int)n))._msg;
            aCL = message.getACL();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return aCL;
    }

    public Envelope getEnvelope(int n) {
        Envelope envelope = null;
        try {
            Message message = ((MessageDetails)this._messages.get((int)n))._msg;
            envelope = message.getEnvelope();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return envelope;
    }

    public ACLMessage getMessage(int n) {
        ACLMessage aCLMessage = null;
        try {
            Message message = ((MessageDetails)this._messages.get((int)n))._msg;
            ACL aCL = message.getACL();
            aCLMessage = new ACLMessage(aCL);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return aCLMessage;
    }

    public String getSender(int n) {
        String string = null;
        try {
            MessageDetails messageDetails = (MessageDetails)this._messages.get(n);
            string = messageDetails._msg.getACL().getSenderAID().toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    public AgentID getSenderAID(int n) {
        AgentID agentID = null;
        try {
            MessageDetails messageDetails = (MessageDetails)this._messages.get(n);
            agentID = messageDetails._msg.getACL().getSenderAID();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return agentID;
    }

    public long getTimeStamp(int n) {
        long l = -1L;
        try {
            l = ((MessageDetails)this._messages.get((int)n))._timestamp;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return l;
    }

    public long getTimeOut() {
        long l = -1L;
        try {
            l = ((MessageDetails)this._messages.get((int)(this._messages.size() - 1)))._timeout;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return l;
    }

    public List getNextPerformatives() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this._current_node == null && this._protocol_tree != null) {
            linkedList.add(this._protocol_tree._performative);
        } else if (this._current_node != null) {
            Iterator iterator = this._current_node._following_nodes.iterator();
            while (iterator.hasNext()) {
                ConversationProtocol conversationProtocol = (ConversationProtocol)iterator.next();
                if (conversationProtocol._initiator != this._initiator && this._initiator_known) continue;
                linkedList.add(conversationProtocol._performative);
            }
        }
        return linkedList;
    }

    public List getNextMessages() {
        LinkedList<ACL> linkedList = new LinkedList<ACL>();
        if (this._current_node == null && this._protocol_tree != null) {
            ACL aCL = this.getFilledInACL();
            aCL.setPerformative(this._protocol_tree._performative);
            linkedList.add(aCL);
        } else if (this._current_node != null) {
            Iterator iterator = this._current_node._following_nodes.iterator();
            while (iterator.hasNext()) {
                ConversationProtocol conversationProtocol = (ConversationProtocol)iterator.next();
                if (conversationProtocol._initiator != this._initiator && this._initiator_known) continue;
                ACL aCL = this.getFilledInACL();
                aCL.setPerformative(conversationProtocol._performative);
                aCL.setReceiverAID(this._other_agent_aid);
                linkedList.add(aCL);
            }
        }
        return linkedList;
    }

    public ACL getFilledInACL() {
        ACL aCL = new ACL();
        try {
            aCL.setConversationID(this._conv_id);
            aCL.setSenderAID(this._agent_id);
            aCL.setProtocol(this._protocol);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return aCL;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getConversationID() {
        return this._conv_id;
    }

    public synchronized int getState() {
        if (this._serialised == null) {
            return -1;
        }
        if (this._current_node == null && this._protocol_tree != null) {
            return -2;
        }
        if (this._protocol_tree == null) {
            if (this._agent_id.equals(this.getSenderAID(this.getLatestMessageIndex()))) {
                return -2;
            }
            return -3;
        }
        if (this._current_node._following_nodes.isEmpty()) {
            return -1;
        }
        if (this._initiator == this._current_node._initiator && this._initiator_known) {
            Iterator iterator = this._current_node._following_nodes.iterator();
            while (iterator.hasNext()) {
                ConversationProtocol conversationProtocol = (ConversationProtocol)iterator.next();
                if (this._initiator != conversationProtocol._initiator) continue;
                return -3;
            }
            return -2;
        }
        if (this._current_node._conv_state == -4) {
            if (this._wait_before_end_timeout > System.currentTimeMillis()) {
                return -2;
            }
            return -1;
        }
        return this._current_node._conv_state;
    }

    public String getObjectID() {
        return this._conv_id;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        ConversationImpl conversationImpl = this;
        synchronized (conversationImpl) {
            stringBuffer.append("-----------------------------\n");
            int n = this._messages.size();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(this._messages.get(n2));
                stringBuffer.append("\n");
                ++n2;
            }
            stringBuffer.append("State: ");
            if (this.getState() == -3) {
                stringBuffer.append("Agent action required\n");
            } else if (this.getState() == -2) {
                stringBuffer.append("No action required\n");
            } else if (this.getState() == -1) {
                stringBuffer.append("End of conversation\n");
            }
        }
        return stringBuffer.toString();
    }

    public synchronized Object clone() {
        try {
            ConversationImpl conversationImpl = (ConversationImpl)super.clone();
            conversationImpl._agent_id = (AgentID)this._agent_id.clone();
            if (this._other_agent_aid != null) {
                conversationImpl._other_agent_aid = (AgentID)this._other_agent_aid.clone();
            }
            this.cloneProtocols(conversationImpl);
            if (this._messages != null) {
                conversationImpl._messages = new LinkedList();
                Iterator iterator = this._messages.iterator();
                while (iterator.hasNext()) {
                    conversationImpl._messages.add(((MessageDetails)iterator.next()).clone());
                }
            }
            conversationImpl._serialised = this._serialised;
            return conversationImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void cloneProtocols(ConversationImpl conversationImpl) {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        if (this._protocol_tree != null) {
            conversationImpl._protocol_tree = this._protocol_tree.clone(linkedList, linkedList2);
        }
        if (this._current_node != null) {
            if (this._current_node == __not_understood) {
                conversationImpl._current_node = __not_understood;
            } else if (this._protocol_tree == null) {
                conversationImpl._current_node = this._current_node;
            } else {
                int n = linkedList.indexOf(this._current_node);
                conversationImpl._current_node = (ConversationProtocol)linkedList2.get(n);
            }
        }
    }

    synchronized void removeReferences() {
        if (this._messages != null) {
            this._messages.clear();
            this._messages = null;
        }
        this._agent_id = null;
        this._other_agent_aid = null;
        this._conv_id = null;
        this._protocol = null;
        if (this._protocol_tree != null) {
            this._protocol_tree.removeReferences();
            this._protocol_tree = null;
        }
        this._current_node = null;
    }

    void setConversationID(String string) {
        this._conv_id = string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void addMessage(Message message) throws ProtocolErrorException, InvalidConversationIDException, ConversationFinishedException {
        ACL aCL;
        block27: {
            ConversationProtocol conversationProtocol;
            Cloneable cloneable;
            String string = message.getACL().getConversationID();
            if (string == null || !string.equals(this._conv_id)) {
                throw new InvalidConversationIDException("ConversationID is invalid or not specified");
            }
            message = (Message)message.clone();
            aCL = message.getACL();
            String string2 = aCL.getPerformative();
            AgentID agentID = aCL.getSenderAID();
            AgentID agentID2 = aCL.getReceiverAID();
            boolean bl = false;
            if (aCL.getReceiverAIDs().size() > 1) {
                agentID2 = this._agent_id;
            } else {
                if (aCL.getReceiverAIDs().size() != 1) {
                    throw new ProtocolErrorException("No receiver specified");
                }
                agentID2 = (AgentID)aCL.getReceiverAIDs().get(0);
            }
            if (!this._initiator_known) {
                cloneable = message.getACL();
                this._initiator = ((ACL)cloneable).getSenderAID().equals(this._agent_id);
                this._initiator_known = true;
                this._other_agent_aid = this._initiator ? ((ACL)cloneable).getReceiverAID() : ((ACL)cloneable).getSenderAID();
            }
            bl = this._initiator && agentID.equals(this._agent_id);
            bl |= !this._initiator && !agentID.equals(this._agent_id);
            if (string2.equalsIgnoreCase("not-understood")) {
                if (this._current_node == __not_understood) {
                    return;
                }
                if (this._current_node != null && this._current_node._performative == "not-understood") {
                    throw new ConversationFinishedException("NOT_UNDERSTOOD is not a valid response for a previous NOT_UNDERSTOOD message!");
                }
                if (!agentID.equals(this._agent_id) && this._other_agent_aid != null && !agentID.equals(this._other_agent_aid)) {
                    return;
                }
                this.addMessageDetails(message);
                if (this._protocol_tree != null) {
                    this._current_node = __not_understood;
                } else {
                    this._current_node = new ConversationProtocol();
                    this._current_node._performative = "not-understood";
                }
                this._updated = true;
                return;
            }
            if (this._protocol_tree == null) {
                this.addMessageDetails(message);
                this._updated = true;
                if (this._current_node != null) {
                    this._current_node._performative = string2;
                }
                return;
            }
            if (this._current_node == null) {
                if (this._protocol_tree._performative.equalsIgnoreCase("query-if") && string2.equals("query-if") || this._protocol_tree._performative.equalsIgnoreCase("query-ref") && string2.equals("query-if") || this._protocol_tree._performative.equalsIgnoreCase(string2)) {
                    this._current_node = this._protocol_tree;
                    this.addMessageDetails(message);
                    break block27;
                } else {
                    if (agentID.equals(this._agent_id)) {
                        this.addMessageDetails(message);
                    }
                    throw new ProtocolErrorException("Unexpected message received of type " + string2);
                }
            }
            if (this._current_node._following_nodes.isEmpty()) {
                throw new ConversationFinishedException("Message received in conversation which has already ended!");
            }
            cloneable = new LinkedList();
            Iterator iterator = this._current_node._following_nodes.iterator();
            while (iterator.hasNext()) {
                conversationProtocol = (ConversationProtocol)iterator.next();
                if (!conversationProtocol._performative.equalsIgnoreCase(string2)) continue;
                cloneable.add(conversationProtocol);
            }
            if (cloneable.isEmpty()) {
                if (agentID.equals(this._agent_id)) {
                    this.addMessageDetails(message);
                }
                throw new ProtocolErrorException("Unexpected message received of type " + string2);
            }
            conversationProtocol = null;
            iterator = cloneable.iterator();
            while (iterator.hasNext() && conversationProtocol == null) {
                ConversationProtocol conversationProtocol2 = (ConversationProtocol)iterator.next();
                if (bl != conversationProtocol2._initiator) continue;
                conversationProtocol = conversationProtocol2;
            }
            if (conversationProtocol == null) {
                if (agentID.equals(this._agent_id)) {
                    throw new ProtocolErrorException("Couldn't match expected message types and participant");
                }
                this.addMessageDetails(message);
            }
            this._current_node = conversationProtocol;
        }
        if (this._current_node._conv_state == -4) {
            if (this._current_node._initiator == this._initiator) {
                aCL.setReplyByUTC(new UTCDuration(0, 0, 0, 0, 0, 10, 0));
                this._wait_before_end_timeout = System.currentTimeMillis() + 10000L;
            } else {
                this._wait_before_end_timeout = 0L;
            }
        }
        this._updated = true;
        this.addMessageDetails(message);
    }

    synchronized boolean isUpdated() {
        return this._updated;
    }

    synchronized void resetUpdate() {
        this._updated = false;
    }

    synchronized ConversationImpl cloneAndResetUpdate() {
        ConversationImpl conversationImpl = (ConversationImpl)this.clone();
        this._updated = false;
        return conversationImpl;
    }

    private static ConversationProtocol setupProtocol(Object[] objectArray) {
        List list = null;
        try {
            list = ConversationImpl.getProtocolTree(objectArray, new TreeMap(Comparators.OBJECT_COMPARE));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (ConversationProtocol)list.get(0);
    }

    private static List getProtocolTree(Object[] objectArray, Map map) {
        if (objectArray == null) {
            return new LinkedList();
        }
        LinkedList<ConversationProtocol> linkedList = new LinkedList<ConversationProtocol>();
        int n = 0;
        while (n < objectArray.length) {
            ConversationProtocol conversationProtocol = new ConversationProtocol();
            conversationProtocol._performative = (String)objectArray[n++];
            conversationProtocol._conv_state = objectArray[n] instanceof Integer && (Integer)objectArray[n] < 0 ? (Integer)objectArray[n++] : -1;
            boolean bl = conversationProtocol._initiator = (Integer)objectArray[n++] == 0;
            if (n < objectArray.length && !(objectArray[n] instanceof String)) {
                if (map.containsKey(objectArray[n])) {
                    conversationProtocol._following_nodes = (List)map.get(objectArray[n++]);
                } else {
                    List list = new LinkedList();
                    map.put(objectArray, linkedList);
                    conversationProtocol._following_nodes = list = ConversationImpl.getProtocolTree((Object[])objectArray[n++], map);
                }
            } else {
                conversationProtocol._following_nodes = new LinkedList();
            }
            if (conversationProtocol._following_nodes == null) {
                conversationProtocol._following_nodes = new LinkedList();
            }
            linkedList.add(conversationProtocol);
        }
        return linkedList;
    }

    private void addMessageDetails(Message message) {
        MessageDetails messageDetails = new MessageDetails();
        messageDetails._msg = message;
        messageDetails._timestamp = System.currentTimeMillis();
        messageDetails._timeout = -1L;
        if (message.getACL().getReplyByUTC() != null) {
            UTCContainer uTCContainer = message.getACL().getReplyByUTC();
            if (uTCContainer instanceof UTCTime) {
                long l = new UTCTime().getZTime().getTimeInMillis();
                long l2 = ((UTCTime)uTCContainer).getZTime().getTimeInMillis() - l;
                messageDetails._timeout = messageDetails._timestamp + l2;
            } else if (uTCContainer instanceof UTCDuration) {
                messageDetails._timeout = messageDetails._timestamp + ((UTCDuration)uTCContainer).getDurationInMillis();
            }
        }
        this._messages.add(messageDetails);
    }

    public static void testAddMessages(String string, String[] stringArray, boolean bl) throws Throwable {
        AgentID agentID = new AgentID();
        agentID.setName(stringArray[1]);
        ConversationImpl conversationImpl = ConversationImpl.getConversation(string, agentID);
        ConversationImpl.testAddMessages(conversationImpl, stringArray, bl);
    }

    public static void testAddMessages(ConversationImpl conversationImpl, String[] stringArray, boolean bl) {
        conversationImpl.setConversationID("testid");
        try {
            int n = 0;
            while (n < stringArray.length) {
                AgentID agentID = new AgentID();
                AgentID agentID2 = new AgentID();
                agentID.setName(stringArray[n + 1]);
                agentID2.setName(stringArray[n + 1].equalsIgnoreCase(stringArray[1]) ? stringArray[3] : stringArray[1]);
                ACL aCL = new ACL();
                aCL.setPerformative(stringArray[n]);
                aCL.setSenderAID(agentID);
                aCL.setReceiverAID(agentID2);
                aCL.setConversationID("testid");
                try {
                    conversationImpl.addMessage(new Message(aCL));
                }
                catch (ProtocolErrorException protocolErrorException) {
                    try {
                        if (stringArray[n + 1].equals(stringArray[1])) {
                            throw protocolErrorException;
                        }
                        ACLMessage aCLMessage = new ACLMessage();
                        aCLMessage.setPerformative("not-understood");
                        aCLMessage.setSenderAID(agentID);
                        aCLMessage.setConversationID("testid");
                        conversationImpl.addMessage(new Message(aCLMessage));
                        if (!bl) {
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    break;
                }
                n += 2;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static ConversationImpl testPopulate(ACLMessage aCLMessage, String string) {
        ConversationImpl conversationImpl = null;
        try {
            conversationImpl = ConversationImpl.getConversation(string, aCLMessage.getSenderAID());
        }
        catch (UnknownProtocolException unknownProtocolException) {
            // empty catch block
        }
        conversationImpl.setConversationID(aCLMessage.getConversationID());
        try {
            conversationImpl.addMessage(new Message(aCLMessage));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return conversationImpl;
    }

    public static void main(String[] stringArray) throws Throwable {
        ACLMessage aCLMessage = new ACLMessage();
        aCLMessage.setConversationID("2222");
        aCLMessage.setSender("agent1@iiop://47.101.224.356:9000/acc");
        aCLMessage.setPerformative("request");
        aCLMessage.setOntology("FIPA Agent Management");
        ConversationImpl conversationImpl = ConversationImpl.testPopulate(aCLMessage, "fipa-request");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ConversationImpl.__not_understood._performative = "not-understood";
        ConversationImpl.__not_understood._conv_state = -1;
        ConversationImpl.__not_understood._following_nodes = new LinkedList();
    }

    public static class ConversationProtocol
    implements Serializable,
    Cloneable {
        public String _performative;
        public boolean _initiator;
        public List _following_nodes;
        public int _conv_state;
        public boolean _wait_for_response;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append(" ");
            stringBuffer.append(this._performative);
            stringBuffer.append(",");
            stringBuffer.append(" ");
            stringBuffer.append("initiator=");
            stringBuffer.append(this._initiator);
            if (this._following_nodes != null) {
                stringBuffer.append(",");
                stringBuffer.append(" ");
                stringBuffer.append(this._following_nodes.toString());
            }
            stringBuffer.append(",");
            stringBuffer.append(this._conv_state);
            stringBuffer.append(" ");
            stringBuffer.append("}");
            return stringBuffer.toString();
        }

        public void removeReferences() {
            if (this._following_nodes != null) {
                LinkedList linkedList = new LinkedList(this._following_nodes);
                Iterator iterator = linkedList.iterator();
                this._following_nodes.clear();
                this._following_nodes = null;
                while (iterator.hasNext()) {
                    ConversationProtocol conversationProtocol = (ConversationProtocol)iterator.next();
                    conversationProtocol.removeReferences();
                }
                linkedList.clear();
            }
        }

        public Object clone() {
            return this.clone(new LinkedList(), new LinkedList());
        }

        public ConversationProtocol clone(List list, List list2) {
            try {
                ConversationProtocol conversationProtocol = (ConversationProtocol)super.clone();
                conversationProtocol._following_nodes = new LinkedList();
                list.add(this);
                list2.add(conversationProtocol);
                Iterator iterator = this._following_nodes.iterator();
                while (iterator.hasNext()) {
                    ConversationProtocol conversationProtocol2 = (ConversationProtocol)iterator.next();
                    if (list.contains(conversationProtocol2)) {
                        int n = list.indexOf(conversationProtocol2);
                        conversationProtocol2 = (ConversationProtocol)list2.get(n);
                    } else {
                        conversationProtocol2 = conversationProtocol2.clone(list, list2);
                    }
                    conversationProtocol._following_nodes.add(conversationProtocol2);
                }
                return conversationProtocol;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    class MessageDetails
    implements Serializable,
    Cloneable {
        public Message _msg;
        public long _timestamp;
        public long _timeout = -1L;

        MessageDetails() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append(" ");
            stringBuffer.append(this._msg.toString());
            stringBuffer.append(",");
            stringBuffer.append(" ");
            stringBuffer.append(this._timestamp);
            stringBuffer.append(",");
            stringBuffer.append(" ");
            stringBuffer.append(this._timeout);
            stringBuffer.append(" ");
            stringBuffer.append("}");
            return stringBuffer.toString();
        }

        public Object clone() {
            try {
                MessageDetails messageDetails = (MessageDetails)super.clone();
                messageDetails._msg = (Message)this._msg.clone();
                return messageDetails;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

