/*
 * Decompiled with CFR 0.152.
 */
package fipaos.agent.conversation.standard;

import fipaos.agent.FIPAOSAgent;
import fipaos.agent.conversation.Conversation;
import fipaos.agent.conversation.ConversationFinishedException;
import fipaos.agent.conversation.ConversationListener;
import fipaos.agent.conversation.ConversationManager;
import fipaos.agent.conversation.ConversationManagerException;
import fipaos.agent.conversation.InvalidConversationIDException;
import fipaos.agent.conversation.ProtocolErrorException;
import fipaos.agent.conversation.UnknownProtocolException;
import fipaos.agent.conversation.standard.ConversationImpl;
import fipaos.agent.profile.DatabaseProfile;
import fipaos.agent.profile.ProtocolMapping;
import fipaos.agent.profile.ProtocolMappingImpl;
import fipaos.agent.profile.ProtocolProfile;
import fipaos.agent.profile.ProtocolProfileImpl;
import fipaos.mts.Message;
import fipaos.mts.MessageReceiver;
import fipaos.mts.MessageSender;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.skill.db.Database;
import fipaos.skill.db.DatabaseException;
import fipaos.skill.db.DatabaseFactory;
import fipaos.skill.db.DatabaseObject;
import fipaos.util.Comparators;
import fipaos.util.FIFOQueue;
import fipaos.util.Monitor;
import fipaos.util.MonitorListener;
import fipaos.util.Queue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class ConversationManagerImpl
implements Runnable,
ConversationManager {
    private int _count = 0;
    private String _agent_name;
    private AgentID _agent_id;
    private Map _active_list;
    private Map _protocol_cache;
    private Queue _updates;
    private MessageSender _sender;
    private FIPAOSAgent _owner;
    private ConversationListener _conversation_listener;
    private Database _database;
    private Thread _thread;
    private Monitor _monitor;
    private boolean _terminate = false;
    private static ProtocolProfile __protocol_profile;

    public ConversationManagerImpl(ConversationListener conversationListener, MessageSender messageSender, FIPAOSAgent fIPAOSAgent, DatabaseProfile databaseProfile, ProtocolProfile protocolProfile) {
        this._owner = fIPAOSAgent;
        this._conversation_listener = conversationListener;
        this._agent_id = fIPAOSAgent.getAID();
        this._agent_name = fIPAOSAgent.getAID().getName();
        this._sender = messageSender;
        __protocol_profile = protocolProfile;
        this._active_list = new TreeMap(Comparators.STRING_COMPARE);
        this._protocol_cache = new TreeMap(Comparators.STRING_COMPARE);
        String string = fIPAOSAgent.getAID().getName() + "_convdb";
        this._database = DatabaseFactory.getDatabase(string, databaseProfile);
        if (this._database == null) {
            return;
        }
        try {
            this._database.openDatabase();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        this._thread = new Thread((Runnable)this, "CM-" + this._agent_name);
        this._thread.start();
        this._updates = new FIFOQueue();
        this._monitor = new Monitor(this._updates, new MonitorListener(){

            public void monitorUpdate(Object object) {
                try {
                    if (object instanceof Conversation) {
                        Conversation conversation = (Conversation)object;
                        ConversationManagerImpl.this.checkState(conversation);
                    } else if (object instanceof Message) {
                        ConversationManagerImpl.this._conversation_listener.notifyMessageInEndedConversation((Message)object);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this._sender.setMessageReceiver(this);
        this._conversation_listener.setMessageSender(this);
    }

    public void shutdown() {
        if (this._terminate) {
            return;
        }
        this._terminate = true;
        this._monitor.halt();
        this._thread.interrupt();
        this._owner = null;
        this._conversation_listener = null;
        this._sender = null;
        this._agent_id = null;
        this._database = null;
        this._monitor = null;
        this._updates = null;
        this._thread = null;
        this._active_list.clear();
        this._active_list = null;
        this._protocol_cache.clear();
        this._protocol_cache = null;
    }

    public void setMessageReceiver(MessageReceiver messageReceiver) {
    }

    public void sendMessage(Message message) {
        if (this._terminate) {
            return;
        }
        message.getEnvelope().setSlotValue("X-fipaos-debug-cm-send-time", new Long(System.currentTimeMillis()));
        try {
            if (this._sender != null) {
                this.handleMessage(message);
                this._sender.sendMessage(message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void receiveMessage(Message message) {
        if (this._terminate) {
            return;
        }
        message.getEnvelope().setSlotValue("X-fipaos-debug-cm-receive-time", new Long(System.currentTimeMillis()));
        try {
            this._owner.waitForPushLock();
            this.handleMessage(message);
        }
        catch (ProtocolErrorException protocolErrorException) {
            this._owner.sendNotUnderstood(message.getACL());
        }
        catch (ConversationFinishedException conversationFinishedException) {
            this._updates.addItem(message);
        }
        catch (ConversationManagerException conversationManagerException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setMessageSender(MessageSender messageSender) {
        this._sender = messageSender;
    }

    public void run() {
        while (!this._terminate) {
            try {
                Thread.sleep(5000L);
                this.checkState();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void setProtocolProfile(ProtocolProfile protocolProfile) {
        __protocol_profile = protocolProfile;
    }

    public void handleMessage(Message message) throws UnknownProtocolException, InvalidConversationIDException, ProtocolErrorException, ConversationFinishedException {
        if (this._terminate) {
            return;
        }
        ACL aCL = message.getACL();
        if (aCL.getConversationID() == null) {
            ConversationImpl conversationImpl = this.createConversation(aCL.getProtocol(), this._agent_id);
            aCL.setConversationID(conversationImpl.getConversationID());
            Map map = this._active_list;
            synchronized (map) {
                this._active_list.put(conversationImpl.getConversationID(), conversationImpl);
                ConversationImpl conversationImpl2 = conversationImpl;
                synchronized (conversationImpl2) {
                    conversationImpl.addMessage(message);
                    conversationImpl = conversationImpl.cloneAndResetUpdate();
                }
                this.dealWithConversation(conversationImpl);
            }
        }
        Map map = this._active_list;
        synchronized (map) {
            ConversationImpl conversationImpl = (ConversationImpl)this._active_list.get(aCL.getConversationID());
            if (conversationImpl == null) {
                conversationImpl = this.createConversation(aCL.getProtocol(), this._agent_name, aCL.getConversationID());
                this._active_list.put(conversationImpl.getConversationID(), conversationImpl);
            }
            ConversationImpl conversationImpl3 = conversationImpl;
            synchronized (conversationImpl3) {
                conversationImpl.addMessage(message);
                conversationImpl = conversationImpl.cloneAndResetUpdate();
            }
            this.dealWithConversation(conversationImpl);
        }
    }

    public Conversation addConversation(String string) throws UnknownProtocolException {
        if (this._terminate) {
            return null;
        }
        Map map = this._active_list;
        synchronized (map) {
            ConversationImpl conversationImpl = this.createConversation(string, this._agent_id);
            this._active_list.put(conversationImpl.getConversationID(), conversationImpl);
            Conversation conversation = (Conversation)conversationImpl.clone();
            return conversation;
        }
    }

    public Conversation getConversation(String string) throws InvalidConversationIDException {
        if (this._terminate) {
            return null;
        }
        Conversation conversation = null;
        Map map = this._active_list;
        synchronized (map) {
            ConversationImpl conversationImpl = (ConversationImpl)this._active_list.get(string);
            if (conversationImpl != null) {
                conversation = (Conversation)conversationImpl.clone();
            }
        }
        if (conversation == null) {
            try {
                this._database.startTransaction(true);
                conversation = (Conversation)this._database.findObject(string);
                return conversation;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    this._database.endTransaction();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (conversation == null) {
            throw new InvalidConversationIDException("Conversation " + string + " isn't active");
        }
        return conversation;
    }

    public boolean hasActiveConversations() {
        return !this._active_list.isEmpty();
    }

    public boolean addProtocol(String string, String string2) {
        return false;
    }

    public boolean hasProtocol(String string) {
        if (this._terminate) {
            return false;
        }
        if (this._protocol_cache.containsKey(string)) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(ConversationManagerImpl.getProtocolClassName(string));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static String getProtocolClassName(String string) throws UnknownProtocolException {
        String string2 = null;
        if (string != null && !string.equals("") && __protocol_profile != null) {
            Vector vector = (Vector)__protocol_profile.getProtocolMappings();
            if (vector != null) {
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    ProtocolMapping protocolMapping = (ProtocolMapping)iterator.next();
                    if (!protocolMapping.getProtocolName().equalsIgnoreCase(string)) continue;
                    string2 = protocolMapping.getProtocolClass();
                }
            }
        } else {
            string2 = "fipaos.agent.conversation.standard.protocol.NoProtocol";
        }
        if (string2 == null) {
            throw new UnknownProtocolException("CM: No class mapped to protocol " + string);
        }
        return string2;
    }

    private synchronized String createConversationID() {
        String string = null;
        String string2 = null;
        ++this._count;
        long l = System.currentTimeMillis();
        string2 = "" + l;
        string = this._agent_name + string2 + this._count;
        return string;
    }

    private ConversationImpl createConversation(String string, AgentID agentID) throws UnknownProtocolException {
        ConversationImpl conversationImpl = null;
        conversationImpl = ConversationImpl.getConversation(string, agentID);
        conversationImpl.setConversationID(this.createConversationID());
        return conversationImpl;
    }

    private ConversationImpl createConversation(String string, String string2, String string3) throws UnknownProtocolException {
        ConversationImpl conversationImpl = this.createConversation(string, this._agent_id);
        conversationImpl.setConversationID(string3);
        return conversationImpl;
    }

    private void dealWithConversation(ConversationImpl conversationImpl) {
        if (this._terminate) {
            return;
        }
        if (conversationImpl.getState() != -2 && conversationImpl.getState() != -4) {
            this._updates.addItem(conversationImpl);
        }
    }

    public void removeConversation(String string) {
        if (this._terminate) {
            return;
        }
        ConversationImpl conversationImpl = null;
        Map map = this._active_list;
        synchronized (map) {
            conversationImpl = (ConversationImpl)this._active_list.remove(string);
        }
        if (conversationImpl != null) {
            this.archiveConversation(conversationImpl);
        }
    }

    /*
     * Loose catch block
     */
    private void archiveConversation(ConversationImpl conversationImpl) {
        block10: {
            if (this._terminate) {
                return;
            }
            this._database.startTransaction(false);
            conversationImpl._serialised = null;
            this._database.addObject((DatabaseObject)conversationImpl.clone());
            Object var4_2 = null;
            try {
                this._database.endTransaction();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            conversationImpl.removeReferences();
            {
                break block10;
                catch (DatabaseException databaseException) {
                    Object var4_3 = null;
                    try {
                        this._database.endTransaction();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    conversationImpl.removeReferences();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this._database.endTransaction();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                conversationImpl.removeReferences();
                throw throwable;
            }
        }
    }

    private void checkState() {
        if (this._terminate) {
            return;
        }
        Map map = this._active_list;
        synchronized (map) {
            Iterator iterator = this._active_list.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ConversationImpl conversationImpl = (ConversationImpl)this._active_list.get(string);
                if (conversationImpl == null) continue;
                ConversationImpl conversationImpl2 = conversationImpl;
                synchronized (conversationImpl2) {
                    long l = conversationImpl.getTimeOut();
                    if (!(conversationImpl.isUpdated() || l != -1L && l <= System.currentTimeMillis())) {
                        continue;
                    }
                    switch (conversationImpl.getState()) {
                        case -3: 
                        case -1: {
                            this._updates.addItem(conversationImpl.cloneAndResetUpdate());
                            break;
                        }
                        case -2: {
                            conversationImpl.resetUpdate();
                            break;
                        }
                    }
                }
            }
        }
    }

    private void checkState(Conversation conversation) {
        if (this._terminate) {
            return;
        }
        boolean bl = false;
        Map map = this._active_list;
        synchronized (map) {
            Conversation conversation2 = conversation;
            synchronized (conversation2) {
                long l = conversation.getTimeOut();
                if (conversation.getLatestMessageIndex() >= 0) {
                    AgentID agentID = conversation.getSenderAID(conversation.getLatestMessageIndex());
                    switch (conversation.getState()) {
                        case -1: {
                            this.removeConversation(conversation.getConversationID());
                        }
                    }
                    if (!agentID.equals(this._agent_id)) {
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            this._conversation_listener.notify(conversation);
        }
    }

    public static void main(String[] stringArray) {
        DatabaseProfile databaseProfile = null;
        ProtocolProfileImpl protocolProfileImpl = new ProtocolProfileImpl();
        ProtocolMappingImpl protocolMappingImpl = new ProtocolMappingImpl();
        protocolMappingImpl.setProtocolName("fipa-request");
        protocolMappingImpl.setProtocolClass("fipaos.agent.conversation.standard.protocol.FIPARequest");
        protocolProfileImpl.addProtocolMapping(protocolMappingImpl);
        TestConvListener testConvListener = new TestConvListener();
        ConversationManagerImpl conversationManagerImpl = new ConversationManagerImpl(testConvListener, new TestMessageSender(), null, databaseProfile, protocolProfileImpl);
        try {
            ACL aCL = new ACL();
            aCL.setSenderAID(new AgentID("other@iiop://somewhere.com:8080/acc"));
            aCL.setReceiverAID(new AgentID("me@iiop://somewhere.com:8080/acc"));
            aCL.setPerformative("inform");
            aCL.setConversationID("test-msg-id");
            aCL.setProtocol("");
            aCL.setContentObject("");
            int n = 0;
            while (n < 1000) {
                conversationManagerImpl.handleMessage(new Message(aCL));
                ++n;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static class TestConvListener
    extends Frame
    implements ConversationListener {
        public int _notified;
        private Label _label;

        public TestConvListener() {
            super("Test 1");
            this.setLayout(new BorderLayout());
            this.add((Component)new Label("Received Conversation Updates:"), "North");
            this._label = new Label("0");
            this.add((Component)this._label, "Center");
            this.pack();
            this.setVisible(true);
        }

        public void notify(Conversation conversation) {
            ++this._notified;
            this._label.setText("" + this._notified);
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void notify(Enumeration enumeration) {
            while (enumeration.hasMoreElements()) {
                this.notify((Conversation)enumeration.nextElement());
            }
        }

        public void setMessageSender(MessageSender messageSender) {
        }

        public void notifyMessageInEndedConversation(Message message) {
        }

        public void notifyMessageUndeliverable(Message message) {
        }
    }

    private static class TestMessageSender
    implements MessageSender {
        private TestMessageSender() {
        }

        public void sendMessage(Message message) {
        }

        public void setMessageReceiver(MessageReceiver messageReceiver) {
        }

        public void shutdown() {
        }
    }
}

