/*
 * Decompiled with CFR 0.152.
 */
package fipaos.agent.task;

import fipaos.agent.AgentList;
import fipaos.agent.conversation.Conversation;
import fipaos.agent.task.Task;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.AgentManagementAction;
import fipaos.ont.fipa.fipaman.AgentManagementResult;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.ont.fipa.fipaman.SearchConstraints;
import fipaos.parser.ParserException;
import java.util.Iterator;
import java.util.Set;

public class DFSearchTask
extends Task {
    private static final int SEARCH_DEPTH = 2;
    private AgentList _store = new AgentList();
    private String _address;
    private DFAgentDescription _df_desc;
    private String _df;
    private SearchConstraints _constraints;
    private boolean _federated;
    private int _selected = -1;

    public DFSearchTask(DFAgentDescription dFAgentDescription) {
        this._df_desc = dFAgentDescription;
        this._selected = 0;
    }

    public DFSearchTask(DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints) {
        this._df_desc = dFAgentDescription;
        this._constraints = searchConstraints;
        this._selected = 1;
    }

    public DFSearchTask(DFAgentDescription dFAgentDescription, boolean bl) {
        this._df_desc = dFAgentDescription;
        this._federated = bl;
        this._selected = 2;
    }

    public DFSearchTask(String string, DFAgentDescription dFAgentDescription, boolean bl) {
        this._df = string;
        this._df_desc = dFAgentDescription;
        this._federated = bl;
        this._selected = 3;
    }

    public DFSearchTask(String string, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints, boolean bl) {
        this._df = string;
        this._df_desc = dFAgentDescription;
        this._constraints = searchConstraints;
        this._federated = bl;
        this._selected = 4;
    }

    protected void startTask() {
        this._store = new AgentList();
        this._address = this._owner.getLocalDF();
        if (this._constraints == null) {
            this._constraints = new SearchConstraints();
        }
        switch (this._selected) {
            case 0: {
                this.searchDF(this._df_desc);
                break;
            }
            case 1: {
                this.searchDF(this._df_desc, this._constraints);
                break;
            }
            case 2: {
                this.searchDF(this._df_desc, this._federated);
                break;
            }
            case 3: {
                this.searchDF(this._df, this._df_desc, this._federated);
                break;
            }
            case 4: {
                this.searchDF(this._df, this._df_desc, this._constraints, this._federated);
            }
        }
    }

    private DFAgentDescription[] fetchDFResults(String string) throws ParserException {
        AgentManagementResult agentManagementResult = new AgentManagementResult(string);
        Set set = agentManagementResult.getResultSet();
        DFAgentDescription[] dFAgentDescriptionArray = new DFAgentDescription[set.size()];
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            dFAgentDescriptionArray[n] = (DFAgentDescription)iterator.next();
            ++n;
        }
        return dFAgentDescriptionArray;
    }

    public void handleNotUnderstood(Conversation conversation) {
        String string = conversation.getACL(conversation.getLatestMessageIndex()).getSenderAID().getName();
        this._store.remove(string);
        this.done(new DFAgentDescription[0]);
    }

    public void handleRefuse(Conversation conversation) {
        String string = conversation.getACL(conversation.getLatestMessageIndex()).getSenderAID().getName();
        this._store.remove(string);
        this.done(new DFAgentDescription[0]);
    }

    public void handleAgree(Conversation conversation) {
    }

    public void handleFailure(Conversation conversation) {
        String string = conversation.getACL(conversation.getLatestMessageIndex()).getSenderAID().getName();
        this._store.remove(string);
        this.done(new DFAgentDescription[0]);
    }

    public void handleInform(Conversation conversation) {
        ACL aCL = conversation.getACL(conversation.getLatestMessageIndex());
        String string = aCL.getSenderAID().getName();
        if (this._store.contains(string)) {
            this._store.remove(string);
            try {
                Object object = aCL.getContentObject();
                if (object instanceof String) {
                    this.done(this.fetchDFResults((String)object));
                } else if (object instanceof AgentManagementResult) {
                    AgentManagementResult agentManagementResult = (AgentManagementResult)object;
                    this.done(agentManagementResult.getResultSet().toArray(new DFAgentDescription[0]));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean searchDF(DFAgentDescription dFAgentDescription) {
        String string = this._address;
        SearchConstraints searchConstraints = new SearchConstraints(2);
        return this.searchDF(string, dFAgentDescription, searchConstraints, true);
    }

    public boolean searchDF(DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints) {
        String string = this._address;
        return this.searchDF(string, dFAgentDescription, searchConstraints, true);
    }

    public boolean searchDF(DFAgentDescription dFAgentDescription, boolean bl) {
        String string = this._address;
        SearchConstraints searchConstraints = new SearchConstraints(2);
        return this.searchDF(string, dFAgentDescription, searchConstraints, bl);
    }

    public boolean searchDF(String string, DFAgentDescription dFAgentDescription, boolean bl) {
        SearchConstraints searchConstraints = new SearchConstraints(2);
        return this.searchDF(string, dFAgentDescription, searchConstraints, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean searchDF(String string, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints, boolean bl) {
        ACL aCL = this.getNewConversation("fipa-request");
        if (aCL == null) {
            return false;
        }
        aCL.setSenderAID(this._owner.getAID());
        aCL.setLanguage("FIPA-SL0");
        aCL.setOntology("fipa-agent-management");
        aCL.setPerformative("request");
        try {
            aCL.setReceiverAID(new AgentID(string));
            AgentManagementAction agentManagementAction = new AgentManagementAction();
            agentManagementAction.setAction("search");
            agentManagementAction.setAgentID(new AgentID(string));
            agentManagementAction.setDFAgentDescription(dFAgentDescription);
            if (bl) {
                agentManagementAction.setSearchConstraints(searchConstraints);
            } else {
                agentManagementAction.setSearchConstraints(new SearchConstraints());
            }
            aCL.setContentObject(agentManagementAction);
            this._store.add(new AgentID(string).getName(), "fipa-df");
            this.forward(aCL);
            return true;
        }
        catch (ParserException parserException) {}
        finally {
            return false;
        }
    }
}

