/*
 * Decompiled with CFR 0.152.
 */
package fipaos.agent.task;

import fipaos.agent.task.Task;
import fipaos.agent.task.TaskManager;

public class SynchronousTask
extends Task {
    private Task _child;
    private long _timeout;
    private Object _lock = new Object();
    private Object _result;
    private boolean _done = false;

    private SynchronousTask(Task task, long l) {
        this._child = task;
        this._timeout = l;
    }

    public void startTask() {
        if (this._timeout > -1L) {
            this.newTask(this._child, this._timeout);
        } else {
            this.newTask(this._child);
        }
    }

    void notifyDone(Task task) {
        super.notifyDone(task);
        this._result = new NoResult();
        this.indicateDone();
    }

    void notifyDone(Task task, Object object) {
        super.notifyDone(task, object);
        this._result = object;
        this.indicateDone();
    }

    void notifyError(Task task, Throwable throwable) {
        super.notifyError(task, throwable);
        this._result = new ErrorResult(throwable);
        this.indicateDone();
    }

    void notifyTimeout(Task task) {
        super.notifyTimeout(task);
        this._result = new TimeoutResult();
        this.indicateDone();
    }

    private void indicateDone() {
        Object object = this._lock;
        synchronized (object) {
            this._done = true;
            this._lock.notifyAll();
        }
        this.done();
    }

    public static Object executeTask(TaskManager taskManager, Task task) {
        return SynchronousTask.executeTask(taskManager, task, -1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object executeTask(TaskManager taskManager, Task task, long l) {
        SynchronousTask synchronousTask = new SynchronousTask(task, l);
        taskManager.newTask(synchronousTask);
        Object object = synchronousTask._lock;
        synchronized (object) {
            while (!synchronousTask._done) {
                try {
                    synchronousTask._lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return synchronousTask._result;
        }
    }

    public static class ErrorResult
    extends UnusualResult {
        private Throwable t;

        private ErrorResult(Throwable throwable) {
            this.t = throwable;
        }

        public Throwable getThrowable() {
            return this.t;
        }
    }

    public static class NoResult
    extends UnusualResult {
    }

    public static class TimeoutResult
    extends UnusualResult {
    }

    public static class UnusualResult {
    }
}

