/*
 * Decompiled with CFR 0.152.
 */
package fipaos.agent.task;

import fipaos.agent.FIPAOSAgent;
import fipaos.agent.conversation.Conversation;
import fipaos.agent.task.DFSearchTask;
import fipaos.agent.task.SynchronousTask;
import fipaos.agent.task.TaskManager;
import fipaos.agent.task.TaskState;
import fipaos.agent.task.event.ChildDoneEvent;
import fipaos.agent.task.event.ChildDoneWithResultEvent;
import fipaos.agent.task.event.ChildFailureEvent;
import fipaos.agent.task.event.ChildTimeoutEvent;
import fipaos.mts.Message;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.ont.fipa.fipaman.SearchConstraints;
import fipaos.util.Comparators;
import fipaos.util.DynamicClass;
import fipaos.util.DynamicClassException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public abstract class Task {
    private static final String HANDLE_METHOD_PREFIX = "handle";
    private static final String DONE_METHOD_PREFIX = "done";
    private static final String ERROR_METHOD_PREFIX = "error";
    private static final String TIMEOUT_METHOD_PREFIX = "timeout";
    protected FIPAOSAgent _owner;
    protected TaskManager _tm;
    TaskState _state = new TaskState();
    String _id;
    protected Set _children;
    Task _parent;
    Set _tm_ids = new TreeSet(Comparators.STRING_COMPARE);
    long _timeout = -1L;
    boolean _done = false;
    protected Object _lock = new Object();
    private boolean _non_exec = false;
    private Object _context = null;
    static /* synthetic */ Class class$fipaos$agent$conversation$Conversation;
    static /* synthetic */ Class class$fipaos$agent$task$Task;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Object;

    public Task() {
        this._children = new TreeSet(Comparators.OBJECT_COMPARE);
        this._id = this.getClassName(this);
    }

    public Task(FIPAOSAgent fIPAOSAgent, TaskManager taskManager) {
        this();
        this._tm = taskManager;
        this._owner = fIPAOSAgent;
        this._id = fIPAOSAgent.toString();
    }

    public Task(FIPAOSAgent fIPAOSAgent, TaskManager taskManager, String string) {
        this();
        this._tm = taskManager;
        this._owner = fIPAOSAgent;
        this._id = string;
    }

    private String capitaliseFirstChar(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private String getClassName(Object object) {
        String string = object.getClass().getName();
        string = string.replace('$', '_');
        int n = string.lastIndexOf(46);
        string = string.substring(n + 1);
        return string;
    }

    public void setContext(Object object) {
        this._context = object;
    }

    public Object getContext() {
        return this._context;
    }

    public TaskState getState() {
        return this._state;
    }

    public void notifyMessageForEndedConversation(Message message) {
        try {
            this.handleLateMessage(message);
        }
        catch (Throwable throwable) {
            if (this._parent != null) {
                ChildFailureEvent childFailureEvent = new ChildFailureEvent(this, throwable);
                this._tm.addEvent(this._parent, childFailureEvent);
            }
            this._tm.removeTask(this);
        }
    }

    public void notifyMessageFailure(Message message) {
        try {
            this.handleUndeliverableMessage(message);
        }
        catch (Throwable throwable) {
            if (this._parent != null) {
                ChildFailureEvent childFailureEvent = new ChildFailureEvent(this, throwable);
                this._tm.addEvent(this._parent, childFailureEvent);
            }
            this._tm.removeTask(this);
        }
    }

    public void notify(Conversation conversation) {
        ACL aCL = conversation.getACL(conversation.getLatestMessageIndex());
        String string = aCL.getPerformative().toLowerCase();
        String string2 = aCL.getSenderAID().getName();
        if (!string2.equals(this._owner.getAID().getName())) {
            this._non_exec = false;
            String string3 = null;
            try {
                if (string.equalsIgnoreCase("inform")) {
                    string3 = "handleInform";
                    this.handleInform(conversation);
                } else if (string.equalsIgnoreCase("request")) {
                    string3 = "handleRequest";
                    this.handleRequest(conversation);
                } else if (string.equalsIgnoreCase("failure")) {
                    string3 = "handleFailure";
                    this.handleFailure(conversation);
                } else if (string.equalsIgnoreCase("not-understood")) {
                    string3 = "handleNotUnderstood";
                    this.handleNotUnderstood(conversation);
                } else if (string.equalsIgnoreCase("refuse")) {
                    string3 = "handleRefuse";
                    this.handleRefuse(conversation);
                } else if (string.equalsIgnoreCase("subscribe")) {
                    string3 = "handleSubscribe";
                    this.handleSubscribe(conversation);
                } else if (string.equalsIgnoreCase("agree")) {
                    string3 = "handleAgree";
                    this.handleAgree(conversation);
                } else if (string.equalsIgnoreCase("accept-proposal")) {
                    string3 = "handleAcceptProposal";
                    this.handleAcceptProposal(conversation);
                } else if (string.equalsIgnoreCase("cfp")) {
                    string3 = "handleCfp";
                    this.handleCfp(conversation);
                } else if (string.equalsIgnoreCase("confirm")) {
                    string3 = "handleConfirm";
                    this.handleConfirm(conversation);
                } else if (string.equalsIgnoreCase("disconfirm")) {
                    string3 = "handleDisconfirm";
                    this.handleDisconfirm(conversation);
                } else if (string.equalsIgnoreCase("inform-if")) {
                    string3 = "handleInformIf";
                    this.handleInformIf(conversation);
                } else if (string.equalsIgnoreCase("inform-ref")) {
                    string3 = "handleInformRef";
                    this.handleInformRef(conversation);
                } else if (string.equalsIgnoreCase("propagate")) {
                    string3 = "handlePropagate";
                    this.handlePropagate(conversation);
                } else if (string.equalsIgnoreCase("propose")) {
                    string3 = "handlePropose";
                    this.handlePropose(conversation);
                } else if (string.equalsIgnoreCase("proxy")) {
                    string3 = "handleProxy";
                    this.handleProxy(conversation);
                } else if (string.equalsIgnoreCase("query-if")) {
                    string3 = "handleQueryIf";
                    this.handleQueryIf(conversation);
                } else if (string.equalsIgnoreCase("query-ref")) {
                    string3 = "handleQueryRef";
                    this.handleQueryRef(conversation);
                } else if (string.equalsIgnoreCase("reject-proposal")) {
                    string3 = "handleRejectProposal";
                    this.handleRejectProposal(conversation);
                } else if (string.equalsIgnoreCase("request-when")) {
                    string3 = "handleRequestWhen";
                    this.handleRequestWhen(conversation);
                } else if (string.equalsIgnoreCase("request-whenever")) {
                    string3 = "handleRequestWhenever";
                    this.handleRequestWhenever(conversation);
                } else {
                    this._non_exec = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!this._non_exec) {
                return;
            }
            boolean bl = true;
            StringBuffer stringBuffer = new StringBuffer(HANDLE_METHOD_PREFIX);
            while (bl) {
                int n = string.indexOf("-");
                if (n > 0) {
                    stringBuffer.append(this.capitaliseFirstChar(string.substring(0, n)));
                    string = string.substring(n + 1);
                    continue;
                }
                stringBuffer.append(this.capitaliseFirstChar(string));
                bl = false;
            }
            this._non_exec = false;
            try {
                Class[] classArray = new Class[]{class$fipaos$agent$conversation$Conversation == null ? (class$fipaos$agent$conversation$Conversation = Task.class$("fipaos.agent.conversation.Conversation")) : class$fipaos$agent$conversation$Conversation};
                Object[] objectArray = new Object[]{conversation};
                DynamicClass dynamicClass = new DynamicClass(this);
                dynamicClass.invoke(stringBuffer.toString(), classArray, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this._non_exec = true;
            }
            catch (DynamicClassException dynamicClassException) {
                // empty catch block
            }
        }
        if (this._non_exec) {
            try {
                this.handleOther(conversation);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void handleInform(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleRequest(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleFailure(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleNotUnderstood(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleRefuse(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleSubscribe(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleAgree(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleAcceptProposal(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleCfp(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleConfirm(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleDisconfirm(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleInformIf(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleInformRef(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handlePropagate(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handlePropose(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleProxy(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleQueryIf(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleQueryRef(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleRejectProposal(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleRequestWhen(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleRequestWhenever(Conversation conversation) throws Exception {
        this._non_exec = true;
    }

    public void handleUndeliverableMessage(Message message) throws Exception {
    }

    public void handleLateMessage(Message message) throws Exception {
        this._owner.sendNotUnderstood(message.getACL());
    }

    protected boolean searchDF(DFAgentDescription dFAgentDescription) {
        this.newTask(new DFSearchTask(dFAgentDescription));
        return true;
    }

    protected boolean searchDF(DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints) {
        this.newTask(new DFSearchTask(dFAgentDescription, searchConstraints));
        return true;
    }

    protected boolean searchDF(DFAgentDescription dFAgentDescription, boolean bl) {
        this.newTask(new DFSearchTask(dFAgentDescription, bl));
        return true;
    }

    protected boolean searchDF(String string, DFAgentDescription dFAgentDescription, boolean bl) {
        this.newTask(new DFSearchTask(string, dFAgentDescription, bl));
        return true;
    }

    protected boolean searchDF(String string, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints, boolean bl) {
        this.newTask(new DFSearchTask(string, dFAgentDescription, searchConstraints, bl));
        return true;
    }

    protected void DFSearchResults(DFAgentDescription[] dFAgentDescriptionArray) {
        if (!(this instanceof SynchronousTask)) {
            // empty if block
        }
    }

    public void doneDFSearchTask(Object object) throws Exception {
        if (!this._tm._shutdown) {
            if (object != null && object instanceof DFAgentDescription[]) {
                this.DFSearchResults((DFAgentDescription[])object);
            } else {
                this.DFSearchResults(new DFAgentDescription[0]);
            }
        }
    }

    public void errorDFSearchTask(Task task, Throwable throwable) {
        if (!this._tm._shutdown) {
            this.DFSearchResults(new DFAgentDescription[0]);
        }
    }

    public void timeoutDFSearchTask(Task task) {
        if (!this._tm._shutdown) {
            this.DFSearchResults(new DFAgentDescription[0]);
        }
    }

    protected void forward(ACL aCL) {
        TaskManager taskManager = null;
        Object object = this._lock;
        synchronized (object) {
            taskManager = this._tm;
        }
        if (this._tm != null) {
            if (aCL.getReceiverAIDs().size() > 1 && aCL.getProtocol() != null) {
                Iterator iterator = aCL.getReceiverAIDs().iterator();
                while (iterator.hasNext()) {
                    try {
                        ACL aCL2 = (ACL)aCL.clone();
                        aCL2.setReceiverAID((AgentID)iterator.next());
                        this._tm.forward(aCL2, this);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } else {
                this._tm.forward(aCL, this);
            }
        }
    }

    protected void forward(Message message) {
        TaskManager taskManager = null;
        Object object = this._lock;
        synchronized (object) {
            taskManager = this._tm;
        }
        if (taskManager != null) {
            if (message.getACL().getReceiverAIDs().size() > 1 && message.getACL().getProtocol() != null) {
                Iterator iterator = message.getACL().getReceiverAIDs().iterator();
                while (iterator.hasNext()) {
                    try {
                        Message message2 = (Message)message.clone();
                        message2.getACL().setReceiverAID((AgentID)iterator.next());
                        message2.getEnvelope().setReceivers(message2.getACL().getReceiverAIDs());
                        this._tm.forward(message2, this);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } else {
                this._tm.forward(message, this);
            }
        }
    }

    protected boolean sendNotUnderstood(ACL aCL) {
        TaskManager taskManager = null;
        FIPAOSAgent fIPAOSAgent = null;
        Object object = this._lock;
        synchronized (object) {
            taskManager = this._tm;
            fIPAOSAgent = this._owner;
        }
        if (taskManager._shutdown && fIPAOSAgent != null) {
            return fIPAOSAgent.sendNotUnderstood(aCL);
        }
        return false;
    }

    protected ACL getNewConversation(String string) {
        return this._tm.getNewConversation(string);
    }

    protected void newTask(Task task) {
        this.newTask(this.getClassName(task), task);
    }

    protected void newTask(Task task, Conversation conversation) {
        this.newTask(this.getClassName(task), task, conversation);
    }

    protected void newTask(String string, Task task) {
        if (this._tm != null) {
            this._tm.newTask(string, task, this);
        }
    }

    protected void newTask(String string, Task task, Conversation conversation) {
        if (this._tm != null) {
            this._tm.newTask(string, task, conversation, this);
        }
    }

    protected void newTask(Task task, long l) {
        if (this._tm != null) {
            this._tm.newTask(task, l, this);
        }
    }

    protected void newTask(Task task, Conversation conversation, long l) {
        if (this._tm != null) {
            this._tm.newTask(task, conversation, l, this);
        }
    }

    protected void newTask(String string, Task task, long l) {
        task._id = string;
        if (this._tm != null) {
            this._tm.newTask(task, l, this);
        }
    }

    protected void newTask(String string, Task task, Conversation conversation, long l) {
        task._id = string;
        if (this._tm != null) {
            this._tm.newTask(task, conversation, l, this);
        }
    }

    protected void done() {
        TaskManager taskManager = null;
        Task task = null;
        Object object = this._lock;
        synchronized (object) {
            taskManager = this._tm;
            task = this._parent;
        }
        if (this.thisThreadFirstToIndicateDone()) {
            if (task != null && taskManager != null) {
                ChildDoneEvent childDoneEvent = new ChildDoneEvent(this);
                taskManager.addEvent(task, childDoneEvent);
            } else if (task == null && taskManager != null) {
                taskManager.removeTask(this);
            }
        }
    }

    protected void done(Object object) {
        TaskManager taskManager = null;
        Task task = null;
        Object object2 = this._lock;
        synchronized (object2) {
            taskManager = this._tm;
            task = this._parent;
        }
        if (this.thisThreadFirstToIndicateDone()) {
            if (task != null && taskManager != null) {
                ChildDoneWithResultEvent childDoneWithResultEvent = new ChildDoneWithResultEvent(this, object);
                taskManager.addEvent(task, childDoneWithResultEvent);
            } else if (this._parent == null && taskManager != null) {
                taskManager.removeTask(this);
            }
        }
    }

    protected void startTask() throws Exception {
    }

    protected void endTask() throws Exception {
    }

    void removeReferences() {
        Object object = this._lock;
        synchronized (object) {
            this._owner = null;
            this._parent = null;
            this._tm = null;
            if (this._state != null) {
                this._state.removeReferences();
                this._state = null;
            }
            if (this._tm_ids != null) {
                this._tm_ids.clear();
                this._tm_ids = null;
            }
            if (this._children != null) {
                this._children.clear();
                this._children = null;
            }
        }
    }

    void notifyStart() {
        block10: {
            Task task = this;
            try {
                this.startTask();
                Object object = this._lock;
                synchronized (object) {
                    if (!this._done && this._state != null) {
                        this._state.setState(0);
                    }
                }
            }
            catch (Throwable throwable) {
                if (!this.thisThreadFirstToIndicateDone()) break block10;
                TaskManager taskManager = null;
                Task task2 = null;
                Object object = this._lock;
                synchronized (object) {
                    taskManager = this._tm;
                    task2 = this._parent;
                }
                if (taskManager == null) break block10;
                if (task2 != null) {
                    ChildFailureEvent childFailureEvent = new ChildFailureEvent(task, throwable);
                    taskManager.addEvent(task2, childFailureEvent);
                }
                taskManager.removeTask(task);
            }
        }
    }

    void timeoutReached() {
        if (this.thisThreadFirstToIndicateDone()) {
            TaskManager taskManager = null;
            Task task = null;
            Object object = this._lock;
            synchronized (object) {
                taskManager = this._tm;
                task = this._parent;
            }
            if (taskManager != null) {
                if (task != null) {
                    ChildTimeoutEvent childTimeoutEvent = new ChildTimeoutEvent(this);
                    taskManager.addEvent(task, childTimeoutEvent);
                } else {
                    taskManager.removeTask(this);
                }
            }
        }
    }

    void notifyError(Task task, Throwable throwable) {
        if (!this._tm._shutdown) {
            Object object;
            Object object2 = this._lock;
            synchronized (object2) {
                if (this._children != null && !this._children.contains(task)) {
                    return;
                }
            }
            Object object3 = null;
            object3 = this instanceof FIPAOSAgent.TopLevelHandlerTask ? this._owner : this;
            if (object3 instanceof Task) {
                object = (Task)object3;
                ((Task)object).notifyError(task, ERROR_METHOD_PREFIX + task._id, throwable);
            } else if (object3 instanceof FIPAOSAgent) {
                object = (FIPAOSAgent)object3;
                ((FIPAOSAgent)object).notifyError(task, ERROR_METHOD_PREFIX + task._id, throwable);
            }
            object = this._lock;
            synchronized (object) {
                if (this._children != null) {
                    this._children.remove(task);
                }
            }
        }
    }

    protected void notifyError(Task task, String string, Throwable throwable) {
        DynamicClass dynamicClass = new DynamicClass(this);
        try {
            dynamicClass.invoke(string, new Class[]{class$fipaos$agent$task$Task == null ? (class$fipaos$agent$task$Task = Task.class$("fipaos.agent.task.Task")) : class$fipaos$agent$task$Task, class$java$lang$Throwable == null ? (class$java$lang$Throwable = Task.class$("java.lang.Throwable")) : class$java$lang$Throwable}, new Object[]{task, throwable});
        }
        catch (DynamicClassException dynamicClassException) {
            if (!(this instanceof SynchronousTask)) {
                if (this._parent != null) {
                    ChildFailureEvent childFailureEvent = new ChildFailureEvent(this, dynamicClassException.getThrowable());
                    this._tm.addEvent(this._parent, childFailureEvent);
                } else {
                    this._tm.removeTask(this);
                }
            }
        }
        catch (Throwable throwable2) {
            if (!(this instanceof SynchronousTask)) {
                // empty if block
            }
        }
    }

    void notifyDone(Task task) {
        if (!this._tm._shutdown) {
            Object object;
            Object object2 = this._lock;
            synchronized (object2) {
                if (this._children != null && !this._children.contains(task)) {
                    return;
                }
            }
            Object object3 = null;
            object3 = this instanceof FIPAOSAgent.TopLevelHandlerTask ? this._owner : this;
            if (object3 instanceof Task) {
                object = (Task)object3;
                ((Task)object).notifyDone(task, DONE_METHOD_PREFIX + task._id, null);
            } else if (object3 instanceof FIPAOSAgent) {
                object = (FIPAOSAgent)object3;
                ((FIPAOSAgent)object).notifyDone(task, DONE_METHOD_PREFIX + task._id, null);
            }
            object = this._lock;
            synchronized (object) {
                if (this._children != null) {
                    this._children.remove(task);
                }
            }
        }
    }

    void notifyDone(Task task, Object object) {
        if (!this._tm._shutdown) {
            Object object2;
            Object object3 = this._lock;
            synchronized (object3) {
                if (this._children != null && !this._children.contains(task)) {
                    return;
                }
            }
            Object object4 = null;
            object4 = this instanceof FIPAOSAgent.TopLevelHandlerTask ? this._owner : this;
            if (object4 instanceof Task) {
                object2 = (Task)object4;
                ((Task)object2).notifyDone(task, DONE_METHOD_PREFIX + task._id, object);
            } else if (object4 instanceof FIPAOSAgent) {
                object2 = (FIPAOSAgent)object4;
                ((FIPAOSAgent)object2).notifyDone(task, DONE_METHOD_PREFIX + task._id, object);
            }
            object2 = this._lock;
            synchronized (object2) {
                if (this._children != null) {
                    this._children.remove(task);
                }
            }
        }
    }

    protected void notifyDone(Task task, String string, Object object) {
        block9: {
            DynamicClass dynamicClass = new DynamicClass(this);
            try {
                if (object == null) {
                    dynamicClass.invoke(string, new Class[]{class$fipaos$agent$task$Task == null ? (class$fipaos$agent$task$Task = Task.class$("fipaos.agent.task.Task")) : class$fipaos$agent$task$Task}, new Object[]{task});
                } else {
                    try {
                        dynamicClass.invoke(string, new Class[]{class$fipaos$agent$task$Task == null ? (class$fipaos$agent$task$Task = Task.class$("fipaos.agent.task.Task")) : class$fipaos$agent$task$Task, class$java$lang$Object == null ? (class$java$lang$Object = Task.class$("java.lang.Object")) : class$java$lang$Object}, new Object[]{task, object});
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        dynamicClass.invoke(string, new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = Task.class$("java.lang.Object")) : class$java$lang$Object}, new Object[]{object});
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!(this instanceof SynchronousTask)) {
                    // empty if block
                }
            }
            catch (DynamicClassException dynamicClassException) {
                if (this instanceof SynchronousTask) break block9;
                if (this._parent != null) {
                    ChildFailureEvent childFailureEvent = new ChildFailureEvent(this, dynamicClassException);
                    this._tm.addEvent(this._parent, childFailureEvent);
                }
                this._tm.removeTask(this);
            }
        }
    }

    void notifyTimeout(Task task) {
        if (!this._tm._shutdown) {
            Object object;
            Object object2 = this._lock;
            synchronized (object2) {
                if (this._children != null && !this._children.contains(task)) {
                    return;
                }
            }
            Object object3 = null;
            object3 = this instanceof FIPAOSAgent.TopLevelHandlerTask ? this._owner : this;
            if (object3 instanceof Task) {
                object = (Task)object3;
                ((Task)object).notifyTimeout(task, TIMEOUT_METHOD_PREFIX + task._id);
            } else if (object3 instanceof FIPAOSAgent) {
                object = (FIPAOSAgent)object3;
                ((FIPAOSAgent)object).notifyTimeout(task, TIMEOUT_METHOD_PREFIX + task._id);
            }
            object = this._lock;
            synchronized (object) {
                if (this._children != null) {
                    this._children.remove(task);
                }
            }
        }
    }

    protected void notifyTimeout(Task task, String string) {
        DynamicClass dynamicClass = new DynamicClass(this);
        try {
            dynamicClass.invoke(string, new Class[]{class$fipaos$agent$task$Task == null ? (class$fipaos$agent$task$Task = Task.class$("fipaos.agent.task.Task")) : class$fipaos$agent$task$Task}, new Object[]{task});
        }
        catch (DynamicClassException dynamicClassException) {
            if (!(this instanceof SynchronousTask) && !(task instanceof SynchronousTask)) {
                if (this._parent != null) {
                    ChildFailureEvent childFailureEvent = new ChildFailureEvent(this, dynamicClassException.getThrowable());
                    this._tm.addEvent(this._parent, childFailureEvent);
                } else {
                    this._tm.removeTask(this);
                }
            }
        }
        catch (Throwable throwable) {
            if (this instanceof SynchronousTask || !(task instanceof SynchronousTask)) {
                // empty if block
            }
        }
    }

    boolean thisThreadFirstToIndicateDone() {
        boolean bl = false;
        Object object = this._lock;
        synchronized (object) {
            if (!this._done) {
                this._done = true;
                bl = true;
            }
        }
        return bl;
    }

    protected void handleOther(Conversation conversation) throws Exception {
        ACL aCL;
        if (!this._tm._shutdown && !(aCL = conversation.getACL(conversation.getLatestMessageIndex())).getPerformative().equals("not-understood")) {
            try {
                this._owner.sendNotUnderstood(aCL, "internal-error unhandled-performative");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

