/*
 * Decompiled with CFR 0.152.
 */
package fipaos.agent.task;

import fipaos.agent.FIPAOSAgent;
import fipaos.agent.conversation.Conversation;
import fipaos.agent.conversation.ConversationListener;
import fipaos.agent.conversation.UnknownProtocolException;
import fipaos.agent.profile.TaskManagerProfile;
import fipaos.agent.task.SynchronousTask;
import fipaos.agent.task.Task;
import fipaos.agent.task.TaskManagerListener;
import fipaos.agent.task.event.ChildDoneEvent;
import fipaos.agent.task.event.ChildDoneWithResultEvent;
import fipaos.agent.task.event.ChildFailureEvent;
import fipaos.agent.task.event.ChildTimeoutEvent;
import fipaos.agent.task.event.ConversationUpdateEvent;
import fipaos.agent.task.event.InitialisedEvent;
import fipaos.agent.task.event.MessageDeliveryFailureEvent;
import fipaos.agent.task.event.MessageForEndedConversationEvent;
import fipaos.agent.task.event.TaskEvent;
import fipaos.mts.Message;
import fipaos.mts.MessageSender;
import fipaos.ont.fipa.ACL;
import fipaos.util.Comparators;
import fipaos.util.FIFOQueue;
import fipaos.util.Queue;
import fipaos.util.ThreadPool;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class TaskManager
implements ConversationListener {
    private static final String DF_SEARCH = "df-search-task";
    private static final String IDLE = "IDLE";
    private static Set __all_task_managers = new HashSet();
    private Map _ids_map;
    private Set _tasks_set;
    private Set _timeouts_set;
    protected Set _conversation_ids = new TreeSet(Comparators.STRING_COMPARE);
    private FIPAOSAgent _owner;
    private MessageSender _ms;
    boolean _shutdown = false;
    private Queue _execution_order = new FIFOQueue();
    private TaskManagerListener _tm_listener;
    private Task _top_level_parent;
    private ThreadPool _thread_pool;
    private ThreadPool _thread_pool2;
    private TaskManagerProfile _profile;

    public TaskManager(FIPAOSAgent fIPAOSAgent, MessageSender messageSender, Task task, TaskManagerProfile taskManagerProfile) {
        this._profile = taskManagerProfile;
        this._ids_map = new TreeMap(Comparators.STRING_COMPARE);
        this._tasks_set = new HashSet();
        this._timeouts_set = new HashSet();
        this._ms = messageSender;
        this._owner = fIPAOSAgent;
        this._thread_pool = this._profile.getUseGlobalThreads() ? ThreadPool.getGlobalThreadPool() : new ThreadPool(this._profile.getLocalThreads(), fIPAOSAgent.getAID().getName() + "-TM-ThreadPool");
        this._top_level_parent = task;
        this.newTask(this._top_level_parent);
        this._thread_pool2 = fIPAOSAgent == null ? new ThreadPool(2, "TMControl-ThreadPool") : new ThreadPool(2, fIPAOSAgent.getAID().getName() + "-TMControl-ThreadPool");
        this._thread_pool2.addJob(new TMCheckState());
        this._thread_pool2.addJob(new TMCheckTimeout());
        __all_task_managers.add(this);
    }

    public synchronized void shutdown() {
        __all_task_managers.remove(this);
        this._shutdown = true;
        if (this._thread_pool != ThreadPool.getGlobalThreadPool()) {
            this._thread_pool.shutdown();
        }
        this._thread_pool = null;
        this._thread_pool2.shutdown();
        this._thread_pool2 = null;
        this._execution_order.releaseBlock();
        this._execution_order = null;
        this._owner = null;
        this._ms = null;
        this._ids_map.clear();
        this._ids_map = null;
        this._tasks_set.clear();
        this._tasks_set = null;
        this._timeouts_set.clear();
        this._timeouts_set = null;
    }

    public void newTask(Task task) {
        if (!this._shutdown) {
            Object object;
            if (task._parent == null && task != this._top_level_parent && !(task instanceof SynchronousTask)) {
                task._parent = this._top_level_parent;
                object = this._top_level_parent._lock;
                synchronized (object) {
                    if (!this._top_level_parent._children.contains(task)) {
                        this._top_level_parent._children.add(task);
                    }
                }
            }
            object = task._lock;
            synchronized (object) {
                task._tm = this;
                task._owner = this._owner;
                this._tasks_set.add(task);
            }
            if (task != this._top_level_parent) {
                this.addEvent(task, new InitialisedEvent());
            } else {
                task.getState().setState(0);
            }
        }
    }

    void newTask(Task task, Task task2) {
        if (!this._shutdown) {
            Object object = task._lock;
            synchronized (object) {
                task._parent = task2;
                task._tm = this;
                task._owner = this._owner;
            }
            TaskManager taskManager = this;
            synchronized (taskManager) {
                Object object2 = task2._lock;
                synchronized (object2) {
                    if (!task2._children.contains(task)) {
                        task2._children.add(task);
                    }
                    this.newTask(task);
                }
            }
        }
    }

    void newTask(String string, Task task, Task task2) {
        if (!this._shutdown) {
            Object object = task._lock;
            synchronized (object) {
                task._parent = task2;
                task._tm = this;
                task._owner = this._owner;
                task._id = string;
            }
            TaskManager taskManager = this;
            synchronized (taskManager) {
                Object object2 = task2._lock;
                synchronized (object2) {
                    if (!task2._children.contains(task)) {
                        task2._children.add(task);
                    }
                    this.newTask(task);
                }
            }
        }
    }

    public void newTask(String string, Task task) {
        if (!this._shutdown) {
            Object object = task._lock;
            synchronized (object) {
                task._parent = this._top_level_parent;
                task._tm = this;
                task._owner = this._owner;
                task._id = string;
            }
            TaskManager taskManager = this;
            synchronized (taskManager) {
                Object object2 = this._top_level_parent._lock;
                synchronized (object2) {
                    if (!this._top_level_parent._children.contains(task)) {
                        this._top_level_parent._children.add(task);
                    }
                    this.newTask(task);
                }
            }
        }
    }

    public void newTask(Task task, String string) {
        if (!this._shutdown) {
            Object object = task._lock;
            synchronized (object) {
                this._ids_map.put(string, task);
                if (!string.equalsIgnoreCase(IDLE)) {
                    this._conversation_ids.add(string);
                }
                task._tm_ids.add(string);
            }
            this.newTask(task);
        }
    }

    public void newTask(Task task, Conversation conversation) {
        this.newTask(task, conversation.getConversationID());
    }

    public void newTask(Task task, Conversation conversation, Task task2) {
        if (!this._shutdown) {
            Object object = task._lock;
            synchronized (object) {
                task._parent = task2;
                task._tm = this;
                task._owner = this._owner;
            }
            TaskManager taskManager = this;
            synchronized (taskManager) {
                Object object2 = task2._lock;
                synchronized (object2) {
                    if (!task2._children.contains(task)) {
                        task2._children.add(task);
                    }
                    this.newTask(task, conversation.getConversationID());
                }
            }
        }
    }

    public void newTask(String string, Task task, Conversation conversation) {
        this.newTask(string, task, conversation, this._top_level_parent);
    }

    public void newTask(String string, Task task, Conversation conversation, Task task2) {
        if (!this._shutdown) {
            Object object = task._lock;
            synchronized (object) {
                task._parent = task2;
                task._tm = this;
                task._owner = this._owner;
                task._id = string;
            }
            TaskManager taskManager = this;
            synchronized (taskManager) {
                Object object2 = task2._lock;
                synchronized (object2) {
                    if (!task2._children.contains(task)) {
                        task2._children.add(task);
                    }
                    this.newTask(task, conversation.getConversationID());
                }
            }
        }
    }

    public void newTask(Task task, long l) {
        if (!this._shutdown) {
            Object object = task._lock;
            synchronized (object) {
                task._timeout = l;
            }
            this.newTask(task);
        }
    }

    void newTask(Task task, long l, Task task2) {
        if (!this._shutdown) {
            Object object = task._lock;
            synchronized (object) {
                task._parent = task2;
                task._tm = this;
                task._owner = this._owner;
            }
            TaskManager taskManager = this;
            synchronized (taskManager) {
                Object object2 = task2._lock;
                synchronized (object2) {
                    if (!task2._children.contains(task)) {
                        task2._children.add(task);
                    }
                    this.newTask(task, l);
                }
            }
        }
    }

    public void newTask(Task task, Conversation conversation, long l) {
        if (!this._shutdown) {
            Object object = task._lock;
            synchronized (object) {
                task._timeout = l;
            }
            this.newTask(task, conversation);
        }
    }

    public void newTask(Task task, Conversation conversation, long l, Task task2) {
        if (!this._shutdown) {
            Object object = task._lock;
            synchronized (object) {
                task._parent = task2;
                task._tm = this;
                task._owner = this._owner;
            }
            TaskManager taskManager = this;
            synchronized (taskManager) {
                Object object2 = task2._lock;
                synchronized (object2) {
                    if (!task2._children.contains(task)) {
                        task2._children.add(task);
                    }
                    this.newTask(task, conversation, l);
                }
            }
        }
    }

    public boolean removeTask(String string) {
        if (!this._shutdown) {
            Task task = null;
            TaskManager taskManager = this;
            synchronized (taskManager) {
                if (this._ids_map.containsKey(string)) {
                    task = (Task)this._ids_map.get(string);
                }
            }
            if (task != null) {
                return this.removeTask(task);
            }
            return true;
        }
        return false;
    }

    public boolean removeTask(Task task) {
        if (!this._shutdown) {
            Object object;
            TreeSet treeSet = null;
            Object object2 = task._lock;
            synchronized (object2) {
                if (task._tm_ids != null) {
                    treeSet = new TreeSet(Comparators.STRING_COMPARE);
                    treeSet.addAll(task._tm_ids);
                } else {
                    treeSet = new TreeSet(Comparators.STRING_COMPARE);
                }
            }
            boolean bl = true;
            TaskManager taskManager = this;
            synchronized (taskManager) {
                object = treeSet.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    bl &= this._ids_map.remove(string) != null;
                }
            }
            task.removeReferences();
            object = this;
            synchronized (object) {
                boolean bl2 = this._tasks_set.remove(task) && bl;
                return bl2;
            }
        }
        return false;
    }

    public synchronized int getTaskCount() {
        return this._tasks_set.size();
    }

    public int getTimeoutCount() {
        Set set = this._timeouts_set;
        synchronized (set) {
            int n = this._timeouts_set.size();
            return n;
        }
    }

    public synchronized int getPendingTaskEvents() {
        return this._execution_order.queueLength();
    }

    public String toString() {
        return this._owner.getAID().getName();
    }

    public static Set getVMTaskManagers() {
        return new HashSet(__all_task_managers);
    }

    void addEvent(Task task, TaskEvent taskEvent) {
        boolean bl = false;
        Object object = task._lock;
        synchronized (object) {
            if (!task._done) {
                task.getState().addEvent(taskEvent);
                bl = true;
            }
        }
        TaskManager taskManager = this;
        synchronized (taskManager) {
            if (bl && this._tm_listener != null) {
                this._tm_listener.taskEvent(task, taskEvent);
            }
        }
    }

    void forward(ACL aCL, Task task) {
        this.forward(new Message(aCL), task);
    }

    void forward(Message message, Task task) {
        try {
            MessageSender messageSender = null;
            FIPAOSAgent fIPAOSAgent = null;
            ACL aCL = message.getACL();
            String string = aCL.getConversationID();
            String string2 = aCL.getProtocol();
            if (string == null) {
                string = this.createNewConversation(string2).getConversationID();
                aCL.setConversationID(string);
            }
            message.getEnvelope().setSlotValue("X-fipaos-debug-tm-send-time", new Long(System.currentTimeMillis()));
            TaskManager taskManager = this;
            synchronized (taskManager) {
                this._ids_map.put(string, task);
                task._tm_ids.add(string);
                this._conversation_ids.add(string);
                messageSender = this._ms;
                fIPAOSAgent = this._owner;
            }
            if (messageSender != null) {
                messageSender.sendMessage(message);
            } else if (fIPAOSAgent != null) {
                fIPAOSAgent.forward(message);
            }
            this.checkConversationEnded(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    ACL getNewConversation(String string) {
        Conversation conversation = this.createNewConversation(string);
        if (conversation != null) {
            return conversation.getFilledInACL();
        }
        return null;
    }

    private Conversation createNewConversation(String string) {
        try {
            return this._owner.getNewConversation(string);
        }
        catch (UnknownProtocolException unknownProtocolException) {
            return null;
        }
    }

    public synchronized void appendToExecutionOrder(Task task) {
        if (!this._shutdown) {
            this._execution_order.addItem(task);
        }
    }

    public synchronized Set getActiveTasks() {
        if (!this._shutdown) {
            TreeSet treeSet = new TreeSet(Comparators.STRING_COMPARE);
            treeSet.addAll(this._tasks_set);
            return treeSet;
        }
        return new TreeSet();
    }

    public synchronized void setTaskManagerListener(TaskManagerListener taskManagerListener) {
        if (!this._shutdown) {
            this._tm_listener = taskManagerListener;
        }
    }

    private void checkState() {
        if (this._shutdown) {
            return;
        }
        Task task = (Task)this._execution_order.getItem();
        Task task2 = null;
        while (task != null && !this._shutdown) {
            TaskEvent taskEvent = null;
            boolean bl = false;
            boolean bl2 = false;
            TaskManager taskManager = this;
            synchronized (taskManager) {
                Object object = task._lock;
                synchronized (object) {
                    taskEvent = task.getState().getNextEvent();
                    if (!task._done && this._tasks_set.contains(task)) {
                        if (taskEvent != null) {
                            bl = true;
                        } else {
                            bl2 = true;
                        }
                    }
                }
            }
            if (bl2) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (bl && !this._shutdown) {
                this.dealWithTask(task, taskEvent);
            }
            if (this._shutdown) continue;
            task2 = task;
            task = (Task)this._execution_order.getItem();
        }
    }

    private void checkTimeout() {
        Object object;
        Iterator iterator;
        if (this._shutdown) {
            return;
        }
        LinkedList<Task> linkedList = new LinkedList<Task>();
        Set set = this._timeouts_set;
        synchronized (set) {
            iterator = this._timeouts_set.iterator();
            while (iterator.hasNext()) {
                object = (Timeout)iterator.next();
                if (((Timeout)object).isDone()) {
                    iterator.remove();
                    continue;
                }
                if (!((Timeout)object).hasTimedout()) continue;
                linkedList.add(((Timeout)object).getTask());
                iterator.remove();
            }
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            object = (Task)iterator.next();
            ((Task)object).timeoutReached();
        }
    }

    private void dealWithTask(final Task task, final TaskEvent taskEvent) {
        Task task2 = task;
        synchronized (task2) {
            task.getState().setState(1);
        }
        if (taskEvent instanceof ChildDoneWithResultEvent) {
            this._thread_pool.addJob(new ThreadPool.Job(){

                public void go() {
                    ChildDoneWithResultEvent childDoneWithResultEvent = (ChildDoneWithResultEvent)taskEvent;
                    task.notifyDone(childDoneWithResultEvent.getChildTask(), childDoneWithResultEvent.getResult());
                    TaskManager.this.removeTask(childDoneWithResultEvent.getChildTask());
                    TaskManager.this.postEventDispatch(task, taskEvent);
                }
            });
        } else if (taskEvent instanceof ChildDoneEvent) {
            this._thread_pool.addJob(new ThreadPool.Job(){

                public void go() {
                    if (!TaskManager.this._shutdown) {
                        ChildDoneEvent childDoneEvent = (ChildDoneEvent)taskEvent;
                        task.notifyDone(childDoneEvent.getChildTask());
                        TaskManager.this.removeTask(childDoneEvent.getChildTask());
                        TaskManager.this.postEventDispatch(task, taskEvent);
                    }
                }
            });
        } else if (taskEvent instanceof ChildFailureEvent) {
            this._thread_pool.addJob(new ThreadPool.Job(){

                public void go() {
                    if (!TaskManager.this._shutdown) {
                        ChildFailureEvent childFailureEvent = (ChildFailureEvent)taskEvent;
                        task.notifyError(childFailureEvent.getChildTask(), childFailureEvent.getFailureReason());
                        TaskManager.this.removeTask(childFailureEvent.getChildTask());
                        TaskManager.this.postEventDispatch(task, taskEvent);
                    }
                }
            });
        } else if (taskEvent instanceof ChildTimeoutEvent) {
            this._thread_pool.addJob(new ThreadPool.Job(){

                public void go() {
                    if (!TaskManager.this._shutdown) {
                        ChildTimeoutEvent childTimeoutEvent = (ChildTimeoutEvent)taskEvent;
                        task.notifyTimeout(childTimeoutEvent.getChildTask());
                        TaskManager.this.removeTask(childTimeoutEvent.getChildTask());
                        TaskManager.this.postEventDispatch(task, taskEvent);
                    }
                }
            });
        } else if (taskEvent instanceof ConversationUpdateEvent) {
            this._thread_pool.addJob(new ThreadPool.Job(){

                public void go() {
                    if (!TaskManager.this._shutdown) {
                        ConversationUpdateEvent conversationUpdateEvent = (ConversationUpdateEvent)taskEvent;
                        task.notify(conversationUpdateEvent.getUpdatedConversation());
                        TaskManager.this.checkConversationEnded(conversationUpdateEvent.getUpdatedConversation());
                        TaskManager.this.postEventDispatch(task, taskEvent);
                    }
                }
            });
        } else if (taskEvent instanceof MessageForEndedConversationEvent) {
            this._thread_pool.addJob(new ThreadPool.Job(){

                public void go() {
                    if (!TaskManager.this._shutdown) {
                        MessageForEndedConversationEvent messageForEndedConversationEvent = (MessageForEndedConversationEvent)taskEvent;
                        task.notifyMessageForEndedConversation(messageForEndedConversationEvent.getMessage());
                        TaskManager.this.postEventDispatch(task, taskEvent);
                    }
                }
            });
        } else if (taskEvent instanceof MessageDeliveryFailureEvent) {
            this._thread_pool.addJob(new ThreadPool.Job(){

                public void go() {
                    if (!TaskManager.this._shutdown) {
                        MessageDeliveryFailureEvent messageDeliveryFailureEvent = (MessageDeliveryFailureEvent)taskEvent;
                        task.notifyMessageFailure(messageDeliveryFailureEvent.getMessage());
                        TaskManager.this.postEventDispatch(task, taskEvent);
                    }
                }
            });
        } else if (taskEvent instanceof InitialisedEvent) {
            this._thread_pool.addJob(new ThreadPool.Job(){

                public void go() {
                    if (!TaskManager.this._shutdown) {
                        task.notifyStart();
                        TaskManager.this.postEventDispatch(task, taskEvent);
                    }
                }
            });
            Object object = task._lock;
            synchronized (object) {
                if (!task._done && task._timeout > 0L) {
                    Set set = this._timeouts_set;
                    synchronized (set) {
                        this._timeouts_set.add(new Timeout(task._timeout, task));
                    }
                }
            }
        }
    }

    private void postEventDispatch(Task task, TaskEvent taskEvent) {
        if (taskEvent != null) {
            if (!(taskEvent instanceof InitialisedEvent)) {
                Object object = task._lock;
                synchronized (object) {
                    if (!task._done && task._state != null) {
                        task._state.setState(0);
                    }
                }
            }
            taskEvent.removeReferences();
        }
    }

    protected void checkConversationEnded(Conversation conversation) {
        try {
            if (conversation != null) {
                if (conversation.getState() == -1) {
                    this._conversation_ids.remove(conversation.getConversationID());
                }
            } else {
                this._conversation_ids.remove(conversation.getConversationID());
            }
        }
        catch (Throwable throwable) {
            this._conversation_ids.remove(conversation.getConversationID());
        }
    }

    private void checkConversationEnded(String string) {
        FIPAOSAgent fIPAOSAgent = null;
        TaskManager taskManager = this;
        synchronized (taskManager) {
            fIPAOSAgent = this._owner;
        }
        if (fIPAOSAgent != null) {
            try {
                Conversation conversation = fIPAOSAgent.getCurrentConversation(string);
                this.checkConversationEnded(conversation);
            }
            catch (Throwable throwable) {
                this._conversation_ids.remove(string);
            }
        }
    }

    public void notify(Conversation conversation) {
        String string = null;
        Task task = null;
        String string2 = conversation.getConversationID();
        if (!this._shutdown) {
            this._owner.waitForPushLock();
        }
        TaskManager taskManager = this;
        synchronized (taskManager) {
            if (!this._shutdown) {
                if (this._ids_map.containsKey(string2)) {
                    task = (Task)this._ids_map.get(string2);
                } else if (this._conversation_ids.contains(string2)) {
                    string = "internal-error Task-no-longer-associated-with-conversation";
                } else if (this._ids_map.containsKey(IDLE)) {
                    task = (Task)this._ids_map.get(IDLE);
                }
            } else {
                return;
            }
        }
        if (task != null) {
            if (!task._done) {
                ConversationUpdateEvent conversationUpdateEvent = new ConversationUpdateEvent(conversation);
                this.addEvent(task, conversationUpdateEvent);
            } else {
                string = "internal-error task-completed";
            }
        } else if (string == null) {
            string = "internal-error no-idle-task";
        }
        if (string != null && !conversation.getACL(conversation.getLatestMessageIndex()).getPerformative().equals("not-understood")) {
            this._owner.sendNotUnderstood(conversation.getACL(conversation.getLatestMessageIndex()), string);
            this.checkConversationEnded(string2);
        }
    }

    public void notify(Enumeration enumeration) {
        if (!this._shutdown) {
            while (enumeration.hasMoreElements()) {
                this.notify((Conversation)enumeration.nextElement());
            }
        }
    }

    public void setMessageSender(MessageSender messageSender) {
        this._ms = messageSender;
    }

    public void notifyMessageInEndedConversation(Message message) {
        Task task = null;
        if (!this._shutdown) {
            this._owner.waitForPushLock();
        }
        TaskManager taskManager = this;
        synchronized (taskManager) {
            if (!this._shutdown) {
                if (!this._ids_map.containsKey(IDLE)) {
                    return;
                }
            } else {
                return;
            }
            task = (Task)this._ids_map.get(IDLE);
        }
        if (task != null) {
            if (!task._done) {
                MessageForEndedConversationEvent messageForEndedConversationEvent = new MessageForEndedConversationEvent(message);
                this.addEvent(task, messageForEndedConversationEvent);
            } else {
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notifyMessageUndeliverable(Message message) {
        Task task = null;
        String string = message.getACL().getConversationID();
        if (!this._shutdown) {
            this._owner.waitForPushLock();
        }
        TaskManager taskManager = this;
        synchronized (taskManager) {
            if (this._shutdown) return;
            if (this._ids_map.containsKey(string)) {
                task = (Task)this._ids_map.get(string);
            } else {
                if (!this._ids_map.containsKey(IDLE)) return;
                task = (Task)this._ids_map.get(IDLE);
            }
        }
        if (task == null) return;
        if (task._done) return;
        MessageDeliveryFailureEvent messageDeliveryFailureEvent = new MessageDeliveryFailureEvent(message);
        this.addEvent(task, messageDeliveryFailureEvent);
    }

    private class TMCheckTimeout
    implements ThreadPool.Job {
        private TMCheckTimeout() {
        }

        public void go() {
            while (!TaskManager.this._shutdown) {
                try {
                    TaskManager.this.checkTimeout();
                    Thread.sleep(250L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private class TMCheckState
    implements ThreadPool.Job {
        private TMCheckState() {
        }

        public void go() {
            while (!TaskManager.this._shutdown) {
                try {
                    TaskManager.this.checkState();
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private class Timeout {
        private long _timeout_time;
        private Task _task;

        public Timeout(long l, Task task) {
            this._timeout_time = System.currentTimeMillis() + l;
            this._task = task;
        }

        public boolean hasTimedout() {
            return System.currentTimeMillis() >= this._timeout_time;
        }

        public boolean isDone() {
            return this._task._done;
        }

        public Task getTask() {
            return this._task;
        }
    }

    public static class DefaultTaskManagerListener
    implements TaskManagerListener {
        private TaskManager _tm;

        public DefaultTaskManagerListener(TaskManager taskManager) {
            this._tm = taskManager;
            this._tm.setTaskManagerListener(this);
        }

        public void taskEvent(Task task, TaskEvent taskEvent) {
            this._tm.appendToExecutionOrder(task);
        }
    }
}

