/*
 * Decompiled with CFR 0.152.
 */
package fipaos.agent.task;

import fipaos.agent.task.event.TaskEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TaskState {
    public static final int TASK_IDLE = 0;
    public static final int TASK_EXECUTING = 1;
    public static final int TASK_READY_TO_START = 2;
    public static final int TASK_READY_TO_CONTINUE = 3;
    private List _events = new LinkedList();
    private int _state = 2;

    public synchronized int getState() {
        if (this._state == 2 || this._state == 1) {
            return this._state;
        }
        if (this._events.size() > 0) {
            return 3;
        }
        return 0;
    }

    synchronized void setState(int n) {
        this._state = n;
    }

    public synchronized TaskEvent peekNextEvent() {
        if (this.getState() != 3) {
            return null;
        }
        return (TaskEvent)this._events.get(0);
    }

    public synchronized TaskEvent getNextEvent() {
        if (this.getState() != 3 && this.getState() != 2) {
            return null;
        }
        return (TaskEvent)this._events.remove(0);
    }

    synchronized void addEvent(TaskEvent taskEvent) {
        this._events.add(taskEvent);
    }

    void removeReferences() {
        if (this._events != null) {
            Iterator iterator = this._events.iterator();
            while (iterator.hasNext()) {
                TaskEvent taskEvent = (TaskEvent)iterator.next();
                taskEvent.removeReferences();
            }
            this._events.clear();
            this._events = null;
        }
    }
}

