/*
 * Decompiled with CFR 0.152.
 */
package fipaos.mts;

import fipaos.mts.ExternalMTP;
import fipaos.mts.InitialisationException;
import fipaos.mts.MTPBase;
import fipaos.mts.Message;
import fipaos.mts.UnableToSendException;
import fipaos.mts.UnknownProtocolException;
import fipaos.mts.UnknownTargetException;
import fipaos.mts.service.PostParserService;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.Envelope;
import fipaos.parser.acl.string.Parser;
import fipaos.util.DIAGNOSTICS;
import fipaos.util.URL;
import java.util.LinkedList;
import java.util.List;

public abstract class ExternalMTPBase
extends MTPBase
implements ExternalMTP {
    private PostParserService _previous;

    protected ExternalMTPBase(String string, URL uRL) throws InitialisationException {
        super(string, uRL);
    }

    public void initialise(PostParserService postParserService, PostParserService postParserService2) {
        this._previous = postParserService;
    }

    public final void outgoing(Envelope envelope, byte[] byArray) {
        super.handleOutgoing(envelope, byArray);
    }

    public final void incoming(Envelope envelope, byte[] byArray) {
        if (envelope.getErrorCode() == 0) {
            // empty if block
        }
        if (this._previous != null) {
            this._previous.incoming(envelope, byArray);
        }
    }

    final void receive(Envelope envelope, Object object) {
        this.incoming(envelope, (byte[])object);
    }

    final void send(Object object, Envelope envelope, Object object2) throws UnknownTargetException, UnknownProtocolException, UnableToSendException {
        this.send(object, envelope, (byte[])object2);
    }

    protected final void handleIncoming(Envelope envelope, byte[] byArray) {
        super.handleIncoming(envelope, byArray);
    }

    public abstract List getAddresses();

    public abstract List getProtocols();

    public abstract void shutdown();

    protected abstract void send(Object var1, Envelope var2, byte[] var3) throws UnknownTargetException, UnknownProtocolException, UnableToSendException;

    public static void main(String[] stringArray) throws Throwable {
        DIAGNOSTICS.setMemoryLevel(1);
        String string = "(agent-identifier :name agent-a :addresses (sequence fipaos-rmi://localhost:1099/ iiop://somehost.com:8888/acc) :resolvers (sequence (agent-identifier :name ams) (agent-identifier :name acc) ) )";
        String string2 = "(agent-identifier :name agent-b :addresses (sequence fipaos-rmi://localhost:1099/ iiop://somehost.com:8989/acc) :resolvers (sequence (agent-identifier :name ams) (agent-identifier :name acc) ) )";
        ACL aCL = new ACL();
        aCL.setPerformative("inform");
        aCL.setOntology("my-ontology");
        aCL.setLanguage("my-language");
        aCL.setProtocol("my-protocol");
        aCL.setSenderAID(new AgentID(string));
        aCL.setReceiverAID(new AgentID(string2));
        aCL.setContentObject("( Test Message )");
        aCL.setConversationID("test-conv-id-2348723648");
        Message message = new Message(aCL);
        message.getEnvelope().setIntendedReceiver(aCL.getReceiverAIDs());
        TestExternalMTPBase testExternalMTPBase = new TestExternalMTPBase("agenta@hap", new URL("fipaos-rmi://localhost:9000/"));
        try {
            testExternalMTPBase.outgoing(message.getEnvelope(), Parser.deparse(message.getACL()));
            testExternalMTPBase.handleIncoming(message.getEnvelope(), Parser.deparse(message.getACL()));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static class TestExternalMTPBase
    extends ExternalMTPBase {
        public TestExternalMTPBase(String string, URL uRL) throws InitialisationException {
            super(string, uRL);
        }

        protected void bind() throws InitialisationException {
        }

        protected void unbind() {
        }

        protected Object lookup(URL uRL) throws UnknownTargetException {
            return uRL;
        }

        protected Object lookup(String string) throws UnknownTargetException {
            return string;
        }

        public List getAddresses() {
            LinkedList<URL> linkedList = new LinkedList<URL>();
            linkedList.add(new URL("http://localhost:9000/agenta"));
            return linkedList;
        }

        public List getProtocols() {
            return new LinkedList();
        }

        public void shutdown() {
            this.unbind();
        }

        protected void send(Object object, Envelope envelope, byte[] byArray) throws UnknownTargetException, UnknownProtocolException, UnableToSendException {
        }
    }
}

