/*
 * Decompiled with CFR 0.152.
 */
package fipaos.mts;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class IOR {
    public static final String TAG_IIOP = "00000000";
    public static final String TAG_GIOP = "00000001";
    private static final String IOR = "IOR:";
    private static final String ZERO_BYTE = "00";
    private static final String ZERO = "0";
    private static final String ONE = "1";
    private static final String LITTLE_E = "00000000";
    private static final String BIG_E = "01000000";
    private static final String VERSION = "00010000";
    private static final String SUN_IDL_MARKER = "afabcafe";
    private static final String VOYAGER_MARKER = "0000000";
    private boolean _big_endian;
    private String _idl;
    private List _host;
    private List _port;
    private List _obj_key;
    private List _tags;
    private int _profiles;
    private int _byte_index;

    public IOR(String string) {
        this.configure();
        this.parseIOR(string);
    }

    public IOR(String string, String string2, int n, String string3) {
        this.configure();
        this._profiles = 0;
        this._big_endian = false;
        this._idl = string;
        this._host.add(this._profiles, string2);
        this._port.add(this._profiles, new Integer(n));
        this._obj_key.add(this._profiles, string3);
        this._tags.add(this._profiles, "00000000");
    }

    public IOR(String string, List list, List list2, List list3) {
        this.configure();
        this._profiles = list.size() - 1;
        this._big_endian = false;
        this._idl = string;
        this._host = list;
        this._port = list2;
        this._obj_key = list3;
        int n = list.size();
        while (--n >= 0) {
            this._tags.add(n, "00000000");
        }
    }

    private void configure() {
        this._byte_index = 0;
        this._host = new ArrayList();
        this._port = new ArrayList();
        this._tags = new ArrayList();
        this._obj_key = new ArrayList();
    }

    private void parseIOR(String string) {
        this._byte_index = 0;
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = (stringBuffer = stringBuffer.delete(0, 4)).substring(0, 8);
        if (string2.indexOf(ONE) >= 0) {
            this._big_endian = true;
        }
        stringBuffer = stringBuffer.delete(0, 8);
        this._byte_index = 4;
        int n = this.getNumber(stringBuffer.substring(0, 8), this._big_endian);
        stringBuffer = stringBuffer.delete(0, 8);
        this._byte_index += 4;
        this._idl = this.hexStringToString(stringBuffer.substring(0, n * 2));
        this._byte_index += n;
        stringBuffer = stringBuffer.delete(0, n * 2);
        this.checkParseAlignment(4, stringBuffer);
        int n2 = this.getNumber(stringBuffer.substring(0, 8), this._big_endian);
        stringBuffer = stringBuffer.delete(0, 8);
        this._byte_index += 4;
        this._profiles = n2 - 1;
        int n3 = 0;
        while (n3 < n2) {
            String string3 = stringBuffer.substring(0, 8);
            this._tags.add(n3, string3);
            stringBuffer = stringBuffer.delete(0, 8);
            this._byte_index += 4;
            n = this.getNumber(stringBuffer.substring(0, 8), this._big_endian);
            stringBuffer = stringBuffer.delete(0, 8);
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.substring(0, n * 2));
            stringBuffer = stringBuffer.delete(0, n * 2);
            this._byte_index += 4;
            stringBuffer2 = stringBuffer2.delete(0, 8);
            this._byte_index += 4;
            n = this.getNumber(stringBuffer2.substring(0, 8), this._big_endian);
            stringBuffer2 = stringBuffer2.delete(0, 8);
            this._byte_index += 4;
            this._host.add(n3, this.hexStringToString(stringBuffer2.substring(0, n * 2)));
            stringBuffer2 = stringBuffer2.delete(0, n * 2);
            this._byte_index += n;
            this.checkParseAlignment(2, stringBuffer2);
            this._port.add(n3, new Integer(this.getNumber(stringBuffer2.substring(0, 4), this._big_endian)));
            stringBuffer2 = stringBuffer2.delete(0, 4);
            this._byte_index += 2;
            this.checkParseAlignment(4, stringBuffer2);
            n = this.getNumber(stringBuffer2.substring(0, 8), this._big_endian);
            stringBuffer2 = stringBuffer2.delete(0, 8);
            this._byte_index += 4;
            this._obj_key.add(n3, stringBuffer2.substring(0, n * 2));
            this._byte_index += n;
            ++n3;
        }
    }

    private int getNumber(String string, boolean bl) {
        String string2 = ZERO_BYTE;
        if (bl) {
            int n = string.indexOf(ZERO, 1);
            string2 = n >= 0 ? string.substring(0, n) : string;
        } else {
            int n = string.lastIndexOf(ZERO, string.length() - 2);
            string2 = n < 0 ? string : string.substring(n + 1);
            if (string2.length() % 2 != 0) {
                string2 = ZERO + string2;
            }
        }
        return this.hexStringToInt(string2);
    }

    private int hexStringToInt(String string) {
        if (string.length() % 2 != 0) {
            return 0;
        }
        return Integer.parseInt(string, 16);
    }

    private String intToHexString(int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toHexString(n));
        int n3 = n2 * 2;
        int n4 = stringBuffer.length();
        while (n4 < n3) {
            if (bl) {
                stringBuffer.append(ZERO);
            } else {
                stringBuffer.insert(0, ZERO);
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    private String hexStringToString(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        string = string.substring(0, string.length() - 2);
        int n2 = n = string.length() / 2;
        while (n2 > 0) {
            String string2 = string.substring(0, 2);
            string = string.substring(2);
            int n3 = this.hexStringToInt(string2);
            byte[] byArray = new byte[]{new Byte(new Integer(n3).toString())};
            stringBuffer.append(new String(byArray));
            --n2;
        }
        return stringBuffer.toString();
    }

    private String stringToHexString(String string, boolean bl, boolean bl2, boolean bl3) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(Integer.toHexString(cArray[n3]));
            ++n3;
        }
        cArray = null;
        if (bl) {
            stringBuffer.append(ZERO_BYTE);
        }
        n = stringBuffer.length() / 2;
        if (bl2) {
            String string2 = Integer.toHexString(n);
            stringBuffer.insert(0, string2);
            int n4 = 8 - string2.length();
            while (--n4 >= 0) {
                if (bl3) {
                    stringBuffer.append(ZERO);
                    continue;
                }
                stringBuffer.insert(0, ZERO);
            }
        }
        return stringBuffer.toString();
    }

    private String checkParseAlignment(int n, StringBuffer stringBuffer) {
        boolean bl = false;
        String string = "";
        while (!bl) {
            if (this._byte_index % n == 0) {
                bl = true;
                continue;
            }
            ++this._byte_index;
            stringBuffer = stringBuffer.delete(0, 2);
        }
        return stringBuffer.toString();
    }

    private String checkDeparseAlignment(int n) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (!bl) {
            if (this._byte_index % n == 0) {
                bl = true;
                continue;
            }
            ++this._byte_index;
            stringBuffer.append(ZERO_BYTE);
        }
        return stringBuffer.toString();
    }

    private static void printInfo() {
    }

    private static void printUsage() {
        System.exit(0);
    }

    private static void printError(String string) {
        System.exit(-1);
    }

    private String printIORDetails(boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append("IDL:\t\t" + this._idl);
        if (bl) {
            stringBuffer.append("\nEndianness:\t");
            if (this._big_endian) {
                stringBuffer.append("Big");
            } else {
                stringBuffer.append("Little");
            }
        }
        if ((n = this.getProfileCount()) > 1) {
            stringBuffer.append("\n\nIOR has " + n + " profiles:");
        }
        String string = new String();
        int n2 = 0;
        while (n2 < n) {
            if (n > 1) {
                stringBuffer.append("\n\nProfile: " + (n2 + 1));
            }
            if (bl) {
                if (((String)this._tags.get(n2)).compareTo("00000000") == 0) {
                    stringBuffer.append("\nType:\t\tIIOP");
                } else {
                    stringBuffer.append("\nType:\t\tGIOP");
                }
            }
            stringBuffer.append("\nHost & port:\t" + this._host.get(n2) + ":" + this._port.get(n2));
            string = (String)this._obj_key.get(n2);
            if (bl) {
                stringBuffer.append("\nObject key:\t" + string);
            }
            ++n2;
        }
        stringBuffer.append("\nCreated by:\t");
        if (string.startsWith(SUN_IDL_MARKER)) {
            stringBuffer.append("Sun Java ORB (sunidl)");
        } else if (string.startsWith(VOYAGER_MARKER)) {
            stringBuffer.append("Voyager");
        } else {
            stringBuffer.append("An unidentified ORB");
        }
        return stringBuffer.toString();
    }

    private static String readIORFromFile(String string) {
        String string2 = new String();
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new FileReader(string);
        }
        catch (Throwable throwable) {
            try {
                URL uRL = new URL(string);
                inputStreamReader = new InputStreamReader(uRL.openStream());
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.indexOf(IOR) >= 0) {
                    return string2.substring(string2.indexOf(IOR));
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            fipaos.mts.IOR.printError("File at " + string + " could not be found or could not be opened.");
        }
        return null;
    }

    public String getIDL() {
        return this._idl;
    }

    public void setIDL(String string) {
        if (string == null) {
            this._idl = string;
        }
    }

    public boolean isBigEndian() {
        return this._big_endian;
    }

    public void isBigEndian(boolean bl) {
        this._big_endian = bl;
    }

    public void setHost(String string) {
        if (string != null) {
            this._host.add(this._profiles, string);
        }
    }

    public void setHost(int n, String string) {
        if (string != null) {
            this._host.add(n, string);
        }
    }

    public String getHost() {
        return (String)this._host.get(this._profiles);
    }

    public String getHost(int n) {
        return (String)this._host.get(n);
    }

    public void setPort(int n) {
        this._port.add(this._profiles, new Integer(n));
    }

    public void setPort(int n, int n2) {
        this._port.add(n, new Integer(n2));
    }

    public int getPort() {
        return (Integer)this._port.get(this._profiles);
    }

    public int getPort(int n) {
        return (Integer)this._port.get(n);
    }

    public void setObjectKey(String string) {
        if (string != null) {
            this._obj_key.add(this._profiles, string);
        }
    }

    public void setObjectKey(int n, String string) {
        if (string != null) {
            this._obj_key.add(n, string);
        }
    }

    public String getObjectKey() {
        return (String)this._obj_key.get(this._profiles);
    }

    public String getObjectKey(int n) {
        return (String)this._obj_key.get(n);
    }

    public void setTag(String string) {
        if (string != null) {
            this._tags.add(this._profiles, string);
        }
    }

    public void setTag(int n, String string) {
        if (string != null) {
            this._tags.add(n, string);
        }
    }

    public String getTag() {
        return (String)this._tags.get(this._profiles);
    }

    public String getTag(int n) {
        return (String)this._tags.get(n);
    }

    public int addProfile(String string, int n, String string2) {
        ++this._profiles;
        this._host.add(this._profiles, string);
        this._port.add(this._profiles, new Integer(n));
        this._obj_key.add(this._profiles, string2);
        this._tags.add(this._profiles, "00000000");
        return this._profiles;
    }

    public int insertProfile(int n, String string, int n2, String string2) {
        ++this._profiles;
        this._host.add(n, string);
        this._port.add(n, new Integer(n2));
        this._obj_key.add(n, string2);
        this._tags.add(n, "00000000");
        return this._profiles;
    }

    public int removeProfile(int n) {
        --this._profiles;
        this._host.remove(n);
        this._tags.remove(n);
        this._port.remove(n);
        this._obj_key.remove(n);
        return this._profiles;
    }

    public int getProfileCount() {
        return this._profiles + 1;
    }

    public String toString() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(IOR);
        if (this._big_endian) {
            stringBuffer.append(BIG_E);
            this._byte_index = BIG_E.length() / 2;
        } else {
            stringBuffer.append("00000000");
            this._byte_index = "00000000".length() / 2;
        }
        String string = this.stringToHexString(this._idl, true, true, this._big_endian);
        stringBuffer.append(string);
        this._byte_index += string.length() / 2;
        stringBuffer.append(this.checkDeparseAlignment(4));
        string = this.intToHexString(this.getProfileCount(), 4, this._big_endian);
        stringBuffer.append(string);
        this._byte_index += string.length() / 2;
        int n = this.getProfileCount();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this._tags.get(n2));
            this._byte_index += 4;
            StringBuffer stringBuffer2 = new StringBuffer(VERSION);
            this._byte_index += 4;
            string = this.stringToHexString((String)this._host.get(n2), true, true, this._big_endian);
            stringBuffer2.append(string);
            this._byte_index += string.length() / 2;
            stringBuffer2.append(this.checkDeparseAlignment(2));
            string = Integer.toHexString((Integer)this._port.get(n2));
            int n3 = 4 - string.length();
            while (--n3 >= 0) {
                stringBuffer2.append(ZERO);
            }
            stringBuffer2.append(string);
            this._byte_index += 2;
            stringBuffer2.append(this.checkDeparseAlignment(4));
            String string2 = (String)this._obj_key.get(n2);
            int n4 = string2.length() / 2;
            String string3 = Integer.toHexString(n4);
            if (this._big_endian) {
                stringBuffer2.append(string3);
            }
            int n5 = 8 - string3.length();
            while (--n5 >= 0) {
                stringBuffer2.append(ZERO);
            }
            if (!this._big_endian) {
                stringBuffer2.append(string3);
            }
            stringBuffer2.append(string2);
            this._byte_index += n4;
            this._byte_index += 4;
            int n6 = stringBuffer2.length() / 2;
            String string4 = Integer.toHexString(n6);
            if (this._big_endian) {
                stringBuffer.append(string4);
            }
            int n7 = 8 - string4.length();
            while (--n7 >= 0) {
                stringBuffer.append(ZERO);
            }
            this._byte_index += 4;
            if (!this._big_endian) {
                stringBuffer.append(string4);
            }
            stringBuffer.append((java.lang.Object)stringBuffer2);
            if (this._byte_index % 2 != 0) {
                stringBuffer.append(ZERO_BYTE);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        fipaos.mts.IOR.printInfo();
        if (stringArray.length > 2 || stringArray.length == 0) {
            fipaos.mts.IOR.printUsage();
        }
        boolean bl = false;
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].compareToIgnoreCase("-v") == 0) {
                bl = true;
            } else if (stringArray[n].startsWith("-h")) {
                fipaos.mts.IOR.printUsage();
            } else if (stringArray[n].startsWith("/h")) {
                fipaos.mts.IOR.printUsage();
            } else if (stringArray[n].indexOf("?") >= 0) {
                fipaos.mts.IOR.printUsage();
            } else {
                string = stringArray[n];
            }
            ++n;
        }
        String string2 = new String();
        try {
            string2 = fipaos.mts.IOR.readIORFromFile(string);
        }
        catch (Throwable throwable) {
            fipaos.mts.IOR.printError("IOR could not be read from file at: " + string);
        }
        if (string2 == null) {
            fipaos.mts.IOR.printError("IOR could not be read from file at: " + string);
        }
        if (bl) {
            // empty if block
        }
        try {
            IOR iOR = new IOR(string2);
            try {
                ORB oRB = ORB.init((String[])new String[0], (Properties)System.getProperties());
                Object object = oRB.string_to_object(string2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
            }
        }
        catch (Throwable throwable) {
            fipaos.mts.IOR.printError("IOR is malformed or corrupt");
        }
        System.exit(0);
    }
}

