/*
 * Decompiled with CFR 0.152.
 */
package fipaos.mts;

import fipaos.mts.InitialisationException;
import fipaos.mts.InternalMTP;
import fipaos.mts.MTPBase;
import fipaos.mts.Message;
import fipaos.mts.UnableToSendException;
import fipaos.mts.UnknownProtocolException;
import fipaos.mts.UnknownTargetException;
import fipaos.mts.service.PreParserService;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.Envelope;
import fipaos.util.DIAGNOSTICS;
import fipaos.util.URL;
import java.util.LinkedList;
import java.util.List;

public abstract class InternalMTPBase
extends MTPBase
implements InternalMTP {
    private PreParserService _previous;

    protected InternalMTPBase(String string, URL uRL) throws InitialisationException {
        super(string, uRL);
    }

    public void initialise(PreParserService preParserService, PreParserService preParserService2) {
        this._previous = preParserService;
    }

    public final void outgoing(Message message) {
        super.handleOutgoing(message.getEnvelope(), message);
    }

    public final void incoming(Message message) {
        if (message.getEnvelope().getErrorCode() == 0) {
            // empty if block
        }
        if (this._previous != null) {
            this._previous.incoming(message);
        }
    }

    final void receive(Envelope envelope, Object object) {
        this.incoming((Message)object);
    }

    final void send(Object object, Envelope envelope, Object object2) throws UnknownTargetException, UnknownProtocolException, UnableToSendException {
        this.send(object, (Message)object2);
    }

    protected final void handleIncoming(Message message) {
        super.handleIncoming(message.getEnvelope(), message);
    }

    public abstract List getAddresses();

    public abstract List getProtocols();

    public abstract void shutdown();

    protected abstract void send(Object var1, Message var2) throws UnknownTargetException, UnknownProtocolException, UnableToSendException;

    public static void main(String[] stringArray) throws Throwable {
        DIAGNOSTICS.setMemoryLevel(1);
        String string = "(agent-identifier :name agent-a :addresses (sequence fipaos-rmi://localhost:1099/ iiop://somehost.com:8888/acc) :resolvers (sequence (agent-identifier :name ams) (agent-identifier :name acc) ) )";
        String string2 = "(agent-identifier :name agent-b :addresses (sequence fipaos-rmi://localhost:1099/ iiop://somehost.com:8989/acc) :resolvers (sequence (agent-identifier :name ams) (agent-identifier :name acc) ) )";
        ACL aCL = new ACL();
        aCL.setPerformative("inform");
        aCL.setOntology("my-ontology");
        aCL.setLanguage("my-language");
        aCL.setProtocol("my-protocol");
        aCL.setSenderAID(new AgentID(string));
        aCL.setReceiverAID(new AgentID(string2));
        aCL.setContentObject("( Test Message )");
        aCL.setConversationID("test-conv-id-2348723648");
        Message message = new Message(aCL);
        message.getEnvelope().setIntendedReceiver(aCL.getReceiverAIDs());
        TestInternalMTPBase testInternalMTPBase = new TestInternalMTPBase("agenta@hap", new URL("fipaos-rmi://localhost:9000/"));
        testInternalMTPBase.outgoing(message);
        testInternalMTPBase.handleIncoming(message.getEnvelope(), message);
    }

    private static class TestInternalMTPBase
    extends InternalMTPBase {
        public TestInternalMTPBase(String string, URL uRL) throws InitialisationException {
            super(string, uRL);
        }

        protected void bind() throws InitialisationException {
        }

        protected void unbind() {
        }

        protected Object lookup(URL uRL) throws UnknownTargetException {
            return uRL;
        }

        protected Object lookup(String string) throws UnknownTargetException {
            return string;
        }

        public List getAddresses() {
            LinkedList<URL> linkedList = new LinkedList<URL>();
            linkedList.add(new URL("http://localhost:9000/agenta"));
            return linkedList;
        }

        public List getProtocols() {
            return new LinkedList();
        }

        public void shutdown() {
            this.unbind();
        }

        protected void send(Object object, Message message) throws UnknownTargetException, UnknownProtocolException, UnableToSendException {
        }
    }
}

