/*
 * Decompiled with CFR 0.152.
 */
package fipaos.mts;

import fipaos.mts.InitialisationException;
import fipaos.mts.Message;
import fipaos.mts.UnableToSendException;
import fipaos.mts.UnknownProtocolException;
import fipaos.mts.UnknownTargetException;
import fipaos.mts.event.MessageListener;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.Envelope;
import fipaos.util.Comparators;
import fipaos.util.DIAGNOSTICS;
import fipaos.util.FIFOQueue;
import fipaos.util.Monitor;
import fipaos.util.MonitorListener;
import fipaos.util.Queue;
import fipaos.util.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class MTPBase {
    public static String ACC_NAME = "acc";
    protected URL _ns_url;
    protected String _name;
    protected String _hap;
    public boolean _shutdown = false;
    private Queue _incoming_queue = new FIFOQueue();
    private Monitor _incoming_queue_monitor;
    private Map _lookup_table;

    protected MTPBase(String string, URL uRL) throws InitialisationException {
        this._ns_url = uRL;
        this._lookup_table = new TreeMap(Comparators.STRING_COMPARE);
        int n = string.indexOf(64);
        this._name = string.substring(0, n);
        this._hap = string.substring(n + 1);
        if (n == -1) {
            throw new InitialisationException("HAP not spcified in Agent name?!?!?");
        }
        try {
            this.bind();
        }
        catch (InitialisationException initialisationException) {
            throw initialisationException;
        }
        catch (Throwable throwable) {
            throw new InitialisationException("Some error occured when binding to the NS");
        }
        this._incoming_queue_monitor = new Monitor(this._incoming_queue, new MonitorListener(){

            public void monitorUpdate(Object object) {
                Envelope envelope = (Envelope)((Object[])object)[0];
                Object object2 = ((Object[])object)[1];
                try {
                    MTPBase.this.receive(envelope, object2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    protected void handleOutgoing(Envelope envelope, Object object) {
        this.handleOutgoing(envelope, object, true);
    }

    private void handleOutgoing(Envelope envelope, Object object, boolean bl) {
        Object object2;
        Object object3;
        URL uRL;
        int n;
        block20: {
            Object object4 = null;
            Throwable throwable = null;
            n = 0;
            uRL = null;
            try {
                if (envelope.getViaACC()) {
                    try {
                        object4 = this.lookup(ACC_NAME);
                    }
                    catch (Throwable throwable2) {
                        n = 1;
                        throwable = throwable2;
                    }
                } else {
                    object3 = (AgentID)envelope.getIntendedReceiver().get(0);
                    if (((AgentID)object3).getAddresses().size() > 0) {
                        try {
                            object4 = this.cachedLookup((AgentID)object3);
                            uRL = (URL)((AgentID)object3).getAddresses().get(0);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                        }
                    }
                    if (object4 == null && ((AgentID)object3).getName().endsWith("@" + this._hap)) {
                        object2 = ((AgentID)object3).getName();
                        int n2 = ((String)object2).lastIndexOf("@" + this._hap);
                        object2 = ((String)object2).substring(0, n2);
                        object4 = this.lookup((String)object2);
                    }
                }
                if (object4 != null) {
                    this.send(object4, envelope, object);
                    break block20;
                }
                if (throwable != null) {
                    throw throwable;
                }
                throw new UnknownTargetException("");
            }
            catch (UnknownTargetException unknownTargetException) {
                n = 1;
            }
            catch (UnknownProtocolException unknownProtocolException) {
                n = 2;
            }
            catch (UnableToSendException unableToSendException) {
                n = 3;
            }
            catch (Throwable throwable4) {
                n = 3;
            }
        }
        if (n != 0) {
            if (uRL != null && bl) {
                this._lookup_table.remove(uRL);
                this.handleOutgoing(envelope, object, false);
            } else {
                envelope.setErrorCode(n);
                this.handleIncoming(envelope, object);
            }
        } else {
            object3 = envelope.getMessageListeners().iterator();
            while (object3.hasNext()) {
                object2 = (MessageListener)object3.next();
                object2.notifyDelivery(envelope);
            }
        }
    }

    private Object cachedLookup(AgentID agentID) throws Exception {
        Object object = null;
        URL uRL = (URL)agentID.getAddresses().get(0);
        if (this.getProtocols().contains(uRL.getProtocol())) {
            if (this._lookup_table.containsKey(uRL.toString())) {
                object = this._lookup_table.get(uRL.toString());
            } else {
                object = this.lookup(uRL);
                if (object != null) {
                    this._lookup_table.put(agentID.getAddresses().get(0), object);
                }
            }
        } else {
            throw new UnknownProtocolException(uRL.getProtocol() + " not supported by MTP");
        }
        return object;
    }

    protected void handleIncoming(Envelope envelope, Object object) {
        if (!this._shutdown) {
            this._incoming_queue.addItem(new Object[]{envelope, object});
        }
    }

    protected void shutdownMTPBase() {
        this._shutdown = true;
        this._incoming_queue_monitor.halt();
        this._incoming_queue_monitor = null;
        this._incoming_queue.flush();
        this._incoming_queue = null;
        this.unbind();
    }

    protected abstract void bind() throws InitialisationException;

    protected abstract void unbind();

    protected abstract Object lookup(URL var1) throws UnknownTargetException;

    protected abstract Object lookup(String var1) throws UnknownTargetException;

    abstract void send(Object var1, Envelope var2, Object var3) throws UnknownTargetException, UnknownProtocolException, UnableToSendException;

    abstract void receive(Envelope var1, Object var2);

    public abstract List getProtocols();

    public static void main(String[] stringArray) throws Throwable {
        DIAGNOSTICS.setMemoryLevel(1);
        String string = "(agent-identifier :name agent-a :addresses (sequence fipaos-rmi://localhost:1099/ iiop://somehost.com:8888/acc) :resolvers (sequence (agent-identifier :name ams) (agent-identifier :name acc) ) )";
        String string2 = "(agent-identifier :name agent-b :addresses (sequence fipaos-rmi://localhost:1099/ iiop://somehost.com:8989/acc) :resolvers (sequence (agent-identifier :name ams) (agent-identifier :name acc) ) )";
        ACL aCL = new ACL();
        aCL.setPerformative("inform");
        aCL.setOntology("my-ontology");
        aCL.setLanguage("my-language");
        aCL.setProtocol("my-protocol");
        aCL.setSenderAID(new AgentID(string));
        aCL.setReceiverAID(new AgentID(string2));
        aCL.setContentObject("( Test Message )");
        aCL.setConversationID("test-conv-id-2348723648");
        Message message = new Message(aCL);
        message.getEnvelope().setIntendedReceiver(aCL.getReceiverAIDs());
        TestMTPBase testMTPBase = new TestMTPBase("agenta@hap", new URL("fipaos-rmi://localhost:9000/"));
        testMTPBase.handleOutgoing(message.getEnvelope(), message);
        testMTPBase.handleIncoming(message.getEnvelope(), message);
    }

    private static class TestMTPBase
    extends MTPBase {
        public TestMTPBase(String string, URL uRL) throws InitialisationException {
            super(string, uRL);
        }

        public List getProtocols() {
            return new LinkedList();
        }

        protected void bind() throws InitialisationException {
        }

        protected void unbind() {
        }

        protected Object lookup(URL uRL) throws UnknownTargetException {
            return uRL;
        }

        protected Object lookup(String string) throws UnknownTargetException {
            return string;
        }

        void send(Object object, Envelope envelope, Object object2) {
        }

        void receive(Envelope envelope, Object object) {
        }
    }
}

