/*
 * Decompiled with CFR 0.152.
 */
package fipaos.mts.httpMTP;

import fipaos.mts.httpMTP.ThreadingAbility;
import fipaos.ont.fipa.fipaman.Envelope;
import fipaos.parser.ParserException;
import fipaos.parser.envelope.xml.Parser;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;

public class SenderThread
extends ThreadingAbility {
    private static final int BOUNDARY_LENGTH = 24;
    private static final int PASS = -1;
    private static final int UNTRIED = 0;
    private static final byte NUM = 48;
    private static final byte CAP = 65;
    private static final byte SMALLCAP = 97;
    private static final Random r = new Random();
    private static final String STANDARD_TYPE1 = "application/xml";
    private static final String STANDARD_TYPE2 = "application/text; charset=US-ASCII";
    private String envelope;
    private String body;
    private String boundary;
    private String envMimeType;
    private String msgMimeType;
    private fipaos.util.URL _target;

    public SenderThread(fipaos.util.URL uRL, Envelope envelope, byte[] byArray) {
        try {
            this.envelope = new String(Parser.deparse(envelope));
            this.body = new String(byArray);
            this._target = uRL;
            this.internal.start();
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }

    protected void runImplementation() {
        try {
            URL uRL = new URL(this._target.toString());
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            String string = this.constructMessage();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Connection", "close");
            httpURLConnection.setRequestProperty("Cache-Control", "no-cache");
            httpURLConnection.setRequestProperty("Content-Type", "multipart/mixed ;\n\tboundary=\"" + this.boundary + "\"");
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(string.length()));
            httpURLConnection.setRequestProperty("Host", uRL.getHost() + ":" + uRL.getPort());
            httpURLConnection.setRequestProperty("MIME-Version", "1.0");
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDefaultUseCaches(false);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            PrintWriter printWriter = new PrintWriter(httpURLConnection.getOutputStream(), true);
            printWriter.print(string);
            printWriter.close();
            int n = httpURLConnection.getResponseCode();
            String string2 = httpURLConnection.getResponseMessage();
            httpURLConnection.disconnect();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException.toString());
        }
    }

    private String constructMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        byte[] byArray = new byte[]{13, 10};
        String string = new String(byArray);
        do {
            this.boundary = this.generateBoundary();
        } while (this.envelope.indexOf(this.boundary) != -1 || this.body.indexOf(this.boundary) != -1);
        stringBuffer.append("This is not part of the MIME multipart encoded message.");
        stringBuffer.append(string + "--");
        stringBuffer.append(this.boundary);
        stringBuffer.append(string + "Content-Type: ");
        stringBuffer.append(this.envMimeType != null ? this.envMimeType : STANDARD_TYPE1);
        stringBuffer.append(string + string);
        stringBuffer.append(this.envelope);
        stringBuffer.append(string + "--");
        stringBuffer.append(this.boundary);
        stringBuffer.append(string + "Content-Type: ");
        stringBuffer.append(this.msgMimeType != null ? this.msgMimeType : STANDARD_TYPE2);
        stringBuffer.append(string + string);
        stringBuffer.append(this.body);
        stringBuffer.append(string + "--");
        stringBuffer.append(this.boundary);
        stringBuffer.append("--" + string);
        return stringBuffer.toString();
    }

    private String generateBoundary() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 24) {
            char c = (char)(Math.random() * 128.0);
            while (!Character.isLetterOrDigit(c)) {
                c = (char)(Math.random() * 128.0);
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }
}

