/*
 * Decompiled with CFR 0.152.
 */
package fipaos.mts.rmi.internal;

import fipaos.mts.InitialisationException;
import fipaos.mts.InternalMTPBase;
import fipaos.mts.Message;
import fipaos.mts.UnableToSendException;
import fipaos.mts.UnknownTargetException;
import fipaos.mts.rmi.internal.MTS;
import fipaos.mts.rmi.internal.ns.RMIAgentNamingService;
import fipaos.mts.rmi.internal.ns.RMIAgentNamingServiceImpl;
import fipaos.mts.service.PreParserService;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.util.DIAGNOSTICS;
import fipaos.util.URL;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class RMIComms
extends InternalMTPBase {
    private static final String TRANSPORT_PROTOCOL = "fipaos-rmi";
    private RMIAgentNamingService _naming_service;
    private MTS _proxy;
    private URL _url;

    public RMIComms(String string, URL uRL) throws InitialisationException, RemoteException {
        super(string, uRL);
        this._url = (URL)uRL.clone();
        this._url.setTarget(this._name);
        if (this._url.getHost() != null && this._url.getHost().equalsIgnoreCase("localhost")) {
            try {
                String string2 = InetAddress.getLocalHost().getHostAddress();
                this._url.setHost(string2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void bind() throws InitialisationException {
        if (this._naming_service == null) {
            try {
                this._naming_service = RMIComms.findNS(this._ns_url);
                this._proxy = this.getMTSListener(this);
            }
            catch (InitialisationException initialisationException) {
                throw initialisationException;
            }
            catch (Throwable throwable) {
                throw new InitialisationException("Error when locating / contacting NS: " + throwable.toString());
            }
        }
        try {
            this._naming_service.bind(this._name, this._proxy);
        }
        catch (RemoteException remoteException) {
            throw new InitialisationException("Error when attempting (re)bind to NS: " + remoteException.getMessage());
        }
    }

    protected void unbind() {
        try {
            boolean bl = false;
            MTS mTS = this.resolve(this._url);
            bl = mTS.equals(this._proxy);
            if (bl) {
                this._naming_service.unbind(this._name);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (UnknownTargetException unknownTargetException) {
            // empty catch block
        }
    }

    protected Object lookup(URL uRL) throws UnknownTargetException {
        MTS mTS = this.resolve(uRL);
        if (mTS == null) {
            throw new UnknownTargetException("Couldn't resolve target: " + uRL);
        }
        return mTS;
    }

    protected Object lookup(String string) throws UnknownTargetException {
        URL uRL = RMIComms.getLocalNSAgentURL(string, this._ns_url, this._hap);
        if (uRL != null) {
            return this.lookup(uRL);
        }
        throw new UnknownTargetException("Couldn't re-create address for Agent \"" + string + "\"");
    }

    protected void send(Object object, Message message) throws UnableToSendException {
        if (object instanceof MTS) {
            MTS mTS = (MTS)object;
            try {
                mTS.ping();
            }
            catch (Throwable throwable) {
                throw new UnableToSendException("Error when sending message to target - cached reference stale?: " + throwable.toString());
            }
            try {
                mTS.message(message);
            }
            catch (Throwable throwable) {
                throw new UnableToSendException("Error when sending message to target:" + throwable.toString());
            }
        }
        throw new UnableToSendException("Target not of correct type!");
    }

    public List getAddresses() {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        linkedList.add(this._url);
        return linkedList;
    }

    public List getProtocols() {
        return Arrays.asList(TRANSPORT_PROTOCOL);
    }

    public void shutdown() {
        super.shutdownMTPBase();
        this._proxy = null;
        this._naming_service = null;
        this._url = null;
    }

    public void handleMessage(Message message) {
        super.handleIncoming(message);
    }

    public static synchronized void startupRegistry(int n) throws InitialisationException {
        try {
            LocateRegistry.createRegistry(n);
        }
        catch (RemoteException remoteException) {
            try {
                Registry registry = LocateRegistry.getRegistry(n);
                registry.list();
            }
            catch (RemoteException remoteException2) {
                throw new InitialisationException("Couldn't locate/create local registry: " + remoteException2);
            }
        }
    }

    public static void bindToRegistry(String string, Remote remote, int n) throws InitialisationException {
        try {
            Registry registry = LocateRegistry.getRegistry(n);
            registry.rebind(string, remote);
        }
        catch (RemoteException remoteException) {
            throw new InitialisationException("Couldn't bind object to local registry: " + remoteException.getMessage());
        }
    }

    private MTS resolve(URL uRL) throws UnknownTargetException {
        MTS mTS;
        block5: {
            mTS = null;
            try {
                RMIAgentNamingService rMIAgentNamingService = null;
                rMIAgentNamingService = RMIComms.getNSURL(uRL).equals(RMIComms.getNSURL(this._ns_url)) ? this._naming_service : RMIComms.findNS(uRL);
                try {
                    mTS = rMIAgentNamingService.lookup(RMIComms.getNSAgentName(uRL));
                }
                catch (Throwable throwable) {
                    if (rMIAgentNamingService == this._naming_service) {
                        this._naming_service = RMIComms.findNS(this._ns_url);
                        mTS = this._naming_service.lookup(RMIComms.getNSAgentName(uRL));
                        break block5;
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                throw new UnknownTargetException("Unable to lookup target name: " + throwable.getMessage());
            }
        }
        return mTS;
    }

    private static RMIAgentNamingService findNS(URL uRL) throws InitialisationException, ConnectException, NoSuchObjectException, NotBoundException {
        RMIAgentNamingService rMIAgentNamingService = null;
        try {
            String string = RMIComms.getNSURL(uRL);
            rMIAgentNamingService = (RMIAgentNamingService)Naming.lookup(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new InitialisationException("Error when locating NS: " + malformedURLException.getMessage());
        }
        catch (RemoteException remoteException) {
            throw new InitialisationException("Error when attempting to find NS (RMI-NS started?) " + remoteException.getMessage());
        }
        return rMIAgentNamingService;
    }

    private static RMIAgentNamingService activateNS(URL uRL) throws InitialisationException {
        try {
            InetAddress inetAddress = InetAddress.getByName(uRL.getHost());
            InetAddress inetAddress2 = InetAddress.getLocalHost();
            String string = uRL.getHost();
            if (string.equals("localhost") || string.equals("127.0.0.1") || inetAddress.equals(inetAddress2)) {
                RMIComms.startupRegistry(uRL.getPort());
                return new RMIAgentNamingServiceImpl(uRL);
            }
            throw new InitialisationException("Couldn't activate NS because " + string + " is not the localhost.  Remote " + "activation is not yet supported.");
        }
        catch (UnknownHostException unknownHostException) {
            throw new InitialisationException("Couldn't activate NS: " + unknownHostException.getMessage());
        }
        catch (RemoteException remoteException) {
            throw new InitialisationException("Couldn't activate NS: " + remoteException.getMessage());
        }
    }

    private static String getNSURL(URL uRL) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("//");
            stringBuffer.append(uRL.getHost());
            stringBuffer.append(":");
            stringBuffer.append(uRL.getPort());
            stringBuffer.append("/");
            stringBuffer.append("RMINS");
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static String getNSAgentName(URL uRL) {
        try {
            String string = uRL.getTarget();
            return string;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static URL getLocalNSAgentURL(String string, URL uRL, String string2) {
        Object object;
        int n = string.indexOf(64);
        if (n != -1) {
            object = string.substring(n + 1);
            string = string.substring(0, n);
            if (!((String)object).equalsIgnoreCase(string2)) {
                return null;
            }
        }
        object = (URL)uRL.clone();
        ((URL)object).setTarget(string);
        return object;
    }

    protected MTSListener getMTSListener(RMIComms rMIComms) throws RemoteException {
        return new MTSListener(rMIComms);
    }

    public static void main(String[] stringArray) throws Exception {
        DIAGNOSTICS.setMemoryLevel(1);
        URL uRL = new URL(stringArray[0]);
        URL uRL2 = new URL(stringArray[1]);
        String string = RMIComms.getNSAgentName(uRL) + "@localhost";
        String string2 = RMIComms.getNSAgentName(uRL2) + "@localhost";
        URL uRL3 = new URL("fipaos-rmi:" + RMIComms.getNSURL(uRL));
        AgentID agentID = new AgentID();
        AgentID agentID2 = new AgentID();
        agentID.setName(string);
        agentID2.setName(string2);
        ACL aCL = new ACL();
        aCL.setContentObject("Hello");
        aCL.setSenderAID(agentID);
        aCL.addReceiverAID(agentID2);
        Message message = new Message(aCL);
        message.getEnvelope().setIntendedReceiver(Arrays.asList(agentID2));
        RMIComms rMIComms = new RMIComms(RMIComms.getNSAgentName(uRL) + "@localhost", uRL3);
        rMIComms.initialise(new TestClass(), null);
        agentID.setAddresses(rMIComms.getAddresses());
        agentID2.setAddresses(Arrays.asList(uRL2));
        Message message2 = (Message)message.clone();
        while (true) {
            try {
                while (true) {
                    long l = System.currentTimeMillis();
                    rMIComms.outgoing(message);
                    l = System.currentTimeMillis() - l;
                    message = (Message)message2.clone();
                    Thread.sleep(1000L);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static class TestClass
    implements PreParserService {
        int _received = 0;

        private TestClass() {
        }

        public void initialise(PreParserService preParserService, PreParserService preParserService2) {
        }

        public void outgoing(Message message) {
        }

        public void incoming(Message message) {
        }

        public void shutdown() {
        }
    }

    public class MTSListener
    extends UnicastRemoteObject
    implements MTS {
        RMIComms _parent;

        public MTSListener(RMIComms rMIComms2) throws RemoteException {
            this._parent = rMIComms2;
        }

        public void message(Message message) throws RemoteException {
            this._parent.handleMessage(message);
        }

        public void ping() throws RemoteException {
            if (RMIComms.this._shutdown) {
                throw new RemoteException("This MTS has shutdown!");
            }
        }
    }
}

