/*
 * Decompiled with CFR 0.152.
 */
package fipaos.mts.rmi.internal.ns;

import fipaos.agent.profile.DatabaseProfileImpl;
import fipaos.mts.rmi.internal.MTS;
import fipaos.mts.rmi.internal.RMIComms;
import fipaos.mts.rmi.internal.ns.RMIAgentNamingService;
import fipaos.skill.db.Database;
import fipaos.skill.db.DatabaseFactory;
import fipaos.skill.db.DatabaseObject;
import fipaos.util.DIAGNOSTICS;
import fipaos.util.URL;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;

public class RMIAgentNamingServiceImpl
extends UnicastRemoteObject
implements RMIAgentNamingService {
    public static final String RMIREGISTRY_NAME = "RMINS";
    private Database _references;

    public RMIAgentNamingServiceImpl(URL uRL) throws RemoteException {
        this(uRL.getPort());
    }

    private RMIAgentNamingServiceImpl(int n) throws RemoteException {
        try {
            DatabaseProfileImpl databaseProfileImpl = new DatabaseProfileImpl();
            databaseProfileImpl.setDatabaseType("SerializationDatabase");
            databaseProfileImpl.setDatabaseLocation(System.getProperty("user.dir"));
            this._references = DatabaseFactory.getDatabase("rmi-ns", databaseProfileImpl);
            this._references.openDatabase();
            RMIAgentNamingServiceImpl rMIAgentNamingServiceImpl = this;
            synchronized (rMIAgentNamingServiceImpl) {
                RMIComms.startupRegistry(n);
                RMIComms.bindToRegistry(RMIREGISTRY_NAME, this, n);
                this.checkReferences();
            }
        }
        catch (Throwable throwable) {
            throw new RemoteException("Problem initialising RMIAgentNamingService", throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized MTS lookup(String string) throws RemoteException {
        NSReference nSReference = null;
        try {
            try {
                Object object;
                this._references.startTransaction(true);
                Enumeration enumeration = this._references.getIDs();
                while (true) {
                    if (!enumeration.hasMoreElements()) {
                        object = null;
                        if (nSReference != null) {
                            object = nSReference._ref;
                        }
                        break;
                    }
                    object = this._references.findObject((String)enumeration.nextElement());
                    if (!object.getObjectID().equalsIgnoreCase(string)) continue;
                    nSReference = (NSReference)object;
                }
                MTS mTS = object;
                Object var7_7 = null;
                try {
                    this._references.endTransaction();
                    return mTS;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return mTS;
            }
            catch (Throwable throwable) {
                throw new RemoteException("Error when performing lookup", throwable);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {}
            catch (Throwable throwable2) {
                throw throwable;
            }
            this._references.endTransaction();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void bind(String string, MTS mTS) throws RemoteException {
        try {
            try {
                this._references.startTransaction(false);
                NSReference nSReference = new NSReference(string, mTS);
                this._references.addObject(nSReference);
            }
            catch (Throwable throwable) {
                throw new RemoteException("Error when performing bind", throwable);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                this._references.endTransaction();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {}
        this._references.endTransaction();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void unbind(String string) throws RemoteException {
        try {
            try {
                this._references.startTransaction(false);
                this._references.removeObject(string);
            }
            catch (Throwable throwable) {
                throw new RemoteException("Error when performing unbind", throwable);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                this._references.endTransaction();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {}
        this._references.endTransaction();
        return;
    }

    private synchronized void checkReferences() {
        try {
            Enumeration enumeration = null;
            this._references.startTransaction(true);
            enumeration = this._references.getIDs();
            this._references.endTransaction();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                try {
                    MTS mTS = this.lookup(string);
                    mTS.ping();
                }
                catch (Throwable throwable) {
                    try {
                        this.unbind(string);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DIAGNOSTICS.setMemoryLevel(1);
        if (stringArray.length != 1) {
            System.exit(-10);
        }
        new RMIAgentNamingServiceImpl(Integer.parseInt(stringArray[0]));
    }

    private static class NSReference
    implements DatabaseObject {
        public MTS _ref;
        public String _name;

        public NSReference(String string, MTS mTS) {
            this._ref = mTS;
            this._name = string;
        }

        public String getObjectID() {
            return this._name;
        }
    }
}

