/*
 * Decompiled with CFR 0.152.
 */
package fipaos.mts.service;

import fipaos.FIPAOSFactory;
import fipaos.agent.profile.ACCProfile;
import fipaos.agent.profile.DatabaseProfile;
import fipaos.agent.profile.ExternalAddress;
import fipaos.agent.profile.InternalAddress;
import fipaos.agent.profile.PlatformProfile;
import fipaos.agent.profile.RemoteAgentPlatformProfile;
import fipaos.mts.InitialisationException;
import fipaos.mts.Message;
import fipaos.mts.TransportProvider;
import fipaos.mts.service.BufferService;
import fipaos.mts.service.CommMultiplexService;
import fipaos.mts.service.ParserService;
import fipaos.mts.service.PreParserService;
import fipaos.mts.service.Service;
import fipaos.mts.service.ServiceStack;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AMSAgentDescription;
import fipaos.ont.fipa.fipaman.APDescription;
import fipaos.ont.fipa.fipaman.APTDescription;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.AgentManagementAction;
import fipaos.ont.fipa.fipaman.AgentManagementResult;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.ont.fipa.fipaman.Envelope;
import fipaos.ont.fipa.fipaman.MTPDescription;
import fipaos.ont.fipa.fipaman.Received;
import fipaos.parser.datamapping.DataMapper;
import fipaos.parser.datamapping.DataMapperFactory;
import fipaos.skill.db.Database;
import fipaos.skill.db.DatabaseException;
import fipaos.skill.db.DatabaseFactory;
import fipaos.skill.db.DatabaseObject;
import fipaos.util.Comparators;
import fipaos.util.DocumentRetriever;
import fipaos.util.URL;
import fipaos.util.UTCTime;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class AgentCommunicationChannel {
    public static String ACC_NAME = "acc";
    public static String DATABASE_NAME = "acc-db";
    public static final boolean PROPOGATE_ADDRS = System.getProperty("acc.propogate.addrs", "false").equals("true");
    public static final boolean FIPAOS_BOOTSTRAP = System.getProperty("acc.bootstrap.fipaosformat", "false").equals("true");
    public static final boolean BOOTSTRAP_FILES = System.getProperty("acc.bootstrap.usefile", "false").equals("true");
    private PreParserService _internal_stack;
    private PreParserService _external_stack;
    private List _addresses = new LinkedList();
    private String _hap;
    private Database _platforms;
    private int _update_threads = 0;
    private ACCProfile _acc_profile;
    private PlatformProfile _platform_profile;
    static /* synthetic */ Class class$fipaos$mts$TransportProvider;

    public AgentCommunicationChannel(PlatformProfile platformProfile, ACCProfile aCCProfile) throws InitialisationException {
        this._hap = platformProfile.getHAPName();
        this._acc_profile = aCCProfile;
        this._platform_profile = platformProfile;
        this.setupTransports(aCCProfile);
        this.publishAddresses(aCCProfile);
        this.dealWithRemotePlatforms(aCCProfile);
    }

    private void dealWithRemotePlatforms(ACCProfile aCCProfile) throws InitialisationException {
        DatabaseProfile databaseProfile = aCCProfile.getDatabaseProfile();
        try {
            this._platforms = DatabaseFactory.getDatabase(this._hap + "-" + DATABASE_NAME, databaseProfile);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this._platforms == null) {
            throw new InitialisationException("Couldn't create database for some reason - profile = " + databaseProfile);
        }
        try {
            this._platforms.openDatabase();
        }
        catch (DatabaseException databaseException) {
            try {
                this._platforms.createDatabase();
            }
            catch (DatabaseException databaseException2) {
                // empty catch block
            }
        }
        try {
            HAPAddresses hAPAddresses;
            Object object;
            Object object2;
            this._platforms.startTransaction(false);
            List list = aCCProfile.getRemoteAgentPlatformProfiles();
            if (list != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (RemoteAgentPlatformProfile)object2.next();
                    hAPAddresses = (HAPAddresses)this._platforms.findObject(object.getHAPName());
                    if (hAPAddresses != null) {
                        hAPAddresses._addresses_location = object.getAddressesLocation();
                        hAPAddresses._hap_name = object.getHAPName();
                        this._platforms.updateObject(hAPAddresses);
                        continue;
                    }
                    hAPAddresses = new HAPAddresses(object.getHAPName(), null, object.getAddressesLocation());
                    this._platforms.addObject(hAPAddresses);
                }
            }
            object2 = this._platforms.getIDs();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                hAPAddresses = (HAPAddresses)this._platforms.findObject((String)object);
                this.update(hAPAddresses);
            }
            this._platforms.endTransaction();
            this.waitForUpdates();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setupTransports(ACCProfile aCCProfile) throws InitialisationException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Cloneable cloneable;
        CommMultiplexService commMultiplexService = new CommMultiplexService();
        CommMultiplexService commMultiplexService2 = new CommMultiplexService();
        String string = ACC_NAME + '@' + this._hap;
        TreeMap treeMap = new TreeMap(Comparators.STRING_COMPARE);
        Iterator iterator = aCCProfile.getInternalAddresss().iterator();
        while (iterator.hasNext()) {
            InternalAddress internalAddress = (InternalAddress)iterator.next();
            cloneable = new URL(internalAddress.getAddress());
            object4 = (TransportProvider)FIPAOSFactory.getFactoryInstance(class$fipaos$mts$TransportProvider == null ? AgentCommunicationChannel.class$("fipaos.mts.TransportProvider") : class$fipaos$mts$TransportProvider);
            object3 = ((TransportProvider)object4).getInternalMTP(string, (URL)cloneable);
            if (object3 == null) continue;
            this._addresses.addAll(object3.getAddresses());
            object3.initialise(commMultiplexService, null);
            object2 = object3.getProtocols();
            object = object2.iterator();
            while (object.hasNext()) {
                treeMap.put(object.next(), object3);
            }
        }
        cloneable = new TreeMap(Comparators.STRING_COMPARE);
        iterator = aCCProfile.getExternalAddresss().iterator();
        while (iterator.hasNext()) {
            object4 = (ExternalAddress)iterator.next();
            object3 = new URL(object4.getAddress());
            object2 = (TransportProvider)FIPAOSFactory.getFactoryInstance(class$fipaos$mts$TransportProvider == null ? AgentCommunicationChannel.class$("fipaos.mts.TransportProvider") : class$fipaos$mts$TransportProvider);
            object = ((TransportProvider)object2).getExternalMTP(string, (URL)object3);
            if (object == null) continue;
            this._addresses.addAll(object.getAddresses());
            object.initialise(commMultiplexService2, null);
            List list = object.getProtocols();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                cloneable.put(iterator2.next(), object);
            }
        }
        this._internal_stack = new InternalStack();
        object3 = new ServiceStack();
        ((ServiceStack)object3).add(this._internal_stack);
        ((ServiceStack)object3).add(new BufferService());
        commMultiplexService.initialise(treeMap);
        ((ServiceStack)object3).add(commMultiplexService);
        ((ServiceStack)object3).initialise();
        this._external_stack = new ExternalStack();
        object3 = new ServiceStack();
        ((ServiceStack)object3).add(this._external_stack);
        ((ServiceStack)object3).add(new BufferService());
        ((ServiceStack)object3).add(new ParserService());
        commMultiplexService2.initialise((Map)((Object)cloneable));
        ((ServiceStack)object3).add(commMultiplexService2);
        ((ServiceStack)object3).initialise();
    }

    private void publishAddresses(ACCProfile aCCProfile) {
        String string = AgentCommunicationChannel.deparseAddresses(this._hap, this._addresses);
        String string2 = aCCProfile.getLocalAddressesLocation();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void handleInternal(Message message) {
        if (message.getEnvelope().getErrorCode() != 0) {
            this.handleInternalError(message);
            return;
        }
        AgentID agentID = (AgentID)message.getEnvelope().getIntendedReceiver().get(0);
        this.removeHAPAddresses(agentID);
        String string = this.getHAP(agentID);
        if (string.equalsIgnoreCase(this._hap)) {
            if (agentID.getName().startsWith("acc@")) {
                this.handleForACC(message);
            } else {
                this._internal_stack.outgoing(message);
            }
        } else {
            this.addHAPAddresses((AgentID)message.getEnvelope().getIntendedReceiver().get(0));
            Object object = message.getACL().getContentObject();
            if (object != null) {
                if (object instanceof AgentManagementAction) {
                    this.updateMessageContent((AgentManagementAction)object);
                } else if (object instanceof AgentManagementResult) {
                    this.updateMessageContent((AgentManagementResult)object);
                }
            }
            this.addLAPAddresses(message);
            this._external_stack.outgoing(message);
        }
    }

    private void handleExternal(Message message) {
        if (message.getEnvelope().getErrorCode() != 0) {
            this.handleExternalError(message);
            return;
        }
        message.getEnvelope().newSubEnvelope();
        message.getEnvelope().setReceived(new Received(null, (URL)this._addresses.get(0), null, null, new UTCTime()));
        if (message.getEnvelope().getIntendedReceiver().size() > 1) {
            Iterator iterator = message.getEnvelope().getIntendedReceiver().iterator();
            while (iterator.hasNext()) {
                AgentID agentID = (AgentID)iterator.next();
                try {
                    Message message2 = (Message)message.clone();
                    LinkedList<AgentID> linkedList = new LinkedList<AgentID>();
                    linkedList.add(agentID);
                    message2.getEnvelope().setIntendedReceiver(linkedList);
                    this.handleExternal(message2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
        AgentID agentID = (AgentID)message.getEnvelope().getIntendedReceiver().get(0);
        this.removeHAPAddresses(agentID);
        String string = this.getHAP(agentID);
        if (string.equalsIgnoreCase(this._hap)) {
            if (agentID.getName().startsWith("acc@")) {
                this.handleForACC(message);
            } else {
                this._internal_stack.outgoing(message);
            }
        } else {
            this.addHAPAddresses((AgentID)message.getEnvelope().getIntendedReceiver().get(0));
            this._external_stack.outgoing(message);
        }
    }

    /*
     * Loose catch block
     */
    private void handleForACC(Message message) {
        block9: {
            block8: {
                String string = (String)message.getACL().getContentObject();
                HAPAddresses hAPAddresses = AgentCommunicationChannel.parseAddresses(string);
                this._platforms.startTransaction(false);
                if (hAPAddresses == null) break block8;
                this._platforms.addObject(hAPAddresses);
            }
            Object var5_5 = null;
            try {
                this._platforms.endTransaction();
            }
            catch (Throwable throwable) {}
            break block9;
            {
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    try {
                        this._platforms.endTransaction();
                    }
                    catch (Throwable throwable2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    this._platforms.endTransaction();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void handleInternalError(Message message) {
        if (message.getEnvelope().getSlotValue("X-msg-delivery-failure-reason") == null) {
            Envelope envelope = message.getEnvelope();
            envelope.setIntendedReceiver(Arrays.asList(envelope.getSender()));
            envelope.setSlotValue("X-msg-delivery-failure-reason", Service.ERROR_STRING[envelope.getErrorCode()]);
            envelope.setErrorCode(0);
            this.handleInternal(message);
        }
    }

    private void handleExternalError(Message message) {
        if (message.getEnvelope().getSlotValue("X-msg-delivery-failure-reason") == null) {
            Envelope envelope = message.getEnvelope();
            envelope.setIntendedReceiver(Arrays.asList(envelope.getSender()));
            envelope.setSlotValue("X-msg-delivery-failure-reason", Service.ERROR_STRING[envelope.getErrorCode()]);
            envelope.setErrorCode(0);
            this.handleExternal(message);
        }
    }

    private String getHAP(AgentID agentID) {
        String string = agentID.getName();
        int n = string.indexOf(64);
        if (n != -1) {
            String string2 = string.substring(n + 1);
            return string2;
        }
        return "";
    }

    private void addLAPAddresses(Message message) {
        Envelope envelope = message.getEnvelope();
        AgentID agentID = envelope.getSender();
        AgentID agentID2 = message.getACL().getSenderAID();
        String string = this.getHAP(agentID);
        if (string != null && string.equals(this._hap)) {
            this.addURLs(agentID, this._addresses);
            this.addURLs(agentID2, this._addresses);
        }
    }

    private void addHAPAddresses(AgentID agentID) {
        String string = this.getHAP(agentID);
        if (!string.equalsIgnoreCase(this._hap)) {
            HAPAddresses hAPAddresses = null;
            try {
                this._platforms.startTransaction(true);
                hAPAddresses = (HAPAddresses)this._platforms.findObject(string);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    this._platforms.endTransaction();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void updateMessageContent(AgentManagementAction agentManagementAction) {
        if (agentManagementAction.getAction().equalsIgnoreCase("register")) {
            if (agentManagementAction.getDFAgentDescription() != null) {
                AgentID agentID = agentManagementAction.getDFAgentDescription().getAgentID();
                this.addURLs(agentID, this._addresses);
            } else if (agentManagementAction.getAMSAgentDescription() != null) {
                AgentID agentID = agentManagementAction.getAMSAgentDescription().getAgentID();
                this.addURLs(agentID, this._addresses);
            }
        }
    }

    private void updateMessageContent(AgentManagementResult agentManagementResult) {
        String string = agentManagementResult.getAgentManagementAction().getAction();
        if (string.equalsIgnoreCase("get-description")) {
            Object object;
            Cloneable cloneable;
            APTDescription aPTDescription = new APTDescription();
            TreeMap<String, MTPDescription> treeMap = new TreeMap<String, MTPDescription>(Comparators.STRING_COMPARE);
            Iterator iterator = this._addresses.iterator();
            while (iterator.hasNext()) {
                try {
                    cloneable = (URL)iterator.next();
                    object = (TransportProvider)FIPAOSFactory.getFactoryInstance(class$fipaos$mts$TransportProvider == null ? AgentCommunicationChannel.class$("fipaos.mts.TransportProvider") : class$fipaos$mts$TransportProvider);
                    String string2 = ((TransportProvider)object).getMTPProfileName(((URL)cloneable).getProtocol());
                    if (string2 == null) continue;
                    MTPDescription mTPDescription = null;
                    if (treeMap.containsKey(string2)) {
                        mTPDescription = (MTPDescription)treeMap.get(string2);
                    } else {
                        mTPDescription = new MTPDescription();
                        mTPDescription.setMTPName(string2);
                        aPTDescription.addMTPD(mTPDescription);
                        treeMap.put(string2, mTPDescription);
                    }
                    mTPDescription.addAddress((URL)cloneable);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            cloneable = new LinkedList(agentManagementResult.getResultSet());
            object = (APDescription)cloneable.get(0);
            ((APDescription)object).setTransportDescription(aPTDescription);
        } else if (string.equalsIgnoreCase("search")) {
            Set set = agentManagementResult.getResultSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3;
                AgentID agentID;
                DatabaseObject databaseObject;
                Object e = iterator.next();
                if (e instanceof DFAgentDescription) {
                    databaseObject = (DFAgentDescription)e;
                    agentID = ((DFAgentDescription)databaseObject).getAgentID();
                    string3 = agentID.getName();
                    if (string3.substring(string3.indexOf("@") + 1).equals(ACC_NAME.substring(ACC_NAME.indexOf("@") + 1))) continue;
                    this.addURLs(agentID, this._addresses);
                    continue;
                }
                if (!(e instanceof AMSAgentDescription) || (string3 = (agentID = ((AMSAgentDescription)(databaseObject = (AMSAgentDescription)e)).getAgentID()).getName()).substring(string3.indexOf("@") + 1).equals(ACC_NAME.substring(ACC_NAME.indexOf("@") + 1))) continue;
                this.addURLs(agentID, this._addresses);
            }
        }
    }

    private void removeHAPAddresses(AgentID agentID) {
        List list = agentID.getAddresses();
        Iterator iterator = this._addresses.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            list.remove(uRL);
        }
    }

    private void addURLs(AgentID agentID, List list) {
        List list2 = agentID.getAddresses();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            if (list2.contains(uRL)) continue;
            list2.add(uRL.clone());
        }
    }

    private void update(final HAPAddresses hAPAddresses) {
        AgentCommunicationChannel agentCommunicationChannel;
        AgentCommunicationChannel agentCommunicationChannel2 = agentCommunicationChannel = this;
        synchronized (agentCommunicationChannel2) {
            ++this._update_threads;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                AgentCommunicationChannel.this.updateHAPDetails(agentCommunicationChannel, hAPAddresses);
                if (hAPAddresses._hap_addresses != null) {
                    AgentCommunicationChannel.this.sendUpdateDetails(hAPAddresses);
                }
            }
        }, "Remote Platform Address Retreiver Thread");
        thread.start();
    }

    private void sendUpdateDetails(HAPAddresses hAPAddresses) {
        if (PROPOGATE_ADDRS) {
            AgentID agentID = new AgentID();
            agentID.setName("acc@" + hAPAddresses._hap_name);
            agentID.setAddresses(hAPAddresses._hap_addresses);
            ACL aCL = new ACL();
            aCL.setPerformative("inform");
            aCL.setReceiverAID(agentID);
            aCL.setContentObject(AgentCommunicationChannel.deparseAddresses(this._hap, this._addresses));
            this._external_stack.outgoing(new Message(aCL));
        }
    }

    private void updateHAPDetails(Object object, HAPAddresses hAPAddresses) {
        Object object2;
        boolean bl = true;
        if (BOOTSTRAP_FILES && (object2 = DocumentRetriever.getDoc(hAPAddresses._addresses_location)) != null) {
            AgentCommunicationChannel.parseAddresses((String)object2, hAPAddresses);
            bl = false;
            try {
                this._platforms.startTransaction(false);
                this._platforms.addObject(hAPAddresses);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    this._platforms.endTransaction();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (bl) {
            try {
                object2 = new URL(hAPAddresses._addresses_location);
                hAPAddresses._hap_addresses = new LinkedList();
                hAPAddresses._hap_addresses.add(object2);
                try {
                    this._platforms.startTransaction(false);
                    this._platforms.addObject(hAPAddresses);
                }
                catch (Throwable throwable) {
                    Object var10_17 = null;
                    try {
                        this._platforms.endTransaction();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        object2 = object;
        synchronized (object2) {
            --this._update_threads;
            object.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForUpdates() {
        AgentCommunicationChannel agentCommunicationChannel = this;
        synchronized (agentCommunicationChannel) {
            while (this._update_threads > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    private static void parseAddresses(String string, HAPAddresses hAPAddresses) {
        HAPAddresses hAPAddresses2 = AgentCommunicationChannel.parseAddresses(string);
        if (hAPAddresses2 != null) {
            hAPAddresses._hap_addresses = hAPAddresses2._hap_addresses;
        }
    }

    private static HAPAddresses parseAddresses(String string) {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        HAPAddresses hAPAddresses = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",\r\n", false);
        String string2 = stringTokenizer.nextToken();
        if (string2 != null) {
            if (string2.startsWith("IOR:")) {
                hAPAddresses = new HAPAddresses(null, linkedList, null);
                linkedList.add(new URL(string2));
            } else {
                hAPAddresses = new HAPAddresses(string2, linkedList, null);
            }
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.trim().equals("")) continue;
                    linkedList.add(new URL(string3));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return hAPAddresses;
    }

    private static String deparseAddresses(String string, List list) {
        StringBuffer stringBuffer = new StringBuffer();
        if (FIPAOS_BOOTSTRAP) {
            stringBuffer.append(string);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            if (FIPAOS_BOOTSTRAP) {
                if (uRL == null) continue;
                stringBuffer.append(',');
                stringBuffer.append(uRL.toString());
                continue;
            }
            if (!uRL.getProtocol().equals("IOR")) continue;
            stringBuffer.append(uRL.toString());
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Throwable {
        DataMapper dataMapper;
        PlatformProfile platformProfile;
        String string;
        String string2 = System.getProperty("fipaos.profile.platform");
        String string3 = DocumentRetriever.getDoc(string2);
        if (string3 == null) {
            System.err.println("Error loading PlatformProfile, aborting...");
            System.exit(-10);
        }
        if ((string3 = DocumentRetriever.getDoc(string = new File((platformProfile = (PlatformProfile)(dataMapper = DataMapperFactory.createDataMapper(string2, string3, null)).unmarshall(string3)).getProfileDirectory(), "acc.profile").getCanonicalPath())) == null) {
            System.err.println("Error loading ACCProfile, aborting...");
            System.exit(-10);
        }
        dataMapper = DataMapperFactory.createDataMapper(string, string3, null);
        ACCProfile aCCProfile = (ACCProfile)dataMapper.unmarshall(string3);
        new AgentCommunicationChannel(platformProfile, aCCProfile);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ExternalStack
    implements PreParserService {
        private PreParserService _next;

        private ExternalStack() {
        }

        public void shutdown() {
            this._next.shutdown();
        }

        public void initialise(PreParserService preParserService, PreParserService preParserService2) {
            this._next = preParserService2;
        }

        public void outgoing(Message message) {
            this._next.outgoing(message);
        }

        public void incoming(Message message) {
            AgentCommunicationChannel.this.handleExternal(message);
        }
    }

    private class InternalStack
    implements PreParserService {
        private PreParserService _next;

        private InternalStack() {
        }

        public void shutdown() {
            this._next.shutdown();
        }

        public void initialise(PreParserService preParserService, PreParserService preParserService2) {
            this._next = preParserService2;
        }

        public void outgoing(Message message) {
            this._next.outgoing(message);
        }

        public void incoming(Message message) {
            AgentCommunicationChannel.this.handleInternal(message);
        }
    }

    private static class HAPAddresses
    implements DatabaseObject,
    Serializable {
        public String _addresses_location;
        public String _hap_name;
        public List _hap_addresses = new LinkedList();

        public HAPAddresses(String string, List list, String string2) {
            this._addresses_location = string2;
            this._hap_name = string;
            this._hap_addresses = list;
        }

        public String getObjectID() {
            return this._hap_name;
        }
    }
}

