/*
 * Decompiled with CFR 0.152.
 */
package fipaos.mts.service;

import fipaos.mts.Message;
import fipaos.mts.service.PostParserService;
import fipaos.mts.service.PreParserService;
import fipaos.mts.service.Service;
import fipaos.ont.fipa.fipaman.Envelope;
import fipaos.util.FIFOQueue;
import fipaos.util.Monitor;
import fipaos.util.MonitorListener;
import fipaos.util.Queue;

public class BufferService
implements PreParserService,
PostParserService {
    private static final int INCOMING = 0;
    private static final int OUTGOING = 1;
    private static final int PREPARSER = 0;
    private static final int POSTPARSER = 2;
    private Queue[] _queues = new Queue[4];
    private Monitor[] _monitors = new Monitor[4];
    private Service[] _targets = new Service[4];
    private boolean _shutdown = false;

    public int getBufferSize() {
        return -1;
    }

    public void setLimit(int n) {
    }

    public String getIdentifier() {
        return "bufferservice";
    }

    public void halt() {
    }

    public void restart() {
    }

    public synchronized void shutdown() {
        this._shutdown = true;
        int n = 0;
        while (n < this._monitors.length) {
            if (this._monitors[n] != null) {
                this._monitors[n].halt();
                this._monitors[n] = null;
            }
            ++n;
        }
        this._monitors = null;
        int n2 = 0;
        while (n2 < this._queues.length) {
            if (this._queues[n2] != null) {
                this._queues[n2].flush();
                this._queues[n2] = null;
            }
            ++n2;
        }
        this._queues = null;
        int n3 = 0;
        while (n3 < this._targets.length) {
            if (this._targets[n3] != null && n3 % 2 == 1) {
                this._targets[n3].shutdown();
                this._targets[n3] = null;
            }
            ++n3;
        }
        this._targets = null;
    }

    public synchronized void outgoing(Envelope envelope, byte[] byArray) {
        if (this._shutdown) {
            return;
        }
        this.getQueue(3).addItem(new Object[]{envelope, byArray});
    }

    public synchronized void incoming(Envelope envelope, byte[] byArray) {
        if (this._shutdown) {
            return;
        }
        this.getQueue(2).addItem(new Object[]{envelope, byArray});
    }

    public void initialise(PostParserService postParserService, PostParserService postParserService2) {
        this._targets[2] = postParserService;
        this._targets[3] = postParserService2;
    }

    public synchronized void incoming(Message message) {
        if (this._shutdown) {
            return;
        }
        this.getQueue(0).addItem(message);
    }

    public synchronized void outgoing(Message message) {
        if (this._shutdown) {
            return;
        }
        this.getQueue(1).addItem(message);
    }

    public void initialise(PreParserService preParserService, PreParserService preParserService2) {
        this._targets[0] = preParserService;
        this._targets[1] = preParserService2;
    }

    private synchronized Queue getQueue(int n) {
        if (this._queues[n] == null) {
            this._queues[n] = new FIFOQueue();
            Service service = this._targets[n];
            this._monitors[n] = n % 2 == 0 ? new Monitor(this._queues[n], new IncomingMonitor(service)) : new Monitor(this._queues[n], new OutgoingMonitor(service));
        }
        return this._queues[n];
    }

    private class OutgoingMonitor
    implements MonitorListener {
        Object _target;

        public OutgoingMonitor(Object object) {
            this._target = object;
        }

        public void monitorUpdate(Object object) {
            if (this._target instanceof PreParserService) {
                PreParserService preParserService = (PreParserService)this._target;
                try {
                    preParserService.outgoing((Message)object);
                }
                catch (Throwable throwable) {}
            } else if (this._target instanceof PostParserService) {
                PostParserService postParserService = (PostParserService)this._target;
                try {
                    Object[] objectArray = (Object[])object;
                    postParserService.outgoing((Envelope)objectArray[0], (byte[])objectArray[1]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private class IncomingMonitor
    implements MonitorListener {
        Object _target;

        public IncomingMonitor(Object object) {
            this._target = object;
        }

        public void monitorUpdate(Object object) {
            if (this._target instanceof PreParserService) {
                PreParserService preParserService = (PreParserService)this._target;
                try {
                    preParserService.incoming((Message)object);
                }
                catch (Throwable throwable) {}
            } else if (this._target instanceof PostParserService) {
                PostParserService postParserService = (PostParserService)this._target;
                try {
                    Object[] objectArray = (Object[])object;
                    postParserService.incoming((Envelope)objectArray[0], (byte[])objectArray[1]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

