/*
 * Decompiled with CFR 0.152.
 */
package fipaos.ont.fipa;

import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.parser.ParserException;
import fipaos.parser.acl.string.Parser;
import fipaos.util.Comparators;
import fipaos.util.Serialize;
import fipaos.util.StringParser;
import fipaos.util.UTCContainer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ACL
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1234567890123456L;
    public static final int STRINGLITERAL_ENCODING = 1;
    public static final int BYTELENGTH_ENCODING = 2;
    private static final String[] RESERVED_SLOT_NAME_ARRAY = new String[]{":content", "Content-encoding", "Content-length", ":sender", ":receiver", ":reply-to", ":reply-by", ":reply-with", ":language", ":ontology", ":protocol", ":conversation-id", ":in-reply-to"};
    public static final List RESERVED_SLOT_NAMES = Arrays.asList(RESERVED_SLOT_NAME_ARRAY);
    public static final String FIPA00070 = "fipa.acl.rep.string.std";
    public static final String FIPA00069 = "fipa.acl.rep.bitefficient.std";
    public static final String FIPA00071 = "fipa.acl.rep.xml.std";
    public static final String FIPA_OS_SERIALIZATION = "fipaos.acl.rep.java.serialization";
    private String _content_encoding = null;
    private AgentID _sender;
    private List _receivers;
    private List _reply_to;
    private Object _content;
    private String _language;
    private String _ontology;
    private String _protocol;
    private String _conversation_id;
    private String _in_reply_to;
    private String _reply_with;
    private UTCContainer _reply_by;
    private String _performative;
    private int _encoding = 2;
    private boolean _encoded = false;
    private boolean _brackets_stripped = true;
    private Map _user_slots = new TreeMap(Comparators.STRING_COMPARE);

    public ACL(ACL aCL) {
        this();
        Iterator iterator;
        this._conversation_id = aCL._conversation_id;
        this._protocol = aCL._protocol;
        this._ontology = aCL._ontology;
        this._language = aCL._language;
        this._content = aCL._content;
        this._in_reply_to = aCL._in_reply_to;
        this._performative = aCL._performative;
        this._reply_with = aCL._reply_with;
        this._encoding = aCL._encoding;
        this._encoded = aCL._encoded;
        this._brackets_stripped = aCL._brackets_stripped;
        this._user_slots.putAll(aCL._user_slots);
        if (aCL._sender != null) {
            this._sender = (AgentID)aCL._sender.clone();
        }
        if (aCL._reply_by != null) {
            this._reply_by = (UTCContainer)aCL._reply_by.clone();
        }
        if (aCL._reply_to != null) {
            this._reply_to = new LinkedList();
            iterator = aCL._reply_to.iterator();
            while (iterator.hasNext()) {
                this._reply_to.add(((AgentID)iterator.next()).clone());
            }
        }
        if (aCL._receivers != null) {
            this._receivers = new LinkedList();
            iterator = aCL._receivers.iterator();
            while (iterator.hasNext()) {
                this._receivers.add(((AgentID)iterator.next()).clone());
            }
        }
    }

    public Object clone() {
        try {
            Iterator iterator;
            ACL aCL = (ACL)super.clone();
            if (this._sender != null) {
                aCL._sender = (AgentID)this._sender.clone();
            }
            if (this._reply_by != null) {
                aCL._reply_by = (UTCContainer)this._reply_by.clone();
            }
            if (this._reply_to != null) {
                aCL._reply_to = new LinkedList();
                iterator = this._reply_to.iterator();
                while (iterator.hasNext()) {
                    aCL._reply_to.add(((AgentID)iterator.next()).clone());
                }
            }
            if (this._receivers != null) {
                aCL._receivers = new LinkedList();
                iterator = this._receivers.iterator();
                while (iterator.hasNext()) {
                    aCL._receivers.add(((AgentID)iterator.next()).clone());
                }
            }
            aCL._user_slots.putAll(this._user_slots);
            if (!(this._content instanceof Cloneable) && !(this._content instanceof String) && this._content instanceof Serializable) {
                aCL._content = Serialize.duplicate(this._content);
            }
            return aCL;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public ACL(String string) throws ParserException {
        this();
        ACL aCL = null;
        aCL = Parser.parse(string.getBytes());
        this._sender = aCL._sender;
        this._reply_by = aCL._reply_by;
        this._content = aCL._content;
        this._conversation_id = aCL._conversation_id;
        this._in_reply_to = aCL._in_reply_to;
        this._language = aCL._language;
        this._ontology = aCL._ontology;
        this._performative = aCL._performative;
        this._protocol = aCL._protocol;
        this._reply_with = aCL._reply_with;
        this._receivers = aCL._receivers;
        this._reply_to = aCL._reply_to;
        this._encoded = aCL._encoded;
        this._encoding = aCL._encoding;
        this._content_encoding = aCL._content_encoding;
        this._brackets_stripped = aCL._brackets_stripped;
    }

    public ACL() {
        this._receivers = new LinkedList();
        this._reply_to = new LinkedList();
    }

    public void setSenderAID(AgentID agentID) {
        this._sender = agentID;
    }

    public AgentID getSenderAID() {
        return this._sender;
    }

    public void addReceiverAID(AgentID agentID) {
        this._receivers.add(agentID);
    }

    public void setReceiverAID(AgentID agentID) {
        this._receivers.clear();
        if (agentID != null) {
            this._receivers.add(agentID);
        }
    }

    public void setReceiverAIDs(List list) {
        this._receivers.clear();
        if (list != null) {
            this._receivers.addAll(list);
        }
    }

    public AgentID getReceiverAID() {
        if (this._receivers != null && this._receivers.size() > 0) {
            return (AgentID)this._receivers.get(0);
        }
        return null;
    }

    public List getReceiverAIDs() {
        return new LinkedList(this._receivers);
    }

    public void addReplyToAID(AgentID agentID) {
        this._reply_to.add(agentID);
    }

    public void setReplyToAIDs(List list) {
        this._reply_to.clear();
        if (list != null) {
            this._reply_to.addAll(list);
        }
    }

    public List getReplyToAIDs() {
        return new LinkedList(this._reply_to);
    }

    public void setContentObjectACLParser(String string) {
        this._brackets_stripped = false;
        this._content = string;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            this._encoded = true;
            this._encoding = 1;
        } else if (string.startsWith("#")) {
            this._encoded = true;
            this._encoding = 2;
        } else {
            this._encoded = false;
            this._encoding = 1;
        }
    }

    public void setContentObject(Object object) {
        this._content = object;
        if (this._content instanceof String) {
            String string = (String)object;
            if (string.startsWith("\"") && string.endsWith("\"")) {
                this._encoded = true;
                this._encoding = 1;
            } else if (string.startsWith("#")) {
                this._encoded = true;
                this._encoding = 2;
            } else {
                this._encoded = false;
                this._encoding = 1;
            }
        } else {
            this._encoded = false;
            this._encoding = 2;
        }
        this._brackets_stripped = true;
    }

    public Object getContentObject() {
        return this.getContentObject(true);
    }

    public Object getContentObject(boolean bl) {
        String string = null;
        if (this._content instanceof String && bl) {
            string = (String)this._content;
            string = string.trim();
            if (this._encoded) {
                switch (this._encoding) {
                    case 2: {
                        string = ACL.byteLengthDecode(string);
                        break;
                    }
                    case 1: {
                        string = ACL.stringLiteralDecode(string);
                    }
                }
            }
            if (this._language != null && this._language.toLowerCase().startsWith("fipa-sl") && !this._brackets_stripped) {
                string = StringParser.trimBrackets(string);
            }
            return string;
        }
        return this._content;
    }

    public void setContentObject(Object object, int n) {
        this.setContentObject(object);
        this._encoding = n;
        this._encoded = false;
        this._brackets_stripped = true;
    }

    public boolean isBracketsStripped() {
        return this._brackets_stripped;
    }

    public boolean isEncoded() {
        return this._encoded;
    }

    public int getEncoding() {
        return this._encoding;
    }

    public void setContentEncoding(String string) {
        this._content_encoding = string;
    }

    public String getContentEncoding() {
        return this._content_encoding;
    }

    public void setConversationID(String string) {
        this._conversation_id = string;
    }

    public String getConversationID() {
        return this._conversation_id;
    }

    public void setInReplyTo(String string) {
        this._in_reply_to = string;
    }

    public String getInReplyTo() {
        return this._in_reply_to;
    }

    public void setLanguage(String string) {
        this._language = string;
    }

    public String getLanguage() {
        return this._language;
    }

    public void setOntology(String string) {
        this._ontology = string;
    }

    public String getOntology() {
        return this._ontology;
    }

    public void setPerformative(String string) {
        this._performative = string;
    }

    public String getPerformative() {
        return this._performative;
    }

    public void setProtocol(String string) {
        this._protocol = string;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setReplyByUTC(UTCContainer uTCContainer) {
        this._reply_by = uTCContainer;
    }

    public UTCContainer getReplyByUTC() {
        return this._reply_by;
    }

    public void setReplyWith(String string) {
        this._reply_with = string;
    }

    public String getReplyWith() {
        return this._reply_with;
    }

    public String getUserSlot(String string) {
        return (String)this._user_slots.get(string);
    }

    public boolean setUserSlot(String string, String string2) {
        if (RESERVED_SLOT_NAMES.contains(':' + string)) {
            return false;
        }
        this._user_slots.put(string, string2);
        return true;
    }

    public Set getUserSlots() {
        TreeSet treeSet = new TreeSet(Comparators.STRING_COMPARE);
        treeSet.addAll(this._user_slots.keySet());
        return treeSet;
    }

    public String toString() {
        return new String(Parser.deparse(this));
    }

    public static String stringLiteralEncode(String string) {
        return Parser.stringLiteralEncode(string);
    }

    public static String stringLiteralDecode(String string) {
        return Parser.stringLiteralDecode(string);
    }

    public static String byteLengthEncode(String string) {
        return Parser.byteLengthEncode(string);
    }

    public static String byteLengthDecode(String string) {
        return Parser.byteLengthDecode(string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public static void main(String[] stringArray) throws Throwable {
        ACL aCL = new ACL();
        aCL.setPerformative("inform");
        aCL.setUserSlot("session-id", "11232139479234792347");
        String string = new String(Parser.deparse(aCL));
        ACL aCL2 = Parser.parse(string.getBytes());
    }
}

