/*
 * Decompiled with CFR 0.152.
 */
package fipaos.ont.fipa.fipaman;

import fipaos.agent.conversation.content.Content;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.parser.ParserException;
import fipaos.parser.sl.ParseException;
import fipaos.parser.sl.SLParser;
import fipaos.skill.db.DatabaseObject;
import java.io.Serializable;
import java.util.List;

public class AMSAgentDescription
implements DatabaseObject,
Serializable {
    private AgentID _agent_id = null;
    private String _state = null;
    private String _ownership = null;

    public AMSAgentDescription(String string) throws ParserException {
        try {
            this.parse(SLParser.parseTerm(string));
        }
        catch (ParseException parseException) {
            throw new ParserException(parseException.getMessage());
        }
    }

    public AMSAgentDescription(Content content) throws ParserException {
        this.parse(content);
    }

    public AMSAgentDescription() {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("ams-agent-description");
        stringBuffer.append("\n");
        if (this._agent_id != null) {
            this.addKeywordValuePair(stringBuffer, ":name", this._agent_id.toString());
        }
        if (this._ownership != null) {
            this.addKeywordValuePair(stringBuffer, ":ownership", this._ownership);
        }
        if (this._state != null) {
            this.addKeywordValuePair(stringBuffer, ":state", this._state);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void addKeywordValuePair(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append("\n");
    }

    public String getObjectID() {
        return this._agent_id.getName();
    }

    public AgentID getAgentID() {
        return this._agent_id;
    }

    public void setAgentID(AgentID agentID) {
        this._agent_id = agentID;
    }

    public String getAgentName() {
        return this._agent_id.getName();
    }

    public String getState() {
        return this._state;
    }

    public void setState(String string) {
        this._state = string;
    }

    public String getOwnership() {
        return this._ownership;
    }

    public void setOwnership(String string) {
        this._ownership = string;
    }

    public boolean canRegister() {
        return this._agent_id != null;
    }

    public boolean canModify() {
        return this._agent_id != null;
    }

    public boolean canDeregister() {
        return this._agent_id != null;
    }

    public boolean hasAgentID() {
        return this._agent_id != null;
    }

    public boolean hasState() {
        return this._state != null;
    }

    public static void main(String[] stringArray) {
        String string = "(ams-agent-description \n:name (agent-identifier :name df@phard1f0.europe.nortel.com :addresses (sequence \nfipaos-rmi://localhost:3000/df ) ) \n:ownership fipaos \n:state active \n)";
        try {
            AMSAgentDescription aMSAgentDescription = new AMSAgentDescription(string);
            aMSAgentDescription = new AMSAgentDescription();
            aMSAgentDescription.setAgentID(new AgentID("(agent-identifier :name dummy@foo.com :addresses (sequence iiop://foo.com/acc ))"));
            aMSAgentDescription.setOwnership("ME");
            aMSAgentDescription.setState("active");
        }
        catch (ParserException parserException) {
            parserException.printStackTrace();
        }
    }

    private void parse(Content content) throws IllegalArgumentException, ParserException {
        if (content != null) {
            boolean bl = false;
            Content content2 = (Content)content.getAttribute("functionalTerm");
            if (content2 == null || !content2.getAttribute("functionalOperator").equals("ams-agent-description")) {
                throw new IllegalArgumentException("Content is not a AMS-AGENT-DESCRIPTION");
            }
            if (content2.getAttribute("parameter") instanceof List) {
                List list = (List)content2.getAttribute("parameter");
                int n = 0;
                while (n < list.size()) {
                    Content content3 = (Content)list.get(n);
                    if (content3.getName() != "parameter") {
                        throw new IllegalArgumentException("Illegal AMS-AGENT-DESCRIPTION FORMAT");
                    }
                    this.parse2(content3);
                    ++n;
                }
            } else {
                Content content4 = (Content)content2.getAttribute("parameter");
                this.parse2(content4);
            }
        }
    }

    private void parse2(Content content) throws IllegalArgumentException, ParserException {
        if (content != null) {
            String string = (String)content.getAttribute("parameterName");
            String string2 = (String)((Content)content.getAttribute("parameterValue")).getAttribute("formattedString");
            if (string.equals(":name")) {
                this._agent_id = new AgentID(string2);
            } else if (string.equals(":ownership")) {
                this._ownership = string2;
            } else if (string.equals(":state")) {
                this._state = string2;
            }
        }
    }
}

