/*
 * Decompiled with CFR 0.152.
 */
package fipaos.ont.fipa.fipaman;

import fipaos.agent.conversation.content.Content;
import fipaos.ont.fipa.fipaman.APTDescription;
import fipaos.ont.fipa.fipaman.MTPDescription;
import fipaos.parser.ParserException;
import fipaos.parser.sl.ParseException;
import fipaos.parser.sl.SLParser;
import fipaos.util.URL;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class APDescription
implements Serializable {
    private String _name;
    private Boolean _dynamic;
    private Boolean _mobility;
    private APTDescription _transport_description;

    public APDescription() {
        this._transport_description = new APTDescription();
    }

    public APDescription(String string) throws ParserException {
        try {
            this.parse(SLParser.parseTerm(string));
        }
        catch (ParseException parseException) {
            throw new ParserException(parseException.getMessage());
        }
    }

    public APDescription(Content content) throws ParserException {
        this.parse(content);
    }

    private void parse(Content content) throws IllegalArgumentException, ParserException {
        if (content != null) {
            boolean bl = false;
            Content content2 = (Content)content.getAttribute("functionalTerm");
            if (content2 == null || !content2.getAttribute("functionalOperator").equals("ap-description")) {
                throw new IllegalArgumentException("Content is not a AP-DESCRIPTION");
            }
            Object object = content2.getAttribute("parameter");
            if (object instanceof List) {
                int n = 0;
                while (n < ((List)object).size()) {
                    Content content3 = (Content)((List)object).get(n);
                    if (content3.getName() != "parameter") {
                        throw new IllegalArgumentException("Illegal AP-DESCRIPTION FORMAT");
                    }
                    String string = (String)content3.getAttribute("parameterName");
                    String string2 = (String)((Content)content3.getAttribute("parameterValue")).getAttribute("formattedString");
                    if (string.equals(":name")) {
                        bl = true;
                        this._name = string2;
                    } else if (string.equals(":dynamic")) {
                        this._dynamic = new Boolean(string2);
                    } else if (string.equals(":mobility")) {
                        this._mobility = new Boolean(string2);
                    } else if (string.equals(":transport-profile")) {
                        this._transport_description = new APTDescription(string2);
                    }
                    ++n;
                }
            } else {
                String string = (String)((Content)object).getAttribute("parameterName");
                String string3 = (String)((Content)((Content)object).getAttribute("parameterValue")).getAttribute("formattedString");
                if (string.equals(":name")) {
                    bl = true;
                    this._name = string3;
                }
            }
            if (!bl) {
                throw new IllegalArgumentException("AP Description must contain name attribute");
            }
        }
    }

    private void addKeywordValuePair(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append("\n");
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setDynamic(Boolean bl) {
        this._dynamic = bl;
    }

    public void setMobility(Boolean bl) {
        this._mobility = bl;
    }

    public void setMTPDs(Set set) {
        this._transport_description.setMTPSSet(set);
    }

    public void setTransportDescription(APTDescription aPTDescription) {
        this._transport_description = aPTDescription;
    }

    public String getName() {
        return this._name;
    }

    public Boolean getDynamic() {
        return this._dynamic;
    }

    public Boolean getMobility() {
        return this._mobility;
    }

    public Set getMTPDs() {
        return this._transport_description.getMTPSSet();
    }

    public APTDescription getTransportDescription() {
        return this._transport_description;
    }

    public boolean addMTPD(MTPDescription mTPDescription) {
        return this._transport_description.addMTPD(mTPDescription);
    }

    public boolean removeMTPD(MTPDescription mTPDescription) {
        return this._transport_description.removeMTPD(mTPDescription);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("ap-description");
        stringBuffer.append("\n");
        if (this._name != null) {
            this.addKeywordValuePair(stringBuffer, ":name", this._name);
        }
        if (this._dynamic != null) {
            this.addKeywordValuePair(stringBuffer, ":dynamic", this._dynamic.toString());
        }
        if (this._mobility != null) {
            this.addKeywordValuePair(stringBuffer, ":mobility", this._mobility.toString());
        }
        if (this._transport_description != null) {
            this.addKeywordValuePair(stringBuffer, ":transport-profile", this._transport_description.toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = "(ap-description :name platform_description :mobility false :dynamic true :transport-profile (ap-transport-description  :available-mtps (set (mtp-description :profile fipa-alpha :mtp-name fipa-iiop-std :addresses (set iiop://monitor.co.uk:9000/acc http://www.agentworld.co.uk:9000 ) ) ) ) ) ";
        try {
            APDescription aPDescription = new APDescription(string);
            aPDescription = new APDescription();
            aPDescription.setName("Local");
            aPDescription.setDynamic(new Boolean("true"));
            APTDescription aPTDescription = new APTDescription();
            MTPDescription[] mTPDescriptionArray = new MTPDescription[1];
            MTPDescription mTPDescription = new MTPDescription();
            mTPDescription.setProfile("Test Profile");
            LinkedList<URL> linkedList = new LinkedList<URL>();
            linkedList.add(new URL("http://www.foo.com/acc"));
            linkedList.add(new URL("iiop://www.kso.com/ams"));
            mTPDescription.setAddresses(linkedList);
            mTPDescriptionArray[0] = mTPDescription;
            aPTDescription.setMTPSSet(mTPDescriptionArray);
            aPDescription.setTransportDescription(aPTDescription);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

