/*
 * Decompiled with CFR 0.152.
 */
package fipaos.ont.fipa.fipaman;

import fipaos.agent.conversation.content.Content;
import fipaos.ont.fipa.fipaman.AMSAgentDescription;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.ont.fipa.fipaman.SearchConstraints;
import fipaos.parser.ParserException;
import fipaos.parser.sl.ParseException;
import fipaos.parser.sl.SLParser;
import java.io.Serializable;
import java.util.List;

public class AgentManagementAction
implements Serializable {
    private String _action;
    private DFAgentDescription _df_description;
    private AMSAgentDescription _ams_description;
    private AgentID _agent;
    private SearchConstraints _constraints;

    public AgentManagementAction(Content content) throws ParserException {
        try {
            this.parse(content);
        }
        catch (Throwable throwable) {
            throw new ParserException(throwable.toString());
        }
    }

    public AgentManagementAction(String string) throws ParserException {
        try {
            this.parse(SLParser.parseActionExpression(string));
        }
        catch (ParseException parseException) {
            throw new ParserException(parseException.getMessage());
        }
    }

    public AgentManagementAction() {
    }

    public String getAction() {
        return this._action;
    }

    public void setAction(String string) {
        if (!(string.equals("register") || string.equals("deregister") || string.equals("modify") || string.equals("search") || string.equals("get-description"))) {
            throw new IllegalArgumentException("no such action value of: " + string);
        }
        this._action = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("action");
        stringBuffer.append("\n");
        if (this._agent != null) {
            stringBuffer.append(this._agent.toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("(");
        stringBuffer.append(this._action);
        stringBuffer.append("\n");
        if (this._df_description != null) {
            stringBuffer.append(this._df_description.toString());
            stringBuffer.append("\n");
        } else if (this._ams_description != null) {
            stringBuffer.append(this._ams_description.toString());
            stringBuffer.append("\n");
        }
        if (this._constraints != null) {
            stringBuffer.append(this._constraints.toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append(")");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public DFAgentDescription getDFAgentDescription() {
        return this._df_description;
    }

    public void setDFAgentDescription(DFAgentDescription dFAgentDescription) {
        this._df_description = dFAgentDescription;
    }

    public AMSAgentDescription getAMSAgentDescription() {
        return this._ams_description;
    }

    public void setAMSAgentDescription(AMSAgentDescription aMSAgentDescription) {
        this._ams_description = aMSAgentDescription;
    }

    public SearchConstraints getSearchConstraints() {
        return this._constraints;
    }

    public void setSearchConstraints(SearchConstraints searchConstraints) {
        this._constraints = searchConstraints;
    }

    public void setAgentID(AgentID agentID) {
        this._agent = agentID;
    }

    private void addKeywordValuePair(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append("\n");
    }

    private String getFunctionalOperator(Content content) {
        Content content2 = (Content)content.getAttribute("functionalTerm");
        if (content2 != null) {
            return (String)content2.getAttribute("functionalOperator");
        }
        return null;
    }

    private Object getTerms(Content content) {
        Content content2 = (Content)content.getAttribute("functionalTerm");
        if (content2 != null) {
            return content2.getAttribute("term");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(Content content) throws IllegalArgumentException, ParserException {
        if (content == null) return;
        Content content2 = (Content)content.getAttribute("agent");
        Content content3 = (Content)content.getAttribute("term");
        if (!content.getAttribute("actionExpressionOperator").equals("action") || content2 == null || content3 == null) throw new IllegalArgumentException("Content is not a ACTION-EXPRESSION-DESCRIPTION");
        this._agent = new AgentID((String)content2.getAttribute("formattedString"));
        String string = this.getFunctionalOperator(content3);
        Object object = this.getTerms(content3);
        if (string == null) throw new IllegalArgumentException("Content is not a ACTION-EXPRESSION-DESCRIPTION");
        this._action = string;
        if (string.equals("register") || string.equals("deregister") || string.equals("modify")) {
            String string2 = this.getFunctionalOperator((Content)object);
            if (string2.equals("ams-agent-description")) {
                this._ams_description = new AMSAgentDescription((Content)object);
                return;
            } else {
                if (!string2.equals("df-agent-description")) return;
                this._df_description = new DFAgentDescription((Content)object);
            }
            return;
        } else if (string.equals("search")) {
            if (object instanceof List) {
                Content content4 = (Content)((List)object).get(0);
                String string3 = this.getFunctionalOperator(content4);
                if (string3.equals("ams-agent-description")) {
                    this._ams_description = new AMSAgentDescription(content4);
                } else if (string3.equals("df-agent-description")) {
                    this._df_description = new DFAgentDescription(content4);
                }
                Content content5 = (Content)((List)object).get(1);
                this._constraints = new SearchConstraints(content5);
                return;
            } else {
                if (!(object instanceof Content)) return;
                String string4 = this.getFunctionalOperator((Content)object);
                if (string4.equals("ams-agent-description")) {
                    this._ams_description = new AMSAgentDescription((Content)object);
                    return;
                } else {
                    if (!string4.equals("df-agent-description")) return;
                    this._df_description = new DFAgentDescription((Content)object);
                }
            }
            return;
        } else if (!string.equals("get-description")) return;
    }

    public static void main(String[] stringArray) {
        AgentManagementAction agentManagementAction;
        String string = "(action (agent-identifier :name CameraProxy@foo.com :addresses (sequence iiop://foo.com/acc)) (register (ams-agent-description :name (agent-identifier :name CameraProxy@foo.com :addresses (sequence iiop://foo.com/acc)) :state active )))";
        try {
            agentManagementAction = new AgentManagementAction(string);
        }
        catch (ParserException parserException) {
            parserException.printStackTrace();
        }
        string = "(action (agent-identifier :name df@phard1f0.europe.nortel.com ) (register (df-agent-description :name (agent-identifier :name df2@phard1f0.europe.nortel.com :addresses (sequence fipaos-rmi://localhost:3000/df2 ) ) :services (set (service-description :type fipa-df )) ))) ";
        try {
            agentManagementAction = new AgentManagementAction(string);
        }
        catch (ParserException parserException) {
            parserException.printStackTrace();
        }
        string = "(action (agent-identifier :name CameraProxy@foo.com :addresses (sequence iiop://foo.com/acc)) (search (df-agent-description :name (agent-identifier :name CameraProxy@foo.com :addresses (sequence iiop://foo.com/acc)) :ontology (set meeting-scheduler) :language (set FIPA-L0 KIF)) (search-constraints :max-depth 2)))";
        try {
            agentManagementAction = new AgentManagementAction(string);
            agentManagementAction = new AgentManagementAction();
            agentManagementAction.setAction("register");
            agentManagementAction.setAgentID(new AgentID("(agent-identifier :name CameraProxy@foo.com :addresses (sequence iiop://foo.com/acc))"));
            agentManagementAction.setAMSAgentDescription(new AMSAgentDescription("(ams-agent-description :name (agent-identifier :name CameraProxy@foo.com :addresses (sequence iiop://foo.com/acc)) :state active )"));
            agentManagementAction.setSearchConstraints(new SearchConstraints("(search-constraints :max-depth 20 :max-results 100)"));
        }
        catch (ParserException parserException) {
            parserException.printStackTrace();
        }
    }
}

