/*
 * Decompiled with CFR 0.152.
 */
package fipaos.ont.fipa.fipaman;

import fipaos.agent.conversation.content.Content;
import fipaos.ont.fipa.fipaman.AMSAgentDescription;
import fipaos.ont.fipa.fipaman.AgentManagementAction;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.parser.ParserException;
import fipaos.parser.sl.SLParser;
import fipaos.util.Comparators;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class AgentManagementResult
implements Serializable {
    private AgentManagementAction _action;
    private Set _results;

    public AgentManagementResult() {
        this._results = Collections.synchronizedSet(new TreeSet(Comparators.OBJECT_COMPARE));
    }

    public AgentManagementResult(String string) throws ParserException {
        try {
            this._results = Collections.synchronizedSet(new TreeSet(Comparators.OBJECT_COMPARE));
            this.parse(SLParser.parseAtomicFormula(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new ParserException(throwable.getMessage());
        }
    }

    public AgentManagementResult(Content content) throws ParserException {
        try {
            this._results = Collections.synchronizedSet(new TreeSet(Comparators.OBJECT_COMPARE));
            this.parse(content);
        }
        catch (Throwable throwable) {
            throw new ParserException(throwable.getMessage());
        }
    }

    public void setAgentManagementAction(AgentManagementAction agentManagementAction) {
        this._action = agentManagementAction;
    }

    public void setResultSet(Set set) {
        this._results = set;
    }

    public AgentManagementAction getAgentManagementAction() {
        return this._action;
    }

    public Set getResultSet() {
        return this._results;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(" ");
        stringBuffer.append("result");
        stringBuffer.append(" ");
        stringBuffer.append(this._action.toString());
        stringBuffer.append("\n");
        stringBuffer.append(this.convertResultSetIntoString(this._results));
        stringBuffer.append(" ");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String convertResultSetIntoString(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("set");
        stringBuffer.append(" ");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            stringBuffer.append(string.toString());
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void parse(Content content) throws ParserException {
        if (content != null) {
            String string = (String)content.getAttribute("binaryTermOp");
            if (string == null || !string.equals("result")) {
                throw new ParserException("Result keyword expected");
            }
            Object object = content.getAttribute("term");
            if (!(object instanceof List)) {
                throw new ParserException("2 items expected");
            }
            List list = (List)object;
            Content content2 = (Content)list.get(0);
            Content content3 = (Content)list.get(1);
            Content content4 = (Content)content2.getAttribute("actionExpression");
            Content content5 = (Content)content3.getAttribute("set");
            this._action = new AgentManagementAction(content4);
            if (content5.getAttribute("term") instanceof List) {
                List list2 = (List)content5.getAttribute("term");
                int n = 0;
                while (n < list2.size()) {
                    Content content6 = (Content)list2.get(n);
                    this._results.add(this.convertToObject(content6));
                    ++n;
                }
            } else if (content5.getAttribute("term") instanceof Content) {
                Content content7 = (Content)content5.getAttribute("term");
                this._results.add(this.convertToObject(content7));
            } else if (content5.getAttribute("term") != null) {
                throw new ParserException("Invalid result set");
            }
        }
    }

    public Object convertToObject(Content content) throws ParserException {
        Content content2 = (Content)content.getAttribute("functionalTerm");
        String string = (String)content2.getAttribute("functionalOperator");
        if (string.equals("df-agent-description")) {
            return new DFAgentDescription(content);
        }
        if (string.equals("ams-agent-description")) {
            return new AMSAgentDescription(content);
        }
        throw new ParserException("Unknown description type " + string);
    }

    public static void main(String[] stringArray) {
        String string = "(result (action (agent-identifier :name df@foo.com :addresses (sequence iiop://foo.com/acc)) (search (df-agent-description :ontology (set meeting-scheduler) :language (set FIPA-SL0 KIF) :services (set (service-description :name profiling :type meeting-scheduler-service)) (search-constraint :max-depth 2)))) (set (df-agent-description :name (agent-identifier :name scheduler-agent@foo.com :addresses (sequence iiop://foo.com/acc)) :ontology (set meeting-scheduler FIPA-Agent-Management) :languages (set FIPA-SL0 FIPA-SL1 KIF) :services (set (service-description :name profiling :type meeting-scheduler-service) (service-description :name profiling :type user-profiling-service))))) ";
        try {
            AgentManagementResult agentManagementResult = new AgentManagementResult(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

