/*
 * Decompiled with CFR 0.152.
 */
package fipaos.ont.fipa.fipaman;

import fipaos.agent.conversation.content.Content;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.ServiceDescription;
import fipaos.parser.ParserException;
import fipaos.parser.sl.ParseException;
import fipaos.parser.sl.SLParser;
import fipaos.skill.db.DatabaseObject;
import fipaos.util.Comparators;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class DFAgentDescription
implements DatabaseObject,
Serializable {
    private AgentID _agent_name;
    private Set _agent_services;
    private Set _ontologies;
    private Set _languages;
    private Set _protocols;

    public DFAgentDescription() {
    }

    public DFAgentDescription(String string) throws ParserException {
        try {
            this.parse(SLParser.parseTerm(string));
        }
        catch (ParseException parseException) {
            throw new ParserException(parseException.getMessage());
        }
    }

    public DFAgentDescription(Content content) throws ParserException {
        this.parse(content);
    }

    private void parse(Content content) throws IllegalArgumentException, ParserException {
        Content content2 = (Content)content.getAttribute("functionalTerm");
        if (content2 == null || !content2.getAttribute("functionalOperator").equals("df-agent-description")) {
            throw new IllegalArgumentException("Content is not a DF-AGENT-DESCRIPTION");
        }
        if (content2.getAttribute("parameter") instanceof List) {
            List list = (List)content2.getAttribute("parameter");
            int n = 0;
            while (n < list.size()) {
                Content content3 = (Content)list.get(n);
                if (content3.getName() != "parameter") {
                    throw new IllegalArgumentException("Illegal DF-AGENT-DESCRIPTION FORMAT");
                }
                String string = (String)content3.getAttribute("parameterName");
                if (string.equals(":name")) {
                    String string2 = (String)((Content)content3.getAttribute("parameterValue")).getAttribute("formattedString");
                    this._agent_name = new AgentID(string2);
                } else if (string.equals(":services")) {
                    this._agent_services = this.createServiceDescriptionSet(content3);
                } else if (string.equals(":protocol")) {
                    this._protocols = this.createSet(content3);
                } else if (string.equals(":ontology")) {
                    this._ontologies = this.createSet(content3);
                } else if (string.equals(":language")) {
                    this._languages = this.createSet(content3);
                }
                ++n;
            }
        } else {
            Content content4 = (Content)content2.getAttribute("parameter");
            if (content4 != null) {
                String string = (String)content4.getAttribute("parameterName");
                if (string.equals(":name")) {
                    String string3 = (String)((Content)content4.getAttribute("parameterValue")).getAttribute("formattedString");
                    this._agent_name = new AgentID(string3);
                } else if (string.equals(":services")) {
                    this._agent_services = this.createServiceDescriptionSet(content4);
                } else if (string.equals(":protocol")) {
                    this._protocols = this.createSet(content4);
                } else if (string.equals(":ontology")) {
                    this._ontologies = this.createSet(content4);
                } else if (string.equals(":language")) {
                    this._languages = this.createSet(content4);
                }
            }
        }
    }

    private void addKeywordValuePair(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append("\n");
    }

    private String convertSetIntoString(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("set");
        stringBuffer.append(" ");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String convertSDSetIntoString(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("set");
        stringBuffer.append(" ");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ServiceDescription serviceDescription = (ServiceDescription)iterator.next();
            stringBuffer.append(serviceDescription.toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private Set createSet(Content content) {
        Set<String> set = Collections.synchronizedSet(new TreeSet(Comparators.OBJECT_COMPARE));
        Content content2 = (Content)content.getAttribute("parameterValue");
        content2 = (Content)content2.getAttribute("term");
        if ((content2 = (Content)content2.getAttribute("set")) == null) {
            throw new IllegalArgumentException("Illegal DF-AGENT-DESCRIPTION FORMAT: SET");
        }
        if (content2.getAttribute("term") instanceof List) {
            List list = (List)content2.getAttribute("term");
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Content content3 = (Content)list.get(n2);
                set.add((String)content3.getAttribute("formattedString"));
                ++n2;
            }
        } else {
            set.add((String)((Content)content2.getAttribute("term")).getAttribute("formattedString"));
        }
        return set;
    }

    private Set createServiceDescriptionSet(Content content) throws ParserException {
        Set<ServiceDescription> set = Collections.synchronizedSet(new TreeSet(Comparators.OBJECT_COMPARE));
        Content content2 = (Content)content.getAttribute("parameterValue");
        if (content2 != null && (content2 = (Content)content2.getAttribute("term")) != null) {
            if ((content2 = (Content)content2.getAttribute("set")) == null) {
                throw new IllegalArgumentException("Illegal DF-AGENT-DESCRIPTION FORMAT: SET");
            }
            if (content2.getAttribute("term") instanceof List) {
                List list = (List)content2.getAttribute("term");
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    Content content3 = (Content)list.get(n2);
                    set.add(new ServiceDescription((String)content3.getAttribute("formattedString")));
                    ++n2;
                }
            } else {
                Content content4 = (Content)content2.getAttribute("term");
                if (content4 != null && content4.getAttribute("formattedString") != null) {
                    ServiceDescription serviceDescription = new ServiceDescription((String)content4.getAttribute("formattedString"));
                    set.add(serviceDescription);
                }
            }
        }
        return set;
    }

    public String getObjectID() {
        return this._agent_name.getName();
    }

    public AgentID getAgentID() {
        return this._agent_name;
    }

    public void setAgentID(AgentID agentID) {
        this._agent_name = agentID;
    }

    public String getAgentName() {
        return this._agent_name.getName();
    }

    public Set getAgentServices() {
        return this._agent_services;
    }

    public int getNumberofDataElements() {
        int n = 0;
        if (this._agent_name != null) {
            ++n;
        }
        if (this._agent_services != null) {
            ++n;
        }
        if (this._languages != null) {
            ++n;
        }
        if (this._protocols != null) {
            ++n;
        }
        if (this._ontologies != null) {
            ++n;
        }
        return n;
    }

    public Set getOntologies() {
        return this._ontologies;
    }

    public Set getProtocols() {
        return this._protocols;
    }

    public Set getLanguages() {
        return this._languages;
    }

    public void setAgentName(AgentID agentID) {
        this._agent_name = agentID;
    }

    public void setAgentServices(Set set) {
        this._agent_services = set;
    }

    public void setAgentServices(ServiceDescription[] serviceDescriptionArray) {
        TreeSet<ServiceDescription> treeSet = new TreeSet<ServiceDescription>(Comparators.OBJECT_COMPARE);
        int n = 0;
        while (n < serviceDescriptionArray.length) {
            treeSet.add(serviceDescriptionArray[n]);
            ++n;
        }
        this._agent_services = treeSet;
    }

    public void setProtocols(Set set) {
        this._protocols = set;
    }

    public void setProtocols(String[] stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>(Comparators.OBJECT_COMPARE);
        int n = 0;
        while (n < stringArray.length) {
            treeSet.add(stringArray[n]);
            ++n;
        }
        this._protocols = treeSet;
    }

    public void setOntologies(Set set) {
        this._ontologies = set;
    }

    public void setOntologies(String[] stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>(Comparators.OBJECT_COMPARE);
        int n = 0;
        while (n < stringArray.length) {
            treeSet.add(stringArray[n]);
            ++n;
        }
        this._ontologies = treeSet;
    }

    public void setLanguages(Set set) {
        this._languages = set;
    }

    public void setLanguages(String[] stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>(Comparators.OBJECT_COMPARE);
        int n = 0;
        while (n < stringArray.length) {
            treeSet.add(stringArray[n]);
            ++n;
        }
        this._languages = treeSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("df-agent-description");
        stringBuffer.append("\n");
        if (this._agent_name != null) {
            this.addKeywordValuePair(stringBuffer, ":name", this._agent_name.toString());
        }
        if (this._agent_services != null) {
            this.addKeywordValuePair(stringBuffer, ":services", this.convertSDSetIntoString(this._agent_services));
        }
        if (this._protocols != null) {
            this.addKeywordValuePair(stringBuffer, ":protocol", this.convertSetIntoString(this._protocols));
        }
        if (this._ontologies != null) {
            this.addKeywordValuePair(stringBuffer, ":ontology", this.convertSetIntoString(this._ontologies));
        }
        if (this._languages != null) {
            this.addKeywordValuePair(stringBuffer, ":language", this.convertSetIntoString(this._languages));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = "( df-agent-description :services ( set ( service-description :type ping-agent  )  )  )";
        try {
            DFAgentDescription dFAgentDescription = new DFAgentDescription(string);
            System.out.println(dFAgentDescription.getAgentServices());
            dFAgentDescription = new DFAgentDescription();
            dFAgentDescription.setAgentName(new AgentID("(agent-identifier :name dummy@foo.com :addresses (sequence iiop://foo.com/acc ))"));
            ServiceDescription[] serviceDescriptionArray = new ServiceDescription[]{new ServiceDescription("(service-description :name profiling :type user-profiling)")};
            dFAgentDescription.setAgentServices(serviceDescriptionArray);
            String[] stringArray2 = new String[]{"KIF", "SL"};
            dFAgentDescription.setLanguages(stringArray2);
        }
        catch (ParserException parserException) {
            parserException.printStackTrace();
        }
    }
}

