/*
 * Decompiled with CFR 0.152.
 */
package fipaos.ont.fipa.fipaman;

import fipaos.mts.event.MessageListener;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.Received;
import fipaos.ont.fipa.fipaman.TransportBehaviour;
import fipaos.util.Comparators;
import fipaos.util.URL;
import fipaos.util.UTCContainer;
import fipaos.util.UTCTime;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Envelope
implements Serializable,
Cloneable {
    private static final String[] STANDARD_SLOTS = new String[]{"ACL-Representation", "Comments", "Date", "Encrypted", "Intended-receiver", "Received", ":receiver", ":sender", "Transport-behaviour", "Payload-Encoding", "Payload-Length"};
    private Map _slots;
    private List _sub_envelopes;
    private Envelope _parent;
    private Envelope _current_envelope;
    private transient int _error_code = 0;
    private transient boolean _via_acc = false;
    private transient List _transports_tried;
    private transient List _urls_tried;
    private transient List _listeners;

    public Envelope() {
        this(false);
    }

    private Envelope(boolean bl) {
        this._slots = new TreeMap(Comparators.STRING_COMPARE);
        this._sub_envelopes = new LinkedList();
        if (!bl) {
            this._current_envelope = new Envelope(true);
            this._current_envelope._parent = this;
            this._sub_envelopes.add(this._current_envelope);
        }
    }

    public Envelope(Envelope envelope) {
        Iterator<Object> iterator;
        if (envelope._parent != envelope._parent) {
            this._parent = envelope._parent;
        }
        if (envelope._slots != null) {
            this._slots = new TreeMap(Comparators.STRING_COMPARE);
            iterator = envelope._slots.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this._slots.put(string, new LinkedList((List)envelope._slots.get(string)));
            }
        }
        if (envelope._sub_envelopes != null) {
            this._sub_envelopes = new LinkedList();
            iterator = envelope._sub_envelopes.iterator();
            while (iterator.hasNext()) {
                this._sub_envelopes.add(((Envelope)iterator.next()).clone());
            }
        }
        if (envelope._current_envelope != null) {
            this._current_envelope = (Envelope)envelope._current_envelope.clone();
        }
        if (envelope._listeners != null) {
            this._listeners = new LinkedList(envelope._listeners);
        }
    }

    public Envelope(ACL aCL) {
        this(false);
        if (aCL.getSenderAID() != null) {
            this.setSender((AgentID)aCL.getSenderAID().clone());
        }
        if (aCL.getReceiverAIDs() != null) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            Iterator iterator = aCL.getReceiverAIDs().iterator();
            while (iterator.hasNext()) {
                linkedList.add(((AgentID)iterator.next()).clone());
            }
            this.setReceivers(linkedList);
        }
        this.setDate(new UTCTime());
        this.setACLRepresentation("fipa.acl.rep.string.std");
    }

    public Object clone() {
        try {
            Object object;
            Iterator<Object> iterator;
            Envelope envelope = (Envelope)super.clone();
            if (this._parent != null && this._parent == this) {
                envelope._parent = envelope;
            }
            if (this._slots != null) {
                envelope._slots = new TreeMap(Comparators.STRING_COMPARE);
                iterator = this._slots.keySet().iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    envelope._slots.put(object, this.cloneSlot(this._slots.get(object)));
                }
            }
            if (this._sub_envelopes != null) {
                envelope._sub_envelopes = new LinkedList();
                iterator = this._sub_envelopes.iterator();
                while (iterator.hasNext()) {
                    object = (Envelope)((Envelope)iterator.next()).clone();
                    ((Envelope)object)._parent = envelope;
                    envelope._sub_envelopes.add(object);
                }
                if (this._current_envelope != null) {
                    envelope._current_envelope = (Envelope)envelope._sub_envelopes.get(0);
                }
            }
            if (this._transports_tried != null) {
                envelope._transports_tried = new LinkedList(this._transports_tried);
            }
            if (this._urls_tried != null) {
                envelope._urls_tried = new LinkedList();
                iterator = this._urls_tried.iterator();
                while (iterator.hasNext()) {
                    envelope._urls_tried.add(((URL)iterator.next()).clone());
                }
            }
            return envelope;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object cloneSlot(Object object) {
        if (object instanceof List) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                linkedList.add(this.cloneSlot(iterator.next()));
            }
            return linkedList;
        }
        if (object instanceof Set) {
            TreeSet<Object> treeSet = new TreeSet<Object>(Comparators.OBJECT_COMPARE);
            Iterator iterator = ((Set)object).iterator();
            while (iterator.hasNext()) {
                treeSet.add(this.cloneSlot(iterator.next()));
            }
            return treeSet;
        }
        if (object instanceof Map) {
            TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(Comparators.OBJECT_COMPARE);
            Iterator iterator = ((Map)object).keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                treeMap.put(this.cloneSlot(k), this.cloneSlot(((Map)object).get(k)));
            }
            return treeMap;
        }
        if (object instanceof String) {
            return new String((String)object);
        }
        if (object instanceof AgentID) {
            return ((AgentID)object).clone();
        }
        if (object instanceof URL) {
            return ((URL)object).clone();
        }
        if (object instanceof UTCContainer) {
            return ((UTCContainer)object).clone();
        }
        if (object instanceof Received) {
            return ((Received)object).clone();
        }
        if (object instanceof TransportBehaviour) {
            return ((TransportBehaviour)object).clone();
        }
        return object.toString();
    }

    public void addMessageListener(MessageListener messageListener) {
        if (this._listeners == null) {
            this._listeners = new LinkedList();
        }
        if (!this._listeners.contains(messageListener)) {
            this._listeners.add(messageListener);
        }
    }

    public void removeMessageListener(MessageListener messageListener) {
        if (this._listeners == null) {
            return;
        }
        if (this._listeners.contains(messageListener)) {
            this._listeners.remove(messageListener);
        }
    }

    public List getMessageListeners() {
        LinkedList linkedList = new LinkedList();
        if (this._listeners != null) {
            linkedList.addAll(this._listeners);
        }
        return linkedList;
    }

    public synchronized void newSubEnvelope() {
        if (this._parent != null) {
            return;
        }
        this._current_envelope = new Envelope(true);
        this._current_envelope._parent = this;
        this._sub_envelopes.add(this._current_envelope);
    }

    public synchronized List getSubEnvelopes() {
        if (this._parent == null) {
            return new LinkedList(this._sub_envelopes);
        }
        return null;
    }

    public synchronized Envelope getSubEnvelope(int n) {
        if (n >= this._sub_envelopes.size() || this._parent != null) {
            return null;
        }
        return (Envelope)this._sub_envelopes.get(n);
    }

    public void setACLRepresentation(String string) {
        this.setSlotValue("ACL-Representation", string);
    }

    public String getACLRepresentation() {
        return (String)this.getSlotValue("ACL-Representation");
    }

    public void setComments(String string) {
        this.setSlotValue("Comments", string);
    }

    public String getComments() {
        return (String)this.getSlotValue("Comments");
    }

    public void setPayloadEncoding(String string) {
        this.setSlotValue("Payload-Encoding", string);
    }

    public String getPayloadEncoding() {
        return (String)this.getSlotValue("Payload-Encoding");
    }

    public void setPayloadLength(int n) {
        if (n > -1) {
            this.setSlotValue("Payload-Length", new Integer(n));
        } else {
            this.setSlotValue("Payload-Length", null);
        }
    }

    public int getPayloadLength() {
        Integer n = (Integer)this.getSlotValue("Payload-Length");
        if (n != null) {
            return n;
        }
        return -1;
    }

    public void setDate(UTCTime uTCTime) {
        this.setSlotValue("Date", uTCTime);
    }

    public UTCTime getDate() {
        return (UTCTime)this.getSlotValue("Date");
    }

    public void setEncrypted(List list) {
        this.setSlotValue("Encrypted", list);
    }

    public List getEncrypted() {
        return (List)this.getSlotValue("Encrypted");
    }

    public void setReceived(Received received) {
        this.setSlotValue("Received", received);
    }

    public Received getReceived() {
        return (Received)this.getSlotValue("Received");
    }

    public void setSender(AgentID agentID) {
        this.setSlotValue(":sender", agentID);
    }

    public AgentID getSender() {
        return (AgentID)this.getSlotValue(":sender");
    }

    public void setReceivers(List list) {
        this.setSlotValue(":receiver", list);
    }

    public List getReceivers() {
        return (List)this.getSlotValue(":receiver");
    }

    public void setIntendedReceiver(List list) {
        this.setSlotValue("Intended-receiver", list);
    }

    public List getIntendedReceiver() {
        return (List)this.getSlotValue("Intended-receiver");
    }

    public void setTransportBehaviour(TransportBehaviour transportBehaviour) {
        this.setSlotValue("Transport-behaviour", transportBehaviour);
    }

    public TransportBehaviour getTransportBehaviour() {
        return (TransportBehaviour)this.getSlotValue("Transport-behaviour");
    }

    public void setErrorCode(int n) {
        this._error_code = n;
    }

    public int getErrorCode() {
        return this._error_code;
    }

    public void setViaACC(boolean bl) {
        this._via_acc = bl;
    }

    public boolean getViaACC() {
        return this._via_acc;
    }

    public List getTransportsTried() {
        if (this._transports_tried == null) {
            this._transports_tried = new LinkedList();
        }
        return this._transports_tried;
    }

    public List getUnknownURLsTried() {
        if (this._urls_tried == null) {
            this._urls_tried = new LinkedList();
        }
        return this._urls_tried;
    }

    public synchronized void setSlotValue(String string, Object object) {
        Object var3_3 = null;
        if (this._parent == null) {
            this._current_envelope.setSlotValue(string, object);
        } else {
            this._slots.put(string, object);
        }
    }

    public synchronized Object getSlotValue(String string) {
        Object object = null;
        if (this._parent != null) {
            object = this._slots.get(string);
        } else {
            Iterator iterator = this._sub_envelopes.iterator();
            while (iterator.hasNext()) {
                Envelope envelope = (Envelope)iterator.next();
                Object object2 = envelope.getSlotValue(string);
                if (object2 == null) continue;
                object = object2;
            }
        }
        return object;
    }

    public synchronized Set getUserSlots() {
        TreeSet treeSet = null;
        if (this._parent != null) {
            List<String> list = Arrays.asList(STANDARD_SLOTS);
            treeSet = new TreeSet(Comparators.STRING_COMPARE);
            treeSet.addAll(this._slots.keySet());
            treeSet.removeAll(list);
        } else {
            treeSet = new TreeSet(Comparators.STRING_COMPARE);
            Iterator iterator = this._sub_envelopes.iterator();
            while (iterator.hasNext()) {
                Envelope envelope = (Envelope)iterator.next();
                treeSet.addAll(envelope.getUserSlots());
            }
        }
        return treeSet;
    }

    public String toString() {
        return this._parent == null ? this._sub_envelopes.toString() : this._slots.toString();
    }

    public static void main(String[] stringArray) {
        Envelope envelope = new Envelope();
        envelope.setSlotValue(":sender", "abc");
        envelope.newSubEnvelope();
        envelope.setSlotValue(":sender", "mnp");
        envelope.newSubEnvelope();
        envelope.setSlotValue(":X-SomeOther", "xyz");
        if (!envelope.getSlotValue(":sender").equals("mnp") || !envelope.getSlotValue(":X-SomeOther").equals("xyz") || envelope.getUserSlots().size() != 1 || envelope.getUserSlots().contains(":X-SomeOther")) {
            // empty if block
        }
    }
}

