/*
 * Decompiled with CFR 0.152.
 */
package fipaos.ont.fipa.fipaman;

import fipaos.agent.conversation.content.Content;
import fipaos.parser.ParserException;
import fipaos.parser.sl.ParseException;
import fipaos.parser.sl.SLParser;
import fipaos.util.URL;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MTPDescription
implements Serializable {
    private String _profile;
    private String _mtp_name;
    private List _addresses;

    public MTPDescription(String string, String string2, List list) {
        this._profile = string;
        this._mtp_name = string2;
        this._addresses = list;
    }

    public MTPDescription() {
        this._addresses = Collections.synchronizedList(new LinkedList());
    }

    public MTPDescription(String string) throws ParserException {
        this._addresses = Collections.synchronizedList(new LinkedList());
        try {
            this.parse(SLParser.parseTerm(string));
        }
        catch (ParseException parseException) {
            throw new ParserException(parseException.getMessage());
        }
    }

    private void addKeywordValuePair(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
    }

    private String convertListIntoString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("sequence");
        stringBuffer.append(" ");
        int n = 0;
        while (n < list.size()) {
            URL uRL = (URL)list.get(n);
            stringBuffer.append(uRL);
            stringBuffer.append(" ");
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private List createList(Content content) {
        List<URL> list = Collections.synchronizedList(new LinkedList());
        Content content2 = (Content)content.getAttribute("parameterValue");
        content2 = (Content)content2.getAttribute("term");
        if ((content2 = (Content)content2.getAttribute("set")) == null) {
            throw new IllegalArgumentException("Illegal MTP-DESCRIPTION FORMAT: SEQUENCE");
        }
        if (content2.getAttribute("term") instanceof List) {
            List list2 = (List)content2.getAttribute("term");
            int n = list2.size();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                Content content3 = (Content)list2.get(n2);
                list.add(new URL((String)content3.getAttribute("formattedString")));
                ++n2;
            }
        } else {
            list.add(new URL((String)((Content)content2.getAttribute("term")).getAttribute("formattedString")));
        }
        return list;
    }

    private void parse(Content content) throws IllegalArgumentException {
        if (content != null) {
            boolean bl = false;
            Content content2 = (Content)content.getAttribute("functionalTerm");
            if (content2 == null || !content2.getAttribute("functionalOperator").equals("mtp-description")) {
                throw new IllegalArgumentException("Content is not a MTP-DESCRIPTION");
            }
            Object object = content2.getAttribute("parameter");
            if (object instanceof List) {
                int n = 0;
                while (n < ((List)object).size()) {
                    String string;
                    Content content3 = (Content)((List)object).get(n);
                    if (content3.getName() != "parameter") {
                        throw new IllegalArgumentException("Illegal MTP-DESCRIPTION FORMAT");
                    }
                    String string2 = (String)content3.getAttribute("parameterName");
                    if (string2.equals(":profile")) {
                        this._profile = string = (String)((Content)content3.getAttribute("parameterValue")).getAttribute("formattedString");
                    } else if (string2.equals(":mtp-name")) {
                        this._mtp_name = string = (String)((Content)content3.getAttribute("parameterValue")).getAttribute("formattedString");
                    } else if (string2.equals(":addresses")) {
                        bl = true;
                        this._addresses = this.createList(content3);
                    }
                    ++n;
                }
            } else {
                String string = (String)((Content)object).getAttribute("parameterName");
                if (string.equals(":addresses")) {
                    bl = true;
                    this.setAddresses(this.createList((Content)object));
                }
            }
            if (!bl) {
                throw new IllegalArgumentException("Message Transport Protocol Description must contain addresses");
            }
        }
    }

    public void setProfile(String string) {
        this._profile = string;
    }

    public void setMTPName(String string) {
        this._mtp_name = string;
    }

    public void setAddresses(List list) {
        this._addresses = list;
    }

    public boolean addAddress(URL uRL) {
        List list = this._addresses;
        synchronized (list) {
            if (!this._addresses.contains(uRL)) {
                boolean bl = this._addresses.add(uRL);
                return bl;
            }
        }
        return false;
    }

    public String getProfile() {
        return this._profile;
    }

    public String getMTPName() {
        return this._mtp_name;
    }

    public List getAddresses() {
        return this._addresses;
    }

    public boolean removeAddress(URL uRL) {
        List list = this._addresses;
        synchronized (list) {
            boolean bl = this._addresses.remove(uRL);
            return bl;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("mtp-description");
        stringBuffer.append("\n");
        if (this._profile != null) {
            this.addKeywordValuePair(stringBuffer, ":profile", this._profile);
        }
        if (this._mtp_name != null) {
            this.addKeywordValuePair(stringBuffer, ":mtp-name", this._mtp_name);
        }
        if (this._addresses != null) {
            this.addKeywordValuePair(stringBuffer, ":addresses", this.convertListIntoString(this._addresses));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = "(mtp-description :profile fipa-alpha :mtp-name fipa-iiop-std :addresses (set iiop://monitor.co.uk:9000/acc http://www.agentworld.co.uk:9000 ) ) ";
        try {
            MTPDescription mTPDescription = new MTPDescription(string);
        }
        catch (ParserException parserException) {
            parserException.printStackTrace();
        }
    }
}

