/*
 * Decompiled with CFR 0.152.
 */
package fipaos.ont.fipa.fipaman;

import fipaos.agent.conversation.content.Content;
import fipaos.ont.fipa.fipaman.PropertyTemplate;
import fipaos.parser.ParserException;
import fipaos.parser.sl.ParseException;
import fipaos.parser.sl.SLParser;
import fipaos.util.Comparators;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ServiceDescription
implements Serializable {
    private String _service_name = null;
    private String _service_type = null;
    private String _ownership = null;
    private Set _ontologies = null;
    private Set _properties = null;
    private Set _protocols = null;

    public ServiceDescription(String string) throws ParserException {
        try {
            this.parse(SLParser.parseTerm(string));
        }
        catch (ParseException parseException) {
            throw new ParserException(parseException.getMessage());
        }
    }

    public ServiceDescription(Content content) throws ParserException {
        this.parse(content);
    }

    public ServiceDescription() {
    }

    public String getServiceName() {
        return this._service_name;
    }

    public String getServiceType() {
        return this._service_type;
    }

    public String getOwnership() {
        return this._ownership;
    }

    public Set getOntologies() {
        return this._ontologies;
    }

    public Set getProperties() {
        return this._properties;
    }

    public Set getProtocols() {
        return this._protocols;
    }

    public void setServiceName(String string) {
        this._service_name = string;
    }

    public void setServiceType(String string) {
        this._service_type = string;
    }

    public void setOwnership(String string) {
        this._ownership = string;
    }

    public void setOntologies(Set set) {
        this._ontologies = set;
    }

    public void setOntologies(String[] stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>(Comparators.OBJECT_COMPARE);
        int n = 0;
        while (n < stringArray.length) {
            treeSet.add(stringArray[n]);
            ++n;
        }
        this._ontologies = treeSet;
    }

    public void setProperties(Set set) {
        this._properties = set;
    }

    public void setProperties(PropertyTemplate[] propertyTemplateArray) throws ParserException {
        TreeSet<PropertyTemplate> treeSet = new TreeSet<PropertyTemplate>(Comparators.OBJECT_COMPARE);
        int n = 0;
        while (n < propertyTemplateArray.length) {
            treeSet.add(propertyTemplateArray[n]);
            ++n;
        }
        this._properties = treeSet;
    }

    public void setProperties(String[] stringArray) throws ParserException {
        TreeSet<PropertyTemplate> treeSet = new TreeSet<PropertyTemplate>(Comparators.OBJECT_COMPARE);
        int n = 0;
        while (n < stringArray.length) {
            treeSet.add(new PropertyTemplate(stringArray[n]));
            ++n;
        }
        this._properties = treeSet;
    }

    public void setProtocols(Set set) {
        this._protocols = set;
    }

    public void setProtocols(String[] stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>(Comparators.OBJECT_COMPARE);
        int n = 0;
        while (n < stringArray.length) {
            treeSet.add(stringArray[n]);
            ++n;
        }
        this._protocols = treeSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("service-description");
        stringBuffer.append("\n");
        if (this._service_name != null) {
            this.addKeywordValuePair(stringBuffer, ":name", this._service_name);
        }
        if (this._service_type != null) {
            this.addKeywordValuePair(stringBuffer, ":type", this._service_type);
        }
        if (this._ontologies != null) {
            this.addKeywordValuePair(stringBuffer, ":ontology", this.convertSetIntoString(this._ontologies));
        }
        if (this._protocols != null) {
            this.addKeywordValuePair(stringBuffer, ":protocol", this.convertSetIntoString(this._protocols));
        }
        if (this._ownership != null) {
            this.addKeywordValuePair(stringBuffer, ":ownership", this._ownership);
        }
        if (this._properties != null) {
            this.addKeywordValuePair(stringBuffer, ":properties", this.convertPropertySetIntoString(this._properties));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(ServiceDescription serviceDescription) {
        if (serviceDescription == null) {
            return false;
        }
        if (this._service_name != null && !this._service_name.equals(serviceDescription.getServiceName())) {
            return false;
        }
        if (this._service_type != null && !this._service_type.equals(serviceDescription.getServiceType())) {
            return false;
        }
        if (this._ownership != null && !this._ownership.equals(serviceDescription.getOwnership())) {
            return false;
        }
        if (this._ontologies != null && !this._ontologies.equals(serviceDescription.getOntologies())) {
            return false;
        }
        if (this._properties != null && !this._properties.equals(serviceDescription.getProperties())) {
            return false;
        }
        return this._protocols == null || this._protocols.equals(serviceDescription.getProtocols());
    }

    private void addKeywordValuePair(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append("\n");
    }

    private String convertSetIntoString(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("set");
        stringBuffer.append(" ");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private String convertPropertySetIntoString(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("set");
        stringBuffer.append(" ");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            PropertyTemplate propertyTemplate = (PropertyTemplate)iterator.next();
            stringBuffer.append(propertyTemplate.toString());
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private Set createSet(Content content) {
        Set<String> set = Collections.synchronizedSet(new TreeSet(Comparators.OBJECT_COMPARE));
        Content content2 = (Content)content.getAttribute("parameterValue");
        content2 = (Content)content2.getAttribute("term");
        if ((content2 = (Content)content2.getAttribute("set")) == null) {
            throw new IllegalArgumentException("Illegal DF-AGENT-DESCRIPTION FORMAT: SET");
        }
        if (content2.getAttribute("term") instanceof List) {
            List list = (List)content2.getAttribute("term");
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Content content3 = (Content)list.get(n2);
                set.add((String)content3.getAttribute("formattedString"));
                ++n2;
            }
        } else {
            set.add((String)((Content)content2.getAttribute("term")).getAttribute("formattedString"));
        }
        return set;
    }

    private Set createPropertySet(Content content) throws ParserException {
        Content content2;
        Set<PropertyTemplate> set = Collections.synchronizedSet(new TreeSet(Comparators.OBJECT_COMPARE));
        if (content != null && (content2 = (Content)content.getAttribute("parameterValue")) != null && (content2 = (Content)content2.getAttribute("term")) != null) {
            if ((content2 = (Content)content2.getAttribute("set")) == null) {
                throw new IllegalArgumentException("Illegal DF-AGENT-DESCRIPTION FORMAT: SET");
            }
            if (content2.getAttribute("term") instanceof List) {
                List list = (List)content2.getAttribute("term");
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    Content content3 = (Content)list.get(n2);
                    set.add(new PropertyTemplate((String)content3.getAttribute("formattedString")));
                    ++n2;
                }
            } else {
                String string;
                Content content4 = (Content)content2.getAttribute("term");
                if (content4 != null && (string = (String)content4.getAttribute("formattedString")) != null) {
                    PropertyTemplate propertyTemplate = new PropertyTemplate(string);
                    set.add(propertyTemplate);
                }
            }
        }
        return set;
    }

    private void parse(Content content) throws IllegalArgumentException, ParserException {
        if (content != null) {
            boolean bl = false;
            boolean bl2 = false;
            Content content2 = (Content)content.getAttribute("functionalTerm");
            if (content2 == null || !content2.getAttribute("functionalOperator").equals("service-description")) {
                throw new IllegalArgumentException("Content is not a SERVICE-DESCRIPTION");
            }
            List<Object> list = null;
            Object object = content2.getAttribute("parameter");
            list = object instanceof List ? (List<Object>)object : Arrays.asList(object);
            int n = 0;
            while (n < list.size()) {
                String string;
                Content content3 = (Content)list.get(n);
                if (content3.getName() != "parameter") {
                    throw new IllegalArgumentException("Illegal SERVICE-DESCRIPTION FORMAT");
                }
                String string2 = (String)content3.getAttribute("parameterName");
                if (string2.equals(":name")) {
                    this._service_name = string = (String)((Content)content3.getAttribute("parameterValue")).getAttribute("formattedString");
                } else if (string2.equals(":type")) {
                    this._service_type = string = (String)((Content)content3.getAttribute("parameterValue")).getAttribute("formattedString");
                } else if (string2.equals(":ownership")) {
                    this._ownership = string = (String)((Content)content3.getAttribute("parameterValue")).getAttribute("formattedString");
                } else if (string2.equals(":protocol")) {
                    this._protocols = this.createSet(content3);
                } else if (string2.equals(":ontology")) {
                    this._ontologies = this.createSet(content3);
                } else if (string2.equals(":properties")) {
                    this._properties = this.createPropertySet(content3);
                }
                ++n;
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            ServiceDescription serviceDescription = new ServiceDescription("(service-description :name profiling :type user-profiling :ontology (set meeting-scheduler) :properties (set (property :name learning algorithm :value BBN) (property :name max-nodes :value 1000000)))");
            serviceDescription = new ServiceDescription();
            serviceDescription.setServiceName("profiling");
            serviceDescription.setServiceType("user-profiling");
            String[] stringArray2 = new String[]{"meeting scheduler"};
            serviceDescription.setOntologies(stringArray2);
            PropertyTemplate[] propertyTemplateArray = new PropertyTemplate[]{new PropertyTemplate("learning algorithm", "BBN"), new PropertyTemplate("max-nodes", "1000000")};
            serviceDescription.setProperties(propertyTemplateArray);
        }
        catch (ParserException parserException) {
            parserException.printStackTrace();
        }
    }
}

