/*
 * Decompiled with CFR 0.152.
 */
package fipaos.parser.acl;

import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.parser.aid.AIDParser;
import fipaos.util.UTCContainer;
import fipaos.util.UTCDuration;
import fipaos.util.UTCTime;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public class ACLMessage
extends ACL
implements Serializable {
    public ACLMessage() {
    }

    public ACLMessage(ACL aCL) {
        super(aCL);
    }

    public void setMessageType(String string) {
        super.setPerformative(string);
    }

    public void setSender(String string) {
        try {
            super.setSenderAID(AIDParser.parse(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setReceiver(String string) {
        if (string != null) {
            List list = AgentID.getAgentIDs(string);
            super.setReceiverAIDs(list);
        } else {
            super.setReceiverAIDs(null);
        }
    }

    public void setContent(String string) {
        super.setContentObject(string);
    }

    public void setContent(String string, int n) {
        super.setContentObject(string, n);
    }

    public void setReplyTo(String string) {
        if (string != null) {
            List list = AgentID.getAgentIDs(string);
            super.setReplyToAIDs(list);
        } else {
            super.setReplyToAIDs(null);
        }
    }

    public void setReplyBy(String string) {
        UTCContainer uTCContainer = null;
        try {
            uTCContainer = new UTCTime(string);
        }
        catch (Throwable throwable) {
            uTCContainer = new UTCDuration(string);
        }
        super.setReplyByUTC(uTCContainer);
    }

    public String getMessageType() {
        return super.getPerformative();
    }

    public String getSender() {
        return super.getSenderAID().toString();
    }

    public String getReceiver() {
        List list = super.getReceiverAIDs();
        String string = null;
        if (list != null && list.size() > 0) {
            string = ((AgentID)list.get(0)).toString();
        }
        return string;
    }

    public String getContent() {
        Object object = super.getContentObject();
        if (!(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        return string;
    }

    public String getReplyBy() {
        return super.getReplyByUTC().toString();
    }

    public String getReplyTo() {
        List list = super.getReplyToAIDs();
        String string = null;
        if (list != null && list.size() > 0) {
            string = (String)list.get(0);
        }
        return string;
    }

    public Vector getEnvelope() {
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "(agent-identifier :name agent-a :addresses (sequence fipaos-rmi://localhost:1099/ iiop://somehost.com:8888/acc) :resolvers (sequence (agent-identifier :name ams) (agent-identifier :name acc) ) )";
        String string2 = "(agent-identifier :name agent-b :addresses (sequence fipaos-rmi://localhost:1099/ iiop://somehost.com:8989/acc) :resolvers (sequence (agent-identifier :name ams) (agent-identifier :name acc) ) )";
        ACLMessage aCLMessage = new ACLMessage();
        aCLMessage.setPerformative("inform");
        aCLMessage.setOntology("my-ontology");
        aCLMessage.setLanguage("my-language");
        aCLMessage.setProtocol("my-protocol");
        aCLMessage.setSender(string);
        aCLMessage.setReceiver(string2);
        aCLMessage.setContent("( Test Message )");
        aCLMessage.setConversationID("test-conv-id-2348723648");
        ACL aCL = new ACL(aCLMessage.toString());
    }
}

