/*
 * Decompiled with CFR 0.152.
 */
package fipaos.parser.acl.bitefficient;

import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.parser.acl.bitefficient.ACLConstants;
import fipaos.parser.acl.bitefficient.ACLPerformatives;
import fipaos.parser.acl.bitefficient.BinDate;
import fipaos.parser.acl.bitefficient.BinNumber;
import fipaos.parser.acl.bitefficient.EncoderCodetable;
import fipaos.parser.acl.util.ByteArray;
import fipaos.util.UTCContainer;
import java.util.Iterator;
import java.util.List;

public class ACLEncoder
implements ACLConstants {
    private static ACLPerformatives as;
    private ByteArray buf = new ByteArray(1024);
    private BinDate bd = new BinDate();
    private BinNumber bn = new BinNumber();
    private EncoderCodetable ct;
    private int size;
    private byte baseCoding;
    private byte currCoding;
    private ExprParser ex = new ExprParser();

    public ACLEncoder() {
        this.baseCoding = (byte)-6;
        this.initialize(0);
    }

    public ACLEncoder(int n) {
        this.baseCoding = (byte)(n > 0 ? -5 : -6);
        this.initialize(n);
    }

    public ACLEncoder(int n, EncoderCodetable encoderCodetable) {
        this.ct = encoderCodetable;
        this.size = n;
        as = new ACLPerformatives();
    }

    private void initialize(int n) {
        this.ct = this.baseCoding == -6 || n == 0 ? null : new EncoderCodetable(n);
        this.size = n;
        as = new ACLPerformatives();
    }

    public EncoderCodetable getCodeTable() {
        return this.ct;
    }

    public ByteArray encode(ACL aCL) {
        this.currCoding = this.baseCoding;
        return this.outputMessage(aCL);
    }

    public ByteArray encode(ACL aCL, byte by) {
        this.currCoding = by;
        return this.outputMessage(aCL);
    }

    private ByteArray outputMessage(ACL aCL) {
        return this.outputMessage(aCL, 0);
    }

    private ByteArray outputMessage(ACL aCL, int n) {
        UTCContainer uTCContainer;
        this.buf.reset();
        this.buf.add(this.currCoding);
        this.buf.add((byte)16);
        this.dumpMsgType(aCL.getPerformative());
        this.dumpSender(aCL.getSenderAID(), (byte)2);
        this.dumpAIDList(aCL.getReceiverAIDs(), (byte)3);
        String string = aCL.getConversationID();
        if (string != null && string.length() > 0) {
            this.dumpParam(string, (byte)13);
        }
        if ((uTCContainer = aCL.getReplyByUTC()) != null) {
            this.dumpDate(uTCContainer.toString());
        }
        this.dumpAIDList(aCL.getReplyToAIDs(), (byte)8);
        this.dumpContent(aCL, n);
        string = aCL.getInReplyTo();
        if (string != null && string.length() > 0) {
            this.dumpParam(string, (byte)7);
        }
        if ((string = aCL.getReplyWith()) != null && string.length() > 0) {
            this.dumpParam(string, (byte)5);
        }
        if ((string = aCL.getLanguage()) != null && string.length() > 0) {
            this.dumpParam(aCL.getLanguage(), (byte)9);
        }
        if ((string = aCL.getOntology()) != null && string.length() > 0) {
            this.dumpParam(string, (byte)11);
        }
        if ((string = aCL.getProtocol()) != null && string.length() > 0) {
            this.dumpWordParam(string, (byte)12);
        }
        this.buf.add((byte)1);
        return this.buf;
    }

    private void dumpMsgType(String string) {
        byte by = as.getCACode(string);
        this.buf.add(by);
    }

    private void dumpDate(String string) {
        if (string == null || string.length() < 1) {
            return;
        }
        int n = BinDate.containsTypeDg(string) ? 1 : 0;
        this.buf.add((byte)6);
        this.buf.add((byte)(32 + n));
        this.buf.add(this.bd.toBin(string), 9);
        if (n == 1) {
            this.buf.add((byte)string.charAt(string.length() - 1));
        }
    }

    private void dumpNumber(ByteArray byteArray, byte by) {
        if (byteArray.length() < 1) {
            return;
        }
        this.buf.add((byte)(0x12 | by));
        ByteArray byteArray2 = this.bn.toBin(byteArray);
        this.buf.add(byteArray2.get(), byteArray2.length());
    }

    private void dumpString(String string) {
        this.dumpString(string, (byte)0);
    }

    private void dumpString(String string, byte by) {
        int n;
        if (string == null || string.length() < 1) {
            return;
        }
        int n2 = n = this.currCoding == -6 ? -1 : this.ct.lookup(string);
        if (n == -1) {
            if (this.currCoding == -5) {
                this.ct.insert(string);
            }
            this.buf.add((byte)(0x10 | by));
            this.buf.add(string.getBytes(), string.length());
            this.buf.add((byte)0);
        } else {
            this.buf.add((byte)(0x11 | by));
            this.outputCode(n);
        }
    }

    private void outputCode(int n) {
        if (this.size > 8) {
            this.buf.add((byte)(n >> 8 & 0xFF));
            this.buf.add((byte)(n & 0xFF));
        } else {
            this.buf.add((byte)n);
        }
    }

    private void outputLong(int n) {
        this.buf.add((byte)(n >> 24 & 0xFF));
        this.buf.add((byte)(n >> 16 & 0xFF));
        this.buf.add((byte)(n >> 8 & 0xFF));
        this.buf.add((byte)(n & 0xFF));
    }

    private void dumpSender(AgentID agentID, byte by) {
        if (agentID == null) {
            return;
        }
        this.buf.add(by);
        this.dumpAID(agentID);
    }

    private void dumpAIDList(List list, byte by) {
        if (list.size() > 0) {
            this.buf.add(by);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.dumpAID((AgentID)iterator.next());
            }
            this.buf.add((byte)1);
        }
    }

    private void dumpAID(AgentID agentID) {
        Object object;
        this.buf.add((byte)2);
        this.dumpString(agentID.getName());
        List list = agentID.getAddresses();
        if (list.size() > 0) {
            this.buf.add((byte)2);
            object = list.iterator();
            while (object.hasNext()) {
                this.dumpString(object.next().toString());
            }
            this.buf.add((byte)1);
        }
        if ((object = agentID.getResolvers()).size() > 0) {
            this.buf.add((byte)3);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                this.dumpAID((AgentID)iterator.next());
            }
            this.buf.add((byte)1);
        }
        this.buf.add((byte)1);
    }

    private void dumpWordParam(String string, byte by) {
        if (string == null || string.length() < 1) {
            return;
        }
        this.buf.add(by);
        this.dumpString(string);
    }

    private void dumpParam(String string, byte by) {
        this.buf.add(by);
        this.dumpString(string);
    }

    private void dumpContent(ACL aCL, int n) {
        if (aCL == null) {
            return;
        }
        switch (n) {
            case 0: {
                if (aCL.getContentObject() == null) {
                    return;
                }
                this.buf.add((byte)4);
                this.dumpString(aCL.getContentObject().toString());
                break;
            }
            case 1: {
                this.buf.add((byte)4);
                if (aCL.getContentObject() == null) {
                    return;
                }
                this.dumpString(aCL.getContentObject().toString());
            }
            default: {
                return;
            }
        }
    }

    private void dumpBLE(ByteArray byteArray) {
        int n = byteArray.length();
        if (n < 256) {
            this.buf.add((byte)22);
            this.buf.add((byte)(n & 0xFF));
        } else if (n < 65536) {
            this.buf.add((byte)23);
            this.outputCode(n);
        } else {
            this.buf.add((byte)25);
            this.outputLong(n);
        }
        this.buf.add(byteArray);
    }

    private class ExprParser {
        private int level;
        private int index;
        private int len;
        private ByteArray ba = new ByteArray();
        private String _str;
        byte l;

        public void fromString(String string) {
            byte by;
            this.index = 0;
            this.level = 0;
            this.l = 0;
            this._str = string;
            this.len = this._str.length();
            while ((by = this.getChar()) != -1) {
                this.parse(by);
            }
            if (this.level > 0) {
                System.err.println("Invalid expression");
            }
            if (this.l > 0) {
                ACLEncoder.this.buf.add(this.l);
            }
        }

        private void parse(byte by) {
            if (by == 40) {
                if (this.l == 96 || this.l == 64) {
                    ACLEncoder.this.buf.add(this.l);
                }
                this.l = (byte)96;
                ++this.level;
            } else if (by == 41) {
                if (this.l == 96 || this.l == 64) {
                    ACLEncoder.this.buf.add(this.l);
                }
                this.l = (byte)64;
                --this.level;
            } else if (by > 32) {
                if (by == 34) {
                    byte by2 = this.l;
                    String string = this.getString(by);
                    if (this.l != by2) {
                        ACLEncoder.this.dumpString(string, by2);
                    } else {
                        ACLEncoder.this.dumpString(string, this.l);
                    }
                    this.l = 0;
                } else if (by == 35) {
                    System.err.println("ByteLenEncoded not implemented");
                } else if (by >= 48 && by <= 57 || by == 45) {
                    ACLEncoder.this.dumpNumber(this.getNumber(by), this.l);
                    this.l = 0;
                } else if (by > 32) {
                    ACLEncoder.this.dumpString(this.getWord(by), this.l);
                    this.l = 0;
                } else {
                    System.err.println("Unknown char " + by);
                }
            }
        }

        private ByteArray getNumber(byte by) {
            this.ba.reset();
            this.ba.add(by);
            while ((by = this.getChar()) != -1) {
                if (by >= 48 && by <= 57 || by == 101 || by == 46 || by == 69 || by == 43 || by == 45) {
                    this.ba.add(by);
                    continue;
                }
                --this.index;
                break;
            }
            return this.ba;
        }

        private String getWord(byte by) {
            this.ba.reset();
            this.ba.add(by);
            while ((by = this.getChar()) != -1) {
                if (by > 32 && by != 41 && by != 40) {
                    this.ba.add(by);
                    continue;
                }
                --this.index;
                break;
            }
            return new String(this.ba.get(), 0, this.ba.length());
        }

        private String getString(byte by) {
            this.ba.reset();
            int n = 0;
            this.ba.add(by);
            while ((by = this.getChar()) != -1) {
                if (by == 92 && n == 92) {
                    this.ba.add(by);
                    n = 0;
                    continue;
                }
                if (by == 34 && n == 92) {
                    this.ba.add(by);
                } else if (by != 34) {
                    this.ba.add(by);
                } else {
                    this.ba.add(by);
                    break;
                }
                n = by;
            }
            if (by == -1) {
                --this.index;
                this.l = (byte)96;
                return new String(this.ba.get(), 0, this.ba.length() - 1);
            }
            return new String(this.ba.get(), 0, this.ba.length());
        }

        private byte getChar() {
            return this.index < this.len ? (byte)this._str.charAt(this.index++) : (byte)-1;
        }
    }
}

