/*
 * Decompiled with CFR 0.152.
 */
package fipaos.parser.acl.bitefficient;

import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.parser.acl.bitefficient.ACLConstants;
import fipaos.parser.acl.bitefficient.ACLPerformatives;
import fipaos.parser.acl.bitefficient.BEParseException;
import fipaos.parser.acl.bitefficient.BinDate;
import fipaos.parser.acl.bitefficient.BinNumber;
import fipaos.parser.acl.bitefficient.DecoderCodetable;
import fipaos.parser.acl.util.ByteArray;
import fipaos.util.URL;
import fipaos.util.UTCContainer;
import fipaos.util.UTCDuration;
import fipaos.util.UTCTime;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class ACLInputStream
extends BufferedInputStream
implements ACLConstants {
    private static ACLPerformatives as;
    private DecoderCodetable ct;
    private BinNumber bn = new BinNumber();
    private int size;
    private ByteArray ba = new ByteArray();
    private ByteArray bb = new ByteArray(32);
    private ACL m;
    private int coding;
    private ExprParser ex = new ExprParser();
    byte[] _b = new byte[3];

    public ACLInputStream(InputStream inputStream) {
        super(inputStream);
        this.coding = -6;
        this.initialize(8);
    }

    public ACLInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.coding = -5;
        this.initialize(n);
    }

    public ACLInputStream(InputStream inputStream, int n, DecoderCodetable decoderCodetable) {
        super(inputStream);
        this.coding = -5;
        this.size = n;
        this.initialize(this.size);
        this.ct = decoderCodetable;
    }

    public void initialize(int n) {
        this.ct = this.coding == -6 ? null : new DecoderCodetable(n);
        this.size = n;
        this.m = new ACL();
        as = new ACLPerformatives();
    }

    public DecoderCodetable getCodeTable() {
        return this.ct;
    }

    public ACL readMsg() throws IOException, BEParseException {
        this.m = new ACL();
        if (this.getCoding(this.getByte()) < 0) {
            throw new BEParseException("Unsupported coding", null);
        }
        if (this.getVersion(this.getByte()) < 0) {
            throw new BEParseException("Unsupported version", null);
        }
        if (this.getType(this.getByte()) < 0) {
            throw new BEParseException("Unsupported type", null);
        }
        while (this.getMsgParam() != -1) {
        }
        return this.m;
    }

    private int getCoding(byte by) {
        return by < -6 || by > -4 ? -1 : 0;
    }

    private int getVersion(byte by) {
        return by != 16 ? -1 : 0;
    }

    private int getType(byte by) throws BEParseException {
        if (by == -1) {
            return -1;
        }
        if (by == 0) {
            throw new BEParseException("Can t handle user defined performatives", null);
        }
        this.m.setPerformative(as.getCAString(by));
        return 0;
    }

    private int getMsgParam() throws IOException, BEParseException {
        byte by = this.getByte();
        switch (by) {
            case 1: {
                return -1;
            }
            case 2: {
                this.m.setSenderAID(this.getAID());
                return 0;
            }
            case 3: {
                this.getReceivers();
                return 0;
            }
            case 4: {
                this.m.setContentObject((String)this.getParamX());
                return 0;
            }
            case 5: {
                this.m.setReplyWith(this.getParam());
                return 0;
            }
            case 6: {
                UTCContainer uTCContainer = null;
                String string = this.getParam();
                try {
                    uTCContainer = new UTCDuration(string);
                }
                catch (Throwable throwable) {
                    try {
                        uTCContainer = new UTCTime(string);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                this.m.setReplyByUTC(uTCContainer);
                return 0;
            }
            case 7: {
                this.m.setInReplyTo(this.getParam());
                return 0;
            }
            case 8: {
                this.getRepliesTo();
                return 0;
            }
            case 9: {
                this.m.setLanguage(this.getParam());
                return 0;
            }
            case 11: {
                this.m.setOntology(this.getParam());
                return 0;
            }
            case 12: {
                this.m.setProtocol(this.getParam());
                return 0;
            }
            case 10: {
                this.getParam();
                return 0;
            }
            case 13: {
                this.m.setConversationID(this.getParam());
                return 0;
            }
            case 0: {
                this.getParam();
                this.getParam();
                return 0;
            }
        }
        throw new BEParseException("Unknown component or something like that", null);
    }

    private void getReceivers() throws IOException, BEParseException {
        AgentID agentID;
        while ((agentID = this.getAID()) != null) {
            this.m.addReceiverAID(agentID);
        }
    }

    private void getRepliesTo() throws IOException, BEParseException {
        AgentID agentID;
        while ((agentID = this.getAID()) != null) {
            this.m.addReplyToAID(agentID);
        }
    }

    private AgentID getAID() throws IOException, BEParseException {
        byte by = this.getByte();
        return this.getAID(by);
    }

    private AgentID getAID(byte by) throws IOException, BEParseException {
        byte by2;
        LinkedList<Cloneable> linkedList = new LinkedList<Cloneable>();
        AgentID agentID = new AgentID();
        if (by != 2) {
            if (by == 1) {
                return null;
            }
            throw new BEParseException("not an agent-identifier", null);
        }
        agentID.setName(this.getString());
        while ((by2 = this.getByte()) != 1) {
            switch (by2) {
                case 2: {
                    while ((by2 = this.getByte()) != 1) {
                        linkedList.add(new URL(this.getRealString(by2)));
                    }
                    agentID.setAddresses(linkedList);
                    linkedList = new LinkedList();
                    break;
                }
                case 3: {
                    while ((by2 = this.getByte()) != 1) {
                        linkedList.add(this.getAID(by2));
                    }
                    agentID.setResolvers(linkedList);
                    linkedList = new LinkedList();
                    break;
                }
                case 4: {
                    String string = this.getString();
                    String string2 = this.getString();
                    break;
                }
                default: {
                    throw new BEParseException("Unexpected stuff in agent-identifier", null);
                }
            }
        }
        return agentID;
    }

    private byte getByte() throws IOException {
        return (byte)super.read();
    }

    private int inputCode() throws IOException {
        int n;
        if (this.size > 8) {
            super.read(this._b, 0, 2);
            n = (this._b[1] & 0xFF) + ((this._b[0] & 0xFF) << 8);
        } else {
            byte by = (byte)super.read();
            n = by & 0xFF;
        }
        return n;
    }

    private String getParam() throws IOException {
        return this.ex.toText();
    }

    private Object getParamX() throws IOException {
        return this.ex.toText();
    }

    private String getString() throws IOException {
        byte by = this.getByte();
        return this.getRealString(by);
    }

    private String getRealString(byte by) throws IOException {
        this.ba.reset();
        String string = null;
        int n = 0;
        int n2 = 0;
        switch (by) {
            case 16: 
            case 20: {
                byte by2;
                do {
                    by2 = this.getByte();
                    this.ba.add(by2);
                } while (by2 != 0);
                string = new String(this.ba.get(), 0, this.ba.length()).trim();
                if (this.coding != -5) break;
                this.ct.insert(string);
                break;
            }
            case 17: 
            case 21: {
                string = this.ct.lookup(this.inputCode());
                break;
            }
            case 32: 
            case 34: {
                n = 0;
                while (n < 9) {
                    this.ba.add(this.getByte());
                    ++n;
                }
                string = new BinDate().fromBin(this.ba.get());
                if ((by & 2) == 0) break;
                string = string + (char)this.getByte();
                break;
            }
            case 18: 
            case 19: {
                byte by3;
                this.bb.reset();
                while (((by3 = this.getByte()) & 0xF) != 0) {
                    this.bb.add(by3);
                }
                if (by3 != 0) {
                    this.bb.add(by3);
                }
                string = this.bn.fromBin(this.bb.get());
                break;
            }
            case 22: {
                System.err.println("STR8");
                n2 = this.getByte();
                byte[] byArray = new byte[1024];
                super.read(byArray, 0, n2);
                string = new String(byArray).trim();
                break;
            }
            case 23: {
                n2 = this.inputCode();
                break;
            }
            case 25: {
                break;
            }
            case 24: {
                System.err.println("BLE's NOT IMPELMENTED YET");
                throw new IOException("BLE's NOT IMPELMENTED YET");
            }
            default: {
                new Integer(0);
                throw new IOException("Unknown field: " + Integer.toHexString(by));
            }
        }
        return string;
    }

    private class ExprParser {
        int level;
        StringBuffer sb = new StringBuffer(256);

        public String toText() throws IOException {
            byte by;
            this.sb.delete(0, this.sb.length());
            this.level = 0;
            boolean bl = true;
            while ((by = ACLInputStream.this.getByte()) != -1) {
                if (by >= 64 && by < 96) {
                    this.sb.append(')');
                    this.sb.append(' ');
                    if (--this.level == 0) {
                        return this.sb.toString();
                    }
                    by = (byte)(by & 0xFFFFFFBF);
                } else if (by >= 96 && by < 128) {
                    this.sb.append(' ');
                    this.sb.append('(');
                    ++this.level;
                    by = (byte)(by & 0xFFFFFF9F);
                }
                if (by == 0) continue;
                if (!bl) {
                    this.sb.append(' ');
                } else {
                    bl = false;
                }
                this.sb.append(ACLInputStream.this.getRealString(by));
                if (this.level != 0) continue;
                return this.sb.toString();
            }
            return this.sb.toString();
        }
    }
}

