/*
 * Decompiled with CFR 0.152.
 */
package fipaos.parser.acl.bitefficient;

import fipaos.ont.fipa.ACL;
import fipaos.parser.acl.bitefficient.ACLEncoder;
import fipaos.parser.acl.bitefficient.EncoderCodetable;
import fipaos.parser.acl.util.ByteArray;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ACLOutputStream
extends BufferedOutputStream {
    private ACLEncoder e;
    private ByteArray ba;

    public ACLOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.initialize(0);
    }

    public ACLOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.initialize(n);
    }

    public EncoderCodetable getCodeTable() {
        return this.e.getCodeTable();
    }

    public void initialize(int n) {
        this.e = new ACLEncoder(n);
        this.ba = new ByteArray();
    }

    public void write(ACL aCL) throws IOException {
        this.ba = this.e.encode(aCL);
        super.write(this.ba.get(), 0, this.ba.length());
        super.flush();
    }

    public void write(ACL aCL, byte by) throws IOException {
        this.ba = this.e.encode(aCL, by);
        super.write(this.ba.get(), 0, this.ba.length());
        super.flush();
    }
}

