/*
 * Decompiled with CFR 0.152.
 */
package fipaos.parser.acl.bitefficient;

import fipaos.parser.acl.bitefficient.BinRep;
import fipaos.parser.acl.util.ByteArray;

public class BinNumber
extends BinRep {
    private static final byte TT_INT = 0;
    private static final byte TT_FLOAT = 1;
    private Integer iNumber;
    private Float fNumber;
    private ByteArray ba = new ByteArray(32);
    byte tag;

    public BinNumber() {
    }

    public BinNumber(Integer n) {
        this.iNumber = n;
        this.tag = 0;
    }

    public BinNumber(Float f) {
        this.fNumber = f;
        this.tag = 1;
    }

    public BinNumber(byte[] byArray) {
        String string = this.fromBin(byArray);
        this.tag = 0;
        int n = 0;
        while (n < string.length() && this.tag == 0) {
            if (string.charAt(n) == 'e' || string.charAt(n) == '.') {
                this.tag = 1;
            }
            ++n;
        }
        if (this.tag == 0) {
            this.iNumber = new Integer(string.trim());
        } else {
            this.fNumber = new Float(string);
        }
    }

    public Object value() {
        return this.tag == 0 ? (Number)this.iNumber : (Number)this.fNumber;
    }

    public ByteArray toBin(ByteArray byteArray) {
        int n = byteArray.length();
        byte[] byArray = byteArray.get();
        this.ba.reset();
        int n2 = 0;
        while (n2 < n) {
            byte by = (byte)(BinRep.encode(byArray[n2]) << 4);
            by = n2 + 1 < n ? (byte)(by | BinRep.encode(byArray[n2 + 1]) & 0xF) : (byte)(by | 0);
            this.ba.add(by);
            n2 += 2;
        }
        boolean bl = false;
        if (n % 2 == 0) {
            this.ba.add((byte)0);
        }
        return this.ba;
    }

    public ByteArray toBin(String string) {
        int n = string.length();
        boolean bl = false;
        this.ba.reset();
        int n2 = 0;
        while (n2 < n) {
            byte by = (byte)(BinRep.encode(string.charAt(n2)) << 4);
            by = n2 + 1 < n ? (byte)(by | BinRep.encode(string.charAt(n2 + 1)) & 0xF) : (byte)(by | 0);
            this.ba.add(by);
            n2 += 2;
        }
        if (n % 2 == 0) {
            this.ba.add((byte)0);
        }
        return this.ba;
    }

    public String fromBin(byte[] byArray) {
        char[] cArray = new char[64];
        int n = 0;
        int n2 = 0;
        while ((byArray[n] & 0xF) != 0) {
            cArray[n2] = (char)BinRep.decode(byArray[n] >> 4 & 0xF);
            cArray[n2 + 1] = (char)BinRep.decode(byArray[n] & 0xF);
            n2 += 2;
            ++n;
        }
        if (byArray[n] != 0) {
            cArray[n2] = (char)BinRep.decode(byArray[n] >> 4 & 0xF);
        }
        return new String(cArray).trim();
    }

    public ByteArray fromBin(ByteArray byteArray) {
        this.ba.reset();
        byte[] byArray = byteArray.get();
        int n = 0;
        while ((byArray[n] & 0xF) != 0) {
            this.ba.add(BinRep.decode(byArray[n] >> 4 & 0xF));
            this.ba.add(BinRep.decode(byArray[n] & 0xF));
            ++n;
        }
        if (byArray[n] != 0) {
            this.ba.add(BinRep.decode(byArray[n] >> 4 & 0xF));
        }
        return this.ba;
    }

    public static void main(String[] stringArray) {
        BinNumber binNumber = new BinNumber();
        ByteArray byteArray = binNumber.toBin("11");
        ByteArray byteArray2 = new ByteArray();
        byteArray2.add((byte)34);
        byteArray2.add((byte)0);
        ByteArray byteArray3 = binNumber.fromBin(byteArray2);
        char[] cArray = new char[byteArray3.length()];
        byte[] byArray = byteArray3.get();
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = (char)byArray[n];
            ++n;
        }
    }
}

