/*
 * Decompiled with CFR 0.152.
 */
package fipaos.parser.acl.bitefficient;

public class DecoderCodetable {
    private int first;
    private int last;
    private int nextFree;
    private int nextCode;
    private int size;
    private int cleanSize;
    private int used;
    private boolean useTableCodes;
    private boolean useLRU;
    private Entry[] dict;

    public DecoderCodetable(int n) {
        this.initialize(n > 16 ? 16 : (n < 8 ? 8 : n));
    }

    private void initialize(int n) {
        this.size = 2 << n - 1;
        this.nextCode = 0;
        this.last = 0;
        this.first = 0;
        this.nextFree = -1;
        this.useTableCodes = false;
        this.used = this.cleanSize = this.size >> 3;
        this.dict = new Entry[this.size + 1];
        int n2 = 0;
        while (n2 < this.size + 1) {
            this.dict[n2] = new Entry();
            ++n2;
        }
    }

    private void doLRU() {
        this.nextFree = this.first;
        int n = this.first;
        int n2 = 0;
        while (n2 < this.cleanSize) {
            this.dict[n].str = null;
            this.first = n = this.dict[n].next;
            ++n2;
        }
        this.used = this.cleanSize;
        this.nextCode = this.nextFree;
        this.nextFree = this.dict[this.nextFree].next;
        this.useLRU = false;
    }

    public String lookup(int n) {
        String string = this.dict[n].str;
        if (n == this.last) {
            return string;
        }
        if (n == this.first) {
            if (this.dict[this.first].prev != -1) {
                this.dict[this.dict[this.first].prev].next = this.dict[this.first].next;
            }
            if (this.dict[this.first].next != -1) {
                this.dict[this.dict[this.first].next].prev = this.dict[this.first].prev;
            }
            this.first = this.dict[n].next;
        }
        if (this.dict[n].prev != -1) {
            this.dict[this.dict[n].prev].next = this.dict[n].next;
        }
        if (this.dict[n].next != -1) {
            this.dict[this.dict[n].next].prev = this.dict[n].prev;
        }
        this.dict[this.last].next = n;
        this.dict[n].prev = this.last;
        this.last = n;
        return string;
    }

    public int insert(String string) {
        if (this.useLRU) {
            this.doLRU();
        }
        this.dict[this.nextCode].str = string;
        if (this.useTableCodes) {
            --this.used;
        }
        if (this.nextCode != this.last) {
            this.dict[this.last].next = this.nextCode;
            this.dict[this.nextCode].next = 0;
            this.dict[this.nextCode].prev = this.last;
            this.last = this.nextCode;
        }
        if (this.first == 0) {
            this.first = this.last;
        }
        if (this.nextFree == -1) {
            ++this.nextCode;
        }
        if (!this.useTableCodes && this.nextCode <= this.size) {
            return this.last;
        }
        this.useLRU = false;
        if (this.used == 0 || this.nextFree == -1) {
            this.useLRU = true;
            this.useTableCodes = true;
        }
        this.nextCode = this.nextFree;
        this.nextFree = this.useLRU ? -1 : this.dict[this.nextFree].next;
        return this.last;
    }

    private class Entry {
        String str = null;
        int prev = -1;
        int next = -1;
    }
}

