/*
 * Decompiled with CFR 0.152.
 */
package fipaos.parser.acl.bitefficient;

public class EncoderCodetable {
    private Entry[] ct;
    private Entry first;
    private Entry last;
    private final int[] primes = new int[]{263, 523, 1049, 2087, 4157, 8291, 16481, 32801, 65677};
    private int[] codes;
    private int size;
    private int current;
    private int cleanSize;
    private int nextCode;
    private int maxCode;
    private int hashSize;
    private boolean useTableCodes = false;

    public EncoderCodetable(int n) {
        this.initialize(n > 16 ? 16 : (n < 8 ? 8 : n));
    }

    private void initialize(int n) {
        this.size = 2 << n - 1;
        this.current = this.cleanSize = this.size >> 3;
        this.nextCode = 0;
        this.maxCode = this.size;
        this.codes = new int[this.size];
        this.last = null;
        this.first = null;
        this.hashSize = this.primes[n - 8];
        this.ct = new Entry[this.hashSize];
        int n2 = 0;
        while (n2 < this.hashSize) {
            this.ct[n2] = null;
            ++n2;
        }
    }

    private int nextAvailableCode() {
        if (!this.useTableCodes && this.nextCode <= this.maxCode) {
            return this.nextCode++;
        }
        if (this.current == this.cleanSize) {
            this.doLRU();
        }
        return this.codes[this.current++];
    }

    private void doLRU() {
        Entry entry = this.first;
        int n = 0;
        while (n < this.cleanSize) {
            this.codes[n] = entry.code;
            entry.inUse = false;
            entry.str = null;
            Entry entry2 = entry;
            entry.prev = null;
            entry = entry.next;
            entry2.next = null;
            entry2.prev = null;
            this.first = entry;
            ++n;
        }
        this.useTableCodes = true;
        this.current = 0;
    }

    private void moveLast(Entry entry) {
        if (entry == this.last) {
            return;
        }
        if (entry == this.first) {
            this.first = entry.next;
        } else if (entry.prev != null) {
            entry.prev.next = entry.next;
        }
        if (entry.next != null) {
            entry.next.prev = entry.prev;
        }
        this.last.next = entry;
        entry.prev = this.last;
        entry.next = null;
        this.last = entry;
    }

    public int insert(String string) {
        int n = this.hash(string);
        Entry entry = this.pLookup(string, n);
        if (entry != null) {
            this.moveLast(entry);
            return entry.code;
        }
        entry = this.ct[n];
        while (entry != null) {
            if (!entry.inUse) break;
            entry = entry.hNext;
        }
        if (entry == null) {
            entry = new Entry(string, this.nextAvailableCode());
            entry.hNext = this.ct[n];
            this.ct[n] = entry;
        } else {
            entry.code = this.nextAvailableCode();
            entry.str = string;
            entry.inUse = true;
            entry.next = null;
            entry.prev = null;
        }
        if (this.last == null) {
            this.last = this.first = entry;
        } else {
            this.moveLast(entry);
        }
        return entry.code;
    }

    public int lookup(String string) {
        Entry entry = this.pLookup(string, this.hash(string));
        if (entry != null) {
            this.moveLast(entry);
            return entry.code;
        }
        return -1;
    }

    private Entry pLookup(String string, int n) {
        Entry entry = this.ct[n];
        while (entry != null) {
            if (entry.inUse && string.compareTo(entry.str) == 0) {
                return entry;
            }
            entry = entry.hNext;
        }
        return null;
    }

    private int hash(String string) {
        return (string.hashCode() & Integer.MAX_VALUE) % this.hashSize;
    }

    private class Entry {
        int code;
        boolean inUse;
        String str;
        Entry next;
        Entry prev;
        Entry hNext;

        public Entry(String string, int n) {
            this.code = n;
            this.str = string;
            this.inUse = true;
            this.hNext = null;
            this.prev = null;
            this.next = null;
        }
    }
}

