/*
 * Decompiled with CFR 0.152.
 */
package fipaos.parser.acl.string;

import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.parser.ParserException;
import fipaos.parser.datamapping.DataMapper;
import fipaos.parser.datamapping.DataMapperFactory;
import fipaos.util.StringParser;
import fipaos.util.UTCContainer;
import fipaos.util.UTCDuration;
import fipaos.util.UTCTime;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class Parser {
    private static final List PROPERTIES = Arrays.asList("unsturctured", "fipa.acl.rep.string.std", (class$fipaos$ont$fipa$ACL == null ? (class$fipaos$ont$fipa$ACL = Parser.class$("fipaos.ont.fipa.ACL")) : class$fipaos$ont$fipa$ACL).getName());
    private static DataMapper __instance = new DataMapperImpl();
    static /* synthetic */ Class class$fipaos$ont$fipa$ACL;

    public static ACL parse(byte[] byArray) throws ParserException {
        ACL aCL = new ACL();
        String string = new String(byArray);
        try {
            string = StringParser.trimBrackets(string);
            String string2 = Parser.getUpToNextWhitespace(string);
            aCL.setPerformative(string2);
            int n = string2.length();
            string = string.substring(n).trim();
            while (string.length() > 0) {
                if (!string.startsWith(":")) {
                    throw new ParserException("\":<slot-name>\" expected, found \"" + string.substring(0, 10) + "...\"");
                }
                String string3 = Parser.getUpToNextWhitespace(string);
                string = string.substring(string3.length()).trim();
                String string4 = Parser.getSlotValue(string);
                string = string.substring(string4.length()).trim();
                Parser.insertValueIntoACL(aCL, string3, string4);
            }
        }
        catch (ParserException parserException) {
            throw parserException;
        }
        catch (Throwable throwable) {
            int n = string.length();
            String string5 = string.substring(n < 20 ? n : 20) + "...";
            throw new ParserException("Unexpected exception during parsing - reached \"" + string5 + "\": " + throwable.toString());
        }
        return aCL;
    }

    private static void insertValueIntoACL(ACL aCL, String string, String string2) throws ParserException {
        if (string.equalsIgnoreCase(":content")) {
            aCL.setContentObjectACLParser(string2);
        } else if (string.equalsIgnoreCase("Content-encoding")) {
            aCL.setContentEncoding(string2);
        } else if (string.equalsIgnoreCase(":conversation-id")) {
            aCL.setConversationID(string2);
        } else if (string.equalsIgnoreCase(":in-reply-to")) {
            aCL.setInReplyTo(string2);
        } else if (string.equalsIgnoreCase(":reply-with")) {
            aCL.setReplyWith(string2);
        } else if (string.equalsIgnoreCase(":language")) {
            aCL.setLanguage(string2);
        } else if (string.equalsIgnoreCase(":ontology")) {
            aCL.setOntology(string2);
        } else if (string.equalsIgnoreCase(":protocol")) {
            aCL.setProtocol(string2);
        } else if (string.equalsIgnoreCase(":receiver")) {
            aCL.setReceiverAIDs(AgentID.getAgentIDs(string2));
        } else if (string.equalsIgnoreCase(":reply-by")) {
            UTCContainer uTCContainer = null;
            uTCContainer = string2.startsWith("+") ? new UTCDuration(string2) : new UTCTime(string2);
            aCL.setReplyByUTC(uTCContainer);
        } else if (string.equalsIgnoreCase(":reply-to")) {
            aCL.setReplyToAIDs(AgentID.getAgentIDs(string2));
        } else if (string.equalsIgnoreCase(":sender")) {
            aCL.setSenderAID(new AgentID(string2));
        } else {
            aCL.setUserSlot(string.substring(1), string2);
        }
    }

    public static String getUpToNextWhitespace(String string) {
        char[] cArray = new char[]{' ', '\t', '\r', '\n'};
        int n = string.length();
        int n2 = 0;
        while (n2 < cArray.length) {
            int n3 = string.indexOf(cArray[n2]);
            if (n3 > -1 && n3 < n) {
                n = n3;
            }
            ++n2;
        }
        return string.substring(0, n);
    }

    private static String getSlotValue(String string) throws NumberFormatException {
        String string2 = null;
        char c = string.trim().charAt(0);
        if (c == '#') {
            int n = string.indexOf("#");
            int n2 = string.indexOf(34);
            int n3 = Integer.parseInt(string.substring(n + 1, n2));
            string2 = string.substring(0, n2 + n3 + 1);
        } else if (c == '\"') {
            int n = string.indexOf(34, 1);
            while (n > 0 && string.charAt(n - 1) == '\\') {
                n = string.indexOf(34, n + 1);
            }
            string2 = string.substring(0, n + 1);
        } else {
            string2 = c == '(' ? StringParser.getBracketedExpression(0, string) : Parser.getUpToNextWhitespace(string);
        }
        return string2;
    }

    public static byte[] deparse(ACL aCL) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(aCL.getPerformative());
        stringBuffer.append(" ");
        if (aCL.getSenderAID() != null) {
            Parser.addWithSpaces(stringBuffer, ":sender", aCL.getSenderAID().toString());
        }
        stringBuffer.append(":receiver");
        stringBuffer.append(" ");
        stringBuffer.append("( ");
        stringBuffer.append("set");
        Iterator iterator = aCL.getReceiverAIDs().iterator();
        while (iterator.hasNext()) {
            object = iterator.next().toString();
            stringBuffer.append(" ");
            stringBuffer.append((String)object);
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
        stringBuffer.append(" ");
        if (aCL.getReplyToAIDs() != null && aCL.getReplyToAIDs().size() > 0) {
            stringBuffer.append(":reply-to");
            stringBuffer.append(" ");
            stringBuffer.append("( ");
            stringBuffer.append("set");
            iterator = aCL.getReplyToAIDs().iterator();
            while (iterator.hasNext()) {
                object = iterator.next().toString();
                stringBuffer.append(" ");
                stringBuffer.append((String)object);
                stringBuffer.append(" ");
            }
            stringBuffer.append(")");
            stringBuffer.append(" ");
        }
        if (aCL.getContentObject(false) != null) {
            object = aCL.getContentObject(false).toString();
            if (aCL.getLanguage() != null && aCL.getLanguage().toLowerCase().startsWith("fipa-sl") && aCL.isBracketsStripped()) {
                object = "(" + (String)object + ")";
            }
            if (!aCL.isEncoded()) {
                switch (aCL.getEncoding()) {
                    case 1: {
                        object = Parser.stringLiteralEncode((String)object);
                        break;
                    }
                    case 2: {
                        object = Parser.byteLengthEncode((String)object);
                        break;
                    }
                }
            }
            Parser.addWithSpaces(stringBuffer, ":content", (String)object);
        }
        if (aCL.getReplyWith() != null) {
            Parser.addWithSpaces(stringBuffer, ":reply-with", aCL.getReplyWith());
        }
        if (aCL.getReplyByUTC() != null) {
            Parser.addWithSpaces(stringBuffer, ":reply-by", aCL.getReplyByUTC().toString());
        }
        if (aCL.getInReplyTo() != null) {
            Parser.addWithSpaces(stringBuffer, ":in-reply-to", aCL.getInReplyTo());
        }
        if (aCL.getLanguage() != null) {
            Parser.addWithSpaces(stringBuffer, ":language", aCL.getLanguage());
        }
        if (aCL.getOntology() != null) {
            Parser.addWithSpaces(stringBuffer, ":ontology", aCL.getOntology());
        }
        if (aCL.getProtocol() != null) {
            Parser.addWithSpaces(stringBuffer, ":protocol", aCL.getProtocol());
        }
        if (aCL.getConversationID() != null) {
            Parser.addWithSpaces(stringBuffer, ":conversation-id", aCL.getConversationID());
        }
        if (aCL.getUserSlots().size() > 0) {
            object = aCL.getUserSlots().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                Parser.addWithSpaces(stringBuffer, ':' + string, aCL.getUserSlot(string));
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString().getBytes();
    }

    public static String stringLiteralEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\\"", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\"")) {
                stringBuffer.append('\\');
                stringBuffer.append('\"');
                continue;
            }
            if (string2.equals("\\")) {
                stringBuffer.append('\\');
                stringBuffer.append('\\');
                continue;
            }
            stringBuffer.append(string2);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static String stringLiteralDecode(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.indexOf(34);
        if (n2 == (n = string.lastIndexOf(34))) {
            return string;
        }
        string = string.substring(n2 + 1, n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\\"", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\\")) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("\"")) {
                    stringBuffer.append('\"');
                    continue;
                }
                if (string3.equals("\\")) {
                    stringBuffer.append('\\');
                    continue;
                }
                stringBuffer.append(string2);
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String byteLengthEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#");
        stringBuffer.append(string.length());
        stringBuffer.append('\"');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String byteLengthDecode(String string) {
        int n = -1;
        int n2 = string.indexOf("#");
        int n3 = string.indexOf(34);
        try {
            n = Integer.parseInt(string.substring(n2 + 1, n3));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string2 = string.substring(n3 + 1);
        if (string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private static void addWithSpaces(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
    }

    public static void main(String[] stringArray) throws Throwable {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = bufferedReader.readLine();
        System.err.print("Parsing input...");
        ACL aCL = Parser.parse(string.getBytes());
        System.err.println("OK\n\n");
        System.err.println(aCL);
        System.err.print("\nDeparsing, reparsing and deparsing...");
        String string2 = new String(Parser.deparse(Parser.parse(Parser.deparse(aCL))));
        System.err.println("OK\n\n");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DataMapperFactory.register(new DataMapperFactory.Creator(){

            public DataMapper createDataMapper(String string, String string2, String string3) {
                return null;
            }

            public DataMapper createDataMapper(List list) {
                DataMapper dataMapper = null;
                if (PROPERTIES.containsAll(list)) {
                    dataMapper = __instance;
                }
                return dataMapper;
            }
        });
    }

    private static class DataMapperImpl
    implements DataMapper {
        private DataMapperImpl() {
        }

        public String marshall(Object object) throws ParserException {
            try {
                return new String(Parser.deparse((ACL)object));
            }
            catch (Throwable throwable) {
                throw new ParserException(throwable);
            }
        }

        public Object unmarshall(String string) throws ParserException {
            try {
                return Parser.parse(string.getBytes());
            }
            catch (Throwable throwable) {
                throw new ParserException(throwable);
            }
        }
    }
}

