/*
 * Decompiled with CFR 0.152.
 */
package fipaos.parser.acl.util;

public class ByteArray {
    private byte[] data;
    private int alloc;
    private int used;
    private static final int grow_size = 100;
    private static final int def_initsize = 100;

    public ByteArray() {
        this.initialize(100);
    }

    public ByteArray(int n) {
        this.initialize(n);
    }

    public void reset() {
        this.used = 0;
    }

    public int length() {
        return this.used;
    }

    public byte[] get() {
        return this.data;
    }

    public ByteArray add(byte by) {
        this.data[this.used++] = by;
        if (this.used == this.alloc) {
            this.grow(100);
        }
        return this;
    }

    public ByteArray addToPos(byte by, int n) {
        if (n >= this.alloc) {
            this.grow(n + 1);
        }
        if (n > this.used) {
            this.used = n + 1;
        }
        this.data[n] = by;
        return this;
    }

    public ByteArray add(byte[] byArray, int n) {
        if (this.used + n >= this.alloc) {
            this.grow(n + 100);
        }
        System.arraycopy(byArray, 0, this.data, this.used, n);
        this.used += n;
        return this;
    }

    public ByteArray add(ByteArray byteArray) {
        return this.add(byteArray.get(), byteArray.length());
    }

    private void grow(int n) {
        this.alloc += n;
        byte[] byArray = new byte[this.alloc];
        System.arraycopy(this.data, 0, byArray, 0, this.used);
        this.data = byArray;
    }

    private void initialize(int n) {
        this.data = new byte[n];
        this.alloc = n;
        this.used = 0;
    }
}

