/*
 * Decompiled with CFR 0.152.
 */
package fipaos.parser.rdf;

import fipaos.agent.conversation.content.Content;
import fipaos.parser.Parser;
import fipaos.parser.xml.XMLContentHandler;
import fipaos.util.Comparators;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.w3c.rdf.Literal;
import org.w3c.rdf.Property;
import org.w3c.rdf.RDFSource;
import org.w3c.rdf.RDFnode;
import org.w3c.rdf.Resource;
import org.w3c.rdf.SiRPAC;
import org.w3c.rdf.Triple;

public class RDFContentHandler
implements Parser {
    public static final String RDF_HEADER = "rdf:RDF";
    public static final String STARTTAG = "<";
    public static final String ENDTAG = ">";
    public static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-16\" ?>\n\n<rdf:RDF xml:lang=\"en\" ";
    public static final String FOOTER = "</rdf:RDF>";
    public static final String RDFSYNTAX = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String RDFSCHEMA = "http://www.w3.org/1999/02/PR-rdf-schema-19990303#";
    public static final String RDFABOUT = "rdf:about";
    public static final String RDFRESOURCE = "rdf:resource";
    public static final String RDF = "rdf";
    public static final String RDFS = "rdfs";
    public static final String RDFNAME = "xmlns:rdf=";
    public static final String RDFSNAME = "xmlns:rdfs=";
    public static final String XMLNS = "xmlns:";
    public static final String PARSE_TYPE_LITERAL = " parseType=\"Literal\"";
    private RDFDocument _document;

    public RDFContentHandler() {
        RDFDocument rDFDocument = new RDFDocument();
    }

    public Content parse(String string) {
        SiRPAC siRPAC;
        block3: {
            siRPAC = null;
            Object var3_3 = null;
            String string2 = System.getProperty("fipaos.parser.xmlparser", "org.apache.xerces.parsers.SAXParser");
            try {
                siRPAC = new SiRPAC(string2);
                siRPAC.fetchSchemas(false);
                siRPAC.setRDFSource(new RDFSource(string));
                siRPAC.fetchRDF();
            }
            catch (Throwable throwable) {
                if (siRPAC != null) break block3;
                return null;
            }
        }
        String string3 = siRPAC.errors();
        if (string3 != null && string3.length() > 0) {
            return null;
        }
        return RDFContentHandler.createContent(siRPAC.triples());
    }

    public String deparse(Content content) {
        Object object;
        Iterator iterator;
        Object object2;
        LinkedList linkedList = new LinkedList();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        RDFDocument rDFDocument = new RDFDocument();
        linkedList = this.getTriples(linkedList, content);
        Hashtable hashtable = new Hashtable();
        hashtable.put("\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"", RDF);
        hashtable.put("\"http://www.w3.org/1999/02/PR-rdf-schema-19990303#\"", RDFS);
        String string = null;
        String string2 = null;
        ListIterator listIterator = linkedList.listIterator();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = 0;
        while (listIterator.hasNext()) {
            object2 = (Content)listIterator.next();
            string6 = ((Content)object2).getName();
            Set set = ((Content)object2).getAttributeNames();
            iterator = set.iterator();
            int n2 = set.size() + 1;
            object = new LinkedList();
            LinkedList<String> linkedList3 = new LinkedList<String>();
            while (iterator.hasNext()) {
                Object object3;
                Object object4;
                ++n;
                string5 = (String)iterator.next();
                Object object5 = ((Content)object2).getAttribute(string5);
                String string7 = rDFDocument.getNameSpaceURI(string5);
                if (object5 instanceof Content) {
                    object4 = (Content)object5;
                    string4 = ((Content)object4).getName();
                    object3 = null;
                    String string8 = null;
                    if (this.isURI(string4)) {
                        object3 = rDFDocument.getSubString(string4);
                        string8 = rDFDocument.getNameSpaceURI(string4);
                    }
                    if (this.isOuterTag(string7)) {
                        hashtable = rDFDocument.makeNameSpace(hashtable, string8, n);
                        string3 = rDFDocument.getNameSpace(hashtable, string8);
                        string = this.createOuterTag(string3, string6, string5, (String)object3);
                        string2 = rDFDocument.getEndTag(string);
                        ((LinkedList)object).add(0, string);
                        continue;
                    }
                    if (this.isMiddleTag(string6, string4)) {
                        hashtable = rDFDocument.makeNameSpace(hashtable, string7, n);
                        string3 = rDFDocument.getNameSpace(hashtable, string7);
                        string = this.createMiddleTag(string3, string6, string5, string4);
                        linkedList3.addLast(string);
                        continue;
                    }
                    hashtable = rDFDocument.makeNameSpace(hashtable, string7, n);
                    string3 = rDFDocument.getNameSpace(hashtable, string7);
                    string = this.createInnerTag(string3, string6, string5, string4);
                    linkedList3.addFirst(string);
                    continue;
                }
                if (object5 instanceof List) {
                    object4 = (List)object5;
                    object3 = object4.iterator();
                    int n3 = 0;
                    while (object3.hasNext()) {
                        ++n3;
                        Object e = object3.next();
                        if (e instanceof Content) {
                            Content content2 = (Content)e;
                            string4 = content2.getName();
                            String string9 = null;
                            String string10 = null;
                            if (this.isURI(string4)) {
                                string9 = rDFDocument.getSubString(string4);
                                string10 = rDFDocument.getNameSpaceURI(string4);
                            }
                            if (this.isOuterTag(string7)) {
                                hashtable = rDFDocument.makeNameSpace(hashtable, string10, n);
                                string3 = rDFDocument.getNameSpace(hashtable, string10);
                                string = this.createOuterTag(string3, string6, string5, string9);
                                string2 = rDFDocument.getEndTag(string);
                                ((LinkedList)object).add(0, string);
                                continue;
                            }
                            if (!this.isMiddleTag(string6, string4)) continue;
                            hashtable = rDFDocument.makeNameSpace(hashtable, string7, n);
                            string3 = rDFDocument.getNameSpace(hashtable, string7);
                            string = this.createMiddleTag(string3, string6, string5, string4);
                            linkedList3.addLast(string);
                            continue;
                        }
                        if (!this.isObjectPrimitive(e)) continue;
                        hashtable = rDFDocument.makeNameSpace(hashtable, string7, n);
                        string3 = rDFDocument.getNameSpace(hashtable, string7);
                        string4 = this.primitiveToString(e);
                        string = this.createInnerTag(string3, string6, string5, string4);
                        linkedList3.addFirst(string);
                    }
                    continue;
                }
                hashtable = rDFDocument.makeNameSpace(hashtable, string7, n);
                string3 = rDFDocument.getNameSpace(hashtable, string7);
                string4 = this.primitiveToString(object5);
                string = this.createInnerTag(string3, string6, string5, string4);
                linkedList3.addFirst(string);
            }
            ((LinkedList)object).addAll(linkedList3);
            if (string2 != null) {
                ((LinkedList)object).addLast(string2);
            }
            linkedList2.addLast(object);
        }
        object2 = new StringBuffer();
        iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof String) {
                ((StringBuffer)object2).append((String)e);
            } else if (e instanceof LinkedList) {
                object = ((LinkedList)e).iterator();
                while (object.hasNext()) {
                    ((StringBuffer)object2).append((String)object.next());
                    ((StringBuffer)object2).append("\n");
                }
            } else if (e instanceof Content) {
                ((StringBuffer)object2).append(((Content)e).toString());
            }
            ((StringBuffer)object2).append("\n");
        }
        object = new StringBuffer();
        ((StringBuffer)object).append(HEADER);
        ((StringBuffer)object).append(rDFDocument.makeNameSpaceHeader(hashtable));
        ((StringBuffer)object).append("\n");
        ((StringBuffer)object).append(object2);
        ((StringBuffer)object).append(FOOTER);
        return ((StringBuffer)object).toString();
    }

    public LinkedList getTriples(LinkedList linkedList, Content content) {
        String string = content.getName();
        Set set = content.getAttributeNames();
        Iterator iterator = set.iterator();
        Content content2 = new Content();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object object = content.getAttribute(string2);
            if (object instanceof Content) {
                content2 = (Content)object;
                if (linkedList.contains(content2) || content2.getAttributeNames().isEmpty()) continue;
                linkedList.addLast(content2);
                this.getTriples(linkedList, content2);
                continue;
            }
            if (!(object instanceof List)) continue;
            List list = (List)object;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (!(e instanceof Content) || linkedList.contains(content2 = (Content)e)) continue;
                linkedList.addLast(content2);
                this.getTriples(linkedList, content2);
            }
        }
        return linkedList;
    }

    public boolean canParse(String string) {
        return XMLContentHandler.isXML(string) && RDFContentHandler.isRDF(string);
    }

    public String getParserType() {
        return "FIPA-RDF";
    }

    public static boolean isRDF(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>", true);
        while (!bl && !bl2 && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals(STARTTAG)) continue;
            String string3 = stringTokenizer.nextToken();
            if (!bl3) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                bl3 = true;
                continue;
            }
            if (!string3.startsWith("--") || !string3.endsWith("--")) {
                if (string3.startsWith(RDF_HEADER)) {
                    bl = true;
                    continue;
                }
                bl2 = true;
                continue;
            }
            stringTokenizer.nextToken();
        }
        return bl;
    }

    private static Content createContent(Enumeration enumeration) {
        TreeMap treeMap = new TreeMap(Comparators.STRING_COMPARE);
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            Triple triple = (Triple)enumeration.nextElement();
            RDFContentHandler.dealWithTriple(triple, treeMap, vector);
        }
        RDFContentHandler.remove(treeMap, vector);
        return new Content(treeMap);
    }

    private static void dealWithTriple(Triple triple, Map map, Vector vector) {
        Resource resource = triple.subject();
        RDFnode rDFnode = triple.object();
        Property property = triple.predicate();
        Content content = null;
        Object object = null;
        content = RDFContentHandler.getContent(resource.toString(), map);
        if (RDFContentHandler.isPrimitive(rDFnode)) {
            object = RDFContentHandler.getPrimitive(rDFnode);
        } else {
            object = RDFContentHandler.getContent(rDFnode.toString(), map);
            if (!vector.contains(rDFnode.toString())) {
                vector.addElement(rDFnode.toString());
            }
        }
        content.addAttribute(property.toString(), object);
    }

    private static boolean isPrimitive(Object object) {
        return RDFContentHandler.getPrimitive(object) != null;
    }

    private static Object getPrimitive(Object object) {
        if (object instanceof Literal) {
            try {
                Long l = new Long(object.toString());
                return l;
            }
            catch (Exception exception) {
                try {
                    Double d = new Double(object.toString());
                    return d;
                }
                catch (Exception exception2) {
                    return object.toString();
                }
            }
        }
        return null;
    }

    private static Content getContent(String string, Map map) {
        if (map.containsKey(string)) {
            return (Content)map.get(string);
        }
        Content content = new Content(string);
        map.put(string, content);
        return content;
    }

    private static void remove(Map map, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            map.remove(string);
        }
    }

    private boolean isObjectPrimitive(Object object) {
        boolean bl = false;
        if (this.primitiveToString(object) != null) {
            bl = true;
        }
        return bl;
    }

    private String primitiveToString(Object object) {
        String string = null;
        Object object2 = null;
        if (object instanceof Long) {
            object2 = new Long((Long)object);
            string = object2.toString();
        } else if (object instanceof Double) {
            object2 = new Double((Double)object);
            string = object2.toString();
        } else if (object instanceof String) {
            object2 = new String((String)object);
            string = (String)object2;
        } else {
            string = null;
        }
        return string;
    }

    private String createInnerTag(String string, String string2, String string3, String string4) {
        String string5 = "inner";
        RDFDocument rDFDocument = new RDFDocument();
        String string6 = rDFDocument.makeTag(string5, string, string2, string3, string4);
        return string6;
    }

    private boolean isOuterTag(String string) {
        boolean bl = false;
        if (string.equals("\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"")) {
            bl = true;
        }
        return bl;
    }

    private String createOuterTag(String string, String string2, String string3, String string4) {
        String string5 = "outer";
        RDFDocument rDFDocument = new RDFDocument();
        String string6 = rDFDocument.makeTag(string5, string, string2, string3, string4);
        return string6;
    }

    private boolean isMiddleTag(String string, String string2) {
        boolean bl = false;
        if (!string.equals(string2)) {
            bl = true;
        } else if (string2.indexOf("\"http://www.w3.org/1999/02/PR-rdf-schema-19990303#\"") != -1) {
            bl = true;
        }
        return bl;
    }

    private String createMiddleTag(String string, String string2, String string3, String string4) {
        RDFDocument rDFDocument = new RDFDocument();
        String string5 = "middle";
        String string6 = rDFDocument.makeTag(string5, string, string2, string3, string4);
        return string6;
    }

    private boolean isURI(String string) {
        boolean bl = false;
        if (string.indexOf("http://") != -1) {
            bl = true;
        }
        return bl;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length <= 0) {
            System.exit(-10);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
        StringBuffer stringBuffer = new StringBuffer();
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        String string2 = stringBuffer.toString();
        RDFContentHandler rDFContentHandler = new RDFContentHandler();
        Content content = rDFContentHandler.parse(string2);
        String string3 = rDFContentHandler.deparse(content);
    }

    static {
        Hashtable hashtable = new Hashtable();
    }

    public class RDFDocument {
        public String getDocument(String string, Vector vector) {
            return null;
        }

        private String makeTag(String string, String string2, String string3, String string4, String string5) {
            String string6 = null;
            String string7 = null;
            String string8 = null;
            string8 = this.getSubString(string4);
            if (string.equals("outer")) {
                string6 = string5.startsWith("http://") ? this.getSubString(string5) : string5;
                string7 = this.getOuterTag(string2, string6, string3, RDFContentHandler.RDFABOUT);
            } else {
                string7 = string.equals("middle") ? this.getMiddleTag(string2, string8, string5, RDFContentHandler.RDFRESOURCE) : this.getInnerTag(string2, string8, string5);
            }
            return string7;
        }

        private String getMiddleTag(String string, String string2, String string3, String string4) {
            String string5 = RDFContentHandler.STARTTAG + string + ":" + string2 + " " + string4 + "=" + "\"" + string3 + "\"" + "/" + RDFContentHandler.ENDTAG;
            return string5;
        }

        private String getInnerTag(String string, String string2, String string3) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(RDFContentHandler.STARTTAG);
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append(string2);
            stringBuffer.append(RDFContentHandler.ENDTAG);
            String string4 = stringBuffer.toString();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(string4);
            stringBuffer2.append(XMLContentHandler.getNormalisedForm(string3));
            stringBuffer2.append(this.getEndTag(string4));
            return stringBuffer2.toString();
        }

        private String getOuterTag(String string, String string2, String string3, String string4) {
            String string5 = RDFContentHandler.STARTTAG + string + ":" + string2 + " " + string4 + "=" + "\"" + string3 + "\"" + RDFContentHandler.ENDTAG;
            return string5;
        }

        private String getSubString(String string) {
            String string2 = string.substring(string.indexOf("#") + 1, string.length());
            return string2;
        }

        private String getNameSpaceURI(String string) {
            String string2 = "\"" + string.substring(0, string.indexOf("#") + 1) + "\"";
            return string2;
        }

        private String getEndTag(String string) {
            int n = string.length() - 1;
            int n2 = string.indexOf(RDFContentHandler.RDFABOUT);
            int n3 = string.indexOf(" ");
            if (n2 != -1) {
                n = n3;
            }
            String string2 = "</" + string.substring(1, n) + RDFContentHandler.ENDTAG;
            return string2;
        }

        private String getNameSpace(Hashtable hashtable, String string) {
            String string2 = (String)hashtable.get(string);
            return string2;
        }

        private Hashtable makeNameSpace(Hashtable hashtable, String string, int n) {
            if (!hashtable.containsKey(string) && string != null) {
                String string2 = "ns" + n;
                hashtable.put(string, string2);
            }
            return hashtable;
        }

        private String makeNameSpaceHeader(Hashtable hashtable) {
            StringBuffer stringBuffer = new StringBuffer();
            Set set = hashtable.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)hashtable.get(string);
                stringBuffer.append(RDFContentHandler.XMLNS);
                stringBuffer.append(string2);
                stringBuffer.append("=");
                stringBuffer.append(string);
                if (!iterator.hasNext()) continue;
                stringBuffer.append("\n");
            }
            stringBuffer.append(RDFContentHandler.ENDTAG);
            return stringBuffer.toString();
        }
    }
}

