/*
 * Decompiled with CFR 0.152.
 */
package fipaos.parser.xml;

import fipaos.agent.conversation.content.Content;
import fipaos.parser.Parser;
import fipaos.parser.rdf.RDFContentHandler;
import fipaos.util.DocumentRetriever;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserFactory;

public class XMLContentHandler
implements Parser,
EntityResolver,
DTDHandler,
ErrorHandler,
DocumentHandler {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-16\" ?>\n";
    public static final String XML_TAG_OPEN = "<";
    public static final String XML_TAG_OPEN_END = "</";
    public static final String XML_TAG_CLOSE = ">\n";
    public static final String XML_TAG_CLOSE_END = "/>\n";
    public static final String XML_ATTR_OPEN = "=\"";
    public static final String XML_ATTR_CLOSE = "\"";
    public static final String XML_CDATA_START = "<![CDATA[";
    public static final String XML_CDATA_CLOSE = "]]>";
    public static final String XML_CDATA_CLOSE_REPLACE = "]]&gt;";
    public static final String XML_DTD_START = "<!DOCTYPE ";
    public static final String XML_DTD_MIDDLE = " SYSTEM \"";
    public static final String XML_DTD_END = "\">\n";
    public static final String XML_SPACE = " ";
    private Content _root;
    private Stack _content_stack;

    public String deparse(Content content) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(XML_HEADER);
            String string = (String)content.getAttribute("dtd-doctype");
            String string2 = (String)content.getAttribute("dtd-system");
            if (string != null && string2 != null) {
                stringBuffer.append(XML_DTD_START);
                stringBuffer.append(string);
                stringBuffer.append(XML_DTD_MIDDLE);
                stringBuffer.append(string2);
                stringBuffer.append(XML_DTD_END);
            }
            stringBuffer.append(XMLContentHandler.deparseContent(content, ""));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public Content parse(String string) {
        Content content = null;
        try {
            XMLContentHandler xMLContentHandler = this;
            synchronized (xMLContentHandler) {
                String string2 = System.getProperty("fipaos.parser.xmlparser", "org.apache.xerces.parsers.SAXParser");
                org.xml.sax.Parser parser = ParserFactory.makeParser(string2);
                parser.setDocumentHandler(this);
                parser.setEntityResolver(this);
                parser.setErrorHandler(this);
                parser.setDTDHandler(this);
                InputSource inputSource = new InputSource(new StringReader(string));
                inputSource.setSystemId("");
                parser.parse(inputSource);
                content = this._root;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return content;
    }

    public boolean canParse(String string) {
        boolean bl = XMLContentHandler.isXML(string) && !RDFContentHandler.isRDF(string);
        return bl;
    }

    public String getParserType() {
        return "FIPA-XML";
    }

    public static boolean isXML(String string) {
        String string2 = string.trim();
        int n = string2.indexOf(XML_HEADER);
        return n == 0;
    }

    private static Object getPrimitive(String string) {
        Object object = string;
        try {
            object = new Long(string);
        }
        catch (Exception exception) {
            try {
                object = new Double(string);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return object;
    }

    private static String deparseContent(Content content, String string) {
        CharSequence charSequence;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = string + "\t";
        Iterator iterator = content.getAttributeNames().iterator();
        while (iterator.hasNext()) {
            charSequence = (String)iterator.next();
            Object object = content.getAttribute((String)charSequence);
            if (object instanceof Content) {
                stringBuffer2.append(XMLContentHandler.deparseContent((Content)object, string2));
                continue;
            }
            if (object instanceof List) {
                Iterator iterator2 = ((List)object).iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (e instanceof Content) {
                        stringBuffer2.append(XMLContentHandler.deparseContent((Content)e, string2));
                        continue;
                    }
                    stringBuffer.append(XML_SPACE);
                    stringBuffer.append((String)charSequence);
                    stringBuffer.append(XML_ATTR_OPEN);
                    stringBuffer.append(e.toString());
                    stringBuffer.append(XML_ATTR_CLOSE);
                }
                continue;
            }
            if (((String)charSequence).equals("xml_tag_content") && object != null && object.toString().length() != 0) {
                stringBuffer2.append(XMLContentHandler.getNormalisedForm(object.toString()));
                stringBuffer2.append("\n");
                continue;
            }
            stringBuffer.append(XML_SPACE);
            stringBuffer.append((String)charSequence);
            stringBuffer.append(XML_ATTR_OPEN);
            stringBuffer.append(object.toString());
            stringBuffer.append(XML_ATTR_CLOSE);
        }
        charSequence = new StringBuffer();
        if (!content.getName().equalsIgnoreCase("root")) {
            ((StringBuffer)charSequence).append(string);
            ((StringBuffer)charSequence).append(XML_TAG_OPEN);
            ((StringBuffer)charSequence).append(content.getName());
            ((StringBuffer)charSequence).append((Object)stringBuffer);
            if (stringBuffer2.length() == 0) {
                ((StringBuffer)charSequence).append(XML_TAG_CLOSE_END);
            } else {
                ((StringBuffer)charSequence).append(XML_TAG_CLOSE);
                ((StringBuffer)charSequence).append((Object)stringBuffer2);
                ((StringBuffer)charSequence).append(string);
                ((StringBuffer)charSequence).append(XML_TAG_OPEN_END);
                ((StringBuffer)charSequence).append(content.getName());
                ((StringBuffer)charSequence).append(XML_TAG_CLOSE);
            }
        } else {
            ((StringBuffer)charSequence).append((Object)stringBuffer2);
        }
        return ((StringBuffer)charSequence).toString();
    }

    public static String getNormalisedForm(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            char c2 = c;
            if (c2 == '\t') {
                stringBuffer.append("&#9;");
            } else if (c2 == '\n') {
                stringBuffer.append("&#10;");
            } else if (c2 == '\r') {
                stringBuffer.append("&#13;");
            } else if (c2 == '\"') {
                stringBuffer.append("&quot;");
            } else if (c2 == '<') {
                stringBuffer.append("&lt;");
            } else if (c2 == '>') {
                stringBuffer.append("&gt;");
            } else if (c2 == '&') {
                stringBuffer.append("&amp;");
            } else if (c2 >= ' ' && c2 <= '\ud7ff') {
                stringBuffer.append(c);
            } else if (c2 >= '\ue000' && c2 <= '\ufffd') {
                stringBuffer.append(c);
            } else if (c2 >= '\u10000' && c2 <= '\u10ffff') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("&#" + c2 + ';');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        try {
            String string3 = DocumentRetriever.getDoc(string2);
            if (string3 == null) {
                return null;
            }
            InputSource inputSource = new InputSource(new StringReader(string3));
            inputSource.setPublicId(string);
            inputSource.setSystemId(string2);
            return inputSource;
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this._root = new Content("Root");
        this._content_stack = new Stack();
        this._content_stack.push(this._root);
    }

    public void endDocument() throws SAXException {
        this._content_stack = null;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        Content content = new Content(string);
        Content content2 = (Content)this._content_stack.peek();
        content2.addAttribute(string, content);
        this._content_stack.push(content);
        int n = 0;
        while (n < attributeList.getLength()) {
            String string2 = attributeList.getName(n);
            String string3 = attributeList.getValue(n);
            content.addAttribute(string2, XMLContentHandler.getPrimitive(string3));
            ++n;
        }
    }

    public void endElement(String string) throws SAXException {
        Content content = (Content)this._content_stack.peek();
        if (content.getName().equals(string)) {
            this._content_stack.pop();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Content content = (Content)this._content_stack.peek();
        String string = "xml_tag_content";
        String string2 = new String(cArray, n, n2).trim();
        if (string2.length() > 0) {
            content.setAttribute(string, XMLContentHandler.getPrimitive(string2));
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "select clip, price, year, region, name, summary, comments, pid, food, special, grape from Product where (((type = 'red') and (price <= 31) and (country Like '%France%')and(region Like '%%%') and (lighttofull = 3) and (drytosweet = 3))) ORDER BY price DESC";
    }
}

