/*
 * Decompiled with CFR 0.152.
 */
package fipaos.platform;

import fipaos.agent.FIPAOSAgent;
import fipaos.agent.FIPAOSAgentComponentFactory;
import fipaos.agent.conversation.Conversation;
import fipaos.agent.profile.AgentProfile;
import fipaos.agent.profile.PlatformProfile;
import fipaos.agent.task.Task;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentManagementAction;
import fipaos.platform.ams.DeregisterTask;
import fipaos.platform.ams.GetDescriptionTask;
import fipaos.platform.ams.ModifyTask;
import fipaos.platform.ams.RegisterTask;
import fipaos.platform.ams.SearchTask;
import fipaos.skill.db.Database;
import fipaos.skill.db.DatabaseFactory;

public class AgentManagementSystem
extends FIPAOSAgent {
    private static final String DB_NAME = "ams_directory";
    private Database _ams_database;

    public AgentManagementSystem(PlatformProfile platformProfile, AgentProfile agentProfile, String string, String string2) {
        super(platformProfile, agentProfile, string, string2, true);
        this.init(string);
    }

    public AgentManagementSystem(String string, String string2, String string3) {
        super(string, string2, string3, true);
        this.init(string2);
    }

    protected AgentManagementSystem(PlatformProfile platformProfile, AgentProfile agentProfile, String string, String string2, FIPAOSAgentComponentFactory fIPAOSAgentComponentFactory) {
        super(platformProfile, agentProfile, string, string2, true, fIPAOSAgentComponentFactory);
        this.init(string);
    }

    private void init(String string) {
        try {
            this._ams_database = DatabaseFactory.getDatabase(string + "_db", this.getProfile().getDatabaseProfile());
            this._ams_database.openDatabase();
        }
        catch (Throwable throwable) {
            return;
        }
        this.setListenerTask(new IdleTask());
    }

    public void shutdown() {
        super.shutdown();
        if (this._ams_database != null) {
            try {
                this._ams_database.closeDatabase();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public class IdleTask
    extends Task {
        public void startTask() {
        }

        public void handleRequest(Conversation conversation) {
            ACL aCL = conversation.getACL(conversation.getLatestMessageIndex());
            if (aCL.getOntology() == null || !aCL.getOntology().equalsIgnoreCase("fipa-agent-management")) {
                this.sendNotUnderstood(aCL);
                return;
            }
            if (aCL.getLanguage() == null || !aCL.getLanguage().equalsIgnoreCase("FIPA-SL0")) {
                this.sendNotUnderstood(aCL);
                return;
            }
            try {
                String string;
                Object object = aCL.getContentObject();
                AgentManagementAction agentManagementAction = null;
                if (object instanceof AgentManagementAction) {
                    agentManagementAction = (AgentManagementAction)object;
                } else if (object instanceof String) {
                    string = (String)object;
                    agentManagementAction = new AgentManagementAction(string);
                } else {
                    this.sendNotUnderstood(aCL);
                    return;
                }
                string = agentManagementAction.getAction();
                if (string.equals("register")) {
                    this.newTask(new RegisterTask(conversation, agentManagementAction, AgentManagementSystem.this._ams_database));
                } else if (string.equals("deregister")) {
                    this.newTask(new DeregisterTask(conversation, agentManagementAction, AgentManagementSystem.this._ams_database));
                } else if (string.equals("modify")) {
                    this.newTask(new ModifyTask(conversation, agentManagementAction, AgentManagementSystem.this._ams_database));
                } else if (string.equals("search")) {
                    this.newTask(new SearchTask(conversation, agentManagementAction, AgentManagementSystem.this._ams_database));
                } else if (string.equals("get-description")) {
                    this.newTask(new GetDescriptionTask(conversation, agentManagementAction, AgentManagementSystem.this._ams_database));
                } else {
                    this.sendNotUnderstood(aCL);
                }
            }
            catch (Throwable throwable) {
                this.sendNotUnderstood(aCL);
            }
        }

        public void doneRegisterTask(Task task) {
        }

        public void doneDeregisterTask(Task task) {
        }

        public void doneModifyTask(Task task) {
        }

        public void doneSearchTask(Task task) {
        }

        public void doneGetDescriptionTask(Task task) {
        }

        public void errorRegisterTask(Task task, Throwable throwable) {
        }

        public void errorDeregisterTask(Task task, Throwable throwable) {
        }

        public void errorModifyTask(Task task, Throwable throwable) {
        }

        public void errorSearchTask(Task task, Throwable throwable) {
        }

        public void errorGetDescriptionTask(Task task, Throwable throwable) {
        }
    }
}

