/*
 * Decompiled with CFR 0.152.
 */
package fipaos.platform;

import fipaos.FIPAOSFactory;
import fipaos.agent.FIPAOSAgent;
import fipaos.agent.FIPAOSAgentComponentFactory;
import fipaos.agent.conversation.Conversation;
import fipaos.agent.profile.AgentProfile;
import fipaos.agent.profile.PlatformProfile;
import fipaos.agent.task.Task;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.AgentManagementAction;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.ont.fipa.fipaman.ServiceDescription;
import fipaos.platform.ams.AMSRegistrationException;
import fipaos.platform.df.DFCrossPlatformRegistrationFrame;
import fipaos.platform.df.DFRegistrationException;
import fipaos.platform.df.DFSubscriptionFactory;
import fipaos.platform.df.DeregisterTask;
import fipaos.platform.df.ModifyTask;
import fipaos.platform.df.RegisterTask;
import fipaos.platform.df.SearchTask;
import fipaos.platform.df.SubscriptionManager;
import fipaos.skill.db.Database;
import fipaos.skill.db.DatabaseFactory;
import javax.swing.UIManager;

public class DirectoryFacilitator
extends FIPAOSAgent {
    private Database _df_database;
    private DFCrossPlatformRegistrationFrame _frame;
    public SubscriptionManager _subs_manager;

    public DirectoryFacilitator(String string, String string2, String string3) {
        super(string, string2, string3);
        this.init(string2);
    }

    protected DirectoryFacilitator(PlatformProfile platformProfile, AgentProfile agentProfile, String string, String string2, FIPAOSAgentComponentFactory fIPAOSAgentComponentFactory) {
        super(platformProfile, agentProfile, string, string2, true, fIPAOSAgentComponentFactory);
        this.init(string);
    }

    public DirectoryFacilitator(PlatformProfile platformProfile, AgentProfile agentProfile, String string, String string2) {
        super(platformProfile, agentProfile, string, string2, true);
        this.init(string);
    }

    private void init(String string) {
        block12: {
            String string2;
            block11: {
                try {
                    this._df_database = DatabaseFactory.getDatabase(string + "_db", this.getProfile().getDatabaseProfile());
                    this._df_database.openDatabase();
                }
                catch (Throwable throwable) {
                    return;
                }
                this.setListenerTask(new IdleTask());
                try {
                    this.registerWithAMS();
                }
                catch (AMSRegistrationException aMSRegistrationException) {
                    string2 = aMSRegistrationException.getExceptionReason();
                    if (string2 != null && string2.equals("already-registered")) break block11;
                    return;
                }
            }
            if (!string.equals("df")) {
                try {
                    this.registerWithDF("fipa-df");
                }
                catch (DFRegistrationException dFRegistrationException) {
                    string2 = dFRegistrationException.getExceptionReason();
                    if (string2 != null && string2.equals("already-registered")) break block12;
                    return;
                }
            }
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this._frame = new DFCrossPlatformRegistrationFrame(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void shutdown() {
        if (this._frame != null) {
            try {
                this._frame.dispose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.registeredWithAMS()) {
            try {
                this.deregisterWithAMS();
            }
            catch (AMSRegistrationException aMSRegistrationException) {
                String string = aMSRegistrationException.getExceptionReason();
            }
        }
        super.shutdown();
        if (this._df_database != null) {
            try {
                this._df_database.closeDatabase();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void activate() {
        if (this._frame != null) {
            this._frame.setVisible(true);
        }
    }

    public boolean registerWithRemoteDF(AgentID agentID) throws DFRegistrationException {
        this.registerWithDF(agentID, "fipa-df");
        return true;
    }

    public boolean registerRemoteDF(AgentID agentID) {
        boolean bl = false;
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        ServiceDescription serviceDescription = new ServiceDescription();
        serviceDescription.setServiceType("fipa-df");
        serviceDescription.setServiceName("fipa-df");
        dFAgentDescription.setAgentName(agentID);
        dFAgentDescription.setAgentServices(new ServiceDescription[]{serviceDescription});
        try {
            this._df_database.startTransaction(false);
            this._df_database.addObject(dFAgentDescription);
            bl = true;
            AgentManagementAction agentManagementAction = new AgentManagementAction();
            agentManagementAction.setAction("register");
            agentManagementAction.setAgentID(this.getAID());
            agentManagementAction.setDFAgentDescription(dFAgentDescription);
            this._subs_manager.DFUpdate(agentManagementAction);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                this._df_database.endTransaction();
            }
            catch (Throwable throwable2) {
                bl = false;
            }
            throw throwable;
        }
    }

    public class IdleTask
    extends Task {
        static /* synthetic */ Class class$fipaos$platform$df$DFSubscriptionFactory;

        public void startTask() {
            DFSubscriptionFactory dFSubscriptionFactory = (DFSubscriptionFactory)FIPAOSFactory.getFactoryInstance(class$fipaos$platform$df$DFSubscriptionFactory == null ? (class$fipaos$platform$df$DFSubscriptionFactory = IdleTask.class$("fipaos.platform.df.DFSubscriptionFactory")) : class$fipaos$platform$df$DFSubscriptionFactory);
            DirectoryFacilitator.this._subs_manager = dFSubscriptionFactory.getSubscriptionManager();
            this.newTask((Task)((Object)DirectoryFacilitator.this._subs_manager));
        }

        public void handleRequest(Conversation conversation) {
            ACL aCL = conversation.getACL(conversation.getLatestMessageIndex());
            if (aCL.getOntology() == null || !aCL.getOntology().equalsIgnoreCase("fipa-agent-management")) {
                this.sendNotUnderstood(aCL);
                return;
            }
            if (aCL.getLanguage() == null || !aCL.getLanguage().equalsIgnoreCase("FIPA-SL0")) {
                this.sendNotUnderstood(aCL);
                return;
            }
            try {
                String string;
                Object object = aCL.getContentObject();
                AgentManagementAction agentManagementAction = null;
                if (object instanceof AgentManagementAction) {
                    agentManagementAction = (AgentManagementAction)object;
                } else if (object instanceof String) {
                    string = (String)object;
                    agentManagementAction = new AgentManagementAction(string);
                } else {
                    this.sendNotUnderstood(aCL);
                    return;
                }
                string = agentManagementAction.getAction();
                if (string.equals("register")) {
                    this.newTask(new RegisterTask(conversation, agentManagementAction, DirectoryFacilitator.this._df_database));
                } else if (string.equals("deregister")) {
                    this.newTask(new DeregisterTask(conversation, agentManagementAction, DirectoryFacilitator.this._df_database));
                } else if (string.equals("modify")) {
                    this.newTask(new ModifyTask(conversation, agentManagementAction, DirectoryFacilitator.this._df_database));
                } else if (string.equals("search")) {
                    this.newTask(new SearchTask(conversation, agentManagementAction, DirectoryFacilitator.this._df_database));
                } else {
                    this.sendNotUnderstood(aCL);
                }
            }
            catch (Throwable throwable) {
                this.sendNotUnderstood(aCL);
            }
        }

        public void handleOther(Conversation conversation) {
            DirectoryFacilitator.this._subs_manager.handleOther(conversation);
        }

        public void doneRegisterTask(Task task) {
        }

        public void doneDeregisterTask(Task task) {
        }

        public void doneModifyTask(Task task) {
        }

        public void doneSearchTask(Task task) {
        }

        public void errorRegisterTask(Task task, Throwable throwable) {
        }

        public void errorDeregisterTask(Task task, Throwable throwable) {
        }

        public void errorModifyTask(Task task, Throwable throwable) {
        }

        public void errorSearchTask(Task task, Throwable throwable) {
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

