/*
 * Decompiled with CFR 0.152.
 */
package fipaos.platform.ams;

import fipaos.agent.conversation.Conversation;
import fipaos.agent.task.Task;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AMSAgentDescription;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.AgentManagementAction;
import fipaos.ont.fipa.fipaman.AgentManagementException;

public class AMSRegistrationTask
extends Task {
    private AgentID _ams;
    private String _state;

    public AMSRegistrationTask() {
        this((AgentID)null);
    }

    public AMSRegistrationTask(AgentID agentID) {
        this(agentID, "active");
    }

    public AMSRegistrationTask(String string) {
        this((AgentID)null, string);
    }

    public AMSRegistrationTask(AgentID agentID, String string) {
        this._state = string;
        this._ams = agentID;
    }

    public void startTask() {
        if (this._ams == null) {
            this._ams = this._owner.getLocalAMSAID();
        }
        AgentID agentID = this._owner.getAID();
        ACL aCL = this.getNewConversation("fipa-request");
        aCL.setReceiverAID(this._ams);
        aCL.setOntology("fipa-agent-management");
        aCL.setLanguage("FIPA-SL0");
        aCL.setPerformative("request");
        AMSAgentDescription aMSAgentDescription = new AMSAgentDescription();
        aMSAgentDescription.setAgentID(agentID);
        aMSAgentDescription.setState(this._state);
        aMSAgentDescription.setOwnership(this._owner.getOwnership());
        AgentManagementAction agentManagementAction = new AgentManagementAction();
        agentManagementAction.setAction("register");
        agentManagementAction.setAgentID(this._ams);
        agentManagementAction.setAMSAgentDescription(aMSAgentDescription);
        aCL.setContentObject(agentManagementAction);
        this.forward(aCL);
    }

    public void handleNotUnderstood(Conversation conversation) {
        ACL aCL = conversation.getACL(conversation.getLatestMessageIndex());
        AgentID agentID = aCL.getSenderAID();
        this.done(new Object[]{agentID, "not-understood"});
    }

    public void handleRefuse(Conversation conversation) {
        ACL aCL = conversation.getACL(conversation.getLatestMessageIndex());
        AgentID agentID = aCL.getSenderAID();
        String string = new String();
        Object object = aCL.getContentObject();
        try {
            if (object instanceof String) {
                AgentManagementException agentManagementException = new AgentManagementException((String)object);
                if (agentManagementException.getException() != null) {
                    string = agentManagementException.getException();
                }
            } else if (object instanceof AgentManagementException) {
                string = ((AgentManagementException)object).getException();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.done(new Object[]{agentID, string});
    }

    public void handleAgree(Conversation conversation) {
    }

    public void handleFailure(Conversation conversation) {
        ACL aCL = conversation.getACL(conversation.getLatestMessageIndex());
        AgentID agentID = aCL.getSenderAID();
        String string = new String();
        Object object = aCL.getContentObject();
        try {
            if (object instanceof String) {
                AgentManagementException agentManagementException = new AgentManagementException((String)object);
                if (agentManagementException.getException() != null) {
                    string = agentManagementException.getException();
                }
            } else if (object instanceof AgentManagementException) {
                string = ((AgentManagementException)object).getException();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.done(new Object[]{agentID, string});
    }

    public void handleInform(Conversation conversation) {
        ACL aCL = conversation.getACL(conversation.getLatestMessageIndex());
        AgentID agentID = aCL.getSenderAID();
        this.done(agentID);
    }
}

