/*
 * Decompiled with CFR 0.152.
 */
package fipaos.platform.ams;

import fipaos.FIPAOSFactory;
import fipaos.agent.conversation.Conversation;
import fipaos.agent.profile.ACCProfile;
import fipaos.agent.profile.ExternalAddress;
import fipaos.agent.profile.PlatformProfile;
import fipaos.agent.task.Task;
import fipaos.mts.TransportProvider;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AMSAgentDescription;
import fipaos.ont.fipa.fipaman.APDescription;
import fipaos.ont.fipa.fipaman.APTDescription;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.AgentManagementAction;
import fipaos.ont.fipa.fipaman.AgentManagementException;
import fipaos.ont.fipa.fipaman.AgentManagementResult;
import fipaos.ont.fipa.fipaman.MTPDescription;
import fipaos.skill.db.Database;
import fipaos.util.Comparators;
import fipaos.util.FlagHandler;
import fipaos.util.URL;
import fipaos.util.XMLDataBinding;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class AMSTask
extends Task {
    private static final String IDLE = "IDLE";
    private static final String BUSY = "BUSY";
    private static final String NO_MSG_SENT = "no-messages-sent";
    private static final String AGREE_MSG = "agree-message-sent";
    private static final String INFORM_MSG = "inform-message-sent";
    private static final String REFUSE_MSG = "refuse-message-sent";
    private static final String FAILURE_MSG = "failure-message-sent";
    private static final String NOT_UND_MSG = "not-understood-message-sent";
    private FlagHandler _state;
    protected ACL _acl;
    protected Database _ams_db;
    protected Conversation _conv;
    protected AgentManagementAction _ama;
    static /* synthetic */ Class class$fipaos$mts$TransportProvider;

    public AMSTask(Conversation conversation, AgentManagementAction agentManagementAction, Database database) {
        this._conv = conversation;
        this._ama = agentManagementAction;
        this._ams_db = database;
        this._acl = this._conv.getACL(0);
        this._state = new FlagHandler();
        this._state.addFlag(IDLE, BUSY);
        this._state.addFlag(BUSY, IDLE);
        this._state.addFlag(NO_MSG_SENT);
        this._state.addFlag(AGREE_MSG, NO_MSG_SENT);
        this._state.addFlag(INFORM_MSG, AGREE_MSG);
        this._state.addFlag(REFUSE_MSG, NO_MSG_SENT);
        this._state.addFlag(FAILURE_MSG, NO_MSG_SENT);
        this._state.addFlag(NOT_UND_MSG, NO_MSG_SENT);
        this._state.setFlag(IDLE);
    }

    protected boolean isRegistered(AMSAgentDescription aMSAgentDescription) {
        AgentID agentID = aMSAgentDescription.getAgentID();
        return this.isRegistered(agentID);
    }

    protected boolean isRegistered(AgentID agentID) {
        return this.getRegistered(agentID) != null;
    }

    protected AMSAgentDescription getRegistered(AgentID agentID) {
        AMSAgentDescription aMSAgentDescription = null;
        try {
            this._ams_db.startTransaction(true);
            aMSAgentDescription = (AMSAgentDescription)this._ams_db.findObject(agentID.getName());
            return aMSAgentDescription;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this._ams_db.endTransaction();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean register(AMSAgentDescription aMSAgentDescription) {
        boolean bl = false;
        try {
            this._ams_db.startTransaction(false);
            this._ams_db.addObject(aMSAgentDescription);
            bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this._ams_db.endTransaction();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean deregister(AMSAgentDescription aMSAgentDescription) {
        boolean bl = false;
        try {
            this._ams_db.startTransaction(false);
            this._ams_db.removeObject(aMSAgentDescription);
            bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this._ams_db.endTransaction();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean sendAgree() {
        boolean bl = false;
        try {
            Conversation conversation = this._owner.getCurrentConversation(this._conv.getConversationID());
            List list = conversation.getNextPerformatives();
            if (list == null || list.contains("agree")) {
                ACL aCL = (ACL)this._acl.clone();
                aCL.setPerformative("agree");
                aCL.setReceiverAID(aCL.getSenderAID());
                aCL.setSenderAID(this._owner.getAID());
                aCL.setInReplyTo(aCL.getReplyWith());
                aCL.setReplyWith(null);
                this.forward(aCL);
                this._state.setFlag(AGREE_MSG);
                bl = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected boolean sendRefuse(String string) {
        boolean bl = false;
        try {
            ACL aCL = (ACL)this._acl.clone();
            AgentManagementException agentManagementException = new AgentManagementException(this._ama, string);
            aCL.setPerformative("refuse");
            aCL.setReceiverAID(aCL.getSenderAID());
            aCL.setSenderAID(this._owner.getAID());
            aCL.setInReplyTo(aCL.getReplyWith());
            aCL.setReplyWith(null);
            aCL.setContentObject(agentManagementException);
            this.forward(aCL);
            this._state.setFlag(REFUSE_MSG);
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected boolean sendFailure(String string) {
        boolean bl = false;
        try {
            ACL aCL = (ACL)this._acl.clone();
            AgentManagementException agentManagementException = new AgentManagementException(this._ama, string);
            aCL.setPerformative("failure");
            aCL.setReceiverAID(aCL.getSenderAID());
            aCL.setSenderAID(this._owner.getAID());
            aCL.setInReplyTo(aCL.getReplyWith());
            aCL.setReplyWith(null);
            aCL.setContentObject(agentManagementException);
            this.forward(aCL);
            this._state.setFlag(FAILURE_MSG);
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected boolean sendInformDone() {
        boolean bl = false;
        try {
            ACL aCL = (ACL)this._acl.clone();
            aCL.setPerformative("inform");
            aCL.setReceiverAID(aCL.getSenderAID());
            aCL.setSenderAID(this._owner.getAID());
            aCL.setInReplyTo(aCL.getReplyWith());
            aCL.setReplyWith(null);
            aCL.setContentObject("(done " + this._ama.toString() + ")");
            this.forward(aCL);
            this._state.setFlag(INFORM_MSG);
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected boolean sendInformResult(Set set) {
        boolean bl = false;
        try {
            ACL aCL = (ACL)this._acl.clone();
            AgentManagementResult agentManagementResult = new AgentManagementResult();
            agentManagementResult.setAgentManagementAction(this._ama);
            agentManagementResult.setResultSet(set);
            aCL.setPerformative("inform");
            aCL.setReceiverAID(aCL.getSenderAID());
            aCL.setSenderAID(this._owner.getAID());
            aCL.setInReplyTo(aCL.getReplyWith());
            aCL.setReplyWith(null);
            aCL.setContentObject(agentManagementResult);
            this.forward(aCL);
            this._state.setFlag(INFORM_MSG);
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected boolean sendPlatformProfile() {
        boolean bl = false;
        try {
            Object object;
            Cloneable cloneable;
            Object object2;
            TreeSet<Object> treeSet = new TreeSet<Object>(Comparators.OBJECT_COMPARE);
            PlatformProfile platformProfile = this._owner.getPlatformProfile();
            ACCProfile aCCProfile = (ACCProfile)XMLDataBinding.unmarshallFile(new File(platformProfile.getProfileDirectory(), "acc.profile"));
            APTDescription aPTDescription = new APTDescription();
            List list = aCCProfile.getExternalAddresss();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    object2 = (ExternalAddress)iterator.next();
                    cloneable = new URL(object2.getAddress());
                    object = (TransportProvider)FIPAOSFactory.getFactoryInstance(class$fipaos$mts$TransportProvider == null ? AMSTask.class$("fipaos.mts.TransportProvider") : class$fipaos$mts$TransportProvider);
                    String string = ((TransportProvider)object).getMTPProfileName(((URL)cloneable).getProtocol());
                    if (string == null) continue;
                    MTPDescription mTPDescription = new MTPDescription();
                    mTPDescription.addAddress((URL)cloneable);
                    mTPDescription.setMTPName(string);
                    aPTDescription.addMTPD(mTPDescription);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            object2 = new APDescription();
            ((APDescription)object2).setName(platformProfile.getHAPName());
            ((APDescription)object2).setDynamic(new Boolean(platformProfile.getDynamic()));
            ((APDescription)object2).setMobility(new Boolean(platformProfile.getMobility()));
            ((APDescription)object2).setTransportDescription(aPTDescription);
            treeSet.add(object2);
            cloneable = (ACL)this._acl.clone();
            object = new AgentManagementResult();
            ((AgentManagementResult)object).setAgentManagementAction(this._ama);
            ((AgentManagementResult)object).setResultSet(treeSet);
            ((ACL)cloneable).setPerformative("inform");
            ((ACL)cloneable).setReceiverAID(((ACL)cloneable).getSenderAID());
            ((ACL)cloneable).setSenderAID(this._owner.getAID());
            ((ACL)cloneable).setInReplyTo(((ACL)cloneable).getReplyWith());
            ((ACL)cloneable).setReplyWith(null);
            ((ACL)cloneable).setContentObject(object);
            this.forward((ACL)cloneable);
            this._state.setFlag(INFORM_MSG);
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected void clearMessageFlags() {
        this._state.clearFlag(AGREE_MSG);
        this._state.clearFlag(INFORM_MSG);
        this._state.clearFlag(FAILURE_MSG);
        this._state.clearFlag(REFUSE_MSG);
        this._state.clearFlag(NOT_UND_MSG);
        this._state.setFlag(NO_MSG_SENT);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

