/*
 * Decompiled with CFR 0.152.
 */
package fipaos.platform.df;

import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.platform.DirectoryFacilitator;
import fipaos.platform.df.DFRegistrationException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;

public class DFCrossPlatformRegistrationFrame
extends JFrame {
    private DirectoryFacilitator _parent;
    private List _registered = new LinkedList();
    private JButton _register;
    private JTextField jTextField1;
    private JList jList1;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JButton _add;
    private JPanel jPanel1;

    public DFCrossPlatformRegistrationFrame(DirectoryFacilitator directoryFacilitator) {
        this();
        this._parent = directoryFacilitator;
        this.setTitle("DF Cross Registration GUI (" + directoryFacilitator.getAID().getName() + ")");
    }

    private DFCrossPlatformRegistrationFrame() {
        this.initComponents();
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (n < 320) {
            n = 320;
        }
        if (n2 < 240) {
            n2 = 240;
        }
        this.setSize(n, n2);
        n = toolkit.getScreenSize().width - n;
        n2 = toolkit.getScreenSize().height - n2;
        this.setLocation(n / 2, n2 / 2);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jList1 = new JList();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this._register = new JButton();
        this._add = new JButton();
        this.jLabel2 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("images/logo.gif")).getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DFCrossPlatformRegistrationFrame.this.exitForm(windowEvent);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new TitledBorder("Remote DF's Succesfully Registered With"));
        this.jPanel1.add((Component)this.jList1, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setText("Remote DF Name");
        this.jLabel1.setForeground(Color.black);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextField1, gridBagConstraints);
        this._register.setText("Register this DF with Remote DF");
        this._register.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFCrossPlatformRegistrationFrame.this.jButton1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this._register, gridBagConstraints);
        this._add.setText("Add Remote DF to directory");
        this._add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFCrossPlatformRegistrationFrame.this._addActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this._add, gridBagConstraints);
        this.jLabel2.setText(" ");
        this.jLabel2.setBorder(new SoftBevelBorder(1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
    }

    private void _addActionPerformed(ActionEvent actionEvent) {
        AgentID agentID = this.validateAID();
        if (agentID != null) {
            this.status("Registering \"" + agentID.getName() + "\" with this DF...");
            this._parent.registerRemoteDF(agentID);
            this.status("Registered \"" + agentID.getName() + "\" with this DF OK");
        }
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        final AgentID agentID = this.validateAID();
        if (agentID != null) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        DFCrossPlatformRegistrationFrame.this.status("Registering with \"" + agentID.getName() + "\"...");
                        DFCrossPlatformRegistrationFrame.this._parent.registerWithRemoteDF(agentID);
                        DFCrossPlatformRegistrationFrame.this.status("Registered with \"" + agentID.getName() + "\" OK");
                        DFCrossPlatformRegistrationFrame.this._registered.add(agentID.getName());
                        DFCrossPlatformRegistrationFrame.this.jList1.setListData(DFCrossPlatformRegistrationFrame.this._registered.toArray());
                    }
                    catch (DFRegistrationException dFRegistrationException) {
                        DFCrossPlatformRegistrationFrame.this.status("Registration with \"" + agentID.getName() + "\" failed: " + dFRegistrationException.getExceptionReason());
                    }
                    catch (Throwable throwable) {
                        DFCrossPlatformRegistrationFrame.this.status("Registration with \"" + agentID.getName() + "\" failed: " + throwable);
                    }
                }
            });
            thread.start();
        }
    }

    private void status(String string) {
        this.jLabel2.setText(string);
        this.jLabel2.repaint();
    }

    private AgentID validateAID() {
        String string = this.jTextField1.getText().trim();
        AgentID agentID = null;
        this.status("Validating agent name...");
        try {
            AgentID agentID2 = new AgentID();
            agentID2.setName(string);
            agentID = new AgentID(agentID2.toString());
            this.status("Validated agent name OK");
        }
        catch (Throwable throwable) {
            this.status("Validation of agent name failed");
            JOptionPane.showMessageDialog(this, "Please enter a valid agent name (e.g. of the form \"agent@hap\"");
        }
        return agentID;
    }

    private void exitForm(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public static void main(String[] stringArray) {
        new DFCrossPlatformRegistrationFrame();
    }
}

