/*
 * Decompiled with CFR 0.152.
 */
package fipaos.platform.df;

import fipaos.agent.conversation.Conversation;
import fipaos.agent.task.Task;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.AgentManagementAction;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.ont.proprietary.subscription.DFSubscriptionAction;
import fipaos.ont.proprietary.subscription.SubscriptionAction;
import fipaos.platform.df.DFListener;
import fipaos.platform.df.DFListenerManager;

public class DFListenerTask
extends Task
implements DFListenerManager {
    private DFListener _listener;
    private AgentID _df;
    private String _conv_id;
    private boolean _subscribed = false;

    public void startTask() {
        ACL aCL = this.getNewConversation("fipa-subscribe");
        this._conv_id = aCL.getConversationID();
        aCL.setSenderAID(this._owner.getAID());
        aCL.setReceiverAID(this._df);
        aCL.setPerformative("subscribe");
        aCL.setOntology("fipa-agent-management");
        DFSubscriptionAction dFSubscriptionAction = new DFSubscriptionAction();
        dFSubscriptionAction.setDFAction(new String[]{"register", "deregister", "modify"});
        aCL.setContentObject(dFSubscriptionAction);
        this.forward(aCL);
    }

    public boolean subscribedOK() {
        return this._subscribed;
    }

    public void handleNotUnderstood(Conversation conversation) {
        this.done();
    }

    public void handleRefuse(Conversation conversation) {
        this.done();
    }

    public void handleInform(Conversation conversation) {
        ACL aCL = conversation.getACL(conversation.getLatestMessageIndex());
        if (!this._subscribed && aCL.getContentObject() instanceof SubscriptionAction) {
            this._subscribed = true;
            return;
        }
        AgentManagementAction agentManagementAction = null;
        DFAgentDescription dFAgentDescription = null;
        if (!(aCL.getContentObject() instanceof AgentManagementAction)) {
            return;
        }
        agentManagementAction = (AgentManagementAction)aCL.getContentObject();
        if (agentManagementAction != null && agentManagementAction.getDFAgentDescription() != null) {
            dFAgentDescription = agentManagementAction.getDFAgentDescription();
        }
        if (agentManagementAction.getAction().equals("register")) {
            this._listener.registered(dFAgentDescription);
        } else if (agentManagementAction.getAction().equals("deregister")) {
            this._listener.deregistered(dFAgentDescription);
        } else if (agentManagementAction.getAction().equals("modify")) {
            this._listener.modified(dFAgentDescription);
        }
    }

    public void stopListening() {
        if (this._subscribed) {
            this._subscribed = false;
            this.sendCancel();
            this.done();
        }
    }

    private void sendCancel() {
        ACL aCL = new ACL();
        aCL.setSenderAID(this._owner.getAID());
        aCL.setReceiverAID(this._df);
        aCL.setPerformative("cancel");
        aCL.setProtocol("fipa-subscribe");
        aCL.setOntology("fipa-agent-management");
        aCL.setConversationID(this._conv_id);
        DFSubscriptionAction dFSubscriptionAction = new DFSubscriptionAction();
        dFSubscriptionAction.setDFAction(new String[]{"register", "deregister", "modify"});
        aCL.setContentObject(dFSubscriptionAction);
        this.forward(aCL);
    }

    public void init(DFListener dFListener, AgentID agentID, Task task) {
        this._listener = dFListener;
        this._df = agentID;
    }
}

