/*
 * Decompiled with CFR 0.152.
 */
package fipaos.platform.df;

import fipaos.agent.conversation.Conversation;
import fipaos.agent.task.Task;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.AgentManagementAction;
import fipaos.ont.fipa.fipaman.AgentManagementException;
import fipaos.ont.fipa.fipaman.AgentManagementResult;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.platform.DirectoryFacilitator;
import fipaos.skill.db.Database;
import java.util.Arrays;
import java.util.Set;

public class DFTask
extends Task {
    protected ACL _acl;
    protected Database _df_db;
    protected Conversation _conv;
    protected AgentManagementAction _ama;

    public DFTask(Conversation conversation, AgentManagementAction agentManagementAction, Database database) {
        this._conv = conversation;
        this._ama = agentManagementAction;
        this._df_db = database;
        this._acl = this._conv.getACL(0);
    }

    protected boolean isRegistered(DFAgentDescription dFAgentDescription) {
        AgentID agentID = dFAgentDescription.getAgentID();
        return this.isRegistered(agentID);
    }

    protected boolean isRegistered(AgentID agentID) {
        return this.getRegistered(agentID) != null;
    }

    protected DFAgentDescription getRegistered(AgentID agentID) {
        DFAgentDescription dFAgentDescription = null;
        try {
            this._df_db.startTransaction(true);
            dFAgentDescription = (DFAgentDescription)this._df_db.findObject(agentID.getName());
            return dFAgentDescription;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this._df_db.endTransaction();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean register(DFAgentDescription dFAgentDescription) {
        boolean bl = false;
        try {
            this._df_db.startTransaction(false);
            this._df_db.addObject(dFAgentDescription);
            bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this._df_db.endTransaction();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean deregister(DFAgentDescription dFAgentDescription) {
        boolean bl = false;
        try {
            this._df_db.startTransaction(false);
            this._df_db.removeObject(dFAgentDescription);
            bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this._df_db.endTransaction();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean sendAgree() {
        boolean bl = false;
        try {
            ACL aCL = (ACL)this._acl.clone();
            aCL.setPerformative("agree");
            aCL.setReceiverAID(aCL.getSenderAID());
            aCL.setSenderAID(this._owner.getAID());
            aCL.setInReplyTo(aCL.getReplyWith());
            aCL.setReplyWith(null);
            this.forward(aCL);
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected boolean sendRefuse(String string) {
        boolean bl = false;
        try {
            ACL aCL = (ACL)this._acl.clone();
            AgentManagementException agentManagementException = new AgentManagementException(this._ama, string);
            aCL.setPerformative("refuse");
            aCL.setReceiverAID(aCL.getSenderAID());
            aCL.setSenderAID(this._owner.getAID());
            aCL.setInReplyTo(aCL.getReplyWith());
            aCL.setReplyWith(null);
            aCL.setContentObject(agentManagementException);
            this.forward(aCL);
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected boolean sendFailure(String string) {
        boolean bl = false;
        try {
            ACL aCL = (ACL)this._acl.clone();
            AgentManagementException agentManagementException = new AgentManagementException(this._ama, string);
            aCL.setPerformative("failure");
            aCL.setReceiverAID(aCL.getSenderAID());
            aCL.setSenderAID(this._owner.getAID());
            aCL.setInReplyTo(aCL.getReplyWith());
            aCL.setReplyWith(null);
            aCL.setContentObject(agentManagementException);
            this.forward(aCL);
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    protected boolean sendInformDone() {
        boolean bl = false;
        try {
            ACL aCL = (ACL)this._acl.clone();
            aCL.setPerformative("inform");
            aCL.setReceiverAID(aCL.getSenderAID());
            aCL.setSenderAID(this._owner.getAID());
            aCL.setInReplyTo(aCL.getReplyWith());
            aCL.setReplyWith(null);
            aCL.setContentObject("(done " + this._ama.toString() + ")");
            this.forward(aCL);
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ((DirectoryFacilitator)this._owner)._subs_manager.DFUpdate(this._ama);
        return bl;
    }

    protected boolean sendInformResult(Set set) {
        boolean bl = false;
        try {
            ACL aCL = (ACL)this._acl.clone();
            AgentManagementResult agentManagementResult = new AgentManagementResult();
            agentManagementResult.setAgentManagementAction(this._ama);
            agentManagementResult.setResultSet(set);
            aCL.setPerformative("inform");
            aCL.setReceiverAIDs(Arrays.asList(aCL.getSenderAID()));
            aCL.setSenderAID(this._owner.getAID());
            aCL.setInReplyTo(aCL.getReplyWith());
            aCL.setReplyWith(null);
            aCL.setContentObject(agentManagementResult);
            this.forward(aCL);
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }
}

