/*
 * Decompiled with CFR 0.152.
 */
package fipaos.platform.df;

import fipaos.agent.conversation.Conversation;
import fipaos.agent.task.DFSearchTask;
import fipaos.agent.task.Task;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.AgentManagementAction;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.ont.fipa.fipaman.SearchConstraints;
import fipaos.ont.fipa.fipaman.ServiceDescription;
import fipaos.platform.df.DFTask;
import fipaos.skill.db.Database;
import fipaos.skill.db.DatabaseException;
import fipaos.util.Comparators;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SearchTask
extends DFTask {
    public static final long FED_TIMEOUT = 60000L;
    private SearchConstraints _search_constraints;
    private DFAgentDescription _df_desc;
    private Set _results;
    private int _max_results;
    private int _waiting_for = 0;

    public SearchTask(Conversation conversation, AgentManagementAction agentManagementAction, Database database) {
        super(conversation, agentManagementAction, database);
        this._search_constraints = agentManagementAction.getSearchConstraints();
        this._max_results = this._search_constraints != null && this._search_constraints.getMaxResults() != null ? this._search_constraints.getMaxResults() : -1;
        this._df_desc = agentManagementAction.getDFAgentDescription();
    }

    public void startTask() {
        this._results = new TreeSet(Comparators.OBJECT_COMPARE);
        this.sendAgree();
        if (this._max_results == -1 || this._max_results > 0) {
            this._results.addAll(this.localSearch(this._df_desc));
            if (this._search_constraints != null && this._search_constraints.getMaxDepth() != null && this._search_constraints.getMaxDepth() > 0) {
                this.remoteSearch(this._df_desc, this._search_constraints);
            } else {
                this.searchComplete();
            }
        } else {
            this.searchComplete();
        }
    }

    public void doneDFSearchTask(Object object) {
        if (object != null) {
            DFAgentDescription[] dFAgentDescriptionArray = (DFAgentDescription[])object;
            Set set = this._results;
            synchronized (set) {
                int n = 0;
                while (n < dFAgentDescriptionArray.length) {
                    if (this._max_results != -1 && this._results.size() >= this._max_results) break;
                    this._results.add(dFAgentDescriptionArray[n]);
                    ++n;
                }
            }
        }
        this.searchComplete();
    }

    public void errorDFSearchTask(Task task, Throwable throwable) {
        this.searchComplete();
    }

    public void timeoutDFSearchTask(Task task) {
        this.searchComplete();
    }

    private void searchComplete() {
        Set set = this._results;
        synchronized (set) {
            --this._waiting_for;
            if (this._waiting_for <= 0) {
                this.sendInformResult(this._results);
                this.done();
            }
        }
    }

    private void remoteSearch(DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints) {
        List list = this.getDFs();
        this._waiting_for = list.size();
        if (list.size() <= 0) {
            this.searchComplete();
        } else {
            searchConstraints.setMaxDepth(new Integer(searchConstraints.getMaxDepth() - 1));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AgentID agentID = (AgentID)iterator.next();
                this.newTask((Task)new DFSearchTask(agentID.toString(), dFAgentDescription, searchConstraints, true), 60000L);
            }
        }
    }

    private List getDFs() {
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        ServiceDescription serviceDescription = new ServiceDescription();
        serviceDescription.setServiceType("fipa-df");
        dFAgentDescription.setAgentServices(new ServiceDescription[]{serviceDescription});
        Set set = this.localSearch(dFAgentDescription);
        LinkedList<AgentID> linkedList = new LinkedList<AgentID>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DFAgentDescription dFAgentDescription2 = (DFAgentDescription)iterator.next();
            linkedList.add(dFAgentDescription2.getAgentID());
        }
        return linkedList;
    }

    private Set localSearch(DFAgentDescription dFAgentDescription) {
        TreeSet<DFAgentDescription> treeSet = new TreeSet<DFAgentDescription>(Comparators.OBJECT_COMPARE);
        try {
            this._df_db.startTransaction(true);
            Enumeration enumeration = this._df_db.getIDs();
            while (enumeration.hasMoreElements()) {
                DFAgentDescription dFAgentDescription2 = (DFAgentDescription)this._df_db.findObject((String)enumeration.nextElement());
                if (!SearchTask.compare(dFAgentDescription, dFAgentDescription2) || this._max_results != -1 && treeSet.size() >= this._max_results) continue;
                treeSet.add(dFAgentDescription2);
            }
            this._df_db.endTransaction();
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        return treeSet;
    }

    private static boolean compare(DFAgentDescription dFAgentDescription, DFAgentDescription dFAgentDescription2) {
        Set set;
        Set set2;
        if (dFAgentDescription2 == null) {
            return false;
        }
        if (dFAgentDescription.getAgentID() != null && !dFAgentDescription.getAgentID().equals(dFAgentDescription2.getAgentID())) {
            return false;
        }
        if (dFAgentDescription.getLanguages() != null) {
            if (dFAgentDescription2.getLanguages() != null) {
                set2 = dFAgentDescription.getLanguages();
                set = dFAgentDescription2.getLanguages();
                if (!set.containsAll(set2)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (dFAgentDescription.getOntologies() != null) {
            if (dFAgentDescription2.getOntologies() != null) {
                set2 = dFAgentDescription.getOntologies();
                set = dFAgentDescription2.getOntologies();
                if (!set.containsAll(set2)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (dFAgentDescription.getProtocols() != null) {
            if (dFAgentDescription2.getProtocols() != null) {
                set2 = dFAgentDescription.getProtocols();
                set = dFAgentDescription2.getProtocols();
                if (!set.containsAll(set2)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (dFAgentDescription.getAgentServices() != null) {
            if (dFAgentDescription2.getAgentServices() != null) {
                set2 = dFAgentDescription.getAgentServices();
                if (!SearchTask.compare(set2, set = dFAgentDescription2.getAgentServices())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean compare(Set set, Set set2) {
        Iterator iterator = set.iterator();
        boolean bl = true;
        while (iterator.hasNext() && bl) {
            ServiceDescription serviceDescription = (ServiceDescription)iterator.next();
            bl = false;
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext() && !bl) {
                ServiceDescription serviceDescription2 = (ServiceDescription)iterator2.next();
                bl = SearchTask.compare(serviceDescription, serviceDescription2);
            }
        }
        return bl;
    }

    private static boolean compare(ServiceDescription serviceDescription, ServiceDescription serviceDescription2) {
        Set set;
        Set set2;
        if (serviceDescription.getServiceName() != null) {
            if (serviceDescription2.getServiceName() != null) {
                if (!serviceDescription.getServiceName().equals(serviceDescription2.getServiceName())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (serviceDescription.getServiceType() != null) {
            if (serviceDescription2.getServiceType() != null) {
                if (!serviceDescription.getServiceType().equals(serviceDescription2.getServiceType())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (serviceDescription.getOntologies() != null) {
            if (serviceDescription2.getOntologies() != null) {
                set2 = serviceDescription.getOntologies();
                set = serviceDescription2.getOntologies();
                if (!set.containsAll(set2)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (serviceDescription.getOwnership() != null) {
            if (serviceDescription2.getOwnership() != null) {
                if (!serviceDescription.getOwnership().equals(serviceDescription2.getOwnership())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (serviceDescription.getProperties() != null) {
            if (serviceDescription2.getProperties() != null) {
                set2 = serviceDescription.getProperties();
                set = serviceDescription2.getProperties();
                if (!set.containsAll(set2)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (serviceDescription.getProtocols() != null) {
            if (serviceDescription2.getProtocols() != null) {
                set2 = serviceDescription.getProtocols();
                set = serviceDescription2.getProtocols();
                if (!set.containsAll(set2)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

