/*
 * Decompiled with CFR 0.152.
 */
package fipaos.platform.df;

import fipaos.agent.conversation.Conversation;
import fipaos.agent.task.Task;
import fipaos.ont.fipa.ACL;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.AgentManagementAction;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.ont.proprietary.subscription.DFSubscriptionAction;
import fipaos.ont.proprietary.subscription.SubscriptionAction;
import java.util.Iterator;

public class SubscriptionHandlerTask
extends Task {
    private AgentID _agent;
    private String _conv_id;
    private DFSubscriptionAction _subscription;
    private boolean _still_subscribed = true;

    public SubscriptionHandlerTask(ACL aCL) {
        this._conv_id = aCL.getConversationID();
        this._agent = aCL.getSenderAID();
        if (aCL.getContentObject() != null && aCL.getContentObject() instanceof SubscriptionAction) {
            this._subscription = (DFSubscriptionAction)aCL.getContentObject();
        }
    }

    public void startTask() {
        ACL aCL = new ACL();
        aCL.setPerformative("inform");
        aCL.setSenderAID(this._owner.getAID());
        aCL.setReceiverAID(this._agent);
        aCL.setOntology("fipa-agent-management");
        aCL.setConversationID(this._conv_id);
        aCL.setContentObject(this._subscription);
        this.forward(aCL);
    }

    public void handleCancel(Conversation conversation) {
        this._still_subscribed = false;
        this.done();
    }

    public void handleNotUnderstood(Conversation conversation) {
        this._still_subscribed = false;
        this.done();
    }

    void DFUpdate(AgentManagementAction agentManagementAction) {
        if (this._still_subscribed) {
            DFAgentDescription dFAgentDescription = agentManagementAction.getDFAgentDescription();
            if (this._subscription.getDFDescriptions().length == 0) {
                ACL aCL = new ACL();
                aCL.setPerformative("inform");
                aCL.setSenderAID(this._owner.getAID());
                aCL.setReceiverAID(this._agent);
                aCL.setOntology("fipa-agent-management");
                aCL.setConversationID(this._conv_id);
                aCL.setContentObject(agentManagementAction);
                this.forward(aCL);
            }
            int n = 0;
            while (n < this._subscription.getDFDescriptions().length) {
                DFAgentDescription dFAgentDescription2 = this._subscription.getDFDescriptions()[n];
                if (this.compareDFDescriptions(dFAgentDescription2, dFAgentDescription)) {
                    ACL aCL = new ACL();
                    aCL.setPerformative("inform");
                    aCL.setSenderAID(this._owner.getAID());
                    aCL.setReceiverAID(this._agent);
                    aCL.setOntology("fipa-agent-management");
                    aCL.setConversationID(this._conv_id);
                    aCL.setContentObject(agentManagementAction);
                    this.forward(aCL);
                }
                ++n;
            }
        }
    }

    private boolean compareDFDescriptions(DFAgentDescription dFAgentDescription, DFAgentDescription dFAgentDescription2) {
        Object e;
        boolean bl;
        Iterator iterator;
        if (!dFAgentDescription.getAgentID().equals(dFAgentDescription2.getAgentID()) && dFAgentDescription.getAgentID() != null) {
            return false;
        }
        if (dFAgentDescription.getAgentServices() != null) {
            iterator = dFAgentDescription.getAgentServices().iterator();
            bl = false;
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!dFAgentDescription2.getAgentServices().contains(e)) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
        }
        if (dFAgentDescription.getLanguages() != null) {
            iterator = dFAgentDescription.getLanguages().iterator();
            bl = false;
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!dFAgentDescription2.getLanguages().contains(e)) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
        }
        if (dFAgentDescription.getOntologies() != null) {
            iterator = dFAgentDescription.getOntologies().iterator();
            bl = false;
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!dFAgentDescription2.getOntologies().contains(e)) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
        }
        if (dFAgentDescription.getProtocols() != null) {
            iterator = dFAgentDescription.getProtocols().iterator();
            bl = false;
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!dFAgentDescription2.getProtocols().contains(e)) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
        }
        return true;
    }
}

