/*
 * Decompiled with CFR 0.152.
 */
package fipaos.platform.dfgui;

import fipaos.FIPAOSFactory;
import fipaos.agent.FIPAOSAgent;
import fipaos.agent.task.DFSearchTask;
import fipaos.agent.task.SynchronousTask;
import fipaos.agent.task.Task;
import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.ont.fipa.fipaman.SearchConstraints;
import fipaos.platform.ams.AMSRegistrationException;
import fipaos.platform.df.DFListener;
import fipaos.platform.df.DFListenerManager;
import fipaos.platform.df.DFSubscriptionFactory;
import fipaos.util.Comparators;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class DFGUIAgent
extends FIPAOSAgent {
    private static final int DF_TIMEOUT = 30000;
    private Map _df_listener_tasks;
    private Map _df_contents;
    private DFGUIAgent _parent;
    private DFSubscriptionFactory _dfsf;
    private Task _idle_task;
    static /* synthetic */ Class class$fipaos$platform$df$DFSubscriptionFactory;

    public DFGUIAgent(String string, String string2, String string3) {
        block2: {
            super(string, string2, string3);
            this._parent = this;
            this._df_listener_tasks = new TreeMap(Comparators.STRING_COMPARE);
            this._df_contents = new TreeMap(Comparators.STRING_COMPARE);
            this._dfsf = (DFSubscriptionFactory)FIPAOSFactory.getFactoryInstance(class$fipaos$platform$df$DFSubscriptionFactory == null ? (class$fipaos$platform$df$DFSubscriptionFactory = DFGUIAgent.class$("fipaos.platform.df.DFSubscriptionFactory")) : class$fipaos$platform$df$DFSubscriptionFactory);
            this._idle_task = this._dfsf.getIdleTask();
            this.setListenerTask(this._idle_task);
            try {
                this.registerWithAMS();
            }
            catch (AMSRegistrationException aMSRegistrationException) {
                String string4 = aMSRegistrationException.getExceptionReason();
                if (string4 != null && string4.equals("already-registered")) break block2;
                return;
            }
        }
    }

    public abstract void registered(AgentID var1, DFAgentDescription var2);

    public abstract void deregistered(AgentID var1, DFAgentDescription var2);

    public abstract void modified(AgentID var1, DFAgentDescription var2);

    public synchronized void shutdown() {
        TreeSet treeSet = new TreeSet(Comparators.STRING_COMPARE);
        treeSet.addAll(this._df_listener_tasks.keySet());
        Iterator iterator = treeSet.iterator();
        AgentID agentID = new AgentID();
        while (iterator.hasNext()) {
            agentID.setName((String)iterator.next());
            this.removeDF(agentID);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.registeredWithAMS()) {
            try {
                this.deregisterWithAMS();
            }
            catch (AMSRegistrationException aMSRegistrationException) {
                String string = aMSRegistrationException.getExceptionReason();
            }
        }
        super.shutdown();
    }

    protected Map listAgents(AgentID agentID) {
        Map map = null;
        DFListenerManager dFListenerManager = null;
        DFGUIAgent dFGUIAgent = this;
        synchronized (dFGUIAgent) {
            map = (Map)this._df_contents.get(agentID.getName());
            dFListenerManager = (DFListenerManager)this._df_listener_tasks.get(agentID.getName());
        }
        if (map == null && dFListenerManager == null) {
            if (this.addDF(agentID)) {
                map = (Map)this._df_contents.get(agentID.getName());
            }
        } else if (dFListenerManager != null && !dFListenerManager.subscribedOK()) {
            map = this.getDFEntries(agentID, 1);
        }
        return map;
    }

    public synchronized Map federatedSearch(AgentID agentID, int n) {
        return this.getDFEntries(agentID, n);
    }

    protected synchronized boolean stopListeningToDF(AgentID agentID) {
        return this.removeDF(agentID);
    }

    protected synchronized boolean registerAgent(AgentID agentID, DFAgentDescription dFAgentDescription) {
        return false;
    }

    protected synchronized boolean deregisterAgent(AgentID agentID, DFAgentDescription dFAgentDescription) {
        return false;
    }

    protected synchronized boolean modifyAgent(AgentID agentID, DFAgentDescription dFAgentDescription) {
        return false;
    }

    private boolean addDF(AgentID agentID) {
        if (!this._df_listener_tasks.containsKey(agentID.getName())) {
            Map map = this.getDFEntries(agentID, 1);
            if (map == null) {
                return false;
            }
            DFGUIAgent dFGUIAgent = this;
            synchronized (dFGUIAgent) {
                this._df_contents.put(agentID.getName(), map);
                DFListenerManager dFListenerManager = this._dfsf.getDFListenerManager(new ParticularDFListener(agentID), agentID, this._idle_task);
                this._tm.newTask((Task)((Object)dFListenerManager));
                this._df_listener_tasks.put(agentID.getName(), dFListenerManager);
            }
        }
        return true;
    }

    private synchronized boolean removeDF(AgentID agentID) {
        if (this._df_contents.containsKey(agentID.getName())) {
            DFListenerManager dFListenerManager = (DFListenerManager)this._df_listener_tasks.remove(agentID.getName());
            dFListenerManager.stopListening();
            Map map = (Map)this._df_contents.remove(agentID.getName());
            map.clear();
        }
        return true;
    }

    private Map getDFEntries(AgentID agentID, int n) {
        Object object = SynchronousTask.executeTask(this._tm, new DFSearchTask(agentID.toString(), new DFAgentDescription(), new SearchConstraints(n), n > 1), 30000L);
        if (object instanceof SynchronousTask.UnusualResult) {
            return null;
        }
        TreeMap<String, DFAgentDescription> treeMap = new TreeMap<String, DFAgentDescription>(Comparators.STRING_COMPARE);
        if (object != null && object instanceof DFAgentDescription[]) {
            DFAgentDescription[] dFAgentDescriptionArray = (DFAgentDescription[])object;
            int n2 = 0;
            while (n2 < dFAgentDescriptionArray.length) {
                treeMap.put(dFAgentDescriptionArray[n2].getAgentID().getName(), dFAgentDescriptionArray[n2]);
                ++n2;
            }
        }
        return treeMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ParticularDFListener
    implements DFListener {
        private AgentID _df;

        public ParticularDFListener(AgentID agentID) {
            this._df = agentID;
        }

        public void registered(DFAgentDescription dFAgentDescription) {
            try {
                Map map = DFGUIAgent.this._df_contents;
                synchronized (map) {
                    Map map2 = (Map)DFGUIAgent.this._df_contents.get(this._df.getName());
                    map2.put(dFAgentDescription.getAgentID().getName(), dFAgentDescription);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                DFGUIAgent.this._parent.registered(this._df, dFAgentDescription);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void modified(DFAgentDescription dFAgentDescription) {
            try {
                Map map = DFGUIAgent.this._df_contents;
                synchronized (map) {
                    Map map2 = (Map)DFGUIAgent.this._df_contents.get(this._df.getName());
                    map2.put(dFAgentDescription.getAgentID().getName(), dFAgentDescription);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                DFGUIAgent.this._parent.modified(this._df, dFAgentDescription);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void deregistered(DFAgentDescription dFAgentDescription) {
            try {
                Map map = DFGUIAgent.this._df_contents;
                synchronized (map) {
                    Map map2 = (Map)DFGUIAgent.this._df_contents.get(this._df.getName());
                    map2.remove(dFAgentDescription.getAgentID().getName());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                DFGUIAgent.this._parent.deregistered(this._df, dFAgentDescription);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

