/*
 * Decompiled with CFR 0.152.
 */
package fipaos.platform.dfgui.swing;

import fipaos.ont.fipa.fipaman.AgentID;
import fipaos.ont.fipa.fipaman.DFAgentDescription;
import fipaos.platform.dfgui.swing.DFAgentDescriptionEditor;
import fipaos.platform.dfgui.swing.DFAgentDescriptionMapDialog;
import fipaos.platform.dfgui.swing.RegisterWithDFFrame;
import fipaos.platform.dfgui.swing.SwingDFGUIAgent;
import fipaos.util.Comparators;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DFGUIFrame
extends JFrame
implements KeyListener {
    private JMenuBar _menu_bar;
    private JMenu _menu_file;
    private JMenuItem _m_add_df;
    private JMenuItem _m_remove_df;
    private JSeparator _m_separator1;
    private JMenuItem _m_refresh;
    private JSeparator _m_separator3;
    private JMenuItem _m_exit;
    private JMenu _menu_df_functionality;
    private JMenuItem _m_deregister;
    private JMenuItem _m_modify;
    private JSeparator _m_separator2;
    private JMenuItem _m_register_df;
    private JMenu _menu_view;
    private JMenuItem _m_view;
    private JPopupMenu _agent_popup_menu;
    private JMenuItem _pm_deregister;
    private JMenuItem _pm_modify;
    private JSeparator _pm_separator1;
    private JMenuItem _pm_view;
    private JSeparator _pm_separator2;
    private JMenuItem _pm_remove_df;
    private JMenuItem _pm_register_with_df;
    private JMenuItem _pm_federated_search;
    private JPopupMenu _FIPAOS_popup_menu;
    private JMenuItem _pm_add_df;
    private JToolBar _toolbar;
    private JButton _b_deregister;
    private JButton _b_modify;
    private JSeparator _b_separator;
    private JButton _b_add_df;
    private JButton _b_remove_df;
    private JScrollPane _agent_scrollpane;
    private JTree _agent_tree;
    private JLabel _status_bar;
    private Map _dfs = new TreeMap(Comparators.OBJECT_COMPARE);
    private SwingDFGUIAgent _parent;
    private DFGUIModel _tree_model;
    private MouseListener _popup_listener;
    private static final String DF_IMAGE = "dfgui/df.gif";
    private static final String AGENT_IMAGE = "dfgui/Agent.gif";
    private static final String IMAGE_DIRECTORY = "images/";
    private static final String FIPA_GIF = "logo.gif";

    public DFGUIFrame(SwingDFGUIAgent swingDFGUIAgent, AgentID agentID) {
        this._parent = swingDFGUIAgent;
        String string = agentID.getName();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.initComponents();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (n < 320) {
            n = 320;
        }
        if (n2 < 240) {
            n2 = 240;
        }
        this.setSize(n, n2);
        n = toolkit.getScreenSize().width - n;
        n2 = toolkit.getScreenSize().height - n2;
        this.setLocation(n / 2, n2 / 2);
        super.setVisible(true);
        this.addAgentToTree(string, string);
        this.listAgents(agentID);
    }

    private void initComponents() {
        this._menu_bar = new JMenuBar();
        this._menu_file = new JMenu();
        this._m_add_df = new JMenuItem();
        this._m_remove_df = new JMenuItem();
        this._m_separator1 = new JSeparator();
        this._m_refresh = new JMenuItem();
        this._m_separator3 = new JSeparator();
        this._m_exit = new JMenuItem();
        this._menu_df_functionality = new JMenu();
        this._m_deregister = new JMenuItem();
        this._m_modify = new JMenuItem();
        this._m_separator2 = new JSeparator();
        this._m_register_df = new JMenuItem();
        this._menu_view = new JMenu();
        this._m_view = new JMenuItem();
        this._agent_popup_menu = new JPopupMenu();
        this._pm_deregister = new JMenuItem();
        this._pm_modify = new JMenuItem();
        this._pm_separator1 = new JSeparator();
        this._pm_view = new JMenuItem();
        this._pm_separator2 = new JSeparator();
        this._pm_remove_df = new JMenuItem();
        this._pm_register_with_df = new JMenuItem();
        this._pm_federated_search = new JMenuItem();
        this._FIPAOS_popup_menu = new JPopupMenu();
        this._pm_add_df = new JMenuItem();
        this._toolbar = new JToolBar();
        this._b_deregister = new JButton();
        this._b_modify = new JButton();
        this._b_separator = new JSeparator();
        this._b_add_df = new JButton();
        this._b_remove_df = new JButton();
        this._agent_scrollpane = new JScrollPane();
        this._popup_listener = new DFGUIPopupListener();
        this._tree_model = new DFGUIModel();
        this._agent_tree = new JTree(this._tree_model);
        this._agent_tree.putClientProperty("JTree.lineStyle", "Angled");
        this._agent_tree.getSelectionModel().setSelectionMode(1);
        this._agent_tree.addMouseListener(this._popup_listener);
        this._agent_tree.addTreeSelectionListener(new DFGUITreeSelectionListener());
        this._status_bar = new JLabel();
        this._menu_bar.setName("");
        this._menu_file.setText("File");
        this._menu_file.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                DFGUIFrame.this.fileMenuOpened(focusEvent);
            }
        });
        this._m_add_df.setText("Add new DF");
        this._m_add_df.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.addDF(actionEvent);
            }
        });
        this._menu_file.add(this._m_add_df);
        this._m_remove_df.setText("Remove DF");
        this._m_remove_df.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.removeDF(actionEvent);
            }
        });
        this._menu_file.add(this._m_remove_df);
        this._menu_file.add(this._m_separator1);
        this._m_refresh.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this._m_refresh.setText("Refresh");
        this._m_refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.refresh(actionEvent);
            }
        });
        this._menu_file.add(this._m_refresh);
        this._menu_file.add(this._m_separator3);
        this._m_exit.setText("Exit");
        this._m_exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.exit(actionEvent);
            }
        });
        this._menu_file.add(this._m_exit);
        this._menu_bar.add(this._menu_file);
        this._menu_df_functionality.setText("DF Functionality");
        this._menu_df_functionality.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                DFGUIFrame.this.dfMenuOpened(focusEvent);
            }
        });
        this._m_deregister.setText("Deregister");
        this._m_deregister.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.deregister(actionEvent);
            }
        });
        this._menu_df_functionality.add(this._m_deregister);
        this._m_modify.setText("Modify");
        this._m_modify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.modify(actionEvent);
            }
        });
        this._menu_df_functionality.add(this._m_modify);
        this._menu_df_functionality.add(this._m_separator2);
        this._m_register_df.setText("Register DF with another DF");
        this._m_register_df.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.registerDFWithDF(actionEvent);
            }
        });
        this._menu_df_functionality.add(this._m_register_df);
        this._menu_bar.add(this._menu_df_functionality);
        this._menu_view.setText("View");
        this._menu_view.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                DFGUIFrame.this.viewMenuOpened(focusEvent);
            }
        });
        this._m_view.setText("View agent");
        this._m_view.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.view(actionEvent);
            }
        });
        this._menu_view.add(this._m_view);
        this._menu_bar.add(this._menu_view);
        this._pm_deregister.setText("Deregister");
        this._pm_deregister.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.deregister(actionEvent);
            }
        });
        this._agent_popup_menu.add(this._pm_deregister);
        this._pm_modify.setText("Modify");
        this._pm_modify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.modify(actionEvent);
            }
        });
        this._agent_popup_menu.add(this._pm_modify);
        this._agent_popup_menu.add(this._pm_separator1);
        this._pm_view.setText("View");
        this._pm_view.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.view(actionEvent);
            }
        });
        this._agent_popup_menu.add(this._pm_view);
        this._agent_popup_menu.add(this._pm_separator2);
        this._pm_remove_df.setText("Remove DF");
        this._pm_remove_df.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.removeDF(actionEvent);
            }
        });
        this._agent_popup_menu.add(this._pm_remove_df);
        this._pm_register_with_df.setText("Register with a DF");
        this._pm_register_with_df.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.registerDFWithDF(actionEvent);
            }
        });
        this._agent_popup_menu.add(this._pm_register_with_df);
        this._pm_federated_search.setText("Perform Federated Search");
        this._pm_federated_search.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.jMenuItem1ActionPerformed(actionEvent);
            }
        });
        this._agent_popup_menu.add(this._pm_federated_search);
        this._pm_add_df.setText("Add new DF");
        this._pm_add_df.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.addDF(actionEvent);
            }
        });
        this._FIPAOS_popup_menu.add(this._pm_add_df);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("images/logo.gif")).getImage());
        this.setTitle("DF Management GUI");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DFGUIFrame.this.exitForm(windowEvent);
            }
        });
        this._b_deregister.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/dfgui/deregister.gif")));
        this._b_deregister.setToolTipText("Deregister");
        this._b_deregister.setBorder(new BevelBorder(0));
        this._b_deregister.setMargin(new Insets(0, 0, 0, 0));
        this._b_deregister.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.deregister(actionEvent);
            }
        });
        this._toolbar.add(this._b_deregister);
        this._b_modify.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/dfgui/modify.gif")));
        this._b_modify.setToolTipText("Modify");
        this._b_modify.setBorder(new BevelBorder(0));
        this._b_modify.setMargin(new Insets(0, 0, 0, 0));
        this._b_modify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.modify(actionEvent);
            }
        });
        this._toolbar.add(this._b_modify);
        this._b_separator.setPreferredSize(new Dimension(10, 0));
        this._b_separator.setOrientation(1);
        this._toolbar.add(this._b_separator);
        this._b_add_df.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/dfgui/df.gif")));
        this._b_add_df.setToolTipText("New DF");
        this._b_add_df.setBorder(new BevelBorder(0));
        this._b_add_df.setMargin(new Insets(0, 0, 0, 0));
        this._b_add_df.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.addDF(actionEvent);
            }
        });
        this._toolbar.add(this._b_add_df);
        this._b_remove_df.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/dfgui/remove_df.jpg")));
        this._b_remove_df.setToolTipText("Remove DF");
        this._b_remove_df.setBorder(new BevelBorder(0));
        this._b_remove_df.setMargin(new Insets(0, 0, 0, 0));
        this._b_remove_df.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DFGUIFrame.this.removeDF(actionEvent);
            }
        });
        this._toolbar.add(this._b_remove_df);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 3, 0, 3);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this._toolbar, gridBagConstraints);
        this._agent_scrollpane.setBorder(new BevelBorder(1));
        this._agent_scrollpane.setAutoscrolls(true);
        this._agent_tree.setPreferredSize(new Dimension(400, 100));
        this._agent_tree.setBorder(new BevelBorder(1));
        this._agent_tree.setRowHeight(25);
        this._agent_tree.setVisibleRowCount(15);
        this._agent_tree.setCellRenderer(new DFGUIRenderer());
        this._agent_tree.setAutoscrolls(true);
        this._agent_scrollpane.setViewportView(this._agent_tree);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this._agent_scrollpane, gridBagConstraints);
        this._status_bar.setBorder(new BevelBorder(1));
        this._status_bar.setText(" ");
        this._status_bar.setToolTipText("Status of the latest succesful command");
        this._status_bar.setForeground(Color.black);
        this._status_bar.setFont(new Font("Dialog", 0, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.getContentPane().add((Component)this._status_bar, gridBagConstraints);
        this.setJMenuBar(this._menu_bar);
    }

    private void jMenuItem1ActionPerformed(ActionEvent actionEvent) {
        final DFGUIFrame dFGUIFrame = this;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                String string = JOptionPane.showInputDialog("Depth for federated search");
                if (string != null) {
                    try {
                        int n = Integer.parseInt(string);
                        String string2 = DFGUIFrame.this._agent_tree.getSelectionPath().getLastPathComponent().toString();
                        AgentID agentID = new AgentID();
                        agentID.setName(string2);
                        Map map = DFGUIFrame.this._parent.federatedSearch(agentID, n);
                        if (map != null) {
                            new DFAgentDescriptionMapDialog(dFGUIFrame, map, false);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
        thread.start();
    }

    private void registerDFWithDF(ActionEvent actionEvent) {
        this.notifyError("Registering a DF with another DF is not supported in DF GUI in FIPA-OS 2.0.0. \nThis feature will be available in a future release.");
    }

    private void refresh(ActionEvent actionEvent) {
        Iterator iterator = this._dfs.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Map map = this._parent.listAgentsRequest(string);
            this.addAgentToTree(string, string);
            if (map == null) continue;
            Iterator iterator2 = map.values().iterator();
            while (iterator2.hasNext()) {
                String string2 = ((DFAgentDescription)iterator2.next()).getAgentID().getName();
                this.addAgentToTree(string2, string);
            }
        }
    }

    private void viewMenuOpened(FocusEvent focusEvent) {
        int n;
        try {
            n = this._agent_tree.getSelectionPath().getPathCount();
        }
        catch (Throwable throwable) {
            n = 0;
        }
        if (n < 3) {
            this._m_view.setEnabled(false);
        } else {
            this._m_view.setEnabled(true);
        }
    }

    private void dfMenuOpened(FocusEvent focusEvent) {
        int n;
        try {
            n = this._agent_tree.getSelectionPath().getPathCount();
        }
        catch (Throwable throwable) {
            n = 0;
        }
        if (n == 3) {
            this._m_deregister.setEnabled(true);
            this._m_modify.setEnabled(true);
            this._m_register_df.setEnabled(false);
        } else if (n == 2) {
            this._m_deregister.setEnabled(false);
            this._m_modify.setEnabled(false);
            this._m_register_df.setEnabled(true);
        } else {
            this._m_deregister.setEnabled(false);
            this._m_modify.setEnabled(false);
            this._m_register_df.setEnabled(false);
        }
    }

    private void fileMenuOpened(FocusEvent focusEvent) {
        int n;
        try {
            n = this._agent_tree.getSelectionPath().getPathCount();
        }
        catch (Throwable throwable) {
            n = 0;
        }
        if (n == 2) {
            this._m_add_df.setEnabled(false);
            this._m_remove_df.setEnabled(true);
        } else if (n == 1) {
            this._m_add_df.setEnabled(true);
            this._m_remove_df.setEnabled(false);
        } else {
            this._m_add_df.setEnabled(false);
            this._m_remove_df.setEnabled(false);
        }
    }

    private void addDF(ActionEvent actionEvent) {
        this.notifyError("Monitoring of a DF in another platform is not supported in DF GUI in FIPA-OS 2.0.0. \nThis feature will be available in a future release. However, you will be able to manually refresh the contents \nby selecting File -> Refresh.");
        RegisterWithDFFrame registerWithDFFrame = new RegisterWithDFFrame(this);
        registerWithDFFrame.show();
    }

    private void removeDF(ActionEvent actionEvent) {
        String string = this._agent_tree.getSelectionPath().getLastPathComponent().toString();
        this._parent.dropDF(string);
        this.removeAgentFromTree(string);
    }

    private void view(ActionEvent actionEvent) {
        Object object;
        String string = this._agent_tree.getSelectionPath().getParentPath().getLastPathComponent().toString();
        String string2 = this._agent_tree.getSelectionPath().getLastPathComponent().toString();
        AgentID agentID = new AgentID();
        agentID.setName(string);
        DFAgentDescription dFAgentDescription = null;
        TreeMap treeMap = (TreeMap)this._parent.listAgentsRequest(agentID);
        if (treeMap != null) {
            object = treeMap.values().iterator();
            while (object.hasNext()) {
                DFAgentDescription dFAgentDescription2 = (DFAgentDescription)object.next();
                if (!dFAgentDescription2.getAgentID().getName().equals(string2)) continue;
                dFAgentDescription = dFAgentDescription2;
            }
        }
        if (dFAgentDescription != null) {
            object = new DFAgentDescriptionEditor(string2, dFAgentDescription, true);
        } else {
            this.notifyError("Can't display details for '" + string2 + "' - the agent details not found.");
        }
    }

    private void exit(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
        this._parent.shutdown();
    }

    private void modify(ActionEvent actionEvent) {
        this.notifyError("Modifying an agent is not supported in DF GUI in FIPA-OS 2.0.0. \nThis feature will be available in a future release.");
    }

    private void deregister(ActionEvent actionEvent) {
        this.notifyError("Deregistering an agent from a DF is not supported in DF GUI in FIPA-OS 2.0.0. \nThis feature will be available in a future release.");
    }

    private void exitForm(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    private void addAgentToTree(String string, String string2) {
        if (string.equals(string2)) {
            if (!this._dfs.containsKey(string2)) {
                this._dfs.put(string2, new LinkedList());
                this.notifyMessage("Added new DF: " + string2);
            }
        } else if (this._dfs.containsKey(string2)) {
            LinkedList linkedList = (LinkedList)this._dfs.get(string2);
            if (!linkedList.contains(string)) {
                linkedList.add(string);
                this.notifyMessage("Added new agent " + string + " for DF " + string2);
            }
        } else {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string);
            this._dfs.put(string2, linkedList);
            this.notifyMessage("Added new DF " + string2 + " and agent " + string);
        }
        this._tree_model.notifyChanges();
    }

    public static void main(String[] stringArray) {
        SwingDFGUIAgent swingDFGUIAgent = new SwingDFGUIAgent("e:\\fipa-os\\profiles\\platform.profile", "dfgui", "TRINITY");
    }

    private void removeAgentFromTree(String string) {
        if (this._dfs.containsKey(string)) {
            this._dfs.remove(string);
            this._tree_model.notifyChanges();
            this.notifyMessage("DF " + string + " no longer monitored.");
        } else {
            Iterator iterator = this._dfs.values().iterator();
            while (iterator.hasNext()) {
                LinkedList linkedList = (LinkedList)iterator.next();
                if (!linkedList.contains(string)) continue;
                linkedList.remove(string);
                this._tree_model.notifyChanges();
                this.notifyMessage("Agent " + string + " no longer registered.");
            }
        }
    }

    void notifyError(String string) {
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }

    void notifyMessage(String string) {
        this._status_bar.setText(string);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 116) {
            this.refresh(new ActionEvent(keyEvent, 0, "F5 pressed"));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    void returnAID(AgentID agentID) {
        this.addAgentToTree(agentID.getName(), agentID.getName());
        this.listAgents(agentID);
    }

    private void listAgents(final AgentID agentID) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                String string = agentID.getName();
                TreeMap treeMap = (TreeMap)DFGUIFrame.this._parent.listAgentsRequest(agentID);
                if (treeMap != null) {
                    Iterator iterator = treeMap.values().iterator();
                    while (iterator.hasNext()) {
                        String string2 = ((DFAgentDescription)iterator.next()).getAgentID().getName();
                        DFGUIFrame.this.addAgentToTree(string2, string);
                    }
                } else {
                    DFGUIFrame.this.notifyMessage("No agents registered on " + string);
                }
            }
        });
        thread.start();
    }

    void returnRegister(AgentID agentID, String string) {
        if (this._parent.registerDFRequest(agentID, string)) {
            this.notifyMessage("Send a register message to DF " + string + " for DF " + agentID.getName() + ".");
        } else {
            this.notifyError("Registering of DF '" + string + "' with DF '" + agentID.getName() + "' failed.");
        }
    }

    void updateTree() {
        this.refresh(new ActionEvent(this._parent, 0, "Refresh"));
    }

    void agentDeregistered(AgentID agentID, AgentID agentID2) {
        LinkedList linkedList;
        if (this._dfs.containsKey(agentID.getName()) && (linkedList = (LinkedList)this._dfs.get(agentID.getName())).contains(agentID2.getName())) {
            linkedList.remove(agentID2.getName());
            this.updateTree();
        }
    }

    class DFGUITreeSelectionListener
    implements TreeSelectionListener {
        DFGUITreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            int n;
            try {
                n = DFGUIFrame.this._agent_tree.getSelectionPath().getPathCount();
            }
            catch (Throwable throwable) {
                n = 0;
            }
            switch (n) {
                case 1: {
                    DFGUIFrame.this._b_deregister.setEnabled(false);
                    DFGUIFrame.this._b_modify.setEnabled(false);
                    DFGUIFrame.this._b_add_df.setEnabled(true);
                    DFGUIFrame.this._b_remove_df.setEnabled(false);
                    break;
                }
                case 2: {
                    DFGUIFrame.this._b_deregister.setEnabled(false);
                    DFGUIFrame.this._b_modify.setEnabled(false);
                    DFGUIFrame.this._b_add_df.setEnabled(false);
                    DFGUIFrame.this._b_remove_df.setEnabled(true);
                    break;
                }
                case 3: {
                    DFGUIFrame.this._b_deregister.setEnabled(true);
                    DFGUIFrame.this._b_modify.setEnabled(true);
                    DFGUIFrame.this._b_add_df.setEnabled(false);
                    DFGUIFrame.this._b_remove_df.setEnabled(false);
                    break;
                }
                default: {
                    DFGUIFrame.this._b_deregister.setEnabled(false);
                    DFGUIFrame.this._b_modify.setEnabled(false);
                    DFGUIFrame.this._b_add_df.setEnabled(false);
                    DFGUIFrame.this._b_remove_df.setEnabled(false);
                }
            }
        }
    }

    class DFGUIPopupListener
    extends MouseAdapter {
        DFGUIPopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopupMenu(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopupMenu(mouseEvent);
        }

        private void showPopupMenu(MouseEvent mouseEvent) {
            int n;
            try {
                n = DFGUIFrame.this._agent_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()).getPathCount();
                DFGUIFrame.this._agent_tree.setSelectionPath(DFGUIFrame.this._agent_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()));
            }
            catch (Throwable throwable) {
                n = 0;
            }
            if (n > 1 && mouseEvent.isPopupTrigger()) {
                if (n == 2) {
                    DFGUIFrame.this._pm_deregister.setEnabled(false);
                    DFGUIFrame.this._pm_modify.setEnabled(false);
                    DFGUIFrame.this._pm_view.setEnabled(false);
                    DFGUIFrame.this._pm_remove_df.setEnabled(true);
                    DFGUIFrame.this._pm_register_with_df.setEnabled(true);
                    DFGUIFrame.this._pm_federated_search.setEnabled(true);
                } else {
                    DFGUIFrame.this._pm_deregister.setEnabled(true);
                    DFGUIFrame.this._pm_modify.setEnabled(true);
                    DFGUIFrame.this._pm_view.setEnabled(true);
                    DFGUIFrame.this._pm_remove_df.setEnabled(false);
                    DFGUIFrame.this._pm_register_with_df.setEnabled(false);
                    DFGUIFrame.this._pm_federated_search.setEnabled(false);
                }
                DFGUIFrame.this._agent_popup_menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (n == 1 && mouseEvent.isPopupTrigger()) {
                DFGUIFrame.this._FIPAOS_popup_menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class DFGUIModel
    implements TreeModel {
        private List treeModelListeners = new LinkedList();

        DFGUIModel() {
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            if (this.treeModelListeners.contains(treeModelListener)) {
                this.treeModelListeners.remove(treeModelListener);
            }
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.treeModelListeners.add(treeModelListener);
        }

        public void notifyChanges() {
            Iterator iterator = this.treeModelListeners.iterator();
            while (iterator.hasNext()) {
                TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
                treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{DFGUIFrame.this._dfs}));
            }
        }

        public boolean isLeaf(Object object) {
            if (object == DFGUIFrame.this._dfs) {
                return false;
            }
            if (DFGUIFrame.this._dfs.containsKey(object)) {
                LinkedList linkedList = (LinkedList)DFGUIFrame.this._dfs.get(object);
                return linkedList.isEmpty();
            }
            return true;
        }

        public Object getRoot() {
            return DFGUIFrame.this._dfs;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public Object getChild(Object object, int n) {
            if (DFGUIFrame.this._dfs.containsKey(object)) {
                LinkedList linkedList = (LinkedList)DFGUIFrame.this._dfs.get(object);
                return linkedList.get(n);
            }
            if (object == DFGUIFrame.this._dfs) {
                LinkedList linkedList = new LinkedList(DFGUIFrame.this._dfs.keySet());
                Collections.sort(linkedList, Comparators.STRING_COMPARE);
                return linkedList.get(n);
            }
            return null;
        }

        public int getChildCount(Object object) {
            if (object == DFGUIFrame.this._dfs) {
                return DFGUIFrame.this._dfs.keySet().size();
            }
            if (DFGUIFrame.this._dfs.containsKey(object)) {
                return ((List)DFGUIFrame.this._dfs.get(object)).size();
            }
            return 0;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (object == DFGUIFrame.this._dfs) {
                LinkedList linkedList = new LinkedList(DFGUIFrame.this._dfs.keySet());
                Collections.sort(linkedList, Comparators.STRING_COMPARE);
                return linkedList.indexOf(object2);
            }
            if (DFGUIFrame.this._dfs.containsKey(object)) {
                return ((List)DFGUIFrame.this._dfs.get(object)).indexOf(object2);
            }
            return -1;
        }
    }

    class DFGUIRenderer
    extends DefaultTreeCellRenderer {
        public DFGUIRenderer() {
            this.setBackgroundSelectionColor(Color.lightGray);
            this.setBorderSelectionColor(Color.white);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
            int n2 = n >= 0 && jTree.getPathForRow(n) != null ? jTree.getPathForRow(n).getPathCount() : 0;
            this.selected = bl;
            if (string.startsWith("{")) {
                this.setText("FIPA-OS");
                this.setIcon(this.getIcon(n2));
            } else {
                this.setText(string);
                if (!jTree.isEnabled()) {
                    this.setEnabled(false);
                    if (bl3) {
                        this.setDisabledIcon(this.getIcon(n2));
                    } else if (bl2) {
                        this.setDisabledIcon(this.getIcon(n2));
                    } else {
                        this.setDisabledIcon(this.getIcon(n2));
                    }
                } else {
                    this.setEnabled(true);
                    if (bl3) {
                        this.setIcon(this.getIcon(n2));
                    } else if (bl2) {
                        this.setIcon(this.getIcon(n2));
                    } else {
                        this.setIcon(this.getIcon(n2));
                    }
                }
            }
            if (bl) {
                this.setForeground(this.getTextSelectionColor());
            } else {
                this.setForeground(this.getTextNonSelectionColor());
            }
            return this;
        }

        private ImageIcon getIcon(int n) {
            switch (n) {
                case 1: {
                    return new ImageIcon(this.getClass().getClassLoader().getResource("images/logo.gif"));
                }
                case 2: {
                    return new ImageIcon(this.getClass().getClassLoader().getResource("images/dfgui/df.gif"));
                }
                case 3: {
                    return new ImageIcon(this.getClass().getClassLoader().getResource("images/dfgui/Agent.gif"));
                }
            }
            return null;
        }

        public Dimension getPreferredSize() {
            return new Dimension(500, 25);
        }
    }
}

